/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.examples;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.ajdt.examples.AspectJExampleCreationOperation;
import org.eclipse.ajdt.examples.AspectJExampleCreationWizardPage;
import org.eclipse.ajdt.examples.AspectJExampleMessages;
import org.eclipse.ajdt.examples.AspectJExamplePlugin;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class AspectJExampleCreationWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private AspectJExampleCreationWizardPage[] fPages;
    private IConfigurationElement fConfigElement;

    public AspectJExampleCreationWizard() {
        this.setDialogSettings(AspectJExamplePlugin.getDefault().getDialogSettings());
        this.setWindowTitle(AspectJExampleMessages.getString("ExampleProjectCreationWizard.title"));
        this.setNeedsProgressMonitor(true);
    }

    private void initializeDefaultPageImageDescriptor() {
        String string;
        if (this.fConfigElement != null && (string = this.fConfigElement.getAttribute("banner")) != null) {
            ImageDescriptor imageDescriptor = AspectJExamplePlugin.getDefault().getImageDescriptor(string);
            this.setDefaultPageImageDescriptor(imageDescriptor);
        }
    }

    public void addPages() {
        super.addPages();
        IConfigurationElement[] iConfigurationElementArray = this.fConfigElement.getChildren("projectsetup");
        if (iConfigurationElementArray == null || iConfigurationElementArray.length == 0) {
            AspectJExamplePlugin.log("descriptor must contain one ore more projectsetup tags");
            return;
        }
        this.fPages = new AspectJExampleCreationWizardPage[iConfigurationElementArray.length];
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            this.fPages[i] = new AspectJExampleCreationWizardPage(i, iConfigurationElementArray[i]);
            this.addPage((IWizardPage)this.fPages[i]);
        }
    }

    public boolean performFinish() {
        AspectJExampleCreationOperation aspectJExampleCreationOperation = new AspectJExampleCreationOperation(this.fPages, new ImportOverwriteQuery());
        WorkspaceModifyDelegatingOperation workspaceModifyDelegatingOperation = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)aspectJExampleCreationOperation);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)workspaceModifyDelegatingOperation);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleException(invocationTargetException.getTargetException());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
        IResource iResource = aspectJExampleCreationOperation.getElementToOpen();
        if (iResource != null) {
            this.openResource(iResource);
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                AJDTUtils.verifyWorkbenchConfiguration();
            }
        });
        return true;
    }

    private void handleException(Throwable throwable) {
        String string = AspectJExampleMessages.getString("ExampleProjectCreationWizard.op_error.title");
        String string2 = AspectJExampleMessages.getString("ExampleProjectCreationWizard.op_error.message");
        if (throwable instanceof CoreException) {
            IStatus iStatus = ((CoreException)throwable).getStatus();
            ErrorDialog.openError((Shell)this.getShell(), (String)string, (String)string2, (IStatus)iStatus);
            AspectJExamplePlugin.log(iStatus);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)string, (String)throwable.getMessage());
            AspectJExamplePlugin.log(throwable);
        }
    }

    private void openResource(final IResource iResource) {
        if (iResource.getType() != 1) {
            return;
        }
        IWorkbenchWindow iWorkbenchWindow = AspectJExamplePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return;
        }
        final IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage != null) {
            Display display = this.getShell().getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)((IFile)iResource), (boolean)true);
                    }
                    catch (PartInitException partInitException) {
                        AspectJExamplePlugin.log(partInitException);
                    }
                }
            });
            BasicNewResourceWizard.selectAndReveal((IResource)iResource, (IWorkbenchWindow)iWorkbenchPage.getWorkbenchWindow());
        }
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        this.fConfigElement = iConfigurationElement;
        this.initializeDefaultPageImageDescriptor();
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    private class ImportOverwriteQuery
    implements IOverwriteQuery {
        private ImportOverwriteQuery() {
        }

        public String queryOverwrite(String string) {
            String[] stringArray = new String[]{"YES", "NO", "ALL", "CANCEL"};
            int n = this.openDialog(string);
            return n < 0 ? "CANCEL" : stringArray[n];
        }

        private int openDialog(String string) {
            int[] nArray = new int[]{1};
            AspectJExampleCreationWizard.this.getShell().getDisplay().syncExec(new Runnable(this, string, nArray){
                private final /* synthetic */ String val$file;
                private final /* synthetic */ int[] val$result;
                private final /* synthetic */ ImportOverwriteQuery this$1;
                {
                    this.this$1 = importOverwriteQuery;
                    this.val$file = string;
                    this.val$result = nArray;
                }

                public void run() {
                    String string = AspectJExampleMessages.getString("ExampleProjectCreationWizard.overwritequery.title");
                    String string2 = AspectJExampleMessages.getFormattedString("ExampleProjectCreationWizard.overwritequery.message", this.val$file);
                    String[] stringArray = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
                    MessageDialog messageDialog = new MessageDialog(ImportOverwriteQuery.access$100(this.this$1).getShell(), string, null, string2, 3, stringArray, 0);
                    this.val$result[0] = messageDialog.open();
                }
            });
            return nArray[0];
        }

        static /* synthetic */ AspectJExampleCreationWizard access$100(ImportOverwriteQuery importOverwriteQuery) {
            return importOverwriteQuery.AspectJExampleCreationWizard.this;
        }
    }
}

