/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.UserPreferencesAdapter;
import org.aspectj.util.LangUtil;

public class UserPreferencesStore
implements UserPreferencesAdapter {
    public static final String FILE_NAME = "/.ajbrowser";
    private final String VALUE_SEP = ";";
    private Properties properties = new Properties();
    private boolean persist = true;

    public UserPreferencesStore() {
        this(true);
    }

    public UserPreferencesStore(boolean loadDefault) {
        this.persist = loadDefault;
        if (this.persist) {
            this.loadProperties(UserPreferencesStore.getPropertiesFilePath());
        }
    }

    public String getProjectPreference(String name) {
        return this.properties.getProperty(name);
    }

    public List getProjectMultivalPreference(String name) {
        ArrayList<String> values = new ArrayList<String>();
        String valuesString = this.properties.getProperty(name);
        if (valuesString != null && !valuesString.trim().equals("")) {
            StringTokenizer st = new StringTokenizer(valuesString, ";");
            while (st.hasMoreTokens()) {
                values.add(st.nextToken());
            }
        }
        return values;
    }

    public void setProjectPreference(String name, String value) {
        this.properties.setProperty(name, value);
        this.saveProperties();
    }

    public void setProjectMultivalPreference(String name, List values) {
        String valuesString = "";
        Iterator it = values.iterator();
        while (it.hasNext()) {
            valuesString = valuesString + (String)it.next() + ';';
        }
        this.properties.setProperty(name, valuesString);
        this.saveProperties();
    }

    public static String getPropertiesFilePath() {
        String path = System.getProperty("user.home");
        if (path == null) {
            path = ".";
        }
        return path + FILE_NAME;
    }

    public String getGlobalPreference(String name) {
        return this.getProjectPreference(name);
    }

    public List getGlobalMultivalPreference(String name) {
        return this.getProjectMultivalPreference(name);
    }

    public void setGlobalPreference(String name, String value) {
        this.setProjectPreference(name, value);
    }

    public void setGlobalMultivalPreference(String name, List values) {
        this.setProjectMultivalPreference(name, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadProperties(String path) {
        if (LangUtil.isEmpty(path)) {
            return;
        }
        File file = new File(path);
        if (!file.canRead()) {
            return;
        }
        FileInputStream in = null;
        path = UserPreferencesStore.getPropertiesFilePath();
        in = new FileInputStream(file);
        this.properties.load(in);
        Object var6_4 = null;
        if (null == in) return;
        try {
            in.close();
            return;
        }
        catch (IOException e) {}
        return;
        {
            catch (IOException ioe) {
                Ajde.getDefault().getErrorHandler().handleError("Error reading properties from " + path, ioe);
                Object var6_5 = null;
                if (null == in) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException e) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (null == in) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveProperties() {
        if (!this.persist) {
            return;
        }
        FileOutputStream out = null;
        String path = null;
        path = UserPreferencesStore.getPropertiesFilePath();
        out = new FileOutputStream(path);
        this.properties.store(out, "AJDE Settings");
        Object var5_3 = null;
        if (null == out) return;
        try {
            out.close();
            return;
        }
        catch (IOException e) {}
        return;
        {
            catch (IOException ioe) {
                Ajde.getDefault().getErrorHandler().handleError("Error writing properties to " + path, ioe);
                Object var5_4 = null;
                if (null == out) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException e) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (null == out) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

