/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.ajdt.internal.compiler.IBinarySourceProvider;
import org.aspectj.ajdt.internal.compiler.IIntermediateResultsRequestor;
import org.aspectj.ajdt.internal.compiler.IOutputClassFileNameProvider;
import org.aspectj.ajdt.internal.compiler.InterimCompilationResult;
import org.aspectj.ajdt.internal.compiler.WeaverAdapter;
import org.aspectj.ajdt.internal.compiler.WeaverMessageHandler;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.IProgressListener;
import org.aspectj.weaver.bcel.BcelWeaver;
import org.aspectj.weaver.bcel.BcelWorld;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerAdapter;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public class AjCompilerAdapter
implements ICompilerAdapter {
    private Compiler compiler;
    private BcelWeaver weaver;
    private EclipseFactory eWorld;
    private boolean isBatchCompile;
    private boolean reportedErrors;
    private boolean isXNoWeave;
    private IIntermediateResultsRequestor intermediateResultsRequestor;
    private IProgressListener progressListener;
    private IOutputClassFileNameProvider outputFileNameProvider;
    private IBinarySourceProvider binarySourceProvider;
    private WeaverMessageHandler weaverMessageHandler;
    private Map binarySourceSetForFullWeave = new HashMap();
    private Collection resultSetForFullWeave = Collections.EMPTY_LIST;
    List resultsPendingWeave = new ArrayList();

    public AjCompilerAdapter(Compiler compiler, boolean isBatchCompile, BcelWorld world, BcelWeaver weaver, EclipseFactory eFactory, IIntermediateResultsRequestor intRequestor, IProgressListener progressListener, IOutputClassFileNameProvider outputFileNameProvider, IBinarySourceProvider binarySourceProvider, Map fullBinarySourceEntries, Collection resultSetForFullWeave, boolean isXNoWeave) {
        this.compiler = compiler;
        this.isBatchCompile = isBatchCompile;
        this.weaver = weaver;
        this.intermediateResultsRequestor = intRequestor;
        this.progressListener = progressListener;
        this.outputFileNameProvider = outputFileNameProvider;
        this.binarySourceProvider = binarySourceProvider;
        this.isXNoWeave = isXNoWeave;
        this.binarySourceSetForFullWeave = fullBinarySourceEntries;
        this.resultSetForFullWeave = resultSetForFullWeave;
        this.eWorld = eFactory;
        IMessageHandler msgHandler = world.getMessageHandler();
        this.weaverMessageHandler = new WeaverMessageHandler(msgHandler, compiler);
        world.setMessageHandler(this.weaverMessageHandler);
    }

    public void beforeCompiling(ICompilationUnit[] sourceUnits) {
        this.resultsPendingWeave = new ArrayList();
        this.reportedErrors = false;
    }

    public void afterCompiling() {
        try {
            if (this.isXNoWeave || this.reportedErrors) {
                this.notifyRequestor();
            } else {
                this.weave();
            }
        }
        catch (IOException ex) {
            AbortCompilation ac = new AbortCompilation(null, (Throwable)ex);
            throw ac;
        }
        catch (RuntimeException rEx) {
            if (rEx instanceof AbortCompilation) {
                throw rEx;
            }
            throw new AbortCompilation(true, rEx);
        }
    }

    public void beforeProcessing(CompilationUnitDeclaration unit) {
        this.eWorld.showMessage(IMessage.INFO, "compiling " + new String(unit.getFileName()), null, null);
    }

    public void afterProcessing(CompilationUnitDeclaration unit, int unitIndex) {
        this.eWorld.finishedCompilationUnit(unit);
        InterimCompilationResult intRes = new InterimCompilationResult(unit.compilationResult, this.outputFileNameProvider);
        if (unit.compilationResult.hasErrors()) {
            this.reportedErrors = true;
        }
        if (this.intermediateResultsRequestor != null) {
            this.intermediateResultsRequestor.acceptResult(intRes);
        }
        if (this.isXNoWeave) {
            this.acceptResult(unit.compilationResult);
        } else {
            this.resultsPendingWeave.add(intRes);
        }
    }

    public void beforeResolving(CompilationUnitDeclaration unit, ICompilationUnit sourceUnit, boolean verifyMethods, boolean analyzeCode, boolean generateCode) {
        this.resultsPendingWeave = new ArrayList();
        this.reportedErrors = false;
    }

    public void afterResolving(CompilationUnitDeclaration unit, ICompilationUnit sourceUnit, boolean verifyMethods, boolean analyzeCode, boolean generateCode) {
        InterimCompilationResult intRes = new InterimCompilationResult(unit.compilationResult, this.outputFileNameProvider);
        if (unit.compilationResult.hasErrors()) {
            this.reportedErrors = true;
        }
        if (this.isXNoWeave || !generateCode) {
            this.acceptResult(unit.compilationResult);
        } else if (generateCode) {
            this.resultsPendingWeave.add(intRes);
            try {
                this.weave();
            }
            catch (IOException ex) {
                AbortCompilation ac = new AbortCompilation(null, (Throwable)ex);
                throw ac;
            }
        }
    }

    public void acceptResult(CompilationResult result) {
        this.compiler.requestor.acceptResult(result.tagAsAccepted());
        if (this.compiler.unitsToProcess != null) {
            for (int i = 0; i < this.compiler.unitsToProcess.length; ++i) {
                if (this.compiler.unitsToProcess[i] == null || this.compiler.unitsToProcess[i].compilationResult != result) continue;
                this.compiler.unitsToProcess[i] = null;
            }
        }
    }

    private List getBinarySourcesFrom(Map binarySourceEntries) {
        ArrayList<InterimCompilationResult> ret = new ArrayList<InterimCompilationResult>();
        Iterator binIter = binarySourceEntries.keySet().iterator();
        while (binIter.hasNext()) {
            String sourceFileName = (String)binIter.next();
            List unwovenClassFiles = (List)binarySourceEntries.get(sourceFileName);
            CompilationResult result = new CompilationResult(sourceFileName.toCharArray(), 0, 0, Integer.MAX_VALUE);
            result.noSourceAvailable();
            InterimCompilationResult binarySource = new InterimCompilationResult(result, unwovenClassFiles);
            ret.add(binarySource);
        }
        return ret;
    }

    private void notifyRequestor() {
        Iterator iter = this.resultsPendingWeave.iterator();
        while (iter.hasNext()) {
            InterimCompilationResult iresult = (InterimCompilationResult)iter.next();
            this.compiler.requestor.acceptResult(iresult.result().tagAsAccepted());
        }
    }

    private void weave() throws IOException {
        Iterator iter = this.resultsPendingWeave.iterator();
        while (iter.hasNext()) {
            InterimCompilationResult iresult = (InterimCompilationResult)iter.next();
            for (int i = 0; i < iresult.unwovenClassFiles().length; ++i) {
                this.weaver.addClassFile(iresult.unwovenClassFiles()[i]);
            }
        }
        this.weaver.prepareForWeave();
        if (this.weaver.needToReweaveWorld()) {
            if (!this.isBatchCompile) {
                this.addAllKnownClassesToWeaveList();
            }
            this.resultsPendingWeave.addAll(this.getBinarySourcesFrom(this.binarySourceSetForFullWeave));
        } else {
            Map binarySourcesToAdd = this.binarySourceProvider.getBinarySourcesForThisWeave();
            this.resultsPendingWeave.addAll(this.getBinarySourcesFrom(binarySourcesToAdd));
        }
        this.weaver.weave(new WeaverAdapter(this, this.weaverMessageHandler, this.progressListener));
    }

    private void addAllKnownClassesToWeaveList() {
        Iterator iter = this.resultSetForFullWeave.iterator();
        while (iter.hasNext()) {
            InterimCompilationResult ir = (InterimCompilationResult)iter.next();
            if (this.resultsPendingWeave.contains(ir)) continue;
            ir.result().hasBeenAccepted = false;
            this.resultsPendingWeave.add(ir);
        }
    }
}

