/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.ajdt.internal.compiler.ast.EclipseAttributeAdapter;
import org.aspectj.ajdt.internal.compiler.ast.InterSuperFixerVisitor;
import org.aspectj.ajdt.internal.compiler.ast.SuperFixerVisitor;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseTypeMunger;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeScope;
import org.aspectj.ajdt.internal.core.builder.EclipseSourceContext;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.Shadow;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public abstract class InterTypeDeclaration
extends MethodDeclaration {
    public TypeReference onType;
    protected ReferenceBinding onTypeBinding;
    protected ResolvedTypeMunger munger;
    protected int declaredModifiers;
    protected char[] declaredSelector;

    public InterTypeDeclaration(CompilationResult result, TypeReference onType) {
        super(result);
        this.onType = onType;
        ((AbstractMethodDeclaration)this).modifiers = 9;
    }

    public void setDeclaredModifiers(int modifiers) {
        this.declaredModifiers = modifiers;
    }

    public void setSelector(char[] selector) {
        this.declaredSelector = selector;
        ((AbstractMethodDeclaration)this).selector = CharOperation.concat((char[])selector, (char[])Integer.toHexString(((ASTNode)this).sourceStart).toCharArray());
    }

    public void resolve(ClassScope upperScope) {
        if (((AbstractMethodDeclaration)this).ignoreFurtherInvestigation) {
            return;
        }
        InterTypeScope newParent = new InterTypeScope((Scope)upperScope, this.onTypeBinding);
        ((AbstractMethodDeclaration)this).scope.parent = newParent;
        ((AbstractMethodDeclaration)this).scope.isStatic = Modifier.isStatic(this.declaredModifiers);
        this.fixSuperCallsForInterfaceContext(upperScope);
        if (((AbstractMethodDeclaration)this).ignoreFurtherInvestigation) {
            return;
        }
        super.resolve((ClassScope)newParent);
        this.fixSuperCallsInBody();
    }

    private void fixSuperCallsForInterfaceContext(ClassScope scope) {
        if (this.onTypeBinding.isInterface()) {
            InterSuperFixerVisitor v = new InterSuperFixerVisitor(this, EclipseFactory.fromScopeLookupEnvironment((Scope)scope), (Scope)scope);
            this.traverse(v, scope);
        }
    }

    public abstract EclipseTypeMunger build(ClassScope var1);

    public void fixSuperCallsInBody() {
        SuperFixerVisitor v = new SuperFixerVisitor((AbstractMethodDeclaration)this, this.onTypeBinding);
        this.traverse(v, null);
        this.munger.setSuperMethodsCalled(v.superMethodsCalled);
    }

    protected void resolveOnType(ClassScope classScope) {
        this.checkSpec();
        this.onTypeBinding = (ReferenceBinding)this.onType.getTypeBinding((Scope)classScope);
        if (!this.onTypeBinding.isValidBinding()) {
            classScope.problemReporter().invalidType((ASTNode)this.onType, (TypeBinding)this.onTypeBinding);
            ((AbstractMethodDeclaration)this).ignoreFurtherInvestigation = true;
        }
    }

    protected void checkSpec() {
        if (Modifier.isProtected(this.declaredModifiers)) {
            ((AbstractMethodDeclaration)this).scope.problemReporter().signalError(((ASTNode)this).sourceStart, ((ASTNode)this).sourceEnd, "protected inter-type declarations are not allowed");
            ((AbstractMethodDeclaration)this).ignoreFurtherInvestigation = true;
        }
    }

    protected List makeEffectiveSignatureAttribute(ResolvedMember sig, Shadow.Kind kind, boolean weaveBody) {
        ArrayList<EclipseAttributeAdapter> l = new ArrayList<EclipseAttributeAdapter>(1);
        l.add(new EclipseAttributeAdapter(new AjAttribute.EffectiveSignatureAttribute(sig, kind, weaveBody)));
        return l;
    }

    protected void setMunger(ResolvedTypeMunger munger) {
        munger.getSignature().setPosition(((ASTNode)this).sourceStart, ((ASTNode)this).sourceEnd);
        munger.getSignature().setSourceContext(new EclipseSourceContext(((AbstractMethodDeclaration)this).compilationResult));
        this.munger = munger;
    }

    protected int generateInfoAttributes(ClassFile classFile) {
        Shadow.Kind kind = this.getShadowKindForBody();
        List l = kind != null ? this.makeEffectiveSignatureAttribute(this.munger.getSignature(), kind, true) : new ArrayList(0);
        return classFile.generateMethodInfoAttribute(((AbstractMethodDeclaration)this).binding, l);
    }

    protected abstract Shadow.Kind getShadowKindForBody();

    public ResolvedMember getSignature() {
        if (this.munger == null) {
            return null;
        }
        return this.munger.getSignature();
    }

    public char[] getDeclaredSelector() {
        return this.declaredSelector;
    }
}

