/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import java.lang.reflect.Modifier;
import org.aspectj.ajdt.internal.compiler.ast.AstUtil;
import org.aspectj.ajdt.internal.compiler.ast.EclipseAttributeAdapter;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.KnownMessageSend;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseTypeMunger;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.NewFieldTypeMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.TypeX;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;

public class InterTypeFieldDeclaration
extends InterTypeDeclaration {
    public Expression initialization;

    public InterTypeFieldDeclaration(CompilationResult result, TypeReference onType) {
        super(result, onType);
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
    }

    public void resolveOnType(ClassScope classScope) {
        super.resolveOnType(classScope);
        if (((AbstractMethodDeclaration)this).ignoreFurtherInvestigation) {
            return;
        }
        if (Modifier.isStatic(this.declaredModifiers) && this.onTypeBinding.isInterface()) {
            ((AbstractMethodDeclaration)this).scope.problemReporter().signalError(((ASTNode)this).sourceStart, ((ASTNode)this).sourceEnd, "static inter-type field on interface not supported");
            ((AbstractMethodDeclaration)this).ignoreFurtherInvestigation = true;
        }
    }

    public void resolve(ClassScope upperScope) {
        MethodBinding writeMethod;
        if (this.munger == null) {
            ((AbstractMethodDeclaration)this).ignoreFurtherInvestigation = true;
        }
        if (((AbstractMethodDeclaration)this).ignoreFurtherInvestigation) {
            return;
        }
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment((Scope)upperScope);
        ResolvedMember sig = this.munger.getSignature();
        TypeX aspectType = EclipseFactory.fromBinding((TypeBinding)upperScope.referenceContext.binding);
        if (sig.getReturnType() == ResolvedTypeX.VOID || sig.getReturnType().isArray() && sig.getReturnType().getComponentType() == ResolvedTypeX.VOID) {
            upperScope.problemReporter().signalError(((ASTNode)this).sourceStart, ((ASTNode)this).sourceEnd, "field type can not be void");
        }
        if (this.initialization != null && this.initialization instanceof ArrayInitializer) {
            ArrayAllocationExpression aae = new ArrayAllocationExpression();
            aae.initializer = (ArrayInitializer)this.initialization;
            ArrayBinding arrayType = (ArrayBinding)world.makeTypeBinding(sig.getReturnType());
            aae.type = AstUtil.makeTypeReference(arrayType.leafComponentType());
            aae.sourceStart = this.initialization.sourceStart;
            aae.sourceEnd = this.initialization.sourceEnd;
            aae.dimensions = new Expression[arrayType.dimensions];
            this.initialization = aae;
        }
        if (this.initialization == null) {
            ((AbstractMethodDeclaration)this).statements = new Statement[]{new ReturnStatement(null, 0, 0)};
        } else if (!this.onTypeBinding.isInterface()) {
            writeMethod = world.makeMethodBinding(AjcMemberMaker.interFieldSetDispatcher(sig, aspectType));
            ((AbstractMethodDeclaration)this).statements = Modifier.isStatic(this.declaredModifiers) ? new Statement[]{new KnownMessageSend(writeMethod, (Expression)AstUtil.makeNameReference((TypeBinding)writeMethod.declaringClass), new Expression[]{this.initialization})} : new Statement[]{new KnownMessageSend(writeMethod, (Expression)AstUtil.makeNameReference((TypeBinding)writeMethod.declaringClass), new Expression[]{AstUtil.makeLocalVariableReference(((AbstractMethodDeclaration)this).arguments[0].binding), this.initialization})};
        } else {
            writeMethod = world.makeMethodBinding(AjcMemberMaker.interFieldInterfaceSetter(sig, sig.getDeclaringType().resolve(world.getWorld()), aspectType));
            ((AbstractMethodDeclaration)this).statements = Modifier.isStatic(this.declaredModifiers) ? new Statement[]{new KnownMessageSend(writeMethod, (Expression)AstUtil.makeNameReference((TypeBinding)writeMethod.declaringClass), new Expression[]{this.initialization})} : new Statement[]{new KnownMessageSend(writeMethod, (Expression)AstUtil.makeLocalVariableReference(((AbstractMethodDeclaration)this).arguments[0].binding), new Expression[]{this.initialization})};
        }
        super.resolve(upperScope);
    }

    public void setInitialization(Expression initialization) {
        this.initialization = initialization;
    }

    public EclipseTypeMunger build(ClassScope classScope) {
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment((Scope)classScope);
        this.resolveOnType(classScope);
        if (((AbstractMethodDeclaration)this).ignoreFurtherInvestigation) {
            return null;
        }
        ((AbstractMethodDeclaration)this).binding = classScope.referenceContext.binding.resolveTypesFor(((AbstractMethodDeclaration)this).binding);
        if (((AbstractMethodDeclaration)this).ignoreFurtherInvestigation) {
            return null;
        }
        if (!Modifier.isStatic(this.declaredModifiers)) {
            ((AbstractMethodDeclaration)this).binding.parameters = new TypeBinding[]{this.onTypeBinding};
            ((AbstractMethodDeclaration)this).arguments = new Argument[]{AstUtil.makeFinalArgument("ajc$this_".toCharArray(), (TypeBinding)this.onTypeBinding)};
        }
        ResolvedMember sig = new ResolvedMember(Member.FIELD, EclipseFactory.fromBinding((TypeBinding)this.onTypeBinding), this.declaredModifiers, EclipseFactory.fromBinding(((AbstractMethodDeclaration)this).binding.returnType), new String(this.declaredSelector), TypeX.NONE);
        NewFieldTypeMunger myMunger = new NewFieldTypeMunger(sig, null);
        this.setMunger(myMunger);
        ResolvedTypeX aspectType = world.fromEclipse((ReferenceBinding)classScope.referenceContext.binding);
        ResolvedMember me = myMunger.getInitMethod(aspectType);
        ((AbstractMethodDeclaration)this).binding.selector = me.getName().toCharArray();
        ((AbstractMethodDeclaration)this).selector = ((AbstractMethodDeclaration)this).binding.selector;
        ((AbstractMethodDeclaration)this).binding.returnType = BaseTypes.VoidBinding;
        return new EclipseTypeMunger(world, myMunger, aspectType, (AbstractMethodDeclaration)this);
    }

    private AjAttribute makeAttribute() {
        return new AjAttribute.TypeMunger(this.munger);
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        if (((AbstractMethodDeclaration)this).ignoreFurtherInvestigation) {
            return;
        }
        classFile.extraAttributes.add(new EclipseAttributeAdapter(this.makeAttribute()));
        super.generateCode(classScope, classFile);
        this.generateDispatchMethods(classScope, classFile);
    }

    private void generateDispatchMethods(ClassScope classScope, ClassFile classFile) {
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment((Scope)classScope);
        ResolvedMember sig = this.munger.getSignature();
        TypeX aspectType = EclipseFactory.fromBinding((TypeBinding)classScope.referenceContext.binding);
        this.generateDispatchMethod(world, sig, aspectType, classScope, classFile, true);
        this.generateDispatchMethod(world, sig, aspectType, classScope, classFile, false);
    }

    private void generateDispatchMethod(EclipseFactory world, ResolvedMember sig, TypeX aspectType, ClassScope classScope, ClassFile classFile, boolean isGetter) {
        MethodBinding binding = isGetter ? world.makeMethodBinding(AjcMemberMaker.interFieldGetDispatcher(sig, aspectType)) : world.makeMethodBinding(AjcMemberMaker.interFieldSetDispatcher(sig, aspectType));
        classFile.generateMethodInfoHeader(binding);
        int methodAttributeOffset = classFile.contentsOffset;
        int attributeNumber = classFile.generateMethodInfoAttribute(binding, this.makeEffectiveSignatureAttribute(sig, isGetter ? Shadow.FieldGet : Shadow.FieldSet, false));
        int codeAttributeOffset = classFile.contentsOffset;
        classFile.generateCodeAttributeHeader();
        CodeStream codeStream = classFile.codeStream;
        codeStream.reset((AbstractMethodDeclaration)this, classFile);
        FieldBinding classField = world.makeFieldBinding(AjcMemberMaker.interFieldClassField(sig, aspectType));
        codeStream.initializeMaxLocals(binding);
        if (isGetter) {
            if (this.onTypeBinding.isInterface()) {
                MethodBinding readMethod = world.makeMethodBinding(AjcMemberMaker.interFieldInterfaceGetter(sig, world.getWorld().resolve(sig.getDeclaringType()), aspectType));
                this.generateInterfaceReadBody(binding, readMethod, codeStream);
            } else {
                this.generateClassReadBody(binding, classField, codeStream);
            }
        } else if (this.onTypeBinding.isInterface()) {
            MethodBinding writeMethod = world.makeMethodBinding(AjcMemberMaker.interFieldInterfaceSetter(sig, world.getWorld().resolve(sig.getDeclaringType()), aspectType));
            this.generateInterfaceWriteBody(binding, writeMethod, codeStream);
        } else {
            this.generateClassWriteBody(binding, classField, codeStream);
        }
        AstUtil.generateReturn(binding.returnType, codeStream);
        classFile.completeCodeAttribute(codeAttributeOffset);
        classFile.completeMethodInfo(methodAttributeOffset, ++attributeNumber);
    }

    private void generateInterfaceReadBody(MethodBinding binding, MethodBinding readMethod, CodeStream codeStream) {
        codeStream.aload_0();
        codeStream.invokeinterface(readMethod);
    }

    private void generateInterfaceWriteBody(MethodBinding binding, MethodBinding writeMethod, CodeStream codeStream) {
        codeStream.aload_0();
        codeStream.load(writeMethod.parameters[0], 1);
        codeStream.invokeinterface(writeMethod);
    }

    private void generateClassReadBody(MethodBinding binding, FieldBinding field, CodeStream codeStream) {
        if (field.isStatic()) {
            codeStream.getstatic(field);
        } else {
            codeStream.aload_0();
            codeStream.getfield(field);
        }
    }

    private void generateClassWriteBody(MethodBinding binding, FieldBinding field, CodeStream codeStream) {
        if (field.isStatic()) {
            codeStream.load(field.type, 0);
            codeStream.putstatic(field);
        } else {
            codeStream.aload_0();
            codeStream.load(field.type, 1);
            codeStream.putfield(field);
        }
    }

    protected Shadow.Kind getShadowKindForBody() {
        return null;
    }
}

