/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import org.aspectj.ajdt.internal.compiler.ast.AdviceDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AstUtil;
import org.aspectj.weaver.AdviceKind;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class Proceed
extends MessageSend {
    public boolean inInner = false;

    public Proceed(MessageSend parent) {
        this.receiver = parent.receiver;
        this.selector = parent.selector;
        this.arguments = parent.arguments;
        this.binding = parent.binding;
        this.codegenBinding = parent.codegenBinding;
        this.nameSourcePosition = parent.nameSourcePosition;
        this.receiverType = parent.receiverType;
        this.qualifyingType = parent.qualifyingType;
        ((ASTNode)this).sourceStart = parent.sourceStart;
        ((ASTNode)this).sourceEnd = parent.sourceEnd;
    }

    public TypeBinding resolveType(BlockScope scope) {
        AdviceDeclaration aroundDecl = this.findEnclosingAround((Scope)scope);
        if (aroundDecl == null) {
            return super.resolveType(scope);
        }
        ((Expression)this).constant = ASTNode.NotAConstant;
        this.binding = this.codegenBinding = aroundDecl.proceedMethodBinding;
        this.qualifyingType = this.receiverType = this.binding.declaringClass;
        int baseArgCount = 0;
        if (this.arguments != null) {
            baseArgCount = this.arguments.length;
            Expression[] newArguments = new Expression[baseArgCount + 1];
            System.arraycopy(this.arguments, 0, newArguments, 0, baseArgCount);
            this.arguments = newArguments;
        } else {
            this.arguments = new Expression[1];
        }
        this.arguments[baseArgCount] = AstUtil.makeLocalVariableReference(aroundDecl.extraArgument.binding);
        int declaredParameterCount = aroundDecl.getDeclaredParameterCount();
        if (baseArgCount < declaredParameterCount) {
            scope.problemReporter().signalError(((ASTNode)this).sourceStart, ((ASTNode)this).sourceEnd, "too few arguments to proceed, expected " + declaredParameterCount);
            ((AbstractMethodDeclaration)aroundDecl).ignoreFurtherInvestigation = true;
            return null;
        }
        if (baseArgCount > declaredParameterCount) {
            scope.problemReporter().signalError(((ASTNode)this).sourceStart, ((ASTNode)this).sourceEnd, "too many arguments to proceed, expected " + declaredParameterCount);
            ((AbstractMethodDeclaration)aroundDecl).ignoreFurtherInvestigation = true;
            return null;
        }
        int len = this.arguments.length;
        for (int i = 0; i < len; ++i) {
            Expression arg = this.arguments[i];
            TypeBinding argType = arg.resolveType(scope);
            if (argType == null) continue;
            TypeBinding paramType = this.binding.parameters[i];
            if (!argType.isCompatibleWith(paramType)) {
                scope.problemReporter().typeMismatchError(argType, paramType, (ASTNode)arg);
            }
            arg.implicitWidening(this.binding.parameters[i], argType);
        }
        return this.binding.returnType;
    }

    private AdviceDeclaration findEnclosingAround(Scope scope) {
        if (scope == null) {
            return null;
        }
        if (scope instanceof MethodScope) {
            MethodScope methodScope = (MethodScope)scope;
            ReferenceContext context = methodScope.referenceContext;
            if (context instanceof AdviceDeclaration) {
                AdviceDeclaration adviceDecl = (AdviceDeclaration)context;
                if (adviceDecl.kind == AdviceKind.Around) {
                    if (this.receiver != null && !this.receiver.isThis()) {
                        return null;
                    }
                    adviceDecl.proceedCalls.add(this);
                    return adviceDecl;
                }
                return null;
            }
        } else if (scope instanceof ClassScope) {
            this.inInner = true;
        }
        return this.findEnclosingAround(scope.parent);
    }
}

