/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.problem;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import org.aspectj.ajdt.internal.compiler.ast.PointcutDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.Proceed;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.patterns.DeclareSoft;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class AjProblemReporter
extends ProblemReporter {
    private static final boolean DUMP_STACK = false;
    public EclipseFactory factory;

    public AjProblemReporter(IErrorHandlingPolicy policy, CompilerOptions options, IProblemFactory problemFactory) {
        super(policy, options, problemFactory);
    }

    public void unhandledException(TypeBinding exceptionType, ASTNode location) {
        if (!this.factory.getWorld().getDeclareSoft().isEmpty()) {
            Shadow callSite = this.factory.makeShadow(location, this.referenceContext);
            Shadow enclosingExec = this.factory.makeShadow(this.referenceContext);
            Iterator i = this.factory.getWorld().getDeclareSoft().iterator();
            while (i.hasNext()) {
                FuzzyBoolean match;
                DeclareSoft d = (DeclareSoft)i.next();
                ResolvedTypeX throwException = this.factory.fromEclipse((ReferenceBinding)exceptionType);
                FuzzyBoolean isExceptionTypeOrSubtype = d.getException().matchesInstanceof(throwException);
                if (!isExceptionTypeOrSubtype.alwaysTrue()) continue;
                if (callSite != null) {
                    match = d.getPointcut().match(callSite);
                    if (match.alwaysTrue()) {
                        return;
                    }
                    if (!match.alwaysFalse()) {
                        // empty if block
                    }
                }
                if (enclosingExec == null) continue;
                match = d.getPointcut().match(enclosingExec);
                if (match.alwaysTrue()) {
                    return;
                }
                if (match.alwaysFalse()) continue;
            }
        }
        if (location instanceof Proceed) {
            return;
        }
        super.unhandledException(exceptionType, location);
    }

    private boolean isPointcutDeclaration(MethodBinding binding) {
        return CharOperation.prefixEquals((char[])PointcutDeclaration.mangledPrefix, (char[])binding.selector);
    }

    public void abstractMethodCannotBeOverridden(SourceTypeBinding type, MethodBinding concreteMethod) {
        if (this.isPointcutDeclaration(concreteMethod)) {
            return;
        }
        super.abstractMethodCannotBeOverridden(type, concreteMethod);
    }

    public void abstractMethodMustBeImplemented(SourceTypeBinding type, MethodBinding abstractMethod) {
        if (this.isPointcutDeclaration(abstractMethod)) {
            return;
        }
        if (CharOperation.prefixEquals((char[])"ajc$interField".toCharArray(), (char[])abstractMethod.selector)) {
            return;
        }
        ResolvedTypeX onTypeX = this.factory.fromEclipse((ReferenceBinding)type);
        Iterator i = onTypeX.getInterTypeMungersIncludingSupers().iterator();
        while (i.hasNext()) {
            ConcreteTypeMunger m = (ConcreteTypeMunger)i.next();
            ResolvedMember sig = m.getSignature();
            if (Modifier.isAbstract(sig.getModifiers()) || !ResolvedTypeX.matches(AjcMemberMaker.interMethod(sig, m.getAspectType(), sig.getDeclaringType().isInterface(this.factory.getWorld())), EclipseFactory.makeResolvedMember(abstractMethod))) continue;
            return;
        }
        super.abstractMethodMustBeImplemented(type, abstractMethod);
    }

    public void handle(int problemId, String[] problemArguments, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition, ReferenceContext referenceContext, CompilationResult unitResult) {
        if (severity != -1) {
            // empty if block
        }
        super.handle(problemId, problemArguments, messageArguments, severity, problemStartPosition, problemEndPosition, referenceContext, unitResult);
    }
}

