/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Stack;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeDeclaration;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AsmElementFormatter;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.internal.ProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.util.LangUtil;
import org.aspectj.weaver.ResolvedMember;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.problem.ProblemHandler;

public class AsmHierarchyBuilder
extends ASTVisitor {
    protected AsmElementFormatter formatter = new AsmElementFormatter();
    protected AjBuildConfig buildConfig;
    protected Stack stack;
    private CompilationResult currCompilationResult;
    private Initializer inInitializer = null;

    public void buildStructureForCompilationUnit(CompilationUnitDeclaration cuDeclaration, IHierarchy structureModel, AjBuildConfig buildConfig) {
        this.currCompilationResult = cuDeclaration.compilationResult();
        LangUtil.throwIaxIfNull(this.currCompilationResult, "result");
        this.stack = new Stack();
        this.buildConfig = buildConfig;
        this.internalBuild(cuDeclaration, structureModel);
    }

    private void internalBuild(CompilationUnitDeclaration unit, IHierarchy structureModel) {
        LangUtil.throwIaxIfNull(structureModel, "structureModel");
        if (!this.currCompilationResult.equals(unit.compilationResult())) {
            throw new IllegalArgumentException("invalid unit: " + unit);
        }
        File file = new File(new String(unit.getFileName()));
        int startLine = this.getStartLine((ASTNode)unit);
        int endLine = this.getEndLine((ASTNode)unit);
        SourceLocation sourceLocation = new SourceLocation(file, startLine, endLine);
        ProgramElement cuNode = new ProgramElement(new String(file.getName()), IProgramElement.Kind.FILE_JAVA, sourceLocation, 0, "", new ArrayList());
        cuNode.addChild(new ProgramElement("import declarations", IProgramElement.Kind.IMPORT_REFERENCE, null, 0, "", new ArrayList()));
        IProgramElement addToNode = this.genAddToNode(unit, structureModel);
        if (addToNode != null && addToNode.getChildren() != null) {
            ListIterator itt = addToNode.getChildren().listIterator();
            while (itt.hasNext()) {
                IProgramElement child = (IProgramElement)itt.next();
                ISourceLocation childLoc = child.getSourceLocation();
                if (null == childLoc || !childLoc.getSourceFile().equals(file)) continue;
                itt.remove();
            }
        }
        addToNode.addChild(cuNode);
        this.stack.push(cuNode);
        unit.traverse((ASTVisitor)this, unit.scope);
        try {
            structureModel.addToFileMap(file.getCanonicalPath(), cuNode);
        }
        catch (IOException e) {
            System.err.println("IOException " + e.getMessage() + " creating path for " + file);
        }
    }

    private IProgramElement genAddToNode(CompilationUnitDeclaration unit, IHierarchy structureModel) {
        IProgramElement addToNode;
        ImportReference currentPackage = unit.currentPackage;
        if (null == currentPackage) {
            addToNode = structureModel.getRoot();
        } else {
            StringBuffer nameBuffer = new StringBuffer();
            char[][] importName = currentPackage.getImportName();
            int last = importName.length - 1;
            for (int i = 0; i < importName.length; ++i) {
                nameBuffer.append(new String(importName[i]));
                if (i >= last) continue;
                nameBuffer.append('.');
            }
            String pkgName = nameBuffer.toString();
            IProgramElement pkgNode = null;
            if (structureModel != null && structureModel.getRoot() != null && structureModel.getRoot().getChildren() != null) {
                Iterator it = structureModel.getRoot().getChildren().iterator();
                while (it.hasNext()) {
                    IProgramElement currNode = (IProgramElement)it.next();
                    if (!pkgName.equals(currNode.getName())) continue;
                    pkgNode = currNode;
                    break;
                }
            }
            if (pkgNode == null) {
                pkgNode = new ProgramElement(pkgName, IProgramElement.Kind.PACKAGE, new ArrayList());
                structureModel.getRoot().addChild(pkgNode);
            }
            addToNode = pkgNode;
        }
        return addToNode;
    }

    public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        String name = new String(typeDeclaration.name);
        IProgramElement.Kind kind = IProgramElement.Kind.CLASS;
        if (typeDeclaration instanceof AspectDeclaration) {
            kind = IProgramElement.Kind.ASPECT;
        } else if (typeDeclaration.isInterface()) {
            kind = IProgramElement.Kind.INTERFACE;
        }
        ProgramElement peNode = new ProgramElement(name, kind, this.makeLocation((ASTNode)typeDeclaration), typeDeclaration.modifiers, "", new ArrayList());
        peNode.setSourceSignature(this.genSourceSignature(typeDeclaration));
        peNode.setFormalComment(this.generateJavadocComment((ASTNode)typeDeclaration));
        ((IProgramElement)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        this.stack.pop();
    }

    public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
        String name = new String(memberTypeDeclaration.name);
        IProgramElement.Kind kind = IProgramElement.Kind.CLASS;
        if (memberTypeDeclaration instanceof AspectDeclaration) {
            kind = IProgramElement.Kind.ASPECT;
        } else if (memberTypeDeclaration.isInterface()) {
            kind = IProgramElement.Kind.INTERFACE;
        }
        ProgramElement peNode = new ProgramElement(name, kind, this.makeLocation((ASTNode)memberTypeDeclaration), memberTypeDeclaration.modifiers, "", new ArrayList());
        peNode.setSourceSignature(this.genSourceSignature(memberTypeDeclaration));
        peNode.setFormalComment(this.generateJavadocComment((ASTNode)memberTypeDeclaration));
        ((IProgramElement)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
        this.stack.pop();
    }

    public boolean visit(TypeDeclaration memberTypeDeclaration, BlockScope scope) {
        String fullName = "<undefined>";
        if (memberTypeDeclaration.binding != null && memberTypeDeclaration.binding.constantPoolName() != null) {
            fullName = new String(memberTypeDeclaration.binding.constantPoolName());
        }
        int dollar = fullName.indexOf(36);
        fullName = fullName.substring(dollar + 1);
        IProgramElement.Kind kind = IProgramElement.Kind.CLASS;
        if (memberTypeDeclaration.isInterface()) {
            kind = IProgramElement.Kind.INTERFACE;
        }
        ProgramElement peNode = new ProgramElement(fullName, kind, this.makeLocation((ASTNode)memberTypeDeclaration), memberTypeDeclaration.modifiers, "", new ArrayList());
        peNode.setSourceSignature(this.genSourceSignature(memberTypeDeclaration));
        peNode.setFormalComment(this.generateJavadocComment((ASTNode)memberTypeDeclaration));
        this.findEnclosingClass(this.stack).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(TypeDeclaration memberTypeDeclaration, BlockScope scope) {
        this.stack.pop();
    }

    private String genSourceSignature(TypeDeclaration typeDeclaration) {
        StringBuffer output = new StringBuffer();
        typeDeclaration.printHeader(0, output);
        return output.toString();
    }

    private IProgramElement findEnclosingClass(Stack stack) {
        for (int i = stack.size() - 1; i >= 0; --i) {
            IProgramElement pe = (IProgramElement)stack.get(i);
            if (pe.getKind() != IProgramElement.Kind.CLASS) continue;
            return pe;
        }
        return (IProgramElement)stack.peek();
    }

    public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
        ProgramElement peNode = null;
        if (methodDeclaration instanceof InterTypeDeclaration) {
            InterTypeDeclaration itd = (InterTypeDeclaration)methodDeclaration;
            ResolvedMember sig = itd.getSignature();
            peNode = new ProgramElement("", IProgramElement.Kind.ERROR, this.makeLocation((ASTNode)methodDeclaration), sig != null ? sig.getModifiers() : 0, "", new ArrayList());
        } else {
            peNode = new ProgramElement("", IProgramElement.Kind.ERROR, this.makeLocation((ASTNode)methodDeclaration), methodDeclaration.modifiers, "", new ArrayList());
        }
        this.formatter.genLabelAndKind(methodDeclaration, peNode);
        this.genBytecodeInfo(methodDeclaration, peNode);
        if (methodDeclaration.returnType != null) {
            peNode.setCorrespondingType(methodDeclaration.returnType.toString());
        } else {
            peNode.setCorrespondingType(null);
        }
        peNode.setSourceSignature(this.genSourceSignature(methodDeclaration));
        peNode.setFormalComment(this.generateJavadocComment((ASTNode)methodDeclaration));
        if (peNode.getKind().equals(IProgramElement.Kind.METHOD) && peNode.toLabelString().equals("main(String[])") && peNode.getModifiers().contains(IProgramElement.Modifiers.STATIC) && peNode.getAccessibility().equals(IProgramElement.Accessibility.PUBLIC)) {
            ((IProgramElement)this.stack.peek()).setRunnable(true);
        }
        this.stack.push(peNode);
        return true;
    }

    private String genSourceSignature(MethodDeclaration methodDeclaration) {
        int i;
        StringBuffer output = new StringBuffer();
        ASTNode.printModifiers((int)methodDeclaration.modifiers, (StringBuffer)output);
        methodDeclaration.printReturnType(0, output).append(methodDeclaration.selector).append('(');
        if (methodDeclaration.arguments != null) {
            for (i = 0; i < methodDeclaration.arguments.length; ++i) {
                if (i > 0) {
                    output.append(", ");
                }
                methodDeclaration.arguments[i].print(0, output);
            }
        }
        output.append(')');
        if (methodDeclaration.thrownExceptions != null) {
            output.append(" throws ");
            for (i = 0; i < methodDeclaration.thrownExceptions.length; ++i) {
                if (i > 0) {
                    output.append(", ");
                }
                methodDeclaration.thrownExceptions[i].print(0, output);
            }
        }
        return output.toString();
    }

    private void genBytecodeInfo(MethodDeclaration methodDeclaration, IProgramElement peNode) {
        if (methodDeclaration.binding != null) {
            String memberName = "";
            String memberBytecodeSignature = "";
            try {
                ResolvedMember member = EclipseFactory.makeResolvedMember(methodDeclaration.binding);
                memberName = member.getName();
                memberBytecodeSignature = member.getSignature();
            }
            catch (NullPointerException npe) {
                memberName = "<undefined>";
            }
            peNode.setBytecodeName(memberName);
            peNode.setBytecodeSignature(memberBytecodeSignature);
        }
        ((IProgramElement)this.stack.peek()).addChild(peNode);
    }

    public void endVisit(MethodDeclaration methodDeclaration, ClassScope scope) {
        this.stack.pop();
    }

    public boolean visit(ImportReference importRef, CompilationUnitScope scope) {
        int dotIndex = importRef.toString().lastIndexOf(46);
        String currPackageImport = "";
        if (dotIndex != -1) {
            currPackageImport = importRef.toString().substring(0, dotIndex);
        }
        if (!((ProgramElement)this.stack.peek()).getPackageName().equals(currPackageImport)) {
            ProgramElement peNode = new ProgramElement(new String(importRef.toString()), IProgramElement.Kind.IMPORT_REFERENCE, this.makeLocation((ASTNode)importRef), 0, "", new ArrayList());
            ProgramElement imports = (ProgramElement)((ProgramElement)this.stack.peek()).getChildren().get(0);
            imports.addChild(0, peNode);
            this.stack.push(peNode);
        }
        return true;
    }

    public void endVisit(ImportReference importRef, CompilationUnitScope scope) {
        int dotIndex = importRef.toString().lastIndexOf(46);
        String currPackageImport = "";
        if (dotIndex != -1) {
            currPackageImport = importRef.toString().substring(0, dotIndex);
        }
        if (!((ProgramElement)this.stack.peek()).getPackageName().equals(currPackageImport)) {
            this.stack.pop();
        }
    }

    public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
        ProgramElement peNode = new ProgramElement(new String(fieldDeclaration.name), IProgramElement.Kind.FIELD, this.makeLocation((ASTNode)fieldDeclaration), fieldDeclaration.modifiers, "", new ArrayList());
        peNode.setCorrespondingType(fieldDeclaration.type.toString());
        peNode.setSourceSignature(this.genSourceSignature(fieldDeclaration));
        peNode.setFormalComment(this.generateJavadocComment((ASTNode)fieldDeclaration));
        ((IProgramElement)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(FieldDeclaration fieldDeclaration, MethodScope scope) {
        this.stack.pop();
    }

    private String generateJavadocComment(ASTNode astNode) {
        if (this.buildConfig != null && !this.buildConfig.isGenerateJavadocsInModelMode()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        boolean completed = false;
        int startIndex = -1;
        if (astNode instanceof MethodDeclaration) {
            startIndex = ((MethodDeclaration)astNode).declarationSourceStart;
        } else if (astNode instanceof FieldDeclaration) {
            startIndex = ((FieldDeclaration)astNode).declarationSourceStart;
        } else if (astNode instanceof TypeDeclaration) {
            startIndex = ((TypeDeclaration)astNode).declarationSourceStart;
        }
        if (startIndex == -1) {
            return null;
        }
        if (this.currCompilationResult.compilationUnit.getContents()[startIndex] == '/' && this.currCompilationResult.compilationUnit.getContents()[startIndex + 1] == '*' && this.currCompilationResult.compilationUnit.getContents()[startIndex + 2] == '*') {
            for (int i = startIndex; i < astNode.sourceStart && !completed; ++i) {
                char curr = this.currCompilationResult.compilationUnit.getContents()[i];
                if (curr == '/' && sb.length() > 2 && sb.charAt(sb.length() - 1) == '*') {
                    completed = true;
                }
                sb.append(this.currCompilationResult.compilationUnit.getContents()[i]);
            }
            return sb.toString();
        }
        return null;
    }

    private String genSourceSignature(FieldDeclaration fieldDeclaration) {
        StringBuffer output = new StringBuffer();
        ASTNode.printModifiers((int)fieldDeclaration.modifiers, (StringBuffer)output);
        fieldDeclaration.type.print(0, output).append(' ').append(fieldDeclaration.name);
        if (fieldDeclaration.initialization != null && !(fieldDeclaration.initialization instanceof QualifiedAllocationExpression)) {
            output.append(" = ");
            if (fieldDeclaration.initialization instanceof ExtendedStringLiteral) {
                output.append("\"<extended string literal>\"");
            } else {
                fieldDeclaration.initialization.printExpression(0, output);
            }
        }
        output.append(';');
        return output.toString();
    }

    public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
        if (constructorDeclaration.isDefaultConstructor) {
            this.stack.push(null);
            return true;
        }
        StringBuffer argumentsSignature = new StringBuffer();
        argumentsSignature.append("(");
        if (constructorDeclaration.arguments != null) {
            for (int i = 0; i < constructorDeclaration.arguments.length; ++i) {
                argumentsSignature.append(constructorDeclaration.arguments[i]);
                if (i + 1 >= constructorDeclaration.arguments.length) continue;
                argumentsSignature.append(",");
            }
        }
        argumentsSignature.append(")");
        ProgramElement peNode = new ProgramElement(new String(constructorDeclaration.selector) + argumentsSignature, IProgramElement.Kind.CONSTRUCTOR, this.makeLocation((ASTNode)constructorDeclaration), constructorDeclaration.modifiers, "", new ArrayList());
        peNode.setModifiers(constructorDeclaration.modifiers);
        peNode.setSourceSignature(this.genSourceSignature(constructorDeclaration));
        if (constructorDeclaration.binding != null) {
            String memberName = "";
            String memberBytecodeSignature = "";
            try {
                ResolvedMember member = EclipseFactory.makeResolvedMember(constructorDeclaration.binding);
                memberName = member.getName();
                memberBytecodeSignature = member.getSignature();
            }
            catch (NullPointerException npe) {
                memberName = "<undefined>";
            }
            peNode.setBytecodeName(memberName);
            peNode.setBytecodeSignature(memberBytecodeSignature);
        }
        ((IProgramElement)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
        this.stack.pop();
    }

    private String genSourceSignature(ConstructorDeclaration constructorDeclaration) {
        int i;
        StringBuffer output = new StringBuffer();
        ASTNode.printModifiers((int)constructorDeclaration.modifiers, (StringBuffer)output);
        output.append(constructorDeclaration.selector).append('(');
        if (constructorDeclaration.arguments != null) {
            for (i = 0; i < constructorDeclaration.arguments.length; ++i) {
                if (i > 0) {
                    output.append(", ");
                }
                constructorDeclaration.arguments[i].print(0, output);
            }
        }
        output.append(')');
        if (constructorDeclaration.thrownExceptions != null) {
            output.append(" throws ");
            for (i = 0; i < constructorDeclaration.thrownExceptions.length; ++i) {
                if (i > 0) {
                    output.append(", ");
                }
                constructorDeclaration.thrownExceptions[i].print(0, output);
            }
        }
        return output.toString();
    }

    public boolean visit(Initializer initializer, MethodScope scope) {
        if (initializer == this.inInitializer) {
            return false;
        }
        this.inInitializer = initializer;
        ProgramElement peNode = new ProgramElement("...", IProgramElement.Kind.INITIALIZER, this.makeLocation((ASTNode)initializer), initializer.modifiers, "", new ArrayList());
        ((IProgramElement)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        initializer.block.traverse((ASTVisitor)this, (BlockScope)scope);
        this.stack.pop();
        return false;
    }

    private ISourceLocation makeLocation(ASTNode node) {
        String fileName = "";
        if (this.currCompilationResult.getFileName() != null) {
            fileName = new String(this.currCompilationResult.getFileName());
        }
        int startLine = this.getStartLine(node);
        int endLine = this.getEndLine(node);
        SourceLocation loc = null;
        loc = startLine <= endLine ? new SourceLocation(new File(fileName), startLine, endLine) : new SourceLocation(new File(fileName), startLine);
        return loc;
    }

    private int getStartLine(ASTNode n) {
        return ProblemHandler.searchLineNumber((int[])this.currCompilationResult.lineSeparatorPositions, (int)n.sourceStart);
    }

    private int getEndLine(ASTNode n) {
        if (n instanceof AbstractVariableDeclaration) {
            return this.getEndLine((AbstractVariableDeclaration)n);
        }
        if (n instanceof AbstractMethodDeclaration) {
            return this.getEndLine((AbstractMethodDeclaration)n);
        }
        if (n instanceof TypeDeclaration) {
            return this.getEndLine((TypeDeclaration)n);
        }
        return ProblemHandler.searchLineNumber((int[])this.currCompilationResult.lineSeparatorPositions, (int)n.sourceEnd);
    }

    private int getEndLine(AbstractVariableDeclaration avd) {
        return ProblemHandler.searchLineNumber((int[])this.currCompilationResult.lineSeparatorPositions, (int)avd.declarationSourceEnd);
    }

    private int getEndLine(AbstractMethodDeclaration amd) {
        return ProblemHandler.searchLineNumber((int[])this.currCompilationResult.lineSeparatorPositions, (int)amd.declarationSourceEnd);
    }

    private int getEndLine(TypeDeclaration td) {
        return ProblemHandler.searchLineNumber((int[])this.currCompilationResult.lineSeparatorPositions, (int)td.declarationSourceEnd);
    }
}

