/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.bcel.ClassPathManager;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

public class EclipseClassPathManager
extends ClassPathManager {
    private INameEnvironment nameEnv;

    public EclipseClassPathManager(INameEnvironment env) {
        this.nameEnv = env;
    }

    public void setNameEnvironment(INameEnvironment env) {
        this.nameEnv = env;
    }

    public void addPath(String name, IMessageHandler handler) {
        throw new UnsupportedOperationException("Can't add paths to an *Eclipse*ClassPathManager.");
    }

    public ClassPathManager.ClassFile find(TypeX type) {
        char[][] cname;
        NameEnvironmentAnswer answer;
        ClassFileReaderBackedClassFile cf = null;
        String name = type.getName();
        if (name.endsWith(".class")) {
            name = name.substring(0, name.length() - ".class".length());
        }
        if ((answer = this.nameEnv.findType(cname = CharOperation.splitOn((char)'.', (char[])name.toCharArray()))) == null || !answer.isBinaryType()) {
            return null;
        }
        IBinaryType binType = answer.getBinaryType();
        if (!(binType instanceof ClassFileReader)) {
            throw new IllegalArgumentException("I'm only geared up to handle ClassFileReaders, and you gave me a " + binType.getClass().getName());
        }
        ClassFileReader cfr = (ClassFileReader)binType;
        cf = new ClassFileReaderBackedClassFile(cfr);
        return cf;
    }

    public List getAllClassFiles() {
        throw new UnsupportedOperationException("I don't implement getAllClassFiles()");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("EclipseClassPathManager: ");
        buf.append(this.nameEnv.toString());
        return buf.toString();
    }

    private class ClassFileReaderBackedClassFile
    extends ClassPathManager.ClassFile {
        private ClassFileReader source;

        public ClassFileReaderBackedClassFile(ClassFileReader cfr) {
            this.source = cfr;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.source.getReferenceBytes());
        }

        public String getPath() {
            return new String(this.source.getFileName());
        }
    }
}

