/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FigureUtilities {
    private static final float RGB_VALUE_MULTIPLIER = 0.6f;
    private static GC gc;
    private static Font appliedFont;
    private static FontMetrics metrics;
    private static Object LOCK;
    private static Color ghostFillColor;

    static {
        LOCK = new Object();
        ghostFillColor = new Color(null, 31, 31, 31);
    }

    public static Color darker(Color color) {
        return new Color(null, (int)((float)color.getRed() * 0.6f), (int)((float)color.getGreen() * 0.6f), (int)((float)color.getBlue() * 0.6f));
    }

    public static FontMetrics getFontMetrics(Font f) {
        FigureUtilities.setFont(f);
        return metrics;
    }

    protected static GC getGC() {
        if (gc == null) {
            Object object = LOCK;
            synchronized (object) {
                if (gc == null) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            gc = new GC((Drawable)new Shell());
                        }
                    });
                }
            }
        }
        return gc;
    }

    protected static Point getTextDimension(String s, Font f) {
        FigureUtilities.setFont(f);
        return FigureUtilities.getGC().textExtent(s);
    }

    static int getLargestSubstringConfinedTo(String s, Font f, int availableWidth) {
        FontMetrics metrics = FigureUtilities.getFontMetrics(f);
        float avg = metrics.getAverageCharWidth();
        int min = 0;
        int max = s.length() + 1;
        int guess = 0;
        int guessSize = 0;
        while (max - min > 1) {
            if ((guess += (int)((float)(availableWidth - guessSize) / avg)) >= max) {
                guess = max - 1;
            }
            if (guess <= min) {
                guess = min + 1;
            }
            if ((guessSize = FigureUtilities.getTextExtents((String)s.substring((int)0, (int)guess), (Font)f).width) < availableWidth) {
                min = guess;
                continue;
            }
            max = guess;
        }
        return min;
    }

    public static Dimension getTextExtents(String s, Font f) {
        return new Dimension(FigureUtilities.getTextDimension(s, f));
    }

    public static int getTextWidth(String s, Font f) {
        return FigureUtilities.getTextDimension((String)s, (Font)f).x;
    }

    public static Color lighter(Color rgb) {
        int r = rgb.getRed();
        int g = rgb.getGreen();
        int b = rgb.getBlue();
        return new Color(null, Math.max(2, Math.min((int)((float)r / 0.6f), 255)), Math.max(2, Math.min((int)((float)g / 0.6f), 255)), Math.max(2, Math.min((int)((float)b / 0.6f), 255)));
    }

    public static Shape makeGhostShape(Shape s) {
        s.setBackgroundColor(ghostFillColor);
        s.setFillXOR(true);
        return s;
    }

    public static Color mixColors(Color c1, Color c2) {
        return new Color(null, (c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2);
    }

    public static void paintEtchedBorder(Graphics g, Rectangle r, Color shadow, Color highlight) {
        int x = r.x;
        int y = r.y;
        int w = r.width;
        int h = r.height;
        g.setLineStyle(1);
        g.setLineWidth(1);
        g.setXORMode(false);
        g.setForegroundColor(shadow);
        g.drawRectangle(x, y, w -= 2, h -= 2);
        g.setForegroundColor(highlight);
        g.drawRectangle(++x, ++y, w, h);
    }

    public static void paintEtchedBorder(Graphics g, Rectangle r) {
        Color rgb = g.getBackgroundColor();
        Color shadow = FigureUtilities.darker(rgb);
        Color highlight = FigureUtilities.lighter(rgb);
        FigureUtilities.paintEtchedBorder(g, r, shadow, highlight);
    }

    protected static void setFont(Font f) {
        if (appliedFont == f || f.equals((Object)appliedFont)) {
            return;
        }
        FigureUtilities.getGC().setFont(f);
        appliedFont = f;
        metrics = gc.getFontMetrics();
    }

    private static class ColorVector {
        static final double RED_INTENSITY = 0.7;
        static final double BLUE_INTENSITY = 1.3;
        double r;
        double g;
        double b;

        protected ColorVector(Color source) {
            this.r = source.getRed();
            this.g = source.getGreen();
            this.b = source.getBlue();
        }

        protected double getIntensity() {
            return this.r * this.r * 0.7 + this.g * this.g + this.b * this.b * 1.3;
        }

        protected void normalize(double length) {
        }
    }
}

