/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.BufferedGraphicsSource;
import org.eclipse.draw2d.DeferredUpdateManager;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTEventDispatcher;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class LightweightSystem {
    private Canvas canvas;
    IFigure contents;
    private IFigure root;
    private EventDispatcher dispatcher;
    private UpdateManager manager;
    private Rectangle oldControlSize = new Rectangle();

    public LightweightSystem(Canvas c) {
        this();
        this.setControl(c);
    }

    public LightweightSystem() {
        this.init();
    }

    protected void addListeners() {
        EventHandler handler = this.createEventHandler();
        this.canvas.getAccessible().addAccessibleListener((AccessibleListener)handler);
        this.canvas.getAccessible().addAccessibleControlListener((AccessibleControlListener)handler);
        this.canvas.addMouseListener((MouseListener)handler);
        this.canvas.addMouseMoveListener((MouseMoveListener)handler);
        this.canvas.addMouseTrackListener((MouseTrackListener)handler);
        this.canvas.addKeyListener((KeyListener)handler);
        this.canvas.addTraverseListener((TraverseListener)handler);
        this.canvas.addFocusListener((FocusListener)handler);
        this.canvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                LightweightSystem.this.controlResized();
            }
        });
        this.canvas.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                LightweightSystem.this.paint(e.gc);
            }
        });
        this.root.setBounds(this.oldControlSize);
        this.getUpdateManager().performUpdate();
        this.setEventDispatcher(this.getEventDispatcher());
    }

    protected void controlResized() {
        Rectangle r = new Rectangle(this.canvas.getClientArea());
        r.setLocation(0, 0);
        this.root.setBounds(r);
        this.root.revalidate();
        this.manager.performUpdate();
        this.oldControlSize = r;
    }

    protected EventDispatcher getEventDispatcher() {
        if (this.dispatcher == null) {
            this.dispatcher = new SWTEventDispatcher();
        }
        return this.dispatcher;
    }

    public IFigure getRootFigure() {
        return this.root;
    }

    protected final EventHandler createEventHandler() {
        return this.internalCreateEventHandler();
    }

    protected RootFigure createRootFigure() {
        RootFigure f = new RootFigure();
        f.setOpaque(true);
        f.setLayoutManager(new StackLayout());
        return f;
    }

    public UpdateManager getUpdateManager() {
        return this.manager;
    }

    protected void init() {
        this.setRootPaneFigure(this.createRootFigure());
    }

    EventHandler internalCreateEventHandler() {
        return new EventHandler();
    }

    public void paint(GC gc) {
        this.manager.performUpdate(new Rectangle(gc.getClipping()));
    }

    public void setContents(IFigure figure) {
        if (this.contents != null) {
            this.root.remove(this.contents);
        }
        this.contents = figure;
        this.root.add(this.contents);
    }

    public void setControl(Canvas c) {
        if (this.canvas == c) {
            return;
        }
        this.canvas = c;
        this.setUpdateManager(new DeferredUpdateManager());
        this.getUpdateManager().setGraphicsSource(new BufferedGraphicsSource((Control)this.canvas));
        this.controlResized();
        this.addListeners();
    }

    public void setEventDispatcher(EventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
        dispatcher.setRoot(this.root);
        dispatcher.setControl((Control)this.canvas);
    }

    public void setRootPaneFigure(RootFigure root) {
        this.root = root;
    }

    public void setUpdateManager(UpdateManager um) {
        this.manager = um;
        this.manager.setRoot(this.root);
        if (this.root != null) {
            this.root.setUpdateManager(um);
        }
    }

    protected class RootFigure
    extends Figure {
        protected RootFigure() {
        }

        public Color getBackgroundColor() {
            if (this.bgColor != null) {
                return this.bgColor;
            }
            if (LightweightSystem.this.canvas != null) {
                return LightweightSystem.this.canvas.getBackground();
            }
            return null;
        }

        public Font getFont() {
            if (this.font != null) {
                return this.font;
            }
            if (LightweightSystem.this.canvas != null) {
                return LightweightSystem.this.canvas.getFont();
            }
            return null;
        }

        public Color getForegroundColor() {
            if (LightweightSystem.this.canvas != null) {
                return LightweightSystem.this.canvas.getForeground();
            }
            return null;
        }

        public EventDispatcher internalGetEventDispatcher() {
            return LightweightSystem.this.dispatcher;
        }
    }

    protected class EventHandler
    implements MouseMoveListener,
    MouseListener,
    KeyListener,
    MouseTrackListener,
    TraverseListener,
    FocusListener,
    AccessibleListener,
    AccessibleControlListener {
        protected EventHandler() {
        }

        public void focusGained(FocusEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchFocusGained(e);
        }

        public void focusLost(FocusEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchFocusLost(e);
        }

        public void getChild(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getChild(e);
            }
        }

        public void getChildAtPoint(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getChildAtPoint(e);
            }
        }

        public void getChildCount(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getChildCount(e);
            }
        }

        public void getChildren(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getChildren(e);
            }
        }

        public void getDefaultAction(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getDefaultAction(e);
            }
        }

        public void getDescription(AccessibleEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getDescription(e);
            }
        }

        public void getFocus(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getFocus(e);
            }
        }

        public void getHelp(AccessibleEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getHelp(e);
            }
        }

        public void getKeyboardShortcut(AccessibleEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getKeyboardShortcut(e);
            }
        }

        public void getLocation(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getLocation(e);
            }
        }

        public void getName(AccessibleEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getName(e);
            }
        }

        public void getRole(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getRole(e);
            }
        }

        public void getSelection(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getSelection(e);
            }
        }

        public void getState(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getState(e);
            }
        }

        public void getValue(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getValue(e);
            }
        }

        public void keyPressed(KeyEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchKeyPressed(e);
        }

        public void keyReleased(KeyEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchKeyReleased(e);
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 16 || e.detail == 8) {
                e.doit = true;
                LightweightSystem.this.getEventDispatcher().dispatchKeyTraversed(e);
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchMouseDoubleClicked(e);
        }

        public void mouseDown(MouseEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchMousePressed(e);
        }

        public void mouseEnter(MouseEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchMouseEntered(e);
        }

        public void mouseExit(MouseEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchMouseExited(e);
        }

        public void mouseHover(MouseEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchMouseHover(e);
        }

        public void mouseMove(MouseEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchMouseMoved(e);
        }

        public void mouseUp(MouseEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchMouseReleased(e);
        }
    }
}

