/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;

public class ToolbarLayout
extends AbstractLayout {
    private int spacing;
    private Dimension minimumSize;
    private boolean matchWidth;
    protected boolean horizontal = false;
    protected int minorAlignment;
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_TOPLEFT = 1;
    public static final int ALIGN_BOTTOMRIGHT = 2;
    public static final boolean HORIZONTAL = true;
    public static final boolean VERTICAL = false;
    protected Transposer transposer = new Transposer();

    public ToolbarLayout() {
        this.transposer.setEnabled(this.horizontal);
        this.spacing = 0;
        this.matchWidth = true;
        this.minorAlignment = 1;
        this.horizontal = false;
    }

    public ToolbarLayout(boolean isHorizontal) {
        this.transposer.setEnabled(this.horizontal);
        this.horizontal = isHorizontal;
        this.transposer.setEnabled(this.horizontal);
        this.spacing = 0;
        this.matchWidth = false;
        this.minorAlignment = 1;
    }

    public Dimension calculateMinimumSize(IFigure parent) {
        Insets insets = this.transposer.t(parent.getInsets());
        int height = 0;
        int width = 0;
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension childSize = this.transposer.t(child.getMinimumSize());
            height += childSize.height;
            width = Math.max(width, childSize.width);
            ++i;
        }
        Dimension d = new Dimension(width, height);
        d.height += insets.getHeight() + (children.size() - 1) * this.spacing;
        d.width += insets.getWidth();
        return this.transposer.t(d);
    }

    public Dimension getMinimumSize(IFigure container) {
        if (this.minimumSize == null) {
            this.minimumSize = this.calculateMinimumSize(container);
        }
        return this.minimumSize;
    }

    public void invalidate() {
        this.minimumSize = null;
        super.invalidate();
    }

    protected Dimension calculatePreferredSize(IFigure parent) {
        int height = 0;
        int width = 0;
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension childSize = this.transposer.t(child.getPreferredSize());
            height += childSize.height;
            width = Math.max(width, childSize.width);
            ++i;
        }
        Dimension preferred = this.transposer.t(new Dimension(width, height += (children.size() - 1) * this.spacing));
        Insets insets = parent.getInsets();
        preferred.height += insets.getHeight();
        preferred.width += insets.getWidth();
        preferred.union(this.getBorderPreferredSize(parent));
        return preferred;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void layout(IFigure parent) {
        IFigure child;
        List children = parent.getChildren();
        int numChildren = children.size();
        Rectangle clientArea = this.transposer.t(parent.getClientArea());
        int x = clientArea.x;
        int y = clientArea.y;
        int availableHeight = clientArea.height;
        Dimension[] prefSizes = new Dimension[numChildren];
        Dimension[] minSizes = new Dimension[numChildren];
        int totalHeight = 0;
        int totalMinHeight = 0;
        int prefMinSumHeight = 0;
        int i = 0;
        while (i < numChildren) {
            child = (IFigure)children.get(i);
            prefSizes[i] = this.transposer.t(child.getPreferredSize());
            minSizes[i] = this.transposer.t(child.getMinimumSize());
            totalHeight += prefSizes[i].height;
            totalMinHeight += minSizes[i].height;
            prefMinSumHeight += prefSizes[i].height - minSizes[i].height;
            ++i;
        }
        int amntShrinkHeight = (totalHeight += (numChildren - 1) * this.spacing) - Math.max(availableHeight, totalMinHeight += (numChildren - 1) * this.spacing);
        if (amntShrinkHeight < 0) {
            amntShrinkHeight = 0;
        }
        int i2 = 0;
        while (i2 < numChildren) {
            int amntShrinkCurrentHeight = 0;
            int prefHeight = prefSizes[i2].height;
            int minHeight = minSizes[i2].height;
            int prefWidth = prefSizes[i2].width;
            int minWidth = minSizes[i2].width;
            Rectangle newBounds = new Rectangle(x, y, prefWidth, prefHeight);
            child = (IFigure)children.get(i2);
            if (prefMinSumHeight != 0) {
                amntShrinkCurrentHeight = (prefHeight - minHeight) * amntShrinkHeight / prefMinSumHeight;
            }
            int width = Math.min(prefWidth, child.getMaximumSize().width);
            if (this.matchWidth) {
                width = this.transposer.t((Dimension)child.getMaximumSize()).width;
            }
            newBounds.width = width = Math.max(minWidth, Math.min(clientArea.width, width));
            int adjust = clientArea.width - width;
            switch (this.minorAlignment) {
                case 1: {
                    adjust = 0;
                    break;
                }
                case 0: {
                    adjust /= 2;
                    break;
                }
            }
            newBounds.x += adjust;
            newBounds.height -= amntShrinkCurrentHeight;
            child.setBounds(this.transposer.t(newBounds));
            amntShrinkHeight -= amntShrinkCurrentHeight;
            prefMinSumHeight -= prefHeight - minHeight;
            y += newBounds.height + this.spacing;
            ++i2;
        }
    }

    public void setMinorAlignment(int align) {
        this.minorAlignment = align;
    }

    public void setSpacing(int space) {
        this.spacing = space;
    }

    public void setMatchWidth(boolean match) {
        this.matchWidth = match;
    }

    public void setVertical(boolean flag) {
        if (this.horizontal != flag) {
            return;
        }
        this.invalidate();
        this.horizontal = !flag;
        this.transposer.setEnabled(this.horizontal);
    }
}

