/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.util;

import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;

public class ImageDataHelper {
    public static int getNearestColorIndex(int red, int green, int blue, RGB[] colors) {
        int minLength = Integer.MAX_VALUE;
        int minIndex = 0;
        int i = 0;
        while (i < colors.length) {
            RGB rgb = colors[i];
            int rgbRed = rgb.red;
            int rgbGreen = rgb.green;
            int rgbBlue = rgb.blue;
            if (rgbRed == red && rgbGreen == green && rgbBlue == blue) {
                return i;
            }
            int redVector = rgbRed - red;
            int greenVector = rgbGreen - green;
            int blueVector = rgbBlue - blue;
            int lengthSquared = redVector * redVector + greenVector * greenVector + blueVector * blueVector;
            if (lengthSquared < minLength) {
                minLength = lengthSquared;
                minIndex = i;
            }
            ++i;
        }
        return minIndex;
    }

    public static void getPixels(ImageData imageData, int x, int y, int width, int[] pixelRow) {
        byte[] data = imageData.data;
        int depth = imageData.depth;
        int bytesPerLine = imageData.bytesPerLine;
        if (depth == 1) {
            int index = y * bytesPerLine + (x >> 3);
            int theByte = data[index] & 0xFF;
            int mask = 1 << 7 - (x & 7);
            int i = 0;
            int n = width;
            while (n > 1) {
                pixelRow[i] = (theByte & mask) == 0 ? 0 : 1;
                if (mask == 1) {
                    mask = 128;
                    theByte = data[++index];
                } else {
                    mask >>= 1;
                }
                --n;
                ++i;
            }
            pixelRow[i] = (theByte & mask) == 0 ? 0 : 1;
            return;
        }
        if (depth == 4) {
            int theByte;
            int index = y * bytesPerLine + (x >> 1);
            int n = width;
            int i = 0;
            if ((x & 1) == 1) {
                theByte = data[index++] & 0xFF;
                pixelRow[i++] = theByte & 0xF;
                --n;
            }
            while (n > 1) {
                theByte = data[index++] & 0xFF;
                pixelRow[i++] = theByte >> 4;
                pixelRow[i++] = theByte & 0xF;
                n -= 2;
            }
            if (n > 0) {
                theByte = data[index] & 0xFF;
                pixelRow[i] = theByte >> 4;
            }
            return;
        }
        if (depth == 8) {
            int index = y * bytesPerLine + x;
            int i = 0;
            while (i < width) {
                pixelRow[i] = data[index++] & 0xFF;
                ++i;
            }
            return;
        }
        if (depth == 16) {
            int index = y * bytesPerLine + x * 2;
            int i = 0;
            while (i < width) {
                pixelRow[i] = (data[index] & 0xFF) << 8 | data[index + 1] & 0xFF;
                index += 2;
                ++i;
            }
            return;
        }
        if (depth == 24) {
            int index = y * bytesPerLine + x * 3;
            int i = 0;
            while (i < width) {
                pixelRow[i] = (data[index] & 0xFF) << 16 | (data[index + 1] & 0xFF) << 8 | data[index + 2] & 0xFF;
                index += 3;
                ++i;
            }
            return;
        }
        if (depth == 32) {
            int index = y * bytesPerLine + x * 4;
            int i = 0;
            while (i < width) {
                pixelRow[i] = (data[index] & 0xFF) << 24 | (data[index + 1] & 0xFF) << 16 | (data[index + 2] & 0xFF) << 8 | data[index + 3] & 0xFF;
                index += 4;
                ++i;
            }
            return;
        }
    }

    public static ImageData mixAlphaWithinRegion(ImageData fromImageData, Region region, double alpha, RGB backColor) {
        double cba = 1.0 - alpha;
        int redCba = (int)((double)backColor.red * cba + 0.5);
        int greenCba = (int)((double)backColor.green * cba + 0.5);
        int blueCba = (int)((double)backColor.blue * cba + 0.5);
        int aNum = (int)(alpha * 100.0 + 0.5);
        PaletteData palette = fromImageData.palette;
        boolean isDirect = palette.isDirect;
        RGB[] colors = palette.getRGBs();
        byte[] fromData = fromImageData.data;
        byte[] toData = new byte[fromData.length];
        System.arraycopy(fromData, 0, toData, 0, fromData.length);
        int depth = fromImageData.depth;
        int bytesPerLine = fromImageData.bytesPerLine;
        Rectangle outerBounds = region.getBounds().intersection(new Rectangle(0, 0, fromImageData.width, fromImageData.height));
        if (depth != 1) {
            int y = outerBounds.y;
            int endY = outerBounds.y + outerBounds.height;
            while (y < endY) {
                int red;
                int endX;
                int endX2;
                int index;
                int x;
                if (depth == 4) {
                    x = outerBounds.x;
                    index = y * bytesPerLine + (x >> 1);
                    boolean isUpperNibble = (outerBounds.x & 1) == 0;
                    endX2 = x + outerBounds.width;
                    while (x < endX2) {
                        if (region.contains(x, y)) {
                            int pixel = isUpperNibble ? (toData[index] & 0xFF) >>> 4 : toData[index] & 0xF;
                            RGB color = colors[pixel];
                            int red2 = color.red * aNum / 100 + redCba;
                            int green = color.green * aNum / 100 + greenCba;
                            int blue = color.blue * aNum / 100 + blueCba;
                            pixel = ImageDataHelper.getNearestColorIndex(red2, green, blue, colors);
                            toData[index] = isUpperNibble ? (byte)(toData[index] & 0xF | (byte)(pixel << 4)) : (byte)(toData[index] & 0xF0 | (byte)pixel);
                        }
                        if (!isUpperNibble) {
                            ++index;
                        }
                        isUpperNibble = !isUpperNibble;
                        ++x;
                    }
                } else if (depth == 8) {
                    x = outerBounds.x;
                    index = y * bytesPerLine + x;
                    endX = x + outerBounds.width;
                    while (x < endX) {
                        if (region.contains(x, y)) {
                            RGB color = colors[toData[index] & 0xFF];
                            red = color.red * aNum / 100 + redCba;
                            int green = color.green * aNum / 100 + greenCba;
                            int blue = color.blue * aNum / 100 + blueCba;
                            toData[index] = (byte)ImageDataHelper.getNearestColorIndex(red, green, blue, colors);
                        }
                        ++index;
                        ++x;
                    }
                } else if (depth == 16) {
                    x = outerBounds.x;
                    index = y * bytesPerLine + x * 2;
                    endX = x + outerBounds.width;
                    while (x < endX) {
                        if (region.contains(x, y)) {
                            int red3;
                            int green;
                            int blue;
                            if (isDirect) {
                                blue = (toData[index] & 0x1F) * aNum / 100 + blueCba;
                                green = ((toData[index] & 0xFF) >>> 5 | (toData[index + 1] & 3) << 3) * aNum / 100 + greenCba;
                                red3 = ((toData[index + 1] & 0xFF) >>> 2) * aNum / 100 + redCba;
                                toData[index] = (byte)(green << 5 | blue);
                                toData[index + 1] = (byte)(red3 << 2 | green >>> 3);
                            } else {
                                RGB color = colors[(toData[index] & 0xFF) + ((toData[index + 1] & 0xFF) << 8)];
                                red3 = color.red * aNum / 100 + redCba;
                                green = color.green * aNum / 100 + greenCba;
                                blue = color.blue * aNum / 100 + blueCba;
                                int newColorIndex = ImageDataHelper.getNearestColorIndex(red3, green, blue, colors);
                                toData[index] = (byte)newColorIndex;
                                toData[index + 1] = (byte)(newColorIndex >>> 8);
                            }
                        }
                        index += 2;
                        ++x;
                    }
                } else if (depth == 24 || depth == 32) {
                    int byteDepth = depth == 32 ? 4 : 3;
                    int x2 = outerBounds.x;
                    int index2 = y * bytesPerLine + x2 * byteDepth;
                    endX2 = x2 + outerBounds.width;
                    while (x2 < endX2) {
                        if (region.contains(x2, y)) {
                            int green;
                            int blue;
                            if (isDirect) {
                                blue = (toData[index2] & 0xFF) * aNum / 100 + blueCba;
                                green = (toData[index2 + 1] & 0xFF) * aNum / 100 + greenCba;
                                red = (toData[index2 + 2] & 0xFF) * aNum / 100 + redCba;
                                toData[index2] = (byte)blue;
                                toData[index2 + 1] = (byte)green;
                                toData[index2 + 2] = (byte)red;
                            } else {
                                RGB color = colors[(toData[index2] & 0xFF) + ((toData[index2 + 1] & 0xFF) << 8) + ((toData[index2 + 2] & 0xFF) << 16)];
                                red = color.red * aNum / 100 + redCba;
                                green = color.green * aNum / 100 + greenCba;
                                blue = color.blue * aNum / 100 + blueCba;
                                int newColorIndex = ImageDataHelper.getNearestColorIndex(red, green, blue, colors);
                                toData[index2] = (byte)newColorIndex;
                                toData[index2 + 1] = (byte)(newColorIndex >>> 8);
                                toData[index2 + 2] = (byte)(newColorIndex >>> 16);
                            }
                        }
                        index2 += byteDepth;
                        ++x2;
                    }
                }
                ++y;
            }
        }
        return new ImageData(fromImageData.width, fromImageData.height, depth, palette, fromImageData.scanlinePad, toData);
    }

    public static void setPixels(ImageData dest, int x, int y, int putWidth, int[] pixels, int startIndex) {
        if (pixels == null) {
            return;
        }
        int depth = dest.depth;
        int bytesPerLine = dest.bytesPerLine;
        byte[] data = dest.data;
        if (putWidth <= 0) {
            return;
        }
        if (depth == 1) {
            int index = y * bytesPerLine + (x >> 3);
            int theByte = data[index];
            int mask = 1 << 7 - (x & 7);
            int n = putWidth;
            int i = startIndex;
            while (n > 1) {
                theByte = (pixels[i] & 1) == 1 ? (theByte |= mask) : (theByte &= ~mask);
                ++i;
                --n;
                if (mask == 1) {
                    data[index] = (byte)theByte;
                    mask = 128;
                    theByte = data[++index];
                    continue;
                }
                mask >>= 1;
            }
            theByte = (pixels[i] & 1) == 1 ? (theByte |= mask) : (theByte &= ~mask);
            data[index] = (byte)theByte;
            return;
        }
        if (depth == 4) {
            int theByte;
            int index = y * bytesPerLine + (x >> 1);
            int n = putWidth;
            int i = startIndex;
            if ((x & 1) == 1) {
                theByte = data[index] & 0xF0 | pixels[i] & 0xF;
                data[index] = (byte)theByte;
                ++i;
                --n;
                ++index;
            }
            while (n > 1) {
                theByte = (pixels[i] & 0xF) << 4 | pixels[i + 1] & 0xF;
                data[index] = (byte)theByte;
                i += 2;
                n -= 2;
                ++index;
            }
            if (n > 0) {
                theByte = data[index] & 0xF | (pixels[i] & 0xF) << 4;
                data[index] = (byte)theByte;
            }
            return;
        }
        if (depth == 8) {
            int index = y * bytesPerLine + x;
            int i = startIndex;
            int j = 0;
            while (j < putWidth) {
                data[index] = (byte)(pixels[i] & 0xFF);
                ++i;
                ++index;
                ++j;
            }
            return;
        }
        if (depth == 16) {
            int index = y * bytesPerLine + x * 2;
            int i = startIndex;
            int j = 0;
            while (j < putWidth) {
                int pixel = pixels[i];
                data[index + 1] = (byte)(pixel >> 8 & 0xFF);
                data[index] = (byte)(pixel & 0xFF);
                ++i;
                index += 2;
                ++j;
            }
            return;
        }
        if (depth == 24) {
            int index = y * bytesPerLine + x * 3;
            int i = startIndex;
            int j = 0;
            while (j < putWidth) {
                int pixel = pixels[i];
                data[index + 2] = (byte)(pixel >> 16 & 0xFF);
                data[index + 1] = (byte)(pixel >> 8 & 0xFF);
                data[index] = (byte)(pixel & 0xFF);
                ++i;
                index += 3;
                ++j;
            }
            return;
        }
        if (depth == 32) {
            int index = y * bytesPerLine + x * 4;
            int i = startIndex;
            int j = 0;
            while (j < putWidth) {
                int pixel = pixels[i];
                data[index] = (byte)(pixel >> 24 & 0xFF);
                data[index + 1] = (byte)(pixel >> 16 & 0xFF);
                data[index + 2] = (byte)(pixel >> 8 & 0xFF);
                data[index + 3] = (byte)(pixel & 0xFF);
                ++i;
                index += 4;
                ++j;
            }
            return;
        }
    }
}

