/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ajdocexport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.ajdt.ajdocexport.JavadocWriter;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocReader;
import org.eclipse.jdt.internal.ui.javadocexport.RecentSettingsStore;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JavadocOptionsManager {
    private IFile fXmlfile;
    private StatusInfo fWizardStatus;
    private String[] fJavadocCommandHistory;
    private IJavaElement[] fSelectedElements;
    private IJavaElement[] fInitialElements;
    private String fAccess;
    private String fDocletpath;
    private String fDocletname;
    private boolean fFromStandard;
    private String fStylesheet;
    private String fAdditionalParams;
    private String fVMParams;
    private String fOverview;
    private String fTitle;
    private String[] fHRefs;
    private IPath[] fSourcepath;
    private IPath[] fClasspath;
    private boolean fNotree;
    private boolean fNoindex;
    private boolean fSplitindex;
    private boolean fNonavbar;
    private boolean fNodeprecated;
    private boolean fNoDeprecatedlist;
    private boolean fAuthor;
    private boolean fVersion;
    private boolean fUse;
    private boolean fJDK14Mode;
    private boolean fOpenInBrowser;
    private RecentSettingsStore fRecentSettings;
    private String fDestination;
    private String fAntpath;
    public final String PRIVATE = "private";
    public final String PROTECTED = "protected";
    public final String PACKAGE = "package";
    public final String PUBLIC = "public";
    public final String USE = "use";
    public final String NOTREE = "notree";
    public final String NOINDEX = "noindex";
    public final String NONAVBAR = "nonavbar";
    public final String NODEPRECATED = "nodeprecated";
    public final String NODEPRECATEDLIST = "nodeprecatedlist";
    public final String VERSION = "version";
    public final String AUTHOR = "author";
    public final String SPLITINDEX = "splitindex";
    public final String STYLESHEETFILE = "stylesheetfile";
    public final String OVERVIEW = "overview";
    public final String DOCLETNAME = "docletname";
    public final String DOCLETPATH = "docletpath";
    public final String SOURCEPATH = "sourcepath";
    public final String CLASSPATH = "classpath";
    public final String DESTINATION = "destdir";
    public final String OPENINBROWSER = "openinbrowser";
    public final String VISIBILITY = "access";
    public final String PACKAGENAMES = "packagenames";
    public final String SOURCEFILES = "sourcefiles";
    public final String EXTRAOPTIONS = "additionalparam";
    public final String VMOPTIONS = "vmparam";
    public final String TITLE = "doctitle";
    public final String HREF = "href";
    public final String NAME = "name";
    public final String PATH = "path";
    public final String FROMSTANDARD = "fromStandard";
    public final String ANTPATH = "antpath";
    public final String SOURCE = "source";
    private final String SECTION_AJDOC = "ajdoc";
    private static final String AJDOC_COMMAND_HISTORY = "ajdoc_command_history";
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;

    public JavadocOptionsManager(IFile iFile, IDialogSettings iDialogSettings, List list) {
        this.fXmlfile = iFile;
        this.fWizardStatus = new StatusInfo();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection("ajdoc");
        String string = null;
        if (iDialogSettings2 != null) {
            string = iDialogSettings2.get(AJDOC_COMMAND_HISTORY);
        }
        if (string == null || string.length() == 0) {
            string = JavadocOptionsManager.initJavadocCommandDefault();
        }
        this.fJavadocCommandHistory = this.arrayFromFlatString(string);
        this.fRecentSettings = new RecentSettingsStore(iDialogSettings2);
        if (iFile != null) {
            try {
                JavadocReader javadocReader = new JavadocReader(iFile.getContents());
                Element element = javadocReader.readXML();
                if (element != null) {
                    this.loadFromXML(element);
                    return;
                }
                this.fWizardStatus.setWarning(JavadocExportMessages.getString((String)"JavadocOptionsManager.antfileincorrectCE.warning"));
            }
            catch (CoreException coreException) {
                JavaPlugin.log((Throwable)coreException);
                this.fWizardStatus.setWarning(JavadocExportMessages.getString((String)"JavadocOptionsManager.antfileincorrectCE.warning"));
            }
            catch (IOException iOException) {
                JavaPlugin.log((Throwable)iOException);
                this.fWizardStatus.setWarning(JavadocExportMessages.getString((String)"JavadocOptionsManager.antfileincorrectIOE.warning"));
            }
            catch (SAXException sAXException) {
                this.fWizardStatus.setWarning(JavadocExportMessages.getString((String)"JavadocOptionsManager.antfileincorrectSAXE.warning"));
            }
        }
        if (iDialogSettings2 != null) {
            this.loadFromDialogStore(iDialogSettings2, list);
        } else {
            this.loadDefaults(list);
        }
    }

    private IJavaProject getSingleProjectFromInitialSelection() {
        IJavaProject iJavaProject = null;
        for (int i = 0; i < this.fInitialElements.length; ++i) {
            IJavaProject iJavaProject2 = this.fInitialElements[i].getJavaProject();
            if (iJavaProject == null) {
                iJavaProject = iJavaProject2;
                continue;
            }
            if (iJavaProject.equals(iJavaProject2)) continue;
            return null;
        }
        return iJavaProject;
    }

    private void loadFromDialogStore(IDialogSettings iDialogSettings, List list) {
        this.fInitialElements = this.getInitialElementsFromSelection(list);
        IJavaProject iJavaProject = this.getSingleProjectFromInitialSelection();
        this.fAccess = iDialogSettings.get("access");
        if (this.fAccess == null) {
            this.fAccess = "protected";
        }
        this.fFromStandard = iDialogSettings.getBoolean("fromStandard");
        this.fDocletpath = iDialogSettings.get("docletpath");
        this.fDocletname = iDialogSettings.get("docletname");
        if (this.fDocletpath == null || this.fDocletname == null) {
            this.fFromStandard = true;
            this.fDocletpath = "";
            this.fDocletname = "";
        }
        if (iJavaProject != null) {
            this.fAntpath = this.getRecentSettings().getAntpath(iJavaProject);
        } else {
            this.fAntpath = iDialogSettings.get("antpath");
            if (this.fAntpath == null) {
                this.fAntpath = "";
            }
        }
        if (iJavaProject != null) {
            this.fDestination = this.getRecentSettings().getDestination(iJavaProject);
        } else {
            this.fDestination = iDialogSettings.get("destdir");
            if (this.fDestination == null) {
                this.fDestination = "";
            }
        }
        this.fTitle = iDialogSettings.get("doctitle");
        if (this.fTitle == null) {
            this.fTitle = "";
        }
        this.fStylesheet = iDialogSettings.get("stylesheetfile");
        if (this.fStylesheet == null) {
            this.fStylesheet = "";
        }
        this.fVMParams = iDialogSettings.get("vmparam");
        if (this.fVMParams == null) {
            this.fVMParams = "";
        }
        this.fAdditionalParams = iDialogSettings.get("additionalparam");
        if (this.fAdditionalParams == null) {
            this.fAdditionalParams = "";
        }
        this.fOverview = iDialogSettings.get("overview");
        if (this.fOverview == null) {
            this.fOverview = "";
        }
        this.fUse = this.loadBoolean(iDialogSettings.get("use"));
        this.fAuthor = this.loadBoolean(iDialogSettings.get("author"));
        this.fVersion = this.loadBoolean(iDialogSettings.get("version"));
        this.fNodeprecated = this.loadBoolean(iDialogSettings.get("nodeprecated"));
        this.fNoDeprecatedlist = this.loadBoolean(iDialogSettings.get("nodeprecatedlist"));
        this.fNonavbar = this.loadBoolean(iDialogSettings.get("nonavbar"));
        this.fNoindex = this.loadBoolean(iDialogSettings.get("noindex"));
        this.fNotree = this.loadBoolean(iDialogSettings.get("notree"));
        this.fSplitindex = this.loadBoolean(iDialogSettings.get("splitindex"));
        this.fOpenInBrowser = this.loadBoolean(iDialogSettings.get("openinbrowser"));
        this.fJDK14Mode = this.loadBoolean(iDialogSettings.get("source"));
        this.fHRefs = iJavaProject != null ? this.getRecentSettings().getHRefs(iJavaProject) : new String[0];
    }

    private void loadDefaults(List list) {
        this.fInitialElements = this.getInitialElementsFromSelection(list);
        IJavaProject iJavaProject = this.getSingleProjectFromInitialSelection();
        if (iJavaProject != null) {
            this.fAntpath = this.getRecentSettings().getAntpath(iJavaProject);
            this.fDestination = this.getRecentSettings().getDestination(iJavaProject);
            this.fHRefs = this.getRecentSettings().getHRefs(iJavaProject);
        } else {
            this.fAntpath = "";
            this.fDestination = "";
            this.fHRefs = new String[0];
        }
        this.fAccess = "public";
        this.fDocletname = "";
        this.fDocletpath = "";
        this.fTitle = "";
        this.fStylesheet = "";
        this.fVMParams = "";
        this.fAdditionalParams = "";
        this.fOverview = "";
        this.fUse = true;
        this.fAuthor = true;
        this.fVersion = true;
        this.fNodeprecated = false;
        this.fNoDeprecatedlist = false;
        this.fNonavbar = false;
        this.fNoindex = false;
        this.fNotree = false;
        this.fSplitindex = true;
        this.fOpenInBrowser = false;
        this.fJDK14Mode = false;
        this.fFromStandard = true;
    }

    private void loadFromXML(Element element) {
        Object object;
        int n;
        NodeList nodeList;
        this.fAccess = element.getAttribute("access");
        if (this.fAccess.length() == 0) {
            this.fAccess = "protected";
        }
        String string = element.getAttribute("destdir");
        this.fDestination = this.makeAbsolutePathFromRelative(string).toOSString();
        this.fFromStandard = true;
        this.fDocletname = "";
        this.fDocletpath = "";
        if (string.length() == 0) {
            nodeList = element.getChildNodes();
            for (n = 0; n < nodeList.getLength(); ++n) {
                object = nodeList.item(n);
                if (!object.getNodeName().equals("doclet")) continue;
                this.fDocletpath = ((Element)object).getAttribute("path");
                this.fDocletname = ((Element)object).getAttribute("name");
                if (this.fDocletpath.length() != 0 || this.fDocletname.length() != 0) {
                    this.fFromStandard = false;
                    break;
                }
                this.fDocletname = "";
                this.fDocletpath = "";
                break;
            }
        }
        this.fInitialElements = this.getSelectedElementsFromAnt(element);
        nodeList = element.getChildNodes();
        this.fHRefs = new String[nodeList.getLength()];
        for (n = 0; n < this.fHRefs.length; ++n) {
            object = nodeList.item(n);
            if (!object.getNodeName().equals("link")) continue;
            this.fHRefs[n] = ((Element)object).getAttribute("href");
        }
        IPath iPath = this.fXmlfile.getLocation();
        this.fAntpath = iPath != null ? iPath.toOSString() : "";
        this.fStylesheet = element.getAttribute("stylesheetfile");
        this.fTitle = element.getAttribute("doctitle");
        object = new StringBuffer();
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = element.getAttribute("additionalparam");
        if (string2.length() > 0) {
            ExecutionArguments executionArguments = new ExecutionArguments("", string2);
            String[] stringArray = executionArguments.getProgramArgumentsArray();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (string3.length() > 0 && string3.charAt(0) == '-') {
                    boolean bl2 = bl = string3.length() > 1 && string3.charAt(1) == 'J';
                }
                if (bl) {
                    stringBuffer.append(string3).append(' ');
                    continue;
                }
                ((StringBuffer)object).append(string3).append(' ');
            }
        }
        this.fAdditionalParams = ((StringBuffer)object).toString();
        this.fVMParams = stringBuffer.toString();
        this.fOverview = element.getAttribute("overview");
        this.fUse = this.loadBoolean(element.getAttribute("use"));
        this.fAuthor = this.loadBoolean(element.getAttribute("author"));
        this.fVersion = this.loadBoolean(element.getAttribute("version"));
        this.fNodeprecated = this.loadBoolean(element.getAttribute("nodeprecated"));
        this.fNoDeprecatedlist = this.loadBoolean(element.getAttribute("nodeprecatedlist"));
        this.fNonavbar = this.loadBoolean(element.getAttribute("nonavbar"));
        this.fNoindex = this.loadBoolean(element.getAttribute("noindex"));
        this.fNotree = this.loadBoolean(element.getAttribute("notree"));
        this.fSplitindex = this.loadBoolean(element.getAttribute("splitindex"));
    }

    private IPath makeAbsolutePathFromRelative(String string) {
        Path path = new Path(string);
        if (!path.isAbsolute()) {
            if (this.fXmlfile == null) {
                return null;
            }
            IPath iPath = this.fXmlfile.getParent().getLocation();
            if (iPath == null) {
                return null;
            }
            return iPath.append(string);
        }
        return path;
    }

    private IContainer[] getSourceContainers(Element element) {
        String string = element.getAttribute("sourcepath");
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(File.pathSeparatorChar));
        ArrayList<IContainer> arrayList = new ArrayList<IContainer>();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        while (stringTokenizer.hasMoreTokens()) {
            IPath iPath = this.makeAbsolutePathFromRelative(stringTokenizer.nextToken().trim());
            if (iPath == null) continue;
            IContainer[] iContainerArray = iWorkspaceRoot.findContainersForLocation(iPath);
            for (int i = 0; i < iContainerArray.length; ++i) {
                arrayList.add(iContainerArray[i]);
            }
        }
        return arrayList.toArray(new IContainer[arrayList.size()]);
    }

    private IJavaElement[] getSelectedElementsFromAnt(Element element) {
        IResource iResource;
        IPath iPath;
        StringTokenizer stringTokenizer;
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = element.getAttribute("packagenames");
        if (string != null) {
            object2 = this.getSourceContainers(element);
            object = new StringTokenizer(string, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                stringTokenizer = new Path(((StringTokenizer)object).nextToken().trim().replace('.', '/'));
                for (int i = 0; i < ((IContainer[])object2).length; ++i) {
                    IJavaElement iJavaElement;
                    iPath = object2[i];
                    iResource = iPath.findMember((IPath)stringTokenizer);
                    if (iResource == null || !((iJavaElement = JavaCore.create((IResource)iResource)) instanceof IPackageFragment)) continue;
                    arrayList.add(iJavaElement);
                }
            }
        }
        if ((object2 = element.getAttribute("sourcefiles")) != null) {
            object = ResourcesPlugin.getWorkspace().getRoot();
            stringTokenizer = new StringTokenizer((String)object2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (!string2.endsWith(".java") || (iPath = this.makeAbsolutePathFromRelative(string2)) == null) continue;
                iResource = object.findFilesForLocation(iPath);
                for (int i = 0; i < ((IResource)iResource).length; ++i) {
                    ICompilationUnit iCompilationUnit = JavaCore.createCompilationUnitFrom((IFile)iResource[i]);
                    if (iCompilationUnit == null) continue;
                    arrayList.add(iCompilationUnit);
                }
            }
        }
        return arrayList.toArray(new IJavaElement[arrayList.size()]);
    }

    public String[] getJavadocCommandHistory() {
        return this.fJavadocCommandHistory;
    }

    public StatusInfo getWizardStatus() {
        return this.fWizardStatus;
    }

    public IJavaElement[] getInitialElements() {
        return this.fInitialElements;
    }

    public IJavaElement[] getSourceElements() {
        return this.fSelectedElements;
    }

    public String getAccess() {
        return this.fAccess;
    }

    public String getAntpath() {
        return this.fAntpath;
    }

    public boolean isFromStandard() {
        return this.fFromStandard;
    }

    public String getDestination() {
        return this.fDestination;
    }

    public String getDocletPath() {
        return this.fDocletpath;
    }

    public String getDocletName() {
        return this.fDocletname;
    }

    public String getStyleSheet() {
        return this.fStylesheet;
    }

    public String getOverview() {
        return this.fOverview;
    }

    public String getAdditionalParams() {
        return this.fAdditionalParams;
    }

    public String getVMParams() {
        return this.fVMParams;
    }

    public IPath[] getClasspath() {
        return this.fClasspath;
    }

    public IPath[] getSourcepath() {
        return this.fSourcepath;
    }

    public String getTitle() {
        return this.fTitle;
    }

    public boolean doOpenInBrowser() {
        return this.fOpenInBrowser;
    }

    public String[] getHRefs() {
        return this.fHRefs;
    }

    public boolean getBoolean(String string) {
        if (string.equals("author")) {
            return this.fAuthor;
        }
        if (string.equals("version")) {
            return this.fVersion;
        }
        if (string.equals("use")) {
            return this.fUse;
        }
        if (string.equals("nodeprecated")) {
            return this.fNodeprecated;
        }
        if (string.equals("nodeprecatedlist")) {
            return this.fNoDeprecatedlist;
        }
        if (string.equals("noindex")) {
            return this.fNoindex;
        }
        if (string.equals("notree")) {
            return this.fNotree;
        }
        if (string.equals("splitindex")) {
            return this.fSplitindex;
        }
        if (string.equals("nonavbar")) {
            return this.fNonavbar;
        }
        return false;
    }

    private boolean loadBoolean(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equals("true");
    }

    private String flatPathList(IPath[] iPathArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < iPathArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(iPathArray[i].toOSString());
        }
        return stringBuffer.toString();
    }

    private String flatStringList(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private String[] arrayFromFlatString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public void getArgumentArray(List list, List list2) {
        int n;
        String[] stringArray;
        String[] stringArray2;
        ExecutionArguments executionArguments;
        if (this.fFromStandard) {
            list2.add("-d");
            list2.add(this.fDestination);
        } else {
            if (this.fAdditionalParams.length() + this.fVMParams.length() != 0) {
                executionArguments = new ExecutionArguments(this.fVMParams, this.fAdditionalParams);
                stringArray2 = executionArguments.getVMArgumentsArray();
                for (int i = 0; i < stringArray2.length; ++i) {
                    list.add(stringArray2[i]);
                }
                stringArray = executionArguments.getProgramArgumentsArray();
                for (n = 0; n < stringArray.length; ++n) {
                    list2.add(stringArray[n]);
                }
            }
            list2.add("-doclet");
            list2.add(this.fDocletname);
            list2.add("-docletpath");
            list2.add(this.fDocletpath);
        }
        list2.add("-sourcepath");
        list2.add(this.flatPathList(this.fSourcepath));
        list2.add("-classpath");
        list2.add(this.flatPathList(this.fClasspath));
        list2.add("-" + this.fAccess);
        if (this.fFromStandard) {
            if (this.fJDK14Mode) {
                list2.add("-source");
                list2.add("1.4");
            }
            if (this.fVersion) {
                list2.add("-version");
            }
            if (this.fAuthor) {
                list2.add("-author");
            }
            if (this.fNonavbar) {
                list2.add("-nonavbar");
            }
            if (this.fNoindex) {
                list2.add("-noindex");
            }
            if (this.fNotree) {
                list2.add("-notree");
            }
            if (this.fNodeprecated) {
                list2.add("-nodeprecated");
            }
            if (this.fNoDeprecatedlist) {
                list2.add("-nodeprecatedlist");
            }
            if (this.fSplitindex) {
                list2.add("-splitindex");
            }
            if (this.fTitle.length() != 0) {
                list2.add("-doctitle");
                list2.add(this.fTitle);
            }
            if (this.fStylesheet.length() != 0) {
                list2.add("-stylesheetfile");
                list2.add(this.fStylesheet);
            }
            if (this.fAdditionalParams.length() + this.fVMParams.length() != 0) {
                executionArguments = new ExecutionArguments(this.fVMParams, this.fAdditionalParams);
                stringArray2 = executionArguments.getVMArgumentsArray();
                for (int i = 0; i < stringArray2.length; ++i) {
                    list.add(stringArray2[i]);
                }
                stringArray = executionArguments.getProgramArgumentsArray();
                for (n = 0; n < stringArray.length; ++n) {
                    list2.add(stringArray[n]);
                }
            }
            for (int i = 0; i < this.fHRefs.length; ++i) {
                list2.add("-link");
                list2.add(this.fHRefs[i]);
            }
        }
        if (this.fOverview.length() != 0) {
            list2.add("-overview");
            list2.add(this.fOverview);
        }
        for (int i = 0; i < this.fSelectedElements.length; ++i) {
            BuildConfiguration buildConfiguration;
            stringArray2 = this.fSelectedElements[i];
            if (!(stringArray2 instanceof IJavaProject)) continue;
            stringArray = stringArray2;
            ProjectBuildConfigurator projectBuildConfigurator = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator((IJavaProject)stringArray);
            if (projectBuildConfigurator == null || (buildConfiguration = projectBuildConfigurator.getActiveBuildConfiguration()) == null) continue;
            list2.addAll(buildConfiguration.getIncludedJavaFileNames(ProjectProperties.ASPECTJ_SOURCE_FILTER));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createXML(IJavaProject[] iJavaProjectArray) throws CoreException {
        FileOutputStream fileOutputStream = null;
        String string = this.fAntpath;
        try {
            try {
                if (string.length() > 0) {
                    File file = new File(string);
                    Path path = new Path(string);
                    IPath iPath = path.removeLastSegments(1);
                    IPath iPath2 = null;
                    IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    if (iWorkspaceRoot.findFilesForLocation((IPath)path).length > 0) {
                        iPath2 = iPath;
                    }
                    iPath.toFile().mkdirs();
                    fileOutputStream = new FileOutputStream(file);
                    JavadocWriter javadocWriter = new JavadocWriter(fileOutputStream, iPath2, iJavaProjectArray);
                    javadocWriter.writeXML(this);
                }
            }
            catch (IOException iOException) {
                string = JavadocExportMessages.getString((String)"JavadocOptionsManager.createXM.error");
                throw new CoreException(JavaUIStatus.createError((int)4, (String)string, (Throwable)iOException));
            }
            catch (ParserConfigurationException parserConfigurationException) {
                string = JavadocExportMessages.getString((String)"JavadocOptionsManager.createXM.error");
                throw new CoreException(JavaUIStatus.createError((int)4, (String)string, (Throwable)parserConfigurationException));
            }
            catch (TransformerException transformerException) {
                string = JavadocExportMessages.getString((String)"JavadocOptionsManager.createXM.error");
                throw new CoreException(JavaUIStatus.createError((int)4, (String)string, (Throwable)transformerException));
            }
            Object var11_16 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        fileOutputStream.close();
        return;
    }

    public void updateDialogSettings(IDialogSettings iDialogSettings, IJavaProject[] iJavaProjectArray) {
        IDialogSettings iDialogSettings2 = iDialogSettings.addNewSection("ajdoc");
        iDialogSettings2.put(AJDOC_COMMAND_HISTORY, this.flatStringList(this.fJavadocCommandHistory));
        if (this.fJavadocCommandHistory.length > 0) {
            IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
            iPreferenceStore.setValue("command", this.fJavadocCommandHistory[0]);
        }
        iDialogSettings2.put("fromStandard", this.fFromStandard);
        iDialogSettings2.put("docletname", this.fDocletname);
        iDialogSettings2.put("docletpath", this.fDocletpath);
        iDialogSettings2.put("access", this.fAccess);
        iDialogSettings2.put("use", this.fUse);
        iDialogSettings2.put("author", this.fAuthor);
        iDialogSettings2.put("version", this.fVersion);
        iDialogSettings2.put("nodeprecated", this.fNodeprecated);
        iDialogSettings2.put("nodeprecatedlist", this.fNoDeprecatedlist);
        iDialogSettings2.put("splitindex", this.fSplitindex);
        iDialogSettings2.put("noindex", this.fNoindex);
        iDialogSettings2.put("notree", this.fNotree);
        iDialogSettings2.put("nonavbar", this.fNonavbar);
        iDialogSettings2.put("openinbrowser", this.fOpenInBrowser);
        iDialogSettings2.put("source", this.fJDK14Mode);
        if (this.fAntpath.length() != 0) {
            iDialogSettings2.put("antpath", this.fAntpath);
        }
        if (this.fDestination.length() != 0) {
            iDialogSettings2.put("destdir", this.fDestination);
        }
        if (this.fAdditionalParams.length() != 0) {
            iDialogSettings2.put("additionalparam", this.fAdditionalParams);
        }
        if (this.fVMParams.length() != 0) {
            iDialogSettings2.put("vmparam", this.fVMParams);
        }
        if (this.fOverview.length() != 0) {
            iDialogSettings2.put("overview", this.fOverview);
        }
        if (this.fStylesheet.length() != 0) {
            iDialogSettings2.put("stylesheetfile", this.fStylesheet);
        }
        if (this.fTitle.length() != 0) {
            iDialogSettings2.put("doctitle", this.fTitle);
        }
        if (iJavaProjectArray.length == 1) {
            this.updateRecentSettings(iJavaProjectArray[0]);
        }
        this.getRecentSettings().store(iDialogSettings2);
    }

    public void setJavadocCommandHistory(String[] stringArray) {
        this.fJavadocCommandHistory = stringArray;
    }

    public void setAccess(String string) {
        this.fAccess = string;
    }

    public void setDestination(String string) {
        this.fDestination = string;
    }

    public void setDocletPath(String string) {
        this.fDocletpath = string;
    }

    public void setDocletName(String string) {
        this.fDocletname = string;
    }

    public void setStyleSheet(String string) {
        this.fStylesheet = string;
    }

    public void setOverview(String string) {
        this.fOverview = string;
    }

    public void setAdditionalParams(String string) {
        this.fAdditionalParams = string;
    }

    public void setVMParams(String string) {
        this.fVMParams = string;
    }

    public void setGeneralAntpath(String string) {
        this.fAntpath = string;
    }

    public void setClasspath(IPath[] iPathArray) {
        this.fClasspath = iPathArray;
    }

    public void setSourcepath(IPath[] iPathArray) {
        this.fSourcepath = iPathArray;
    }

    public void setCheckedProjects(IJavaProject[] iJavaProjectArray) {
        this.fSelectedElements = iJavaProjectArray;
    }

    public void setFromStandard(boolean bl) {
        this.fFromStandard = bl;
    }

    public void setTitle(String string) {
        this.fTitle = string;
    }

    public void setOpenInBrowser(boolean bl) {
        this.fOpenInBrowser = bl;
    }

    public void setHRefs(String[] stringArray) {
        this.fHRefs = stringArray;
    }

    public void setBoolean(String string, boolean bl) {
        if (string.equals("author")) {
            this.fAuthor = bl;
        } else if (string.equals("use")) {
            this.fUse = bl;
        } else if (string.equals("version")) {
            this.fVersion = bl;
        } else if (string.equals("nodeprecated")) {
            this.fNodeprecated = bl;
        } else if (string.equals("nodeprecatedlist")) {
            this.fNoDeprecatedlist = bl;
        } else if (string.equals("noindex")) {
            this.fNoindex = bl;
        } else if (string.equals("notree")) {
            this.fNotree = bl;
        } else if (string.equals("splitindex")) {
            this.fSplitindex = bl;
        } else if (string.equals("nonavbar")) {
            this.fNonavbar = bl;
        }
    }

    public boolean isJDK14Mode() {
        return this.fJDK14Mode;
    }

    public void setJDK14Mode(boolean bl) {
        this.fJDK14Mode = bl;
    }

    private IJavaElement[] getInitialElementsFromSelection(List list) {
        ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>();
        for (int i = 0; i < list.size(); ++i) {
            try {
                IJavaElement iJavaElement = this.getSelectableJavaElement(list.get(i));
                if (iJavaElement == null) continue;
                arrayList.add(iJavaElement);
                continue;
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new IJavaElement[arrayList.size()]);
    }

    private IJavaElement getSelectableJavaElement(Object object) throws JavaModelException {
        IJavaElement iJavaElement = null;
        if (object instanceof IAdaptable) {
            iJavaElement = (IJavaElement)((IAdaptable)object).getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = JavadocOptionsManager.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement);
        }
        if (iJavaElement != null) {
            IJavaProject iJavaProject;
            switch (iJavaElement.getElementType()) {
                case 1: 
                case 2: 
                case 6: {
                    break;
                }
                case 3: {
                    if (!this.containsCompilationUnits((IPackageFragmentRoot)iJavaElement)) break;
                    return iJavaElement;
                }
                case 4: {
                    if (!this.containsCompilationUnits((IPackageFragment)iJavaElement)) break;
                    return iJavaElement;
                }
                default: {
                    iJavaProject = (ICompilationUnit)iJavaElement.getAncestor(5);
                    if (iJavaProject == null) break;
                    return iJavaProject;
                }
            }
            iJavaProject = iJavaElement.getJavaProject();
            if (this.isValidProject(iJavaProject)) {
                return iJavaProject;
            }
        }
        return null;
    }

    private boolean isValidProject(IJavaProject iJavaProject) throws JavaModelException {
        if (iJavaProject != null && iJavaProject.exists()) {
            IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
            for (int i = 0; i < iPackageFragmentRootArray.length; ++i) {
                if (!this.containsCompilationUnits(iPackageFragmentRootArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsCompilationUnits(IPackageFragmentRoot iPackageFragmentRoot) throws JavaModelException {
        if (iPackageFragmentRoot.getKind() != 1) {
            return false;
        }
        IJavaElement[] iJavaElementArray = iPackageFragmentRoot.getChildren();
        for (int i = 0; i < iJavaElementArray.length; ++i) {
            IPackageFragment iPackageFragment;
            if (!(iJavaElementArray[i] instanceof IPackageFragment) || !this.containsCompilationUnits(iPackageFragment = (IPackageFragment)iJavaElementArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean containsCompilationUnits(IPackageFragment iPackageFragment) throws JavaModelException {
        return iPackageFragment.getCompilationUnits().length > 0;
    }

    public RecentSettingsStore getRecentSettings() {
        return this.fRecentSettings;
    }

    public void updateRecentSettings(IJavaProject iJavaProject) {
        this.fRecentSettings.setProjectSettings(iJavaProject, this.fDestination, this.fAntpath, this.fHRefs);
    }

    private static String initJavadocCommandDefault() {
        IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("command");
        if (string != null && string.length() > 0) {
            iPreferenceStore.setToDefault("command");
            return string;
        }
        File file = JavadocOptionsManager.findJavaDocCommand();
        if (file != null) {
            return file.getPath();
        }
        return "";
    }

    private static File findJavaDocCommand() {
        Object object;
        IVMInstall iVMInstall = JavaRuntime.getDefaultVMInstall();
        if (iVMInstall != null && (object = JavadocOptionsManager.getCommand(iVMInstall)) != null) {
            return object;
        }
        object = JavaRuntime.getVMInstallTypes();
        for (int i = 0; i < ((IVMInstallType[])object).length; ++i) {
            IVMInstallType iVMInstallType = object[i];
            IVMInstall[] iVMInstallArray = iVMInstallType.getVMInstalls();
            for (int j = 0; j < iVMInstallArray.length; ++j) {
                File file = JavadocOptionsManager.getCommand(iVMInstallArray[j]);
                if (file == null) continue;
                return file;
            }
        }
        return null;
    }

    private static File getCommand(IVMInstall iVMInstall) {
        return new File("");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

