/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ajdocexport;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.ajdt.ajdocexport.JavadocOptionsManager;
import org.eclipse.ajdt.ajdocexport.JavadocProjectContentProvider;
import org.eclipse.ajdt.ajdocexport.JavadocWizardPage;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.jarpackager.CheckboxTreeAndListGroup;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocMemberContentProvider;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavadocTreeWizardPage
extends JavadocWizardPage {
    private CheckboxTreeAndListGroup fInputGroup;
    private Text fDestinationText;
    private Button fStandardButton;
    private Button fDestinationBrowserButton;
    private Button fPrivateVisibility;
    private Button fProtectedVisibility;
    private Button fPackageVisibility;
    private Button fPublicVisibility;
    private Label fDestinationLabel;
    private CLabel fDescriptionLabel;
    private String fVisibilitySelection;
    private JavadocOptionsManager fStore;
    private StatusInfo fJavadocStatus;
    private StatusInfo fDestinationStatus;
    private StatusInfo fDocletStatus;
    private StatusInfo fTreeStatus;
    private StatusInfo fPreferenceStatus;
    private StatusInfo fWizardStatus;
    private final int PREFERENCESTATUS = 0;
    private final int CUSTOMSTATUS = 1;
    private final int STANDARDSTATUS = 2;
    private final int TREESTATUS = 3;
    private final int JAVADOCSTATUS = 4;
    public ProjectProperties.FilenameFilter ajFileFilter = new ProjectProperties.FilenameFilter(){

        public boolean accept(String string) {
            return string.endsWith(".aj");
        }
    };

    protected JavadocTreeWizardPage(String string, JavadocOptionsManager javadocOptionsManager) {
        super(string);
        this.setDescription(AspectJPlugin.getResourceString("ajdocTreeWizardPage.javadoctreewizardpage.description"));
        this.fStore = javadocOptionsManager;
        this.fJavadocStatus = new StatusInfo();
        this.fDestinationStatus = new StatusInfo();
        this.fDocletStatus = new StatusInfo();
        this.fTreeStatus = new StatusInfo();
        this.fPreferenceStatus = new StatusInfo();
        this.fWizardStatus = javadocOptionsManager.getWizardStatus();
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        composite2.setLayout((Layout)gridLayout);
        this.createInputGroup(composite2);
        this.createVisibilitySet(composite2);
        this.createOptionsSet(composite2);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
        WorkbenchHelp.setHelp((Control)composite2, (String)"org.eclipse.jdt.ui.javadoc_tree_page_context");
    }

    protected void createInputGroup(Composite composite) {
        this.createLabel(composite, 0, AspectJPlugin.getResourceString("ajdoc.info.projectselection"), this.createGridData(6));
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)this.createGridData(768, 6, 0));
        JavadocProjectContentProvider javadocProjectContentProvider = new JavadocProjectContentProvider();
        JavadocMemberContentProvider javadocMemberContentProvider = new JavadocMemberContentProvider();
        this.fInputGroup = new CheckboxTreeAndListGroup(composite2, (Object)this, (ITreeContentProvider)javadocProjectContentProvider, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), (IStructuredContentProvider)javadocMemberContentProvider, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), 0, this.convertWidthInCharsToPixels(60), this.convertHeightInCharsToPixels(7));
        this.fInputGroup.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                JavadocTreeWizardPage.this.doValidation(3);
            }
        });
        this.fInputGroup.setTreeSorter((ViewerSorter)new JavaElementSorter());
        IJavaElement[] iJavaElementArray = this.fStore.getInitialElements();
        this.setTreeChecked(iJavaElementArray);
        if (iJavaElementArray.length > 0) {
            this.fInputGroup.setTreeSelection((ISelection)new StructuredSelection((Object)iJavaElementArray[0].getJavaProject()));
        }
        this.fInputGroup.aboutToOpen();
    }

    private void createVisibilitySet(Composite composite) {
        GridLayout gridLayout = this.createGridLayout(4);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)this.createGridData(768, 6, 0));
        composite2.setLayout((Layout)gridLayout);
        this.createLabel(composite2, 0, AspectJPlugin.getResourceString("ajdocTreeWizardPage.visibilitygroup.label"), this.createGridData(768, 4, 0));
        this.fPrivateVisibility = this.createButton(composite2, 16, JavadocExportMessages.getString((String)"JavadocTreeWizardPage.privatebutton.label"), this.createGridData(768, 1, 0));
        this.fPackageVisibility = this.createButton(composite2, 16, JavadocExportMessages.getString((String)"JavadocTreeWizardPage.packagebutton.label"), this.createGridData(768, 1, 0));
        this.fProtectedVisibility = this.createButton(composite2, 16, JavadocExportMessages.getString((String)"JavadocTreeWizardPage.protectedbutton.label"), this.createGridData(768, 1, 0));
        this.fPublicVisibility = this.createButton(composite2, 16, JavadocExportMessages.getString((String)"JavadocTreeWizardPage.publicbutton.label"), this.createGridData(768, 1, 0));
        this.fDescriptionLabel = new CLabel(composite2, 16384);
        this.fDescriptionLabel.setLayoutData((Object)this.createGridData(768, 4, this.convertWidthInCharsToPixels(3) - 3));
        this.fPrivateVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (((Button)selectionEvent.widget).getSelection()) {
                    JavadocTreeWizardPage.this.fVisibilitySelection = ((JavadocTreeWizardPage)JavadocTreeWizardPage.this).fStore.PRIVATE;
                    JavadocTreeWizardPage.this.fDescriptionLabel.setText(AspectJPlugin.getResourceString("ajdocTreeWizardPage.privatevisibilitydescription.label"));
                }
            }
        });
        this.fPackageVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (((Button)selectionEvent.widget).getSelection()) {
                    JavadocTreeWizardPage.this.fVisibilitySelection = ((JavadocTreeWizardPage)JavadocTreeWizardPage.this).fStore.PACKAGE;
                    JavadocTreeWizardPage.this.fDescriptionLabel.setText(AspectJPlugin.getResourceString("ajdocTreeWizardPage.packagevisibledescription.label"));
                }
            }
        });
        this.fProtectedVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (((Button)selectionEvent.widget).getSelection()) {
                    JavadocTreeWizardPage.this.fVisibilitySelection = ((JavadocTreeWizardPage)JavadocTreeWizardPage.this).fStore.PROTECTED;
                    JavadocTreeWizardPage.this.fDescriptionLabel.setText(AspectJPlugin.getResourceString("ajdocTreeWizardPage.protectedvisibilitydescription.label"));
                }
            }
        });
        this.fPublicVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (((Button)selectionEvent.widget).getSelection()) {
                    JavadocTreeWizardPage.this.fVisibilitySelection = ((JavadocTreeWizardPage)JavadocTreeWizardPage.this).fStore.PUBLIC;
                    JavadocTreeWizardPage.this.fDescriptionLabel.setText(AspectJPlugin.getResourceString("ajdocTreeWizardPage.publicvisibilitydescription.label"));
                }
            }
        });
        this.setVisibilitySettings();
    }

    protected void setVisibilitySettings() {
        this.fVisibilitySelection = this.fStore.getAccess();
        this.fPrivateVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PRIVATE));
        if (this.fPrivateVisibility.getSelection()) {
            this.fDescriptionLabel.setText(AspectJPlugin.getResourceString("ajdocTreeWizardPage.privatevisibilitydescription.label"));
        }
        this.fProtectedVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PROTECTED));
        if (this.fProtectedVisibility.getSelection()) {
            this.fDescriptionLabel.setText(AspectJPlugin.getResourceString("ajdocTreeWizardPage.protectedvisibilitydescription.label"));
        }
        this.fPackageVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PACKAGE));
        if (this.fPackageVisibility.getSelection()) {
            this.fDescriptionLabel.setText(AspectJPlugin.getResourceString("ajdocTreeWizardPage.packagevisibledescription.label"));
        }
        this.fPublicVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PUBLIC));
        if (this.fPublicVisibility.getSelection()) {
            this.fDescriptionLabel.setText(AspectJPlugin.getResourceString("ajdocTreeWizardPage.publicvisibilitydescription.label"));
        }
    }

    private void createOptionsSet(Composite composite) {
        GridLayout gridLayout = this.createGridLayout(4);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)this.createGridData(768, 6, 0));
        composite2.setLayout((Layout)gridLayout);
        this.fStandardButton = this.createButton(composite2, 16, JavadocExportMessages.getString((String)"JavadocTreeWizardPage.standarddocletbutton.label"), this.createGridData(256, 4, 0));
        this.fDestinationLabel = this.createLabel(composite2, 0, JavadocExportMessages.getString((String)"JavadocTreeWizardPage.destinationfield.label"), this.createGridData(256, 1, this.convertWidthInCharsToPixels(3)));
        this.fDestinationText = this.createText(composite2, 2052, null, this.createGridData(768, 2, 0));
        ((GridData)this.fDestinationText.getLayoutData()).widthHint = 0;
        this.fDestinationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                JavadocTreeWizardPage.this.doValidation(2);
            }
        });
        this.fDestinationBrowserButton = this.createButton(composite2, 8, JavadocExportMessages.getString((String)"JavadocTreeWizardPage.destinationbrowse.label"), this.createGridData(128, 1, 0));
        SWTUtil.setButtonDimensionHint((Button)this.fDestinationBrowserButton);
        this.fDestinationBrowserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = JavadocTreeWizardPage.this.handleFolderBrowseButtonPressed(JavadocTreeWizardPage.this.fDestinationText.getText(), JavadocTreeWizardPage.this.fDestinationText.getShell(), JavadocExportMessages.getString((String)"JavadocTreeWizardPage.destinationbrowsedialog.title"), JavadocExportMessages.getString((String)"JavadocTreeWizardPage.destinationbrowsedialog.label"));
                JavadocTreeWizardPage.this.fDestinationText.setText(string);
            }
        });
        this.setOptionSetSettings();
    }

    private void setOptionSetSettings() {
        if (!this.fStore.isFromStandard()) {
            this.fDestinationText.setText(this.fStore.getDestination());
            this.fDestinationText.setEnabled(false);
            this.fDestinationBrowserButton.setEnabled(false);
            this.fDestinationLabel.setEnabled(false);
        } else {
            this.fStandardButton.setSelection(true);
            this.fDestinationText.setText(this.fStore.getDestination());
        }
    }

    private void setTreeChecked(IJavaElement[] iJavaElementArray) {
        for (int i = 0; i < iJavaElementArray.length; ++i) {
            IPackageFragmentRoot iPackageFragmentRoot;
            IJavaElement iJavaElement = iJavaElementArray[i];
            if (iJavaElement instanceof ICompilationUnit) {
                this.fInputGroup.initialCheckListItem((Object)iJavaElement);
                continue;
            }
            if (iJavaElement instanceof IPackageFragment) {
                this.fInputGroup.initialCheckTreeItem((Object)iJavaElement);
                continue;
            }
            if (iJavaElement instanceof IJavaProject) {
                this.fInputGroup.initialCheckTreeItem((Object)iJavaElement);
                continue;
            }
            if (!(iJavaElement instanceof IPackageFragmentRoot) || (iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement).isArchive()) continue;
            this.fInputGroup.initialCheckTreeItem((Object)iJavaElement);
        }
    }

    private IPath[] getSourcePath(IJavaProject[] iJavaProjectArray) {
        HashSet<IPath> hashSet = new HashSet<IPath>();
        for (int i = 0; i < iJavaProjectArray.length; ++i) {
            IJavaProject iJavaProject = iJavaProjectArray[i];
            try {
                IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
                for (int j = 0; j < iPackageFragmentRootArray.length; ++j) {
                    IPath iPath;
                    IResource iResource;
                    IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[j];
                    if (iPackageFragmentRoot.getKind() != 1 || (iResource = iPackageFragmentRoot.getResource()) == null || (iPath = iResource.getLocation()) == null) continue;
                    hashSet.add(iPath);
                }
                continue;
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log((Throwable)javaModelException);
            }
        }
        return hashSet.toArray(new IPath[hashSet.size()]);
    }

    private IPath[] getClassPath(IJavaProject[] iJavaProjectArray) {
        HashSet<Path> hashSet = new HashSet<Path>();
        for (int i = 0; i < iJavaProjectArray.length; ++i) {
            IJavaProject iJavaProject = iJavaProjectArray[i];
            try {
                IPath iPath = iJavaProject.getProject().getLocation();
                if (iPath == null) continue;
                IPath iPath2 = iPath.append(iJavaProject.getOutputLocation());
                String[] stringArray = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)iJavaProject);
                for (int j = 0; j < stringArray.length; ++j) {
                    Path path = new Path(stringArray[j]);
                    if (iPath2.equals(path)) continue;
                    hashSet.add(path);
                }
                continue;
            }
            catch (CoreException coreException) {
                JavaPlugin.log((Throwable)coreException);
            }
        }
        return hashSet.toArray(new IPath[hashSet.size()]);
    }

    private IJavaElement[] getSourceElements(IJavaProject[] iJavaProjectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            Object object;
            Object object2;
            Object object3;
            Set set = this.fInputGroup.getAllCheckedTreeItems();
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < iJavaProjectArray.length; ++i) {
                object3 = iJavaProjectArray[i];
                object2 = object3.getPackageFragmentRoots();
                for (int j = 0; j < ((IPackageFragmentRoot[])object2).length; ++j) {
                    object = object2[j];
                    if (object.getKind() != 1) continue;
                    IJavaElement[] iJavaElementArray = object.getChildren();
                    for (int k = 0; k < iJavaElementArray.length; ++k) {
                        IJavaElement iJavaElement = iJavaElementArray[k];
                        if (iJavaElement.getElementType() != 4 || iJavaElement.getElementName().length() != 0 && set.contains(iJavaElement) && !this.fInputGroup.isTreeItemGreyChecked((Object)iJavaElement)) continue;
                        hashSet.add(iJavaElement.getElementName());
                    }
                }
            }
            Iterator iterator = this.fInputGroup.getAllCheckedListItems();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                if (!(object3 instanceof ICompilationUnit) || !hashSet.contains((object2 = (ICompilationUnit)object3).getParent().getElementName())) continue;
                arrayList.add(object2);
            }
            object3 = new HashSet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                IPackageFragment iPackageFragment;
                object2 = iterator.next();
                if (!(object2 instanceof IPackageFragment) || hashSet.contains(object = (iPackageFragment = (IPackageFragment)object2).getElementName()) || object3.contains(object)) continue;
                arrayList.add(iPackageFragment);
                object3.add(object);
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log((Throwable)javaModelException);
        }
        return arrayList.toArray(new IJavaElement[arrayList.size()]);
    }

    protected void updateStore(IJavaProject[] iJavaProjectArray) {
        if (this.fStandardButton.getSelection()) {
            this.fStore.setFromStandard(true);
            this.fStore.setDestination(this.fDestinationText.getText());
        }
        this.fStore.setSourcepath(this.getSourcePath(iJavaProjectArray));
        this.fStore.setClasspath(this.getClassPath(iJavaProjectArray));
        this.fStore.setAccess(this.fVisibilitySelection);
        this.fStore.setCheckedProjects(iJavaProjectArray);
    }

    public IJavaProject[] getCheckedProjects() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TreeItem[] treeItemArray = this.fInputGroup.getTree().getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            Object object;
            if (!treeItemArray[i].getChecked() || !((object = treeItemArray[i].getData()) instanceof IJavaProject)) continue;
            arrayList.add(object);
        }
        return arrayList.toArray(new IJavaProject[arrayList.size()]);
    }

    protected void doValidation(int n) {
        switch (n) {
            case 0: {
                this.fPreferenceStatus = new StatusInfo();
                this.fDocletStatus = new StatusInfo();
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (!this.fStandardButton.getSelection()) break;
                this.fDestinationStatus = new StatusInfo();
                this.fDocletStatus = new StatusInfo();
                Path path = new Path(this.fDestinationText.getText());
                if (Path.ROOT.equals((Object)path) || Path.EMPTY.equals((Object)path)) {
                    this.fDestinationStatus.setError(JavadocExportMessages.getString((String)"JavadocTreeWizardPage.nodestination.error"));
                }
                File file = new File(path.toOSString());
                if (!path.isValidPath(path.toOSString()) || file.isFile()) {
                    this.fDestinationStatus.setError(JavadocExportMessages.getString((String)"JavadocTreeWizardPage.invaliddestination.error"));
                }
                if (path.append("package-list").toFile().exists() || path.append("index.html").toFile().exists()) {
                    this.fDestinationStatus.setWarning(AspectJPlugin.getResourceString("ajdocTreeWizardPage.warning.mayoverwritefiles"));
                }
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 3: {
                this.fTreeStatus = new StatusInfo();
                if (this.fInputGroup.getCheckedElementCount() == 0) {
                    this.fTreeStatus.setError(AspectJPlugin.getResourceString("ajdoc.error.noProjectSelected"));
                }
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
        }
    }

    private boolean validDocletPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            File file = new File(stringTokenizer.nextToken());
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere((IStatus[])new IStatus[]{this.fTreeStatus, this.fPreferenceStatus, this.fDestinationStatus, this.fDocletStatus, this.fJavadocStatus, this.fWizardStatus});
    }

    public void init() {
        this.updateStatus((IStatus)new StatusInfo());
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.doValidation(4);
            this.doValidation(2);
            this.doValidation(1);
            this.doValidation(3);
            this.doValidation(0);
        }
    }
}

