/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ajdocexport;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ajdt.ajdocexport.JavadocOptionsManager;
import org.eclipse.ajdt.ajdocexport.JavadocSpecificsWizardPage;
import org.eclipse.ajdt.ajdocexport.JavadocTreeWizardPage;
import org.eclipse.ajdt.internal.core.resources.AspectJImages;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.jdt.internal.ui.jarpackager.ConfirmSaveModifiedResourcesDialog;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class JavadocWizard
extends Wizard
implements IExportWizard {
    private JavadocTreeWizardPage fJTWPage;
    private JavadocSpecificsWizardPage fJSWPage;
    private IPath fDestination;
    private boolean fWriteCustom;
    private boolean fOpenInBrowser;
    private final String TREE_PAGE_DESC = "JavadocTreePage";
    private final String SPECIFICS_PAGE_DESC = "JavadocSpecificsPage";
    private final String STANDARD_PAGE_DESC = "JavadocStandardPage";
    private final int YES = 0;
    private final int YES_TO_ALL = 1;
    private final int NO = 2;
    private final int NO_TO_ALL = 3;
    private JavadocOptionsManager fStore;
    private IWorkspaceRoot fRoot;
    private IFile fXmlJavadocFile;
    private static final String ID_JAVADOC_PROCESS_TYPE = "org.eclipse.jdt.ui.javadocProcess";

    public static void openJavadocWizard(JavadocWizard javadocWizard, Shell shell, IStructuredSelection iStructuredSelection) {
        javadocWizard.init(PlatformUI.getWorkbench(), iStructuredSelection);
        PixelConverter pixelConverter = new PixelConverter((Control)shell);
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)javadocWizard);
        wizardDialog.setMinimumPageSize(pixelConverter.convertWidthInCharsToPixels(100), pixelConverter.convertHeightInCharsToPixels(20));
        wizardDialog.open();
    }

    public JavadocWizard() {
        this(null);
    }

    public JavadocWizard(IFile iFile) {
        this.setDefaultPageImageDescriptor(AspectJImages.W_EXPORT_AJDOC.getImageDescriptor());
        this.setWindowTitle(AspectJPlugin.getResourceString("ajdocWizard.javadocwizard.title"));
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.fRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fXmlJavadocFile = iFile;
        this.fWriteCustom = false;
    }

    public boolean performFinish() {
        IJavaProject[] iJavaProjectArray = this.fJTWPage.getCheckedProjects();
        this.updateStore(iJavaProjectArray);
        if (this.fXmlJavadocFile == null) {
            this.fStore.updateDialogSettings(this.getDialogSettings(), iJavaProjectArray);
        }
        if (!this.checkPreconditions(this.fStore.getSourceElements())) {
            return false;
        }
        this.fDestination = new Path(this.fStore.getDestination());
        this.fDestination.toFile().mkdirs();
        this.fOpenInBrowser = this.fStore.doOpenInBrowser();
        if (this.fStore.isFromStandard()) {
            try {
                URL uRL = this.fDestination.toFile().toURL();
                ArrayList<IJavaProject> arrayList = new ArrayList<IJavaProject>();
                for (int i = 0; i < iJavaProjectArray.length; ++i) {
                    IJavaProject iJavaProject = iJavaProjectArray[i];
                    URL uRL2 = JavaUI.getProjectJavadocLocation((IJavaProject)iJavaProject);
                    if (uRL.equals(uRL2)) continue;
                    arrayList.add(iJavaProject);
                }
                if (!arrayList.isEmpty()) {
                    this.setAllJavadocLocations(arrayList.toArray(new IJavaProject[arrayList.size()]), uRL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                JavaPlugin.log((Throwable)malformedURLException);
            }
        }
        return this.executeJavadocGeneration();
    }

    private void updateStore(IJavaProject[] iJavaProjectArray) {
        this.fJTWPage.updateStore(iJavaProjectArray);
        this.fJSWPage.updateStore();
    }

    public boolean performCancel() {
        IJavaProject[] iJavaProjectArray = this.fJTWPage.getCheckedProjects();
        this.updateStore(iJavaProjectArray);
        if (this.fXmlJavadocFile == null) {
            this.fStore.updateDialogSettings(this.getDialogSettings(), iJavaProjectArray);
        }
        return super.performCancel();
    }

    private void setAllJavadocLocations(IJavaProject[] iJavaProjectArray, URL uRL) {
        Shell shell = this.getShell();
        Image image = shell == null ? null : shell.getDisplay().getSystemImage(4);
        String[] stringArray = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL};
        block5: for (int i = 0; i < iJavaProjectArray.length; ++i) {
            IJavaProject iJavaProject = iJavaProjectArray[i];
            String string = JavadocExportMessages.getFormattedString((String)"JavadocWizard.updatejavadoclocation.message", (Object[])new String[]{iJavaProject.getElementName(), this.fDestination.toOSString()});
            MessageDialog messageDialog = new MessageDialog(shell, JavadocExportMessages.getString((String)"JavadocWizard.updatejavadocdialog.label"), image, string, 4, stringArray, 1);
            switch (messageDialog.open()) {
                case 0: {
                    JavaUI.setProjectJavadocLocation((IJavaProject)iJavaProject, (URL)uRL);
                    continue block5;
                }
                case 1: {
                    for (int j = i; j < iJavaProjectArray.length; ++j) {
                        iJavaProject = iJavaProjectArray[j];
                        JavaUI.setProjectJavadocLocation((IJavaProject)iJavaProject, (URL)uRL);
                        ++i;
                    }
                    continue block5;
                }
                case 3: {
                    i = iJavaProjectArray.length;
                    continue block5;
                }
            }
        }
    }

    private boolean executeJavadocGeneration() {
        block9: {
            Process process = null;
            try {
                CharSequence charSequence;
                ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                this.fStore.getArgumentArray(arrayList, arrayList2);
                File file = File.createTempFile("javadoc-arguments", ".tmp");
                String string = JavaRuntime.getDefaultVMInstall().getInstallLocation().getAbsolutePath();
                String string2 = AspectJPlugin.getDefault().getAjdtProjectProperties().getAspectjrtClasspath();
                String string3 = string2.substring(0, string2.length() - 13).concat("aspectjtools.jar");
                String string4 = string + File.separator + "lib" + File.separator + "tools.jar";
                ArrayList<String> arrayList3 = new ArrayList<String>();
                arrayList3.add(string + File.separator + "bin" + File.separator + "java");
                boolean bl = true;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    charSequence = (String)iterator.next();
                    if (((String)charSequence).startsWith("-Xmx")) {
                        bl = false;
                    }
                    arrayList3.add((String)charSequence);
                }
                if (bl) {
                    arrayList3.add("-Xmx64M");
                }
                arrayList3.add("-classpath");
                arrayList3.add(string3 + File.pathSeparator + string4 + File.pathSeparator + string2);
                arrayList3.add("org.aspectj.tools.ajdoc.Main");
                for (int i = 0; i < arrayList2.size(); ++i) {
                    charSequence = (String)arrayList2.get(i);
                    arrayList3.add(this.checkForSpaces((String)charSequence));
                }
                String[] stringArray = arrayList3.toArray(new String[arrayList3.size()]);
                process = Runtime.getRuntime().exec(stringArray);
                if (process == null) break block9;
                charSequence = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    ((StringBuffer)charSequence).append(stringArray[i]);
                    ((StringBuffer)charSequence).append(' ');
                }
                JavadocDebugEventListener javadocDebugEventListener = new JavadocDebugEventListener(this.getShell().getDisplay(), file);
                DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)javadocDebugEventListener);
                ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = null;
                try {
                    ILaunchConfigurationType iLaunchConfigurationType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
                    String string5 = JavadocExportMessages.getString((String)"JavadocWizard.launchconfig.name");
                    iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, string5);
                    iLaunchConfigurationWorkingCopy.setAttribute(IDebugUIConstants.ATTR_PRIVATE, true);
                    Launch launch = new Launch((ILaunchConfiguration)iLaunchConfigurationWorkingCopy, "run", null);
                    IProcess iProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)JavadocExportMessages.getString((String)"JavadocWizard.javadocprocess.label"));
                    iProcess.setAttribute(IProcess.ATTR_CMDLINE, ((StringBuffer)charSequence).toString());
                    iProcess.setAttribute(IProcess.ATTR_PROCESS_TYPE, ID_JAVADOC_PROCESS_TYPE);
                    DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)launch);
                }
                catch (CoreException coreException) {
                    String string6 = JavadocExportMessages.getString((String)"JavadocWizard.error.title");
                    String string7 = JavadocExportMessages.getString((String)"JavadocWizard.launch.error.message");
                    ExceptionHandler.handle((CoreException)coreException, (Shell)this.getShell(), (String)string6, (String)string7);
                }
                return true;
            }
            catch (IOException iOException) {
                String string = JavadocExportMessages.getString((String)"JavadocWizard.error.title");
                String string8 = JavadocExportMessages.getString((String)"JavadocWizard.exec.error.message");
                Status status = new Status(4, "org.eclipse.jdt.ui", 4, iOException.getMessage(), (Throwable)iOException);
                ExceptionHandler.handle((CoreException)new CoreException((IStatus)status), (Shell)this.getShell(), (String)string, (String)string8);
                return false;
            }
        }
        return false;
    }

    private String checkForSpaces(String string) {
        if (string.indexOf(32) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' || c == '\'') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private boolean checkPreconditions(IJavaElement[] iJavaElementArray) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        for (int i = 0; i < iJavaElementArray.length; ++i) {
            if (!(iJavaElementArray[i] instanceof ICompilationUnit)) continue;
            arrayList.add(iJavaElementArray[i].getResource());
        }
        IFile[] iFileArray = this.getUnsavedFiles(arrayList);
        return this.saveModifiedResourcesIfUserConfirms(iFileArray);
    }

    private IFile[] getUnsavedFiles(List list) {
        IEditorPart[] iEditorPartArray = JavaPlugin.getDirtyEditors();
        HashSet<IFile> hashSet = new HashSet<IFile>(iEditorPartArray.length);
        if (iEditorPartArray.length > 0) {
            for (int i = 0; i < iEditorPartArray.length; ++i) {
                IFile iFile;
                if (!(iEditorPartArray[i].getEditorInput() instanceof IFileEditorInput) || !list.contains(iFile = ((IFileEditorInput)iEditorPartArray[i].getEditorInput()).getFile())) continue;
                hashSet.add(iFile);
            }
        }
        return hashSet.toArray(new IFile[hashSet.size()]);
    }

    private boolean saveModifiedResourcesIfUserConfirms(IFile[] iFileArray) {
        if (this.confirmSaveModifiedResources(iFileArray)) {
            try {
                if (this.saveModifiedResources(iFileArray)) {
                    return true;
                }
            }
            catch (CoreException coreException) {
                ExceptionHandler.handle((CoreException)coreException, (Shell)this.getShell(), (String)JavadocExportMessages.getString((String)"JavadocWizard.saveresourcedialogCE.title"), (String)JavadocExportMessages.getString((String)"JavadocWizard.saveresourcedialogCE.message"));
            }
            catch (InvocationTargetException invocationTargetException) {
                ExceptionHandler.handle((InvocationTargetException)invocationTargetException, (Shell)this.getShell(), (String)JavadocExportMessages.getString((String)"JavadocWizard.saveresourcedialogITE.title"), (String)JavadocExportMessages.getString((String)"JavadocWizard.saveresourcedialogITE.message"));
            }
        }
        return false;
    }

    private boolean confirmSaveModifiedResources(IFile[] iFileArray) {
        if (iFileArray == null || iFileArray.length == 0) {
            return true;
        }
        Display display = this.getShell().getDisplay();
        if (display == null || display.isDisposed()) {
            return false;
        }
        final ConfirmSaveModifiedResourcesDialog confirmSaveModifiedResourcesDialog = new ConfirmSaveModifiedResourcesDialog(this.getShell(), iFileArray);
        final int[] nArray = new int[1];
        Runnable runnable = new Runnable(){

            public void run() {
                nArray[0] = confirmSaveModifiedResourcesDialog.open();
            }
        };
        display.syncExec(runnable);
        return nArray[0] == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveModifiedResources(IFile[] iFileArray) throws CoreException, InvocationTargetException {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription iWorkspaceDescription = iWorkspace.getDescription();
        boolean bl = iWorkspaceDescription.isAutoBuilding();
        iWorkspaceDescription.setAutoBuilding(false);
        try {
            iWorkspace.setDescription(iWorkspaceDescription);
            try {
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), this.createSaveModifiedResourcesRunnable(iFileArray), (ISchedulingRule)iWorkspace.getRoot());
            }
            finally {
                iWorkspaceDescription.setAutoBuilding(bl);
                iWorkspace.setDescription(iWorkspaceDescription);
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private IRunnableWithProgress createSaveModifiedResourcesRunnable(final IFile[] iFileArray) {
        return new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor iProgressMonitor) {
                if (iProgressMonitor == null) {
                    iProgressMonitor = new NullProgressMonitor();
                }
                IEditorPart[] iEditorPartArray = JavaPlugin.getDirtyEditors();
                String string = JavadocExportMessages.getString((String)"JavadocWizard.savetask.name");
                iProgressMonitor.beginTask(string, iEditorPartArray.length);
                try {
                    List<IFile> list = Arrays.asList(iFileArray);
                    for (int i = 0; i < iEditorPartArray.length; ++i) {
                        IFile iFile;
                        if (iEditorPartArray[i].getEditorInput() instanceof IFileEditorInput && list.contains(iFile = ((IFileEditorInput)iEditorPartArray[i].getEditorInput()).getFile())) {
                            iEditorPartArray[i].doSave((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        }
                        iProgressMonitor.worked(1);
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
    }

    public void addPages() {
        this.fJTWPage = new JavadocTreeWizardPage("JavadocTreePage", this.fStore);
        this.fJSWPage = new JavadocSpecificsWizardPage("JavadocSpecificsPage", this.fJTWPage, this.fStore);
        super.addPage((IWizardPage)this.fJTWPage);
        super.addPage((IWizardPage)this.fJSWPage);
        this.fJTWPage.init();
        this.fJSWPage.init();
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        ArrayList<IJavaElement> arrayList = Collections.EMPTY_LIST;
        if (iWorkbenchWindow != null) {
            ISelection iSelection = iWorkbenchWindow.getSelectionService().getSelection();
            if (iSelection instanceof IStructuredSelection) {
                arrayList = ((IStructuredSelection)iSelection).toList();
            } else {
                IJavaElement iJavaElement = EditorUtility.getActiveEditorJavaInput();
                if (iJavaElement != null) {
                    arrayList = new ArrayList<IJavaElement>();
                    arrayList.add(iJavaElement);
                }
            }
        }
        this.fStore = new JavadocOptionsManager(this.fXmlJavadocFile, this.getDialogSettings(), arrayList);
    }

    private void refresh(IPath iPath) {
        if (this.fRoot.findContainersForLocation(iPath).length > 0) {
            try {
                this.fRoot.refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                JavaPlugin.log((Throwable)coreException);
            }
        }
    }

    private void spawnInBrowser(Display display) {
        if (this.fOpenInBrowser) {
            try {
                IPath iPath = this.fDestination.append("index.html");
                URL uRL = iPath.toFile().toURL();
                OpenBrowserUtil.open((URL)uRL, (Display)display, (String)this.getWindowTitle());
            }
            catch (MalformedURLException malformedURLException) {
                JavaPlugin.log((Throwable)malformedURLException);
            }
        }
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        if (iWizardPage instanceof JavadocTreeWizardPage) {
            return this.fJSWPage;
        }
        if (iWizardPage instanceof JavadocSpecificsWizardPage) {
            return null;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage iWizardPage) {
        if (iWizardPage instanceof JavadocSpecificsWizardPage) {
            return this.fJSWPage;
        }
        if (iWizardPage instanceof JavadocTreeWizardPage) {
            return null;
        }
        return null;
    }

    private class JavadocDebugEventListener
    implements IDebugEventSetListener {
        private Display fDisplay;
        private File fFile;

        public JavadocDebugEventListener(Display display, File file) {
            this.fDisplay = display;
            this.fFile = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleDebugEvents(DebugEvent[] debugEventArray) {
            for (int i = 0; i < debugEventArray.length; ++i) {
                if (debugEventArray[i].getKind() != 8) continue;
                try {
                    if (!JavadocWizard.this.fWriteCustom) {
                        this.fFile.delete();
                        JavadocWizard.this.refresh(JavadocWizard.this.fDestination);
                        JavadocWizard.this.spawnInBrowser(this.fDisplay);
                    }
                }
                finally {
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                }
                return;
            }
        }
    }
}

