/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ajdocexport;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.ajdt.ajdocexport.JavadocOptionsManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.util.Assert;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JavadocWriter {
    private static final char PATH_SEPARATOR = '/';
    private OutputStream fOutputStream;
    private IJavaProject[] fJavaProjects;
    private IPath fBasePath;

    public JavadocWriter(OutputStream outputStream, IPath iPath, IJavaProject[] iJavaProjectArray) {
        Assert.isNotNull((Object)outputStream);
        this.fOutputStream = new BufferedOutputStream(outputStream);
        this.fBasePath = iPath;
        this.fJavaProjects = iJavaProjectArray;
    }

    public void writeXML(JavadocOptionsManager javadocOptionsManager) throws ParserConfigurationException, TransformerException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("project");
        document.appendChild(element);
        element.setAttribute("default", "javadoc");
        Element element2 = document.createElement("target");
        element.appendChild(element2);
        element2.setAttribute("name", "javadoc");
        Element element3 = document.createElement("javadoc");
        element2.appendChild(element3);
        if (!javadocOptionsManager.isFromStandard()) {
            this.xmlWriteDoclet(javadocOptionsManager, document, element3);
        } else {
            this.xmlWriteJavadocStandardParams(javadocOptionsManager, document, element3);
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(this.fOutputStream);
        transformer.transform(dOMSource, streamResult);
    }

    private void xmlWriteJavadocStandardParams(JavadocOptionsManager javadocOptionsManager, Document document, Element element) throws DOMException {
        String string = this.getPathString((IPath)new Path(javadocOptionsManager.getDestination()));
        element.setAttribute(javadocOptionsManager.DESTINATION, string);
        element.setAttribute(javadocOptionsManager.VISIBILITY, javadocOptionsManager.getAccess());
        if (javadocOptionsManager.isJDK14Mode()) {
            element.setAttribute(javadocOptionsManager.SOURCE, "1.4");
        }
        element.setAttribute(javadocOptionsManager.USE, this.booleanToString(javadocOptionsManager.getBoolean("use")));
        element.setAttribute(javadocOptionsManager.NOTREE, this.booleanToString(javadocOptionsManager.getBoolean("notree")));
        element.setAttribute(javadocOptionsManager.NONAVBAR, this.booleanToString(javadocOptionsManager.getBoolean("nonavbar")));
        element.setAttribute(javadocOptionsManager.NOINDEX, this.booleanToString(javadocOptionsManager.getBoolean("noindex")));
        element.setAttribute(javadocOptionsManager.SPLITINDEX, this.booleanToString(javadocOptionsManager.getBoolean("splitindex")));
        element.setAttribute(javadocOptionsManager.AUTHOR, this.booleanToString(javadocOptionsManager.getBoolean("author")));
        element.setAttribute(javadocOptionsManager.VERSION, this.booleanToString(javadocOptionsManager.getBoolean("version")));
        element.setAttribute(javadocOptionsManager.NODEPRECATEDLIST, this.booleanToString(javadocOptionsManager.getBoolean("nodeprecatedlist")));
        element.setAttribute(javadocOptionsManager.NODEPRECATED, this.booleanToString(javadocOptionsManager.getBoolean("nodeprecated")));
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.sortSourceElement(javadocOptionsManager.getSourceElements(), arrayList2, arrayList);
        if (!arrayList.isEmpty()) {
            element.setAttribute(javadocOptionsManager.PACKAGENAMES, this.toSeparatedList(arrayList));
        }
        if (!arrayList2.isEmpty()) {
            element.setAttribute(javadocOptionsManager.SOURCEFILES, this.toSeparatedList(arrayList2));
        }
        element.setAttribute(javadocOptionsManager.SOURCEPATH, this.getPathString(javadocOptionsManager.getSourcepath()));
        element.setAttribute(javadocOptionsManager.CLASSPATH, this.getPathString(javadocOptionsManager.getClasspath()));
        String string2 = javadocOptionsManager.getOverview();
        if (string2.length() > 0) {
            element.setAttribute(javadocOptionsManager.OVERVIEW, string2);
        }
        if ((string2 = javadocOptionsManager.getStyleSheet()).length() > 0) {
            element.setAttribute(javadocOptionsManager.STYLESHEETFILE, string2);
        }
        if ((string2 = javadocOptionsManager.getTitle()).length() > 0) {
            element.setAttribute(javadocOptionsManager.TITLE, string2);
        }
        String string3 = javadocOptionsManager.getVMParams();
        String string4 = javadocOptionsManager.getAdditionalParams();
        if (string3.length() + string4.length() > 0) {
            string2 = string3 + ' ' + string4;
            element.setAttribute(javadocOptionsManager.EXTRAOPTIONS, string2);
        }
        String[] stringArray = javadocOptionsManager.getHRefs();
        for (int i = 0; i < stringArray.length; ++i) {
            Element element2 = document.createElement("link");
            element.appendChild(element2);
            element2.setAttribute(javadocOptionsManager.HREF, stringArray[i]);
        }
    }

    private void sortSourceElement(IJavaElement[] iJavaElementArray, List list, List list2) {
        for (int i = 0; i < iJavaElementArray.length; ++i) {
            IJavaElement iJavaElement = iJavaElementArray[i];
            IPath iPath = iJavaElement.getResource().getLocation();
            if (iPath == null) continue;
            if (iJavaElement instanceof ICompilationUnit) {
                String string = this.getPathString(iPath);
                list.add(string);
                continue;
            }
            if (!(iJavaElement instanceof IPackageFragment)) continue;
            list2.add(iJavaElement.getElementName());
        }
    }

    private String getPathString(IPath[] iPathArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < iPathArray.length; ++i) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(this.getPathString(iPathArray[i]));
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append('.');
        }
        return stringBuffer.toString();
    }

    private boolean hasSameDevice(IPath iPath, IPath iPath2) {
        String string = iPath.getDevice();
        if (string == null) {
            return iPath2.getDevice() == null;
        }
        return string.equals(iPath2.getDevice());
    }

    private String getPathString(IPath iPath) {
        if (this.fBasePath == null || !this.hasSameDevice(iPath, this.fBasePath)) {
            return iPath.toOSString();
        }
        int n = this.fBasePath.matchingFirstSegments(iPath);
        if (this.fBasePath.segmentCount() == n) {
            return this.getRelativePath(iPath, n);
        }
        for (int i = 0; i < this.fJavaProjects.length; ++i) {
            IProject iProject = this.fJavaProjects[i].getProject();
            IPath iPath2 = iProject.getLocation();
            if (iPath2.segmentCount() > n || !iPath2.isPrefixOf(iPath)) continue;
            return this.getRelativePath(iPath, n);
        }
        IPath iPath3 = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (iPath3.segmentCount() <= n && iPath3.isPrefixOf(iPath)) {
            return this.getRelativePath(iPath, n);
        }
        return iPath.toOSString();
    }

    private String getRelativePath(IPath iPath, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = this.fBasePath.segmentCount() - n; i > 0; --i) {
            stringBuffer.append("..");
            stringBuffer.append('/');
        }
        int n2 = iPath.segmentCount();
        for (int i = n; i < n2; ++i) {
            if (i > n) {
                stringBuffer.append('/');
            }
            stringBuffer.append(iPath.segment(i));
        }
        return stringBuffer.toString();
    }

    private void xmlWriteDoclet(JavadocOptionsManager javadocOptionsManager, Document document, Element element) throws DOMException {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.sortSourceElement(javadocOptionsManager.getSourceElements(), arrayList2, arrayList);
        if (!arrayList.isEmpty()) {
            element.setAttribute(javadocOptionsManager.PACKAGENAMES, this.toSeparatedList(arrayList));
        }
        if (!arrayList2.isEmpty()) {
            element.setAttribute(javadocOptionsManager.SOURCEFILES, this.toSeparatedList(arrayList2));
        }
        element.setAttribute(javadocOptionsManager.SOURCEPATH, this.getPathString(javadocOptionsManager.getSourcepath()));
        element.setAttribute(javadocOptionsManager.CLASSPATH, this.getPathString(javadocOptionsManager.getClasspath()));
        element.setAttribute(javadocOptionsManager.VISIBILITY, javadocOptionsManager.getAccess());
        Element element2 = document.createElement("doclet");
        element.appendChild(element2);
        element2.setAttribute(javadocOptionsManager.NAME, javadocOptionsManager.getDocletName());
        element2.setAttribute(javadocOptionsManager.PATH, javadocOptionsManager.getDocletPath());
        String string = javadocOptionsManager.getOverview();
        if (string.length() > 0) {
            element.setAttribute(javadocOptionsManager.OVERVIEW, string);
        }
        if ((string = javadocOptionsManager.getAdditionalParams()).length() > 0) {
            element.setAttribute(javadocOptionsManager.EXTRAOPTIONS, string);
        }
    }

    private String toSeparatedList(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            ++n;
            String string = (String)iterator.next();
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String booleanToString(boolean bl) {
        if (bl) {
            return "true";
        }
        return "false";
    }

    public void close() throws IOException {
        if (this.fOutputStream != null) {
            this.fOutputStream.close();
        }
    }
}

