/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurationCreationException;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.Util;
import org.eclipse.ajdt.buildconfigurator.editor.BuildProperties;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class BuildConfiguration
implements Cloneable,
Util.Comparable {
    public static final String EXTENSION = "ajproperties";
    public static final String STANDARD_BUILD_CONFIGURATION_NAME = "build";
    public static final int LST_FILE_LINK = 5;
    private String name;
    private BuildProperties propertiesFile;
    private HashSet fileList;
    private ProjectBuildConfigurator pbc;
    private boolean listenToFileChanges = true;

    public BuildConfiguration(String string, IJavaProject iJavaProject, ProjectBuildConfigurator projectBuildConfigurator) {
        this.pbc = projectBuildConfigurator;
        this.name = string;
        this.fileList = BuildConfigurator.getBuildConfigurator().getInitialFileList();
        if (this.fileList != null) {
            this.propertiesFile = new BuildProperties(this.getFileFromName(string), this.minimizeIncludes(this.fileList));
        } else {
            try {
                IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
                if (BuildConfigurator.getBuildConfigurator().haveExclusionPatterns(iClasspathEntryArray)) {
                    this.fileList = BuildConfigurator.getBuildConfigurator().getFileSetFromCPE(iClasspathEntryArray, iJavaProject);
                    this.propertiesFile = new BuildProperties(this.getFileFromName(string), this.minimizeIncludes(this.fileList));
                } else {
                    this.fileList = BuildConfigurator.getBuildConfigurator().getInitialFileList();
                    if (this.fileList != null) {
                        this.propertiesFile = new BuildProperties(this.getFileFromName(string), this.minimizeIncludes(this.fileList));
                    } else {
                        ArrayList<IPath> arrayList = new ArrayList<IPath>();
                        for (int i = 0; i < iClasspathEntryArray.length; ++i) {
                            if (iClasspathEntryArray[i].getEntryKind() != 3) continue;
                            IPath iPath = iClasspathEntryArray[i].getPath();
                            IResource iResource = iJavaProject.getProject().getParent().findMember(iPath);
                            if (iResource == null || !iResource.exists()) continue;
                            arrayList.add(iResource.getProjectRelativePath());
                        }
                        this.propertiesFile = new BuildProperties(this.getFileFromName(string), arrayList);
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                AspectJPlugin.getDefault().getLog().log(javaModelException.getStatus());
            }
        }
    }

    public IFile getFile() {
        return this.getFileFromName(this.name);
    }

    public BuildConfiguration(IFile iFile, ProjectBuildConfigurator projectBuildConfigurator) {
        this.pbc = projectBuildConfigurator;
        this.loadDataFromFile(iFile);
    }

    private HashSet getFileList() {
        if (this.fileList == null) {
            HashSet hashSet = new HashSet(20);
            hashSet.addAll(this.propertiesFile.getFiles(false));
            this.fileList = hashSet;
            return hashSet;
        }
        return this.fileList;
    }

    public BuildConfiguration(IFile iFile, Shell shell, ProjectBuildConfigurator projectBuildConfigurator) {
        this.pbc = projectBuildConfigurator;
        this.name = iFile.getName();
        this.name = this.name.substring(0, this.name.length() - 4);
        String string = AspectJPlugin.getResourceString("BCDialog.SaveLstAsAJProp.title");
        String string2 = AspectJPlugin.getResourceString("BCDialog.SaveLstAsAJProp.message").replaceAll("%src", this.name);
        InputDialogWithCheck inputDialogWithCheck = new InputDialogWithCheck(shell, string, string2, this.name + "." + EXTENSION, null);
        inputDialogWithCheck.setBlockOnOpen(true);
        if (inputDialogWithCheck.open() == 0 && inputDialogWithCheck.getValue() != null) {
            String string3 = inputDialogWithCheck.getValue();
            if (!string3.endsWith(".ajproperties")) {
                string3 = string3 + "." + EXTENSION;
            }
            IFile iFile2 = projectBuildConfigurator.getJavaProject().getProject().getFile(string3);
            this.name = BuildConfiguration.getNameFromFile(iFile2);
            if (iFile2.exists() && !this.askUserOverwrite(string3)) {
                return;
            }
            this.fileList = new HashSet();
            this.addLStFileContentsToFileList(iFile);
            this.propertiesFile = new BuildProperties(this.getFileFromName(this.name), this.minimizeIncludes(this.fileList));
            projectBuildConfigurator.addBuildConfiguration(this);
            if (inputDialogWithCheck.isChecked()) {
                projectBuildConfigurator.setActiveBuildConfiguration(this);
            }
        }
    }

    private List minimizeIncludes(HashSet hashSet) {
        HashSet hashSet2 = (HashSet)hashSet.clone();
        HashSet hashSet3 = new HashSet();
        boolean bl = true;
        Iterator iterator = hashSet2.iterator();
        while (bl) {
            bl = false;
            iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                block11: {
                    IResource iResource = (IResource)iterator.next();
                    IContainer iContainer = iResource.getParent();
                    if (iContainer.getType() != 4) {
                        try {
                            int n;
                            IResource[] iResourceArray = iContainer.members();
                            boolean bl2 = true;
                            for (n = 0; n < iResourceArray.length; ++n) {
                                if (!hashSet2.contains(iResourceArray[n]) && ProjectProperties.ASPECTJ_SOURCE_FILTER.accept(iResourceArray[n].getName())) {
                                    bl2 = false;
                                    break;
                                }
                                if (hashSet2.contains(iResourceArray[n]) || iResourceArray[n].getType() != 2) continue;
                                bl2 = false;
                                break;
                            }
                            if (!bl2) {
                                for (n = 0; n < iResourceArray.length; ++n) {
                                    if (!hashSet2.remove(iResourceArray[n])) continue;
                                    hashSet3.add(iResourceArray[n]);
                                }
                                break block11;
                            }
                            for (n = 0; n < iResourceArray.length; ++n) {
                                hashSet2.remove(iResourceArray[n]);
                            }
                            bl = true;
                            hashSet3.add(iContainer);
                        }
                        catch (CoreException coreException) {
                            AspectJPlugin.logException(coreException);
                        }
                    } else {
                        hashSet2.remove(iResource);
                        hashSet3.add(iResource);
                    }
                }
                iterator = hashSet2.iterator();
            }
            HashSet hashSet4 = hashSet3;
            hashSet3 = hashSet2;
            hashSet2 = hashSet4;
        }
        return new ArrayList(hashSet2);
    }

    private void addLStFileContentsToFileList(IFile iFile) {
        IFile iFile2;
        String string;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        try {
            Util.getLstFileContents(iFile.getLocation(), arrayList, arrayList2, arrayList3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            AspectJPlugin.logException(fileNotFoundException);
            return;
        }
        IProject iProject = this.pbc.getJavaProject().getProject();
        IPath iPath = iFile.getFullPath().removeLastSegments(1);
        int n = iPath.matchingFirstSegments(iProject.getFullPath());
        IPath iPath2 = iPath.removeFirstSegments(n);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            iFile2 = iProject.getFile(iPath2.append(string));
            if (!iFile2.exists()) continue;
            this.getFileList().add(iFile2);
        }
        iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            string = ((String)iterator.next()).substring(1);
            iFile2 = iProject.getFile(iPath2.append(string));
            if (!iFile2.exists()) continue;
            this.addLStFileContentsToFileList(iFile2);
        }
    }

    public BuildConfiguration(ProjectBuildConfigurator projectBuildConfigurator, Shell shell) throws BuildConfigurationCreationException {
        this.pbc = projectBuildConfigurator;
        String string = AspectJPlugin.getResourceString("BCDialog.SaveBuildConfigurationAs.title");
        String string2 = AspectJPlugin.getResourceString("BCDialog.SaveBuildConfigurationAs.message");
        String string3 = AspectJPlugin.getResourceString("BCDialog.SaveBuildConfigurationAs.default");
        BuildConfiguration buildConfiguration = projectBuildConfigurator.getActiveBuildConfiguration();
        final String string4 = buildConfiguration.getName();
        IInputValidator iInputValidator = new IInputValidator(){

            public String isValid(String string) {
                if (string4.equals(string) || (string4 + "." + BuildConfiguration.EXTENSION).equals(string)) {
                    return AspectJPlugin.getResourceString("BCDialog.NameValidator.ExistsError");
                }
                return null;
            }
        };
        InputDialogWithCheck inputDialogWithCheck = new InputDialogWithCheck(shell, string, string2, string3, iInputValidator);
        inputDialogWithCheck.setBlockOnOpen(true);
        if (inputDialogWithCheck.open() == 0 && inputDialogWithCheck.getValue() != null) {
            String string5;
            this.name = string5 = inputDialogWithCheck.getValue();
            IFile iFile = buildConfiguration.getFile();
            IFile iFile2 = this.getFile();
            if (iFile2.exists()) {
                if (!this.askUserOverwrite(iFile2.getName())) {
                    throw new BuildConfigurationCreationException();
                }
                try {
                    iFile2.delete(true, null);
                }
                catch (CoreException coreException) {
                    AspectJPlugin.logException(coreException);
                }
            }
            try {
                iFile.copy(iFile2.getFullPath(), true, null);
                this.propertiesFile = new BuildProperties(iFile2);
            }
            catch (CoreException coreException) {
                this.propertiesFile = new BuildProperties(this.getFileFromName(this.name), new ArrayList(this.getFileList()));
                AspectJPlugin.logException(coreException);
            }
            this.fileList = new HashSet(this.propertiesFile.getFiles(false));
            projectBuildConfigurator.addBuildConfiguration(this);
            if (inputDialogWithCheck.isChecked()) {
                projectBuildConfigurator.setActiveBuildConfiguration(this);
            }
        } else {
            throw new BuildConfigurationCreationException();
        }
    }

    IFile getFileFromName(String string) {
        return this.pbc.getJavaProject().getProject().getFile(string + "." + EXTENSION);
    }

    static String getNameFromFile(IFile iFile) {
        String string = iFile.getName();
        return string.substring(0, string.indexOf(".ajproperties"));
    }

    public void loadDataFromFile(IFile iFile) {
        if (iFile.exists()) {
            this.name = BuildConfiguration.getNameFromFile(iFile);
            this.propertiesFile = new BuildProperties(iFile);
        }
    }

    private String getLstContentFromData() {
        String string = "";
        Iterator iterator = this.getFileList().iterator();
        while (iterator.hasNext()) {
            string = string.concat(((IFile)iterator.next()).getProjectRelativePath().toOSString().concat("\n"));
        }
        return string;
    }

    public String getName() {
        return this.name;
    }

    private boolean excludeFile(IResource iResource) throws CoreException {
        this.listenToFileChanges = false;
        this.propertiesFile.exclude(iResource);
        this.listenToFileChanges = true;
        if (iResource.getType() == 1) {
            this.getFileList().remove(iResource);
            return true;
        }
        return false;
    }

    public void excludeFiles(List list) throws CoreException {
        Iterator iterator = list.iterator();
        boolean bl = false;
        IResource iResource = null;
        while (iterator.hasNext()) {
            iResource = (IResource)iterator.next();
            if (this.excludeFile(iResource)) continue;
            bl = true;
        }
        if (bl) {
            this.update(false);
        }
        this.propertiesFile.writeFile();
    }

    private boolean includeFile(IResource iResource) {
        this.listenToFileChanges = false;
        this.propertiesFile.include(iResource);
        this.listenToFileChanges = true;
        if (iResource.getType() == 1) {
            this.getFileList().add(iResource);
            return true;
        }
        return false;
    }

    public void includeFiles(List list) {
        Iterator iterator = list.iterator();
        boolean bl = false;
        IResource iResource = null;
        while (iterator.hasNext()) {
            iResource = (IResource)iterator.next();
            if (this.includeFile(iResource)) continue;
            bl = true;
        }
        if (bl) {
            this.update(false);
        }
        this.propertiesFile.writeFile();
    }

    public boolean isIncluded(IResource iResource) {
        boolean bl = this.getFileList().contains(iResource);
        return bl;
    }

    public int compareTo(Util.Comparable comparable) {
        if (comparable instanceof BuildConfiguration) {
            return this.getName().compareToIgnoreCase(((BuildConfiguration)comparable).getName());
        }
        return 0;
    }

    public void update(boolean bl) {
        if (this.listenToFileChanges) {
            if (this.fileList == null) {
                this.fileList = new HashSet();
            } else {
                this.fileList.clear();
            }
            List list = this.propertiesFile.getFiles(bl);
            this.fileList.addAll(list);
        }
    }

    public List getIncludedJavaFiles(ProjectProperties.FilenameFilter filenameFilter) {
        Iterator iterator = this.getFileList().iterator();
        ArrayList<File> arrayList = new ArrayList<File>(this.getFileList().size());
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            if (!iResource.exists() || !filenameFilter.accept(iResource.getName())) continue;
            arrayList.add(new File(iResource.getLocation().toOSString()));
        }
        return arrayList;
    }

    public List getIncludedJavaFileNames(ProjectProperties.FilenameFilter filenameFilter) {
        Iterator iterator = this.getFileList().iterator();
        ArrayList<String> arrayList = new ArrayList<String>(this.getFileList().size());
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            if (!iResource.exists() || !filenameFilter.accept(iResource.getName())) continue;
            arrayList.add(iResource.getLocation().toOSString());
        }
        return arrayList;
    }

    public void writeLstFile() {
        this.update(false);
        String string = this.getLstContentFromData();
        String string2 = AspectJPlugin.getResourceString("BCDialog.SaveAJPropAsLst.title");
        String string3 = AspectJPlugin.getResourceString("BCDialog.SaveAJPropAsLst.message").replaceAll("%name", this.name);
        InputDialog inputDialog = new InputDialog(null, string2, string3, this.name + ".lst", null);
        inputDialog.setBlockOnOpen(true);
        if (inputDialog.open() == 0 && inputDialog.getValue() != null) {
            String string4 = inputDialog.getValue();
            if (!string4.endsWith(".lst")) {
                string4 = string4 + ".lst";
            }
            try {
                IFile iFile = this.pbc.getJavaProject().getProject().getFile(string4);
                if (iFile.exists()) {
                    if (this.askUserOverwrite(string4)) {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                        if (iFile.isReadOnly()) {
                            ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{iFile}, null);
                        }
                        iFile.setContents((InputStream)byteArrayInputStream, 1, null);
                    }
                } else {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                    iFile.create((InputStream)byteArrayInputStream, 1, null);
                }
            }
            catch (CoreException coreException) {
                AspectJPlugin.getDefault().getErrorHandler().handleError(AspectJPlugin.getResourceString("buildConfig.exceptionWriting").replaceAll("%fileName", string4), coreException);
            }
        }
    }

    private boolean askUserOverwrite(String string) {
        String string2;
        String[] stringArray = new String[]{AspectJPlugin.getResourceString("BCDialog.Overwrite.yes"), AspectJPlugin.getResourceString("BCDialog.Overwrite.no")};
        String string3 = AspectJPlugin.getResourceString("BCDialog.Overwrite.title");
        MessageDialog messageDialog = new MessageDialog(null, string3, null, string2 = AspectJPlugin.getResourceString("BCDialog.Overwrite.message").replaceAll("%fileName", string), 3, stringArray, 1);
        return messageDialog.open() == 0;
    }

    public boolean areFilesActive() {
        return this.getFileList().size() != 0;
    }

    public void updateSourceFolders(List list) {
        this.propertiesFile.updateSourceFolders(list);
        this.fileList = null;
    }

    private class InputDialogWithCheck
    extends InputDialog {
        private Button check;
        private boolean selected;

        public InputDialogWithCheck(Shell shell, String string, String string2, String string3, IInputValidator iInputValidator) {
            super(shell, string, string2, string3, iInputValidator);
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            this.check = new Button(composite2, 32);
            this.check.setSelection(true);
            this.check.setText(AspectJPlugin.getResourceString("BCDialog.Activate.check"));
            return composite2;
        }

        protected void okPressed() {
            this.selected = this.check.getSelection();
            super.okPressed();
        }

        public boolean isChecked() {
            return this.selected;
        }
    }
}

