/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.ajdt.buildconfigurator.IBuildConfigurationChangedListener;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.PropertyPageManager;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class BuildConfigurator
implements ISelectionListener {
    private HashMap projectConfigurators = new HashMap();
    private Vector changeListeners = new Vector();
    private IProject currentProj;
    private int notificationType = -1;
    private static BuildConfigurator buildConfigurator;
    private HashSet fileList;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    private BuildConfigurator() {
    }

    public static synchronized BuildConfigurator getBuildConfigurator() {
        if (buildConfigurator == null) {
            buildConfigurator = new BuildConfigurator();
        }
        return buildConfigurator;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        IResource iResource;
        Object object = iWorkbenchPart instanceof IEditorPart ? ((iResource = (IResource)((IEditorPart)iWorkbenchPart).getEditorInput().getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = BuildConfigurator.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource)) != null ? iResource.getProject() : null) : this.getProjectFromSelection(iSelection);
        if (object != this.currentProj && object != null) {
            this.fileList = null;
            this.currentProj = object;
            if (this.canManage(this.currentProj)) {
                PropertyPageManager.unregisterJDTPropertyPage();
            } else if (this.currentProj.isOpen()) {
                PropertyPageManager.registerJDTPropertyPage();
            }
            this.notifyChangeListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChangeListeners() {
        if (this.notificationType == -1) {
            try {
                this.notificationType = 0;
                ProjectBuildConfigurator projectBuildConfigurator = this.getActiveProjectBuildConfigurator();
                Iterator iterator = this.changeListeners.iterator();
                while (iterator.hasNext()) {
                    ((IBuildConfigurationChangedListener)iterator.next()).buildConfigurationChanged(projectBuildConfigurator);
                }
            }
            finally {
                this.notificationType = -1;
            }
        }
    }

    private IProject getProjectFromSelection(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            if (object instanceof IJavaElement) {
                return ((IJavaElement)object).getJavaProject().getProject();
            }
            if (object instanceof IResource) {
                IResource iResource = (IResource)object;
                return iResource.getProject();
            }
            if (object instanceof ClassPathContainer) {
                return ((ClassPathContainer)object).getJavaProject().getProject();
            }
        }
        return null;
    }

    public ProjectBuildConfigurator getActiveProjectBuildConfigurator() {
        return this.getProjectBuildConfigurator(this.currentProj);
    }

    public Set getProjectBuildConfigurators() {
        return this.projectConfigurators.entrySet();
    }

    public ProjectBuildConfigurator getProjectBuildConfigurator(IJavaProject iJavaProject) {
        if (iJavaProject != null && this.canManage(iJavaProject.getProject())) {
            ProjectBuildConfigurator projectBuildConfigurator = (ProjectBuildConfigurator)this.projectConfigurators.get(iJavaProject.getProject().getName());
            if (projectBuildConfigurator != null) {
                return projectBuildConfigurator;
            }
            return this.createPBC(iJavaProject);
        }
        return null;
    }

    private synchronized ProjectBuildConfigurator createPBC(IJavaProject iJavaProject) {
        ProjectBuildConfigurator projectBuildConfigurator = (ProjectBuildConfigurator)this.projectConfigurators.get(iJavaProject.getProject().getName());
        if (projectBuildConfigurator != null) {
            return projectBuildConfigurator;
        }
        projectBuildConfigurator = new ProjectBuildConfigurator(iJavaProject);
        this.projectConfigurators.put(iJavaProject.getProject().getName(), projectBuildConfigurator);
        return projectBuildConfigurator;
    }

    public ProjectBuildConfigurator getProjectBuildConfigurator(IProject iProject) {
        return this.getProjectBuildConfigurator(JavaCore.create((IProject)iProject));
    }

    public boolean canManage(IProject iProject) {
        if (iProject == null || !iProject.isOpen()) {
            return false;
        }
        try {
            if (iProject.getProject().hasNature("org.eclipse.ajdt.ui.ajnature")) {
                return true;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
        return false;
    }

    public void addProjectBuildConfigurator(ProjectBuildConfigurator projectBuildConfigurator) {
        this.projectConfigurators.put(projectBuildConfigurator.getJavaProject().getProject().getName(), projectBuildConfigurator);
    }

    public void addBuildConfigurationChangedListener(IBuildConfigurationChangedListener iBuildConfigurationChangedListener) {
        this.changeListeners.add(iBuildConfigurationChangedListener);
    }

    public void closeProject(IProject iProject) {
        this.fileList = null;
        ProjectBuildConfigurator projectBuildConfigurator = (ProjectBuildConfigurator)this.projectConfigurators.get(iProject.getName());
        if (projectBuildConfigurator != null) {
            if (iProject == this.currentProj) {
                this.currentProj = null;
            }
            this.projectConfigurators.remove(iProject.getName());
            this.notifyChangeListeners();
        }
    }

    public void checkNature(IProject iProject) {
        if (this.projectConfigurators.containsKey(iProject.getName())) {
            ProjectBuildConfigurator projectBuildConfigurator;
            if (!this.canManage(iProject) && (projectBuildConfigurator = (ProjectBuildConfigurator)this.projectConfigurators.get(iProject.getName())) != null) {
                this.closeProject(iProject);
            }
        } else if (this.canManage(iProject)) {
            this.currentProj = iProject;
            this.notifyChangeListeners();
        }
    }

    public void restoreJDTState(IProject iProject) {
        PropertyPageManager.registerJDTPropertyPage();
        this.checkNature(iProject);
    }

    public void setup(IProject iProject) {
        this.fileList = null;
        PropertyPageManager.unregisterJDTPropertyPage();
        try {
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
            if (this.haveExclusionPatterns(iClasspathEntryArray)) {
                this.fileList = this.getFileSetFromCPE(iClasspathEntryArray, iJavaProject);
                for (int i = 0; i < iClasspathEntryArray.length; ++i) {
                    if (iClasspathEntryArray[i].getEntryKind() != 3) continue;
                    iClasspathEntryArray[i] = JavaCore.newSourceEntry((IPath)iClasspathEntryArray[i].getPath());
                }
                iJavaProject.setRawClasspath(iClasspathEntryArray, null);
            }
        }
        catch (JavaModelException javaModelException) {
            AspectJPlugin.logException(javaModelException);
            this.fileList = null;
        }
        if (this.currentProj == null || this.currentProj == iProject) {
            this.currentProj = iProject;
            this.notifyChangeListeners();
        }
    }

    HashSet getFileSetFromCPE(IClasspathEntry[] iClasspathEntryArray, IJavaProject iJavaProject) {
        HashSet hashSet = new HashSet(30);
        for (int i = 0; i < iClasspathEntryArray.length; ++i) {
            IResource iResource;
            if (iClasspathEntryArray[i].getEntryKind() != 3 || (iResource = iJavaProject.getProject().getParent().findMember(iClasspathEntryArray[i].getPath())) == null || iResource.getType() != 2 && iResource.getType() != 4) continue;
            this.addAllIncludedMembers(hashSet, (IContainer)iResource, iJavaProject);
        }
        return hashSet;
    }

    boolean haveExclusionPatterns(IClasspathEntry[] iClasspathEntryArray) {
        for (int i = 0; i < iClasspathEntryArray.length; ++i) {
            if (iClasspathEntryArray[i].getEntryKind() != 3 || iClasspathEntryArray[i].getExclusionPatterns().length <= 0 && iClasspathEntryArray[i].getInclusionPatterns().length <= 0) continue;
            return true;
        }
        return false;
    }

    HashSet getInitialFileList() {
        return this.fileList;
    }

    private void addAllIncludedMembers(HashSet hashSet, IContainer iContainer, IJavaProject iJavaProject) {
        try {
            IResource[] iResourceArray = iContainer.members();
            for (int i = 0; i < iResourceArray.length; ++i) {
                if (iResourceArray[i] instanceof IContainer) {
                    this.addAllIncludedMembers(hashSet, (IContainer)iResourceArray[i], iJavaProject);
                    continue;
                }
                if (!iJavaProject.isOnClasspath(iResourceArray[i]) || !ProjectProperties.ASPECTJ_SOURCE_FILTER.accept(iResourceArray[i].getName())) continue;
                hashSet.add(iResourceArray[i]);
            }
        }
        catch (CoreException coreException) {
            AspectJPlugin.logException(coreException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

