/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator;

import java.util.ArrayList;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.core.resources.AspectJImages;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.viewsupport.TreeHierarchyLayoutProblemsDecorator;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DecoratorManager;

public class ImageDecorator
implements ILabelDecorator {
    private ArrayList listeners = new ArrayList(2);
    private ImageDescriptorRegistry fRegistry;
    private boolean preventRecursion = false;
    private TreeHierarchyLayoutProblemsDecorator problemsDecorator = new TreeHierarchyLayoutProblemsDecorator();
    private DecoratorManager decman = WorkbenchPlugin.getDefault().getDecoratorManager();
    private ImageDescriptor halfFilledPackageID = AspectJImages.BC_HALF_FILLED_PACKAGE.getImageDescriptor();
    private ImageDescriptor activeConfigFileImage = AspectJImages.BC_SELECTED_FILE.getImageDescriptor();
    private BuildConfigurator buildConfor = BuildConfigurator.getBuildConfigurator();

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        this.listeners.add(iLabelProviderListener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        this.listeners.remove(iLabelProviderListener);
    }

    public Image decorateImage(Image image, Object object) {
        ICompilationUnit iCompilationUnit;
        if (this.preventRecursion) {
            return null;
        }
        if (object instanceof ICompilationUnit) {
            iCompilationUnit = (ICompilationUnit)object;
            try {
                object = iCompilationUnit.getCorrespondingResource();
            }
            catch (JavaModelException javaModelException) {
                object = null;
            }
        }
        iCompilationUnit = null;
        if (object instanceof IFile) {
            ProjectBuildConfigurator projectBuildConfigurator;
            IFile iFile = (IFile)object;
            if (ProjectProperties.ASPECTJ_SOURCE_FILTER.accept(iFile.getName())) {
                ProjectBuildConfigurator projectBuildConfigurator2 = this.buildConfor.getProjectBuildConfigurator(iFile.getProject());
                if (projectBuildConfigurator2 == null) {
                    return null;
                }
                if (projectBuildConfigurator2.getActiveBuildConfiguration().isIncluded((IResource)iFile)) {
                    Rectangle rectangle = image.getBounds();
                    int n = rectangle.height == 16 ? 2 : 0;
                    iCompilationUnit = this.getImageLabel(this.getCUImageDescriptor(iFile, n));
                } else {
                    Rectangle rectangle = image.getBounds();
                    int n = rectangle.height == 16 ? 2 : 0;
                    iCompilationUnit = this.getImageLabel(this.getCUResourceImageDescriptor(iFile, n));
                }
            } else if ("ajproperties".equals(iFile.getFileExtension()) && (projectBuildConfigurator = this.buildConfor.getProjectBuildConfigurator(iFile.getProject())) != null && iFile.equals(projectBuildConfigurator.getActiveBuildConfiguration().getFile())) {
                iCompilationUnit = this.getImageLabel(this.activeConfigFileImage);
            }
        } else if (object instanceof IPackageFragment) {
            IPackageFragment iPackageFragment = (IPackageFragment)object;
            ProjectBuildConfigurator projectBuildConfigurator = this.buildConfor.getProjectBuildConfigurator(iPackageFragment.getJavaProject());
            if (projectBuildConfigurator == null) {
                return null;
            }
            BuildConfiguration buildConfiguration = projectBuildConfigurator.getActiveBuildConfiguration();
            try {
                if (ImageDecorator.containsIncludedFiles(buildConfiguration, iPackageFragment)) {
                    if (ImageDecorator.containsExcludedFiles(buildConfiguration, iPackageFragment)) {
                        iCompilationUnit = this.getImageLabel(this.halfFilledPackageID);
                    } else if (!iPackageFragment.containsJavaResources()) {
                        iCompilationUnit = this.getImageLabel(JavaPluginImages.DESC_OBJS_PACKAGE);
                    }
                } else if (ImageDecorator.containsExcludedFiles(buildConfiguration, iPackageFragment)) {
                    iCompilationUnit = this.getImageLabel(JavaPluginImages.DESC_OBJS_EMPTY_PACKAGE);
                }
            }
            catch (JavaModelException javaModelException) {}
        } else {
            return null;
        }
        if (iCompilationUnit != null) {
            this.preventRecursion = true;
            iCompilationUnit = this.problemsDecorator.decorateImage((Image)iCompilationUnit, object);
            iCompilationUnit = this.decman.decorateImage((Image)iCompilationUnit, object);
            this.preventRecursion = false;
            return iCompilationUnit;
        }
        return null;
    }

    public static boolean containsIncludedFiles(BuildConfiguration buildConfiguration, IPackageFragment iPackageFragment) {
        try {
            IJavaElement[] iJavaElementArray = iPackageFragment.getChildren();
            for (int i = 0; i < iJavaElementArray.length; ++i) {
                IResource iResource = iJavaElementArray[i].getCorrespondingResource();
                if (iResource == null || iResource.getType() != 1 || !buildConfiguration.isIncluded(iResource)) continue;
                return true;
            }
            Object[] objectArray = iPackageFragment.getNonJavaResources();
            for (int i = 0; i < objectArray.length; ++i) {
                IFile iFile;
                if (!(objectArray[i] instanceof IFile) || !"aj".equals((iFile = (IFile)objectArray[i]).getFileExtension()) || !buildConfiguration.isIncluded((IResource)iFile)) continue;
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    public static boolean containsExcludedFiles(BuildConfiguration buildConfiguration, IPackageFragment iPackageFragment) {
        try {
            IJavaElement[] iJavaElementArray = iPackageFragment.getChildren();
            for (int i = 0; i < iJavaElementArray.length; ++i) {
                IResource iResource = iJavaElementArray[i].getCorrespondingResource();
                if (iResource == null || iResource.getType() != 1 || buildConfiguration.isIncluded(iResource)) continue;
                return true;
            }
            Object[] objectArray = iPackageFragment.getNonJavaResources();
            for (int i = 0; i < objectArray.length; ++i) {
                IFile iFile;
                if (!(objectArray[i] instanceof IFile) || !"aj".equals((iFile = (IFile)objectArray[i]).getFileExtension()) || buildConfiguration.isIncluded((IResource)iFile)) continue;
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    private Image getImageLabel(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        return this.getRegistry().get(imageDescriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = JavaPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public ImageDescriptor getCUResourceImageDescriptor(IFile iFile, int n) {
        Point point = ImageDecorator.useSmallSize(n) ? JavaElementImageProvider.SMALL_SIZE : JavaElementImageProvider.BIG_SIZE;
        return new JavaElementImageDescriptor(JavaPluginImages.DESC_OBJS_CUNIT_RESOURCE, 0, point);
    }

    public ImageDescriptor getCUImageDescriptor(IFile iFile, int n) {
        Point point = ImageDecorator.useSmallSize(n) ? JavaElementImageProvider.SMALL_SIZE : JavaElementImageProvider.BIG_SIZE;
        return new JavaElementImageDescriptor(JavaPluginImages.DESC_OBJS_CUNIT, 0, point);
    }

    private static boolean useSmallSize(int n) {
        return (n & 2) != 0;
    }

    public String decorateText(String string, Object object) {
        return null;
    }
}

