/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jface.preference.IPreferenceStore;

public class ProjectBuildConfigurator {
    private HashMap buildconfigs;
    private IJavaProject javaProject;
    IFile activeBuildConfiguration;
    private BuildConfigurator buildConfigurator;
    private boolean initialized;
    private boolean fullbuildrequested;

    public ProjectBuildConfigurator(IJavaProject iJavaProject) {
        this.javaProject = iJavaProject;
        this.buildConfigurator = BuildConfigurator.getBuildConfigurator();
        this.buildconfigs = new HashMap();
    }

    public void reInit() {
        this.initialized = false;
    }

    private void init() {
        if (!this.initialized) {
            this.readBuildConfigurationsFromFileSystem();
            this.activeBuildConfiguration = this.getStoredBuildConfiguration();
            this.initialized = true;
        }
    }

    private IFile getStoredBuildConfiguration() {
        IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
        IProject iProject = this.javaProject.getProject();
        String string = "org.eclipse.ajdt.ui." + iProject.getName() + ".ajproperties";
        String string2 = iPreferenceStore.getString(string);
        if (string2.length() == 0) {
            return null;
        }
        return iProject.getFile(string2);
    }

    private void storeActiveBuildConfigurationName(String string) {
        IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
        IProject iProject = this.javaProject.getProject();
        String string2 = "org.eclipse.ajdt.ui." + iProject.getName() + ".ajproperties";
        iPreferenceStore.setValue(string2, string);
    }

    private void readBuildConfigurationsFromFileSystem() {
        try {
            IResource[] iResourceArray = this.javaProject.getProject().members(1);
            for (int i = 0; i < iResourceArray.length; ++i) {
                if (iResourceArray[i].getType() == 2 || !"ajproperties".equals(iResourceArray[i].getFileExtension()) || !iResourceArray[i].exists()) continue;
                BuildConfiguration buildConfiguration = new BuildConfiguration((IFile)iResourceArray[i], this);
                this.buildconfigs.put(iResourceArray[i], buildConfiguration);
            }
        }
        catch (CoreException coreException) {
            AspectJPlugin.logException(coreException);
        }
    }

    public BuildConfiguration getActiveBuildConfiguration() {
        this.makeSureThereIsAtLeastOneActiveConfiguration();
        return (BuildConfiguration)this.buildconfigs.get(this.activeBuildConfiguration);
    }

    public void setActiveBuildConfiguration(BuildConfiguration buildConfiguration) {
        if (this.buildconfigs.containsKey(buildConfiguration.getFile())) {
            IFile iFile = this.activeBuildConfiguration;
            this.activeBuildConfiguration = buildConfiguration.getFile();
            this.storeActiveBuildConfigurationName(buildConfiguration.getFile().getName());
            buildConfiguration.update(false);
            if (!this.activeBuildConfiguration.equals(iFile)) {
                try {
                    this.activeBuildConfiguration.touch(null);
                }
                catch (CoreException coreException) {
                    AspectJPlugin.logException(coreException);
                }
            }
        }
    }

    public BuildConfiguration getBuildConfiguration(IFile iFile) {
        return (BuildConfiguration)this.buildconfigs.get(iFile);
    }

    public void requestFullBuild(boolean bl) {
        this.fullbuildrequested = bl;
    }

    public boolean fullBuildRequested() {
        return this.fullbuildrequested;
    }

    public void configurationChanged(BuildConfiguration buildConfiguration) {
        if (this.initialized) {
            if (!this.buildconfigs.containsKey(buildConfiguration.getFile())) {
                this.buildconfigs.put(buildConfiguration.getFile(), buildConfiguration);
            }
            if (buildConfiguration.getFile().equals(this.activeBuildConfiguration)) {
                this.requestFullBuild(true);
                Runnable runnable = new Runnable(){

                    public void run() {
                        PackageExplorerPart packageExplorerPart = PackageExplorerPart.getFromActivePerspective();
                        if (packageExplorerPart != null) {
                            packageExplorerPart.getTreeViewer().refresh();
                        }
                    }
                };
                AspectJPlugin.getDefault().getDisplay().asyncExec(runnable);
            }
            this.buildConfigurator.notifyChangeListeners();
        }
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public void setProject(IJavaProject iJavaProject) {
        this.javaProject = iJavaProject;
    }

    public IFile[] getConfigurationFiles() {
        this.makeSureThereIsAtLeastOneActiveConfiguration();
        IFile[] iFileArray = new IFile[]{};
        return this.buildconfigs.keySet().toArray(iFileArray);
    }

    public Collection getBuildConfigurations() {
        this.makeSureThereIsAtLeastOneActiveConfiguration();
        return this.buildconfigs.values();
    }

    public void addBuildConfiguration(BuildConfiguration buildConfiguration) {
        this.buildconfigs.put(buildConfiguration.getFile(), buildConfiguration);
        this.buildConfigurator.notifyChangeListeners();
    }

    private void makeSureThereIsAtLeastOneActiveConfiguration() {
        if (!this.initialized) {
            this.init();
        }
        if (this.buildconfigs.size() == 0) {
            BuildConfiguration buildConfiguration = new BuildConfiguration("build", this.javaProject, this);
            this.buildconfigs.put(buildConfiguration.getFile(), buildConfiguration);
        }
        if (this.activeBuildConfiguration == null || !this.buildconfigs.containsKey(this.activeBuildConfiguration)) {
            this.setActiveBuildConfiguration((BuildConfiguration)this.buildconfigs.values().iterator().next());
        }
    }

    public void removeBuildConfiguration(BuildConfiguration buildConfiguration) {
        if (buildConfiguration.getFile().equals(this.activeBuildConfiguration)) {
            this.activeBuildConfiguration = null;
        }
        this.buildconfigs.remove(buildConfiguration.getFile());
        this.makeSureThereIsAtLeastOneActiveConfiguration();
        this.buildConfigurator.notifyChangeListeners();
    }

    public void setActiveBuildConfiguration(IFile iFile) {
        BuildConfiguration buildConfiguration = this.getBuildConfiguration(iFile);
        if (buildConfiguration == null) {
            buildConfiguration = new BuildConfiguration(iFile, this);
            this.addBuildConfiguration(buildConfiguration);
        }
        this.setActiveBuildConfiguration(buildConfiguration);
    }

    public void removeBuildConfiguration(IFile iFile) {
        BuildConfiguration buildConfiguration = this.getBuildConfiguration(iFile);
        if (buildConfiguration != null) {
            this.removeBuildConfiguration(buildConfiguration);
        }
    }
}

