/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class UpdateJob
extends Job {
    public static final int BUILD_CONFIG_CHANGED = 1;
    public static final int BUILD_CONFIG_REMOVED = 2;
    public static final int CLASSPATH_CHANGED = 3;
    public static final int SOURCE_ADDED = 4;
    private int type;
    private IResource myRes;
    private final BuildConfigurator myBCor;

    public UpdateJob(BuildConfigurator buildConfigurator, int n, IResource iResource) {
        super("Build configuration update");
        this.setRule((ISchedulingRule)iResource.getProject());
        this.setPriority(20);
        this.myBCor = buildConfigurator;
        this.type = n;
        this.myRes = iResource;
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        switch (this.type) {
            case 1: {
                this.buildConfigChanged();
                break;
            }
            case 2: {
                this.buildConfigRemoved();
                break;
            }
            case 3: {
                this.classpathChanged();
                break;
            }
            case 4: {
                this.sourceAdded();
            }
        }
        return Status.OK_STATUS;
    }

    private void sourceAdded() {
        BuildConfiguration buildConfiguration;
        ProjectBuildConfigurator projectBuildConfigurator = this.myBCor.getProjectBuildConfigurator(this.myRes.getProject());
        if (projectBuildConfigurator != null && (buildConfiguration = projectBuildConfigurator.getActiveBuildConfiguration()) != null && !buildConfiguration.isIncluded(this.myRes)) {
            buildConfiguration.update(false);
        }
    }

    private void classpathChanged() {
        ProjectBuildConfigurator projectBuildConfigurator = this.myBCor.getProjectBuildConfigurator(this.myRes.getProject());
        if (projectBuildConfigurator != null) {
            try {
                IJavaProject iJavaProject = JavaCore.create((IProject)this.myRes.getProject());
                IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
                ArrayList<IPath> arrayList = new ArrayList<IPath>();
                for (int i = 0; i < iClasspathEntryArray.length; ++i) {
                    if (iClasspathEntryArray[i].getEntryKind() != 3) continue;
                    arrayList.add(iClasspathEntryArray[i].getPath().removeFirstSegments(1));
                }
                Iterator iterator = projectBuildConfigurator.getBuildConfigurations().iterator();
                while (iterator.hasNext()) {
                    ((BuildConfiguration)iterator.next()).updateSourceFolders(arrayList);
                }
            }
            catch (JavaModelException javaModelException) {
                AspectJPlugin.logException(javaModelException);
            }
        }
    }

    private void buildConfigRemoved() {
        ProjectBuildConfigurator projectBuildConfigurator = this.myBCor.getProjectBuildConfigurator(this.myRes.getProject());
        if (projectBuildConfigurator != null) {
            projectBuildConfigurator.removeBuildConfiguration((IFile)this.myRes);
        }
    }

    private void buildConfigChanged() {
        BuildConfiguration buildConfiguration;
        ProjectBuildConfigurator projectBuildConfigurator = this.myBCor.getProjectBuildConfigurator(this.myRes.getProject());
        if (projectBuildConfigurator != null && (buildConfiguration = projectBuildConfigurator.getBuildConfiguration((IFile)this.myRes)) != null) {
            buildConfiguration.update(true);
            projectBuildConfigurator.configurationChanged(buildConfiguration);
        }
    }
}

