/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class Util {
    private static String OS_INDEPENDENT_LINE_SEPARATOR = System.getProperty("line.separator");

    public static String getRelativePathString(IPath iPath, IPath iPath2) {
        String string = null;
        if (iPath != null && iPath2 != null) {
            if (iPath.equals(iPath2)) {
                string = ".";
            } else {
                List list = Util.getPathList(iPath2.toFile());
                List list2 = Util.getPathList(iPath.toFile());
                string = Util.matchPathLists(list, list2);
            }
        }
        return string;
    }

    public static String getRelativePathString(String string, String string2) {
        String string3 = null;
        if (string != null && string2 != null) {
            return Util.getRelativePathString((IPath)new Path(string), (IPath)new Path(string2));
        }
        return string3;
    }

    private static List getPathList(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (File file2 = file.getCanonicalFile(); file2 != null; file2 = file2.getParentFile()) {
                arrayList.add(file2.getName());
            }
        }
        catch (IOException iOException) {
            AspectJPlugin.logException(iOException);
            arrayList = null;
        }
        return arrayList;
    }

    private static String matchPathLists(List list, List list2) {
        int n;
        String string = "";
        int n2 = list.size() - 1;
        for (n = list2.size() - 1; n2 >= 0 && n >= 0 && list.get(n2).equals(list2.get(n)); --n2, --n) {
        }
        while (n2 >= 0) {
            string = string + "../";
            --n2;
        }
        while (n >= 1) {
            string = string + list2.get(n) + "/";
            --n;
        }
        string = string + list2.get(n);
        return string;
    }

    public static IPath getInlinedLstFile(IPath iPath) throws FileNotFoundException {
        IPath iPath2 = iPath;
        if (iPath != null) {
            if (!iPath.toFile().exists()) {
                throw new FileNotFoundException(iPath.toOSString() + " not found!");
            }
            if (Util.lstFileContainsLinks(iPath)) {
                File file = new File(Util.getInlinedFileName(iPath.toOSString()));
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                    Util.writeInlinedLstFileToBuffer(iPath.toFile(), bufferedWriter);
                    bufferedWriter.close();
                    iPath2 = new Path(file.getAbsolutePath());
                }
                catch (IOException iOException) {
                    AspectJPlugin.logException(iOException);
                }
            }
        }
        return iPath2;
    }

    public static String getInlinedFileName(String string) {
        String string2 = string;
        if (string != null) {
            String string3 = string.substring(0, string.lastIndexOf(46));
            String string4 = string.substring(string.lastIndexOf(46));
            string2 = string3 + ".inlined" + string4;
        }
        return string2;
    }

    private static void writeInlinedLstFileToBuffer(File file, BufferedWriter bufferedWriter) throws FileNotFoundException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                if (!(string = string.trim()).startsWith("@")) {
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                    continue;
                }
                String string2 = string.substring(1);
                File file2 = new File(string2);
                if (file2.isAbsolute()) {
                    if (!file2.exists()) continue;
                    Util.writeInlinedLstFileToBuffer(file2, bufferedWriter);
                    continue;
                }
                file2 = new File(file.getParentFile().getAbsolutePath() + "/" + string2);
                if (!file2.exists()) continue;
                Util.writeInlinedLstFileToBuffer(file2, bufferedWriter);
            }
        }
        catch (IOException iOException) {
            AspectJPlugin.logException(iOException);
        }
    }

    private static boolean lstFileContainsLinks(IPath iPath) throws FileNotFoundException {
        boolean bl = false;
        String string = iPath.toOSString();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = null;
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!(string2 = string2.trim()).startsWith("@")) continue;
                bl = true;
                break;
            }
        }
        catch (IOException iOException) {
            AspectJPlugin.logException(iOException);
        }
        return bl;
    }

    public static void getLstFileContents(IPath iPath, List list, List list2, List list3) throws FileNotFoundException {
        if (iPath != null && list != null && list2 != null && list3 != null) {
            String string = iPath.toOSString();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = null;
            try {
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).startsWith("@")) {
                        list3.add(string2);
                        continue;
                    }
                    if (string2.startsWith("-")) {
                        if (AjcOptionsChecker.optionWithArg(string2)) {
                            String string3 = bufferedReader.readLine();
                            if (string3 != null) {
                                list2.add(string2 + OS_INDEPENDENT_LINE_SEPARATOR + string3.trim());
                                continue;
                            }
                            list2.add(string2);
                            continue;
                        }
                        list2.add(string2);
                        continue;
                    }
                    if (string2.equals("")) continue;
                    list.add(string2);
                }
            }
            catch (IOException iOException) {
                AspectJPlugin.logException(iOException);
            }
        }
    }

    static class AjcOptionsChecker {
        private static Set optionsWithArgs;

        AjcOptionsChecker() {
        }

        public static boolean optionWithArg(String string) {
            boolean bl = false;
            if (optionsWithArgs.contains(string)) {
                bl = true;
            }
            return bl;
        }

        private static void initialiseOptionsWithArgs() {
            optionsWithArgs = new HashSet();
            optionsWithArgs.add("-inpath");
            optionsWithArgs.add("-injars");
            optionsWithArgs.add("-aspectpath");
            optionsWithArgs.add("-outjar");
            optionsWithArgs.add("-argfile");
            optionsWithArgs.add("-sourceroots");
            optionsWithArgs.add("-Xlintfile");
            optionsWithArgs.add("-cp");
            optionsWithArgs.add("-classpath");
            optionsWithArgs.add("-bootclasspath");
            optionsWithArgs.add("-d");
            optionsWithArgs.add("-encoding");
            optionsWithArgs.add("-source");
            optionsWithArgs.add("-target");
            optionsWithArgs.add("-log");
            optionsWithArgs.add("-repeat");
            optionsWithArgs.add("-inpath");
        }

        static {
            AjcOptionsChecker.initialiseOptionsWithArgs();
        }
    }
}

