/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.ajdt.buildconfigurator.editor.BuildUtil;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuild;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuildEntry;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuildModel;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class BuildContentsSection
extends TableSection
implements IModelChangedListener,
IResourceChangeListener,
IResourceDeltaVisitor {
    protected CheckboxTreeViewer fTreeViewer;
    private boolean fDoRefresh = false;
    protected IProject fProject;
    protected IBuildModel fBuildModel;
    protected IResource fOriginalResource;
    protected IResource fParentResource;
    protected boolean isChecked;

    protected void createViewerPartControl(Composite composite, int n, int n2, FormToolkit formToolkit) {
        MenuManager menuManager = new MenuManager();
        IMenuListener iMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                BuildContentsSection.this.fillContextMenu(iMenuManager);
            }
        };
        menuManager.addMenuListener(iMenuListener);
        menuManager.setRemoveAllWhenShown(true);
        Control control = this.fTreeViewer.getControl();
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add(this.getPage().getPDEEditor().getContributor().getRevertAction());
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(iMenuManager, false);
    }

    private IBuildModel getBuildModel() {
        InputContext inputContext = this.getPage().getPDEEditor().getContextManager().findContext("build-context");
        return (IBuildModel)inputContext.getModel();
    }

    public BuildContentsSection(PDEFormPage pDEFormPage, Composite composite) {
        super(pDEFormPage, composite, 128, new String[0]);
        PDEPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void createClient(final Section section, FormToolkit formToolkit) {
        Composite composite = this.createClientContainer((Composite)section, 2, formToolkit);
        this.fBuildModel = this.getBuildModel();
        if (this.fBuildModel.getUnderlyingResource() != null) {
            this.fProject = this.fBuildModel.getUnderlyingResource().getProject();
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        composite.setLayout((Layout)gridLayout);
        this.fTreeViewer = new CheckboxTreeViewer(formToolkit.createTree(composite, 32));
        this.fTreeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.fTreeViewer.setAutoExpandLevel(0);
        this.fTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                Object object = checkStateChangedEvent.getElement();
                BusyIndicator.showWhile((Display)section.getDisplay(), (Runnable)new Runnable(this, object, checkStateChangedEvent){
                    private final /* synthetic */ Object val$element;
                    private final /* synthetic */ CheckStateChangedEvent val$event;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$element = object;
                        this.val$event = checkStateChangedEvent;
                    }

                    public void run() {
                        if (this.val$element instanceof IFile) {
                            IFile iFile = (IFile)this.val$event.getElement();
                            2.access$000(this.this$1).handleCheckStateChanged((IResource)iFile, this.val$event.getChecked());
                        } else if (this.val$element instanceof IFolder) {
                            IFolder iFolder = (IFolder)this.val$event.getElement();
                            2.access$000(this.this$1).handleCheckStateChanged((IResource)iFolder, this.val$event.getChecked());
                        }
                    }
                });
            }

            static /* synthetic */ BuildContentsSection access$000(2 var0) {
                return var0.BuildContentsSection.this;
            }
        });
        GridData gridData = new GridData(1808);
        gridData.heightHint = 100;
        gridData.widthHint = 100;
        this.fTreeViewer.getTree().setLayoutData((Object)gridData);
        this.initialize();
        this.initializeCheckState();
        formToolkit.paintBordersFor(composite);
        this.createViewerPartControl(composite, 65536, 2, formToolkit);
        section.setClient((Control)composite);
    }

    public void enableSection(boolean bl) {
        this.fTreeViewer.getTree().setEnabled(bl);
    }

    protected void handleCheckStateChanged(IResource iResource, boolean bl) {
        this.fOriginalResource = iResource;
        this.isChecked = bl;
        boolean bl2 = this.isIncluded((IResource)this.fOriginalResource.getParent());
        if (!this.isChecked) {
            iResource = this.handleAllUnselected(iResource, iResource.getName());
        }
        this.fParentResource = iResource;
        this.handleBuildCheckStateChange(bl2);
    }

    protected IResource handleAllUnselected(IResource iResource, String string) {
        IContainer iContainer = iResource.getParent();
        if (iContainer == iResource.getProject()) {
            return iResource;
        }
        try {
            boolean bl = true;
            IResource[] iResourceArray = ((IFolder)iContainer).members();
            for (int i = 0; i < iResourceArray.length; ++i) {
                if (!this.isIncluded(iResourceArray[i]) || iResourceArray[i].getName().equals(string)) continue;
                bl = false;
            }
            if (bl) {
                return this.handleAllUnselected((IResource)iContainer, iContainer.getName());
            }
            return iResource;
        }
        catch (CoreException coreException) {
            AspectJPlugin.logException(coreException);
            return null;
        }
    }

    protected void setChildrenGrayed(IResource iResource, boolean bl) {
        this.fTreeViewer.setGrayed((Object)iResource, bl);
        if (((TreeContentProvider)this.fTreeViewer.getContentProvider()).hasChildren(iResource)) {
            Object[] objectArray = ((TreeContentProvider)this.fTreeViewer.getContentProvider()).getFolderChildren(iResource);
            for (int i = 0; i < objectArray.length; ++i) {
                this.setChildrenGrayed((IResource)((IFolder)objectArray[i]), bl);
            }
        }
    }

    protected void setParentsChecked(IResource iResource) {
        if (iResource.getParent() != iResource.getProject()) {
            this.fTreeViewer.setChecked((Object)iResource.getParent(), true);
            this.setParentsChecked((IResource)iResource.getParent());
        }
    }

    protected abstract void deleteFolderChildrenFromEntries(IFolder var1);

    protected void initializeCheckState() {
        this.uncheckAll();
    }

    protected void initializeCheckState(final IBuildEntry iBuildEntry, final IBuildEntry iBuildEntry2) {
        this.fTreeViewer.getTree().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IFolder iFolder;
                boolean bl;
                IResource[] iResourceArray;
                int n;
                if (BuildContentsSection.this.fTreeViewer.getTree().isDisposed()) {
                    return;
                }
                Vector<String> vector = new Vector<String>();
                String[] stringArray = new String[]{};
                if (BuildContentsSection.this.fProject == null || iBuildEntry == null) {
                    return;
                }
                String[] stringArray2 = iBuildEntry.getTokens();
                if (iBuildEntry2 != null) {
                    stringArray = iBuildEntry2.getTokens();
                }
                TreeSet<String> treeSet = new TreeSet<String>();
                for (n = 0; n < stringArray2.length; ++n) {
                    treeSet.add(stringArray2[n]);
                }
                for (n = 0; n < stringArray.length; ++n) {
                    treeSet.add(stringArray[n]);
                }
                Iterator iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    iResourceArray = iterator.next().toString();
                    bl = iBuildEntry.contains((String)iResourceArray);
                    if (iResourceArray.lastIndexOf(47) == iResourceArray.length() - 1) {
                        if (iResourceArray.length() == 1) {
                            try {
                                iFolder = BuildContentsSection.this.fProject.members();
                                for (int i = 0; i < ((IFolder)iFolder).length; ++i) {
                                    BuildContentsSection.this.fTreeViewer.setSubtreeChecked((Object)iFolder[i], bl);
                                }
                                continue;
                            }
                            catch (CoreException coreException) {
                                AspectJPlugin.logException(coreException);
                                continue;
                            }
                        }
                        iFolder = BuildContentsSection.this.fProject.getFolder((String)iResourceArray);
                        BuildContentsSection.this.fTreeViewer.setSubtreeChecked((Object)iFolder, bl);
                        BuildContentsSection.this.fTreeViewer.setParentsGrayed((Object)iFolder, true);
                        if (!bl || !iFolder.exists()) continue;
                        BuildContentsSection.this.setParentsChecked((IResource)iFolder);
                        BuildContentsSection.this.fTreeViewer.setGrayed((Object)iFolder, false);
                        continue;
                    }
                    if (iResourceArray.startsWith("*.")) {
                        if (!bl) continue;
                        vector.add(iResourceArray.substring(2));
                        continue;
                    }
                    iFolder = BuildContentsSection.this.fProject.getFile((String)iResourceArray);
                    BuildContentsSection.this.fTreeViewer.setChecked((Object)iFolder, bl);
                    BuildContentsSection.this.fTreeViewer.setParentsGrayed((Object)iFolder, true);
                    if (!bl || !iFolder.exists()) continue;
                    BuildContentsSection.this.fTreeViewer.setGrayed((Object)iFolder, false);
                    BuildContentsSection.this.setParentsChecked((IResource)iFolder);
                }
                try {
                    iResourceArray = BuildContentsSection.this.fProject.members();
                    for (bl = false; bl < iResourceArray.length; bl += 1) {
                        BuildContentsSection.this.fTreeViewer.setExpandedState((Object)iResourceArray[bl], true);
                    }
                    Object[] objectArray = BuildContentsSection.this.fTreeViewer.getVisibleExpandedElements();
                    iFolder = BuildContentsSection.this.fTreeViewer.getContentProvider();
                    if (iFolder instanceof ITreeContentProvider && objectArray.length > 0) {
                        ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)iFolder;
                        Object object = objectArray[0];
                        while (iTreeContentProvider.hasChildren(object)) {
                            object = iTreeContentProvider.getChildren(object)[0];
                            BuildContentsSection.this.fTreeViewer.setExpandedState(object, true);
                        }
                    }
                }
                catch (CoreException coreException) {
                    AspectJPlugin.logException(coreException);
                }
                if (vector.size() == 0) {
                    return;
                }
                try {
                    iResourceArray = BuildContentsSection.this.fProject.members();
                    for (int i = 0; i < iResourceArray.length; ++i) {
                        if (iResourceArray[i] instanceof IFolder || !vector.contains(iResourceArray[i].getFileExtension())) continue;
                        BuildContentsSection.this.fTreeViewer.setChecked((Object)iResourceArray[i], iBuildEntry.contains("*." + iResourceArray[i].getFileExtension()));
                    }
                }
                catch (CoreException coreException) {
                    AspectJPlugin.logException(coreException);
                }
            }
        });
    }

    protected abstract void handleBuildCheckStateChange(boolean var1);

    protected void handleCheck(IBuildEntry iBuildEntry, IBuildEntry iBuildEntry2, String string, IResource iResource, boolean bl, String string2) {
        try {
            if (iBuildEntry == null) {
                iBuildEntry = this.fBuildModel.getFactory().createEntry(string2);
                IBuild iBuild = this.fBuildModel.getBuild();
                iBuild.add(iBuildEntry);
            }
            if (!bl && !iBuildEntry.contains(string) || this.isValidIncludeEntry(iBuildEntry, iBuildEntry2, iResource, string)) {
                iBuildEntry.addToken(string);
            }
            if (iBuildEntry2 != null && iBuildEntry2.contains(string)) {
                iBuildEntry2.removeToken(string);
            }
        }
        catch (CoreException coreException) {
            AspectJPlugin.logException(coreException);
        }
    }

    protected boolean isValidIncludeEntry(IBuildEntry iBuildEntry, IBuildEntry iBuildEntry2, IResource iResource, String string) {
        if (iBuildEntry2 == null) {
            return true;
        }
        IPath iPath = iResource.getProjectRelativePath();
        while (iPath.segmentCount() > 1) {
            if (iBuildEntry.contains((iPath = iPath.removeLastSegments(1)).toString() + '/')) {
                return false;
            }
            if (iBuildEntry2 == null || !iBuildEntry2.contains(iPath.toString() + '/')) continue;
            return true;
        }
        return !iBuildEntry2.contains(string);
    }

    private boolean isIncluded(IResource iResource) {
        if (iResource.getType() == 4) {
            IJavaProject iJavaProject = JavaCore.create((IProject)((IProject)iResource));
            return iJavaProject.isOnClasspath(iResource);
        }
        if (this.fTreeViewer != null) {
            return this.fTreeViewer.getChecked((Object)iResource);
        }
        return false;
    }

    protected void handleUncheck(IBuildEntry iBuildEntry, IBuildEntry iBuildEntry2, String string, IResource iResource, String string2) {
        try {
            IResource[] iResourceArray;
            if (this.isIncluded((IResource)iResource.getParent())) {
                if (iBuildEntry2 == null) {
                    iBuildEntry2 = this.fBuildModel.getFactory().createEntry(string2);
                    iResourceArray = this.fBuildModel.getBuild();
                    iResourceArray.add(iBuildEntry2);
                }
                if (!(iBuildEntry2.contains(string) || iBuildEntry != null && iBuildEntry.contains(string))) {
                    iBuildEntry2.addToken(string);
                }
            }
            if (iBuildEntry != null) {
                if (iBuildEntry.contains(string)) {
                    iBuildEntry.removeToken(string);
                }
                if (iBuildEntry.contains("*." + iResource.getFileExtension())) {
                    iResourceArray = this.fProject.members();
                    for (int i = 0; i < iResourceArray.length; ++i) {
                        if (!(iResourceArray[i] instanceof IFolder) && !iResourceArray[i].getName().equals(iResource.getName()) && iResource.getFileExtension().equals(iResourceArray[i].getFileExtension())) {
                            iBuildEntry.addToken(iResourceArray[i].getName());
                        }
                        IBuildEntry[] iBuildEntryArray = BuildUtil.getBuildLibraries(this.fBuildModel.getBuild().getBuildEntries());
                        if (!iResource.getFileExtension().equals("jar") || iBuildEntryArray.length == 0) continue;
                        for (int j = 0; j < iBuildEntryArray.length; ++j) {
                            String string3 = iBuildEntryArray[j].getName().substring(7);
                            IPath iPath = this.fProject.getFile(string3).getProjectRelativePath();
                            if (iPath.segmentCount() != 1 || iBuildEntry.contains(string3) || string3.equals(iResource.getName())) continue;
                            iBuildEntry.addToken(string3);
                        }
                    }
                    iBuildEntry.removeToken("*." + iResource.getFileExtension());
                }
            }
        }
        catch (CoreException coreException) {
            AspectJPlugin.logException(coreException);
        }
    }

    protected String getResourceFolderName(String string) {
        return string + '/';
    }

    protected String handleResourceFolder(IResource iResource, String string) {
        if (iResource instanceof IFolder) {
            this.deleteFolderChildrenFromEntries((IFolder)iResource);
            return this.getResourceFolderName(string);
        }
        return string;
    }

    public void initialize() {
        if (this.fTreeViewer.getInput() == null) {
            this.fTreeViewer.setUseHashlookup(true);
            this.fTreeViewer.setInput((Object)this.fProject);
        }
        this.fBuildModel.addModelChangedListener(this);
    }

    public void dispose() {
        this.fBuildModel.removeModelChangedListener(this);
        PDEPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    protected void deleteEmptyEntries() {
        IBuild iBuild = this.fBuildModel.getBuild();
        IBuildEntry[] iBuildEntryArray = new IBuildEntry[]{iBuild.getEntry("bin.excludes"), iBuild.getEntry("bin.includes"), iBuild.getEntry("src.excludes"), iBuild.getEntry("src.includes")};
        try {
            for (int i = 0; i < iBuildEntryArray.length; ++i) {
                if (iBuildEntryArray[i] == null || iBuildEntryArray[i].getTokens().length != 0) continue;
                iBuild.remove(iBuildEntryArray[i]);
            }
        }
        catch (CoreException coreException) {
            AspectJPlugin.logException(coreException);
        }
    }

    public CheckboxTreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    protected ISelection getViewerSelection() {
        return this.getTreeViewer().getSelection();
    }

    public void refresh() {
        this.initializeCheckState();
        super.refresh();
    }

    public void uncheckAll() {
        this.fTreeViewer.setCheckedElements(new Object[0]);
    }

    protected void removeChildren(IBuildEntry iBuildEntry, String string) {
        try {
            if (iBuildEntry != null) {
                String[] stringArray = iBuildEntry.getTokens();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].indexOf(47) == -1 || !stringArray[i].startsWith(string) || stringArray[i].equals(string)) continue;
                    iBuildEntry.removeToken(stringArray[i]);
                }
            }
        }
        catch (CoreException coreException) {
            AspectJPlugin.logException(coreException);
        }
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (this.fTreeViewer.getControl().isDisposed()) {
            return;
        }
        this.fDoRefresh = false;
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        try {
            if (iResourceDelta != null) {
                iResourceDelta.accept((IResourceDeltaVisitor)this);
            }
            if (this.fDoRefresh) {
                this.asyncRefresh();
                this.fDoRefresh = false;
            }
        }
        catch (CoreException coreException) {
            AspectJPlugin.logException(coreException);
        }
    }

    public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
        IResource iResource = iResourceDelta.getResource();
        if ((iResource instanceof IFile || iResource instanceof IFolder) && iResource.getProject().equals(this.fBuildModel.getUnderlyingResource().getProject()) && (iResourceDelta.getKind() == 1 || iResourceDelta.getKind() == 2)) {
            this.fDoRefresh = true;
            return false;
        }
        return true;
    }

    private void asyncRefresh() {
        Control control = this.fTreeViewer.getControl();
        if (!control.isDisposed()) {
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!BuildContentsSection.this.fTreeViewer.getControl().isDisposed()) {
                        BuildContentsSection.this.fTreeViewer.refresh(true);
                        BuildContentsSection.this.initializeCheckState();
                    }
                }
            });
        }
    }

    protected void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.getPage().getPDEEditor().setSelection((ISelection)iStructuredSelection);
    }

    public void modelChanged(IModelChangedEvent iModelChangedEvent) {
        Object object;
        if (iModelChangedEvent.getChangeType() == 99) {
            this.markStale();
        }
        if (!((object = iModelChangedEvent.getChangedObjects()[0]) instanceof IBuildEntry && (((IBuildEntry)object).getName().equals("bin.excludes") || ((IBuildEntry)object).getName().equals("bin.includes") || ((IBuildEntry)object).getName().equals("src.excludes") || ((IBuildEntry)object).getName().equals("src.includes")))) {
            return;
        }
        if (this.fParentResource == null && this.fOriginalResource != null || this.fOriginalResource == null && this.fParentResource != null) {
            this.initializeCheckState();
            return;
        }
        if (this.fParentResource == null && this.fOriginalResource == null || iModelChangedEvent.getChangedProperty() != null && iModelChangedEvent.getChangedProperty().equals("bin.includes")) {
            return;
        }
        this.fTreeViewer.setChecked((Object)this.fParentResource, this.isChecked);
        this.fTreeViewer.setGrayed((Object)this.fOriginalResource, false);
        this.fTreeViewer.setParentsGrayed((Object)this.fParentResource, true);
        this.setParentsChecked(this.fParentResource);
        this.fTreeViewer.setGrayed((Object)this.fParentResource, false);
        if (this.fParentResource instanceof IFolder) {
            this.fTreeViewer.setSubtreeChecked((Object)this.fParentResource, this.isChecked);
            this.setChildrenGrayed(this.fParentResource, false);
        }
        while (!this.fOriginalResource.equals(this.fParentResource)) {
            this.fTreeViewer.setChecked((Object)this.fOriginalResource, this.isChecked);
            this.fOriginalResource = this.fOriginalResource.getParent();
        }
        this.fParentResource = null;
        this.fOriginalResource = null;
    }

    public class TreeContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        public Object[] getFilteredChildren(IContainer iContainer) {
            try {
                IResource[] iResourceArray = iContainer.members();
                ArrayList<IResource> arrayList = new ArrayList<IResource>();
                for (int i = 0; i < iResourceArray.length; ++i) {
                    if (iResourceArray[i] instanceof IFolder) {
                        IJavaProject iJavaProject = JavaCore.create((IProject)iResourceArray[i].getProject());
                        if (iJavaProject == null) continue;
                        this.addElementsOnClasspath(arrayList, iJavaProject, iResourceArray[i]);
                        continue;
                    }
                    if (!ProjectProperties.ASPECTJ_SOURCE_FILTER.accept(iResourceArray[i].getName())) continue;
                    arrayList.add(iResourceArray[i]);
                }
                return arrayList.toArray();
            }
            catch (CoreException coreException) {
                AspectJPlugin.logException(coreException);
                return new Object[0];
            }
        }

        private void addElementsOnClasspath(List list, IJavaProject iJavaProject, IResource iResource) {
            if (iJavaProject.isOnClasspath(iResource)) {
                list.add(iResource);
                return;
            }
            if (iResource.getType() == 2) {
                try {
                    IResource[] iResourceArray = ((IFolder)iResource).members();
                    for (int i = 0; i < iResourceArray.length; ++i) {
                        if (iResourceArray[i].getType() != 2) continue;
                        this.addElementsOnClasspath(list, iJavaProject, iResourceArray[i]);
                    }
                }
                catch (CoreException coreException) {
                    AspectJPlugin.logException(coreException);
                }
            }
        }

        public Object[] getElements(Object object) {
            if (object instanceof IContainer) {
                return this.getFilteredChildren((IContainer)object);
            }
            return new Object[0];
        }

        public Object[] getChildren(Object object) {
            if (object instanceof IContainer) {
                return this.getFilteredChildren((IContainer)object);
            }
            return new Object[0];
        }

        public Object[] getFolderChildren(Object object) {
            IResource[] iResourceArray = null;
            try {
                if (!(object instanceof IFolder)) {
                    return new Object[0];
                }
                iResourceArray = ((IFolder)object).members();
                ArrayList<IResource> arrayList = new ArrayList<IResource>();
                for (int i = 0; i < iResourceArray.length; ++i) {
                    if (iResourceArray[i].getType() != 2) continue;
                    arrayList.add(iResourceArray[i]);
                }
                return arrayList.toArray();
            }
            catch (CoreException coreException) {
                AspectJPlugin.logException(coreException);
                return new Object[0];
            }
        }

        public Object getParent(Object object) {
            if (object != null && object instanceof IResource) {
                return ((IResource)object).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            if (object instanceof IContainer) {
                return this.getChildren(object).length > 0;
            }
            return false;
        }
    }
}

