/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.ajdt.buildconfigurator.editor.model.BuildModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.model.AbstractEditingModel;
import org.eclipse.pde.internal.ui.model.IDocumentKey;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class BuildInputContext
extends InputContext {
    public static final String CONTEXT_ID = "build-context";
    private HashMap fOperationTable = new HashMap();
    static /* synthetic */ Class class$java$io$File;

    public BuildInputContext(PDEFormEditor pDEFormEditor, IEditorInput iEditorInput, boolean bl) {
        super(pDEFormEditor, iEditorInput, bl);
        this.create();
    }

    protected String getDefaultCharset() {
        return "ISO-8859-1";
    }

    protected IBaseModel createModel(IEditorInput iEditorInput) throws CoreException {
        BuildModel buildModel = null;
        if (iEditorInput instanceof IStorageEditorInput) {
            boolean bl = iEditorInput instanceof IFileEditorInput;
            IDocument iDocument = this.getDocumentProvider().getDocument((Object)iEditorInput);
            buildModel = new BuildModel(iDocument, bl);
            if (iEditorInput instanceof IFileEditorInput) {
                IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
                buildModel.setUnderlyingResource((IResource)iFile);
                buildModel.setCharset(iFile.getCharset());
            } else if (iEditorInput instanceof SystemFileEditorInput) {
                File file = (File)((SystemFileEditorInput)iEditorInput).getAdapter(class$java$io$File == null ? (class$java$io$File = BuildInputContext.class$("java.io.File")) : class$java$io$File);
                buildModel.setInstallLocation(file.getParent());
                buildModel.setCharset(this.getDefaultCharset());
            }
            buildModel.load();
        }
        return buildModel;
    }

    public String getId() {
        return CONTEXT_ID;
    }

    protected void addTextEditOperation(ArrayList arrayList, IModelChangedEvent iModelChangedEvent) {
        Object[] objectArray = iModelChangedEvent.getChangedObjects();
        if (objectArray != null) {
            block5: for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                IDocumentKey iDocumentKey = (IDocumentKey)object;
                TextEdit textEdit = (TextEdit)this.fOperationTable.get(iDocumentKey);
                if (textEdit != null) {
                    this.fOperationTable.remove(iDocumentKey);
                    arrayList.remove(textEdit);
                }
                switch (iModelChangedEvent.getChangeType()) {
                    case 2: {
                        this.deleteKey(iDocumentKey, arrayList);
                        continue block5;
                    }
                    case 1: {
                        this.insertKey(iDocumentKey, arrayList);
                        continue block5;
                    }
                    case 3: {
                        this.modifyKey(iDocumentKey, arrayList);
                    }
                }
            }
        }
    }

    private void insertKey(IDocumentKey iDocumentKey, ArrayList arrayList) {
        IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getInput());
        InsertEdit insertEdit = new InsertEdit(iDocument.getLength(), iDocumentKey.write());
        this.fOperationTable.put(iDocumentKey, insertEdit);
        arrayList.add(insertEdit);
    }

    private void deleteKey(IDocumentKey iDocumentKey, ArrayList arrayList) {
        if (iDocumentKey.getOffset() >= 0) {
            DeleteEdit deleteEdit = new DeleteEdit(iDocumentKey.getOffset(), iDocumentKey.getLength());
            this.fOperationTable.put(iDocumentKey, deleteEdit);
            arrayList.add(deleteEdit);
        }
    }

    private void modifyKey(IDocumentKey iDocumentKey, ArrayList arrayList) {
        if (iDocumentKey.getOffset() == -1) {
            this.insertKey(iDocumentKey, arrayList);
        } else {
            ReplaceEdit replaceEdit = new ReplaceEdit(iDocumentKey.getOffset(), iDocumentKey.getLength(), iDocumentKey.write());
            this.fOperationTable.put(iDocumentKey, replaceEdit);
            arrayList.add(replaceEdit);
        }
    }

    public void doRevert() {
        this.fEditOperations.clear();
        this.fOperationTable.clear();
        AbstractEditingModel abstractEditingModel = (AbstractEditingModel)this.getModel();
        abstractEditingModel.reconciled(abstractEditingModel.getDocument());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

