/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.editor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.ajdt.buildconfigurator.editor.BuildEditor;
import org.eclipse.ajdt.buildconfigurator.editor.model.Build;
import org.eclipse.ajdt.buildconfigurator.editor.model.BuildEntry;
import org.eclipse.ajdt.buildconfigurator.editor.model.BuildModel;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuild;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuildEntry;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuildModel;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.IBaseModel;

public class BuildProperties {
    private IFile myPropertiesFile;
    private IBuild build;
    private IBuildModel buildModel;

    public BuildProperties(IFile iFile) {
        this.myPropertiesFile = iFile;
    }

    public BuildProperties(IFile iFile, List list) {
        this.myPropertiesFile = iFile;
        this.initBuild();
        IBuildEntry iBuildEntry = this.buildModel.getFactory().createEntry("src.includes");
        this.build.addWithoutNotify(iBuildEntry);
        IBuildEntry iBuildEntry2 = this.build.getEntry("src.excludes");
        if (iBuildEntry2 != null) {
            ((Build)this.build).removeWithoutNotify(iBuildEntry2);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string;
            Object e = iterator.next();
            if (e instanceof IResource) {
                string = this.getNameFromResource((IResource)e);
            } else {
                IPath iPath = ((IPath)e).addTrailingSeparator();
                string = iPath.toString();
            }
            this.addTokenToBuildEntry((BuildEntry)iBuildEntry, string);
        }
        this.writeFile();
    }

    public List getFiles(boolean bl) {
        if (bl) {
            this.build = null;
        }
        this.initBuild();
        IBuildEntry iBuildEntry = this.build.getEntry("src.includes");
        IBuildEntry iBuildEntry2 = this.build.getEntry("src.excludes");
        IProject iProject = this.myPropertiesFile.getProject();
        List list = this.determineIncludedFiles(iBuildEntry, iBuildEntry2, iProject);
        return list;
    }

    public void include(IResource iResource) {
        String string = iResource.getType() == 2 ? iResource.getProjectRelativePath().addTrailingSeparator().toString() : iResource.getProjectRelativePath().toString();
        string = this.handleResourceFolder(iResource, string);
        this.initBuild();
        IBuildEntry iBuildEntry = this.build.getEntry("src.includes");
        IBuildEntry iBuildEntry2 = this.build.getEntry("src.excludes");
        this.handleCheck(iBuildEntry, iBuildEntry2, string, iResource);
        if (iBuildEntry != null) {
            this.build.addWithoutNotify(iBuildEntry);
        }
        if (iBuildEntry2 != null) {
            this.build.addWithoutNotify(iBuildEntry2);
        }
        this.deleteEmptyEntries();
    }

    public void exclude(IResource iResource) throws CoreException {
        String string = iResource.getType() == 2 ? iResource.getProjectRelativePath().addTrailingSeparator().toString() : iResource.getProjectRelativePath().toString();
        string = this.handleResourceFolder(iResource, string);
        this.initBuild();
        IBuildEntry iBuildEntry = this.build.getEntry("src.includes");
        IBuildEntry iBuildEntry2 = this.build.getEntry("src.excludes");
        this.handleUncheck(iBuildEntry, iBuildEntry2, string, iResource);
        if (iBuildEntry != null) {
            this.build.addWithoutNotify(iBuildEntry);
        }
        if (iBuildEntry2 != null) {
            this.build.addWithoutNotify(iBuildEntry2);
        }
        this.deleteEmptyEntries();
    }

    private void initBuild() {
        if (this.build == null) {
            BuildEditor buildEditor = new BuildEditor();
            AJDTEventTrace.buildConfigRead(this.myPropertiesFile);
            buildEditor.monitoredFileAdded(this.myPropertiesFile);
            IBaseModel iBaseModel = buildEditor.getContextManager().findContext((IResource)this.myPropertiesFile).getModel();
            if (iBaseModel instanceof BuildModel) {
                this.buildModel = (BuildModel)iBaseModel;
                this.build = this.buildModel.getBuild();
            }
        }
    }

    private List allFiles(IContainer iContainer) {
        final ArrayList arrayList = new ArrayList();
        try {
            iContainer.accept(new IResourceVisitor(){

                public boolean visit(IResource iResource) {
                    if (iResource.getType() == 1 && ProjectProperties.ASPECTJ_SOURCE_FILTER.accept(iResource.getName())) {
                        arrayList.add(iResource);
                    }
                    return true;
                }
            });
        }
        catch (CoreException coreException) {
            AspectJPlugin.logException(coreException);
        }
        return arrayList;
    }

    private List determineIncludedFiles(IBuildEntry iBuildEntry, IBuildEntry iBuildEntry2, IProject iProject) {
        int n;
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        Vector<String> vector = new Vector<String>();
        String[] stringArray = new String[]{};
        if (iProject == null || iBuildEntry == null) {
            return arrayList;
        }
        String[] stringArray2 = iBuildEntry.getTokens();
        if (iBuildEntry2 != null) {
            stringArray = iBuildEntry2.getTokens();
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (n = 0; n < stringArray2.length; ++n) {
            treeSet.add(stringArray2[n]);
        }
        for (n = 0; n < stringArray.length; ++n) {
            treeSet.add(stringArray[n]);
        }
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            Object object;
            String string = iterator.next().toString();
            boolean bl = iBuildEntry.contains(string);
            if (string.lastIndexOf(47) == string.length() - 1) {
                object = string.length() == 1 ? iProject : iProject.getFolder(string);
                if (bl) {
                    arrayList.addAll(this.allFiles((IContainer)object));
                    continue;
                }
                arrayList.removeAll(this.allFiles((IContainer)object));
                continue;
            }
            if (string.startsWith("*.")) {
                if (!bl) continue;
                vector.add(string.substring(2));
                continue;
            }
            object = iProject.getFile(string);
            if (bl && ProjectProperties.ASPECTJ_SOURCE_FILTER.accept(object.getName())) {
                arrayList.add((IProject)object);
                continue;
            }
            arrayList.remove(object);
        }
        if (vector.size() == 0) {
            return arrayList;
        }
        return arrayList;
    }

    public void writeFile() {
        block6: {
            AJDTEventTrace.buildConfigWrite(this.myPropertiesFile);
            IBuildEntry[] iBuildEntryArray = this.build.getBuildEntries();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < iBuildEntryArray.length; ++i) {
                if (!(iBuildEntryArray[i] instanceof BuildEntry)) continue;
                String string = ((BuildEntry)iBuildEntryArray[i]).write();
                stringBuffer.append(string);
            }
            if (!this.myPropertiesFile.getWorkspace().isTreeLocked()) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes());
                try {
                    if (!this.myPropertiesFile.exists()) {
                        this.myPropertiesFile.create((InputStream)byteArrayInputStream, false, null);
                        break block6;
                    }
                    this.myPropertiesFile.setContents((InputStream)byteArrayInputStream, false, true, null);
                }
                catch (CoreException coreException) {
                    AspectJPlugin.logException(coreException);
                }
            } else {
                System.out.println("tree is locked");
                AspectJPlugin.logException(new Exception("BuildProperties: resource tree locked"));
            }
        }
    }

    private void addTokenToBuildEntry(BuildEntry buildEntry, String string) {
        if (!buildEntry.contains(string)) {
            buildEntry.addTokenWithoutNotify(string);
        }
    }

    private boolean contains(Object[] objectArray, Object object) {
        if (objectArray == null) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!objectArray[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    private String getNameFromResource(IResource iResource) {
        IPath iPath = iResource.getProjectRelativePath();
        if (iResource.getType() == 2 || iResource.getType() == 4) {
            iPath = iPath.addTrailingSeparator();
        }
        return iPath.toString();
    }

    private boolean isIncluded(IResource iResource, IBuildEntry iBuildEntry, IBuildEntry iBuildEntry2) {
        if (iResource.getParent() == null) {
            return false;
        }
        String string = this.getNameFromResource(iResource);
        if (iBuildEntry != null && this.contains(iBuildEntry.getTokens(), string)) {
            return true;
        }
        if (iBuildEntry2 != null && this.contains(iBuildEntry2.getTokens(), string)) {
            return false;
        }
        return this.isIncluded((IResource)iResource.getParent(), iBuildEntry, iBuildEntry2);
    }

    protected String handleResourceFolder(IResource iResource, String string) {
        if (iResource instanceof IFolder) {
            this.deleteFolderChildrenFromEntries((IFolder)iResource);
            return this.getResourceFolderName(string);
        }
        return string;
    }

    protected void deleteFolderChildrenFromEntries(IFolder iFolder) {
        IBuild iBuild = this.buildModel.getBuild();
        IBuildEntry iBuildEntry = iBuild.getEntry("src.includes");
        IBuildEntry iBuildEntry2 = iBuild.getEntry("src.excludes");
        String string = this.getResourceFolderName(iFolder.getProjectRelativePath().toString());
        this.removeChildren(iBuildEntry, string);
        this.removeChildren(iBuildEntry2, string);
    }

    protected String getResourceFolderName(String string) {
        return string;
    }

    protected void removeChildren(IBuildEntry iBuildEntry, String string) {
        if (iBuildEntry != null) {
            String[] stringArray = iBuildEntry.getTokens();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].indexOf(47) == -1 || !stringArray[i].startsWith(string) || stringArray[i].equals(string)) continue;
                ((BuildEntry)iBuildEntry).removeTokenWithoutNotify(stringArray[i]);
            }
        }
    }

    protected void handleCheck(IBuildEntry iBuildEntry, IBuildEntry iBuildEntry2, String string, IResource iResource) {
        if (iBuildEntry == null) {
            iBuildEntry = this.buildModel.getFactory().createEntry("src.includes");
            IBuild iBuild = this.buildModel.getBuild();
            iBuild.addWithoutNotify(iBuildEntry);
        }
        if (iBuildEntry2 != null && iBuildEntry2.contains(string)) {
            iBuildEntry2.removeTokenWithoutNotify(string);
        }
        if (!this.isIncluded(iResource, iBuildEntry, iBuildEntry2)) {
            iBuildEntry.addTokenWithoutNotify(string);
        }
    }

    protected void handleUncheck(IBuildEntry iBuildEntry, IBuildEntry iBuildEntry2, String string, IResource iResource) throws CoreException {
        IResource[] iResourceArray;
        if (this.isIncluded((IResource)iResource.getParent(), iBuildEntry, iBuildEntry2)) {
            if (iBuildEntry2 == null) {
                iBuildEntry2 = this.buildModel.getFactory().createEntry("src.excludes");
                iResourceArray = this.buildModel.getBuild();
                iResourceArray.addWithoutNotify(iBuildEntry2);
            }
            if (!(iBuildEntry2.contains(string) || iBuildEntry != null && iBuildEntry.contains(string))) {
                iBuildEntry2.addTokenWithoutNotify(string);
            }
        }
        if (iBuildEntry != null) {
            if (iBuildEntry.contains(string)) {
                ((BuildEntry)iBuildEntry).removeTokenWithoutNotify(string);
            }
            if (iBuildEntry.contains("*." + iResource.getFileExtension())) {
                iResourceArray = this.myPropertiesFile.getProject().members();
                for (int i = 0; i < iResourceArray.length; ++i) {
                    if (iResourceArray[i] instanceof IFolder || iResourceArray[i].getName().equals(iResource.getName()) || !iResource.getFileExtension().equals(iResourceArray[i].getFileExtension())) continue;
                    iBuildEntry.addTokenWithoutNotify(iResourceArray[i].getName());
                }
                iBuildEntry.removeTokenWithoutNotify("*." + iResource.getFileExtension());
            }
        }
    }

    protected void deleteEmptyEntries() {
        IBuild iBuild = this.buildModel.getBuild();
        IBuildEntry[] iBuildEntryArray = new IBuildEntry[]{iBuild.getEntry("src.excludes"), iBuild.getEntry("src.includes")};
        for (int i = 0; i < iBuildEntryArray.length; ++i) {
            if (iBuildEntryArray[i] == null || iBuildEntryArray[i].getTokens().length != 0) continue;
            ((Build)iBuild).removeWithoutNotify(iBuildEntryArray[i]);
        }
    }

    public void updateSourceFolders(List list) {
        boolean bl = false;
        this.initBuild();
        IBuildEntry iBuildEntry = this.build.getEntry("src.includes");
        if (iBuildEntry != null) {
            bl |= this.removeOldSourceFolders(list, iBuildEntry);
        } else {
            iBuildEntry = this.buildModel.getFactory().createEntry("src.includes");
            this.build.addWithoutNotify(iBuildEntry);
        }
        IBuildEntry iBuildEntry2 = this.build.getEntry("src.excludes");
        if (iBuildEntry2 != null) {
            bl |= this.removeOldSourceFolders(list, iBuildEntry2);
        }
        if (bl |= this.addNewSourceFolders(list, iBuildEntry)) {
            this.writeFile();
        }
    }

    private boolean removeOldSourceFolders(List list, IBuildEntry iBuildEntry) {
        boolean bl = false;
        String[] stringArray = iBuildEntry.getTokens();
        for (int i = 0; i < stringArray.length; ++i) {
            Iterator iterator = list.iterator();
            boolean bl2 = true;
            while (iterator.hasNext()) {
                IPath iPath = (IPath)iterator.next();
                if (!iPath.isPrefixOf((IPath)new Path(stringArray[i]))) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            iBuildEntry.removeTokenWithoutNotify(stringArray[i]);
            bl = true;
        }
        return bl;
    }

    private boolean addNewSourceFolders(List list, IBuildEntry iBuildEntry) {
        boolean bl = false;
        String[] stringArray = iBuildEntry.getTokens();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            boolean bl2 = true;
            IPath iPath = (IPath)iterator.next();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!iPath.isPrefixOf((IPath)new Path(stringArray[i]))) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            iBuildEntry.addTokenWithoutNotify(iPath.addTrailingSeparator().toString());
            bl = true;
        }
        return bl;
    }
}

