/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.editor;

import org.eclipse.ajdt.buildconfigurator.editor.model.IBuild;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuildEntry;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuildModel;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.build.BuildObject;
import org.eclipse.pde.internal.core.build.IBuildObject;
import org.eclipse.pde.internal.ui.editor.ModelUndoManager;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;

public class BuildUndoManager
extends ModelUndoManager {
    public BuildUndoManager(PDEFormEditor pDEFormEditor) {
        super(pDEFormEditor);
        this.setUndoLevelLimit(30);
    }

    protected String getPageId(Object object) {
        if (object instanceof IBuildEntry) {
            return "build";
        }
        return null;
    }

    protected void execute(IModelChangedEvent iModelChangedEvent, boolean bl) {
        Object[] objectArray = iModelChangedEvent.getChangedObjects();
        int n = iModelChangedEvent.getChangeType();
        String string = iModelChangedEvent.getChangedProperty();
        IBuildModel iBuildModel = (IBuildModel)iModelChangedEvent.getChangeProvider();
        switch (n) {
            case 1: {
                if (bl) {
                    this.executeRemove(iBuildModel, objectArray);
                    break;
                }
                this.executeAdd(iBuildModel, objectArray);
                break;
            }
            case 2: {
                if (bl) {
                    this.executeAdd(iBuildModel, objectArray);
                    break;
                }
                this.executeRemove(iBuildModel, objectArray);
                break;
            }
            case 3: {
                if (bl) {
                    this.executeChange(objectArray[0], string, iModelChangedEvent.getNewValue(), iModelChangedEvent.getOldValue());
                    break;
                }
                this.executeChange(objectArray[0], string, iModelChangedEvent.getOldValue(), iModelChangedEvent.getNewValue());
            }
        }
    }

    private void executeAdd(IBuildModel iBuildModel, Object[] objectArray) {
        IBuild iBuild = iBuildModel.getBuild();
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof IBuildEntry)) continue;
                iBuild.add((IBuildEntry)object);
            }
        }
        catch (CoreException coreException) {
            AspectJPlugin.logException(coreException);
        }
    }

    private void executeRemove(IBuildModel iBuildModel, Object[] objectArray) {
        IBuild iBuild = iBuildModel.getBuild();
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof IBuildEntry)) continue;
                iBuild.remove((IBuildEntry)object);
            }
        }
        catch (CoreException coreException) {
            AspectJPlugin.logException(coreException);
        }
    }

    private void executeChange(Object object, String string, Object object2, Object object3) {
        if (object instanceof BuildObject) {
            BuildObject buildObject = (BuildObject)object;
            try {
                buildObject.restoreProperty(string, object2, object3);
            }
            catch (CoreException coreException) {
                AspectJPlugin.logException(coreException);
            }
        }
    }

    public void modelChanged(IModelChangedEvent iModelChangedEvent) {
        IBuildObject iBuildObject;
        Object object;
        if (iModelChangedEvent.getChangeType() == 3 && (object = iModelChangedEvent.getChangedObjects()[0]) instanceof IBuildObject && !((iBuildObject = (IBuildObject)iModelChangedEvent.getChangedObjects()[0]) instanceof IBuild) && !iBuildObject.isInTheModel()) {
            return;
        }
        super.modelChanged(iModelChangedEvent);
    }
}

