/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.editor;

import java.io.PrintWriter;
import java.util.Enumeration;

public class PropertiesUtil {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String createWritableName(String string) {
        if (string.indexOf(32) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                stringBuffer.append("\\ ");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String createEscapedValue(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' || c == '\t' || c == '\r' || c == '\n' || c == '\f') {
                stringBuffer.append('\\');
                stringBuffer.append(c);
                continue;
            }
            if (c < ' ' || c > '~') {
                stringBuffer.append('\\');
                stringBuffer.append('u');
                stringBuffer.append(HEX[c >> 12 & 0xF]);
                stringBuffer.append(HEX[c >> 8 & 0xF]);
                stringBuffer.append(HEX[c >> 4 & 0xF]);
                stringBuffer.append(HEX[c & 0xF]);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static void writeKeyValuePair(String string, String string2, String string3, PrintWriter printWriter) {
        String string4 = PropertiesUtil.createWritableName(string2);
        printWriter.print(string4 + " = ");
        printWriter.println(PropertiesUtil.createEscapedValue(string3));
    }

    public static void writeKeyValuePair(String string, String string2, Enumeration enumeration, PrintWriter printWriter) {
        String string3 = PropertiesUtil.createWritableName(string2);
        printWriter.print(string3 + " = ");
        if (!enumeration.hasMoreElements()) {
            printWriter.println();
            return;
        }
        int n = string2.length() + 3;
        while (enumeration.hasMoreElements()) {
            String string4 = enumeration.nextElement().toString();
            printWriter.print(PropertiesUtil.createEscapedValue(string4));
            if (enumeration.hasMoreElements()) {
                printWriter.println(",\\");
                for (int i = 0; i < n; ++i) {
                    printWriter.print(" ");
                }
                continue;
            }
            printWriter.println("");
        }
    }

    public static String writeKeyValuePair(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(PropertiesUtil.createWritableName(string));
        stringBuffer.append(" = ");
        int n = string.length() + 3;
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(PropertiesUtil.createEscapedValue(stringArray[i]));
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(",\\" + System.getProperty("line.separator"));
            for (int j = 0; j < n; ++j) {
                stringBuffer.append(" ");
            }
        }
        stringBuffer.append(System.getProperty("line.separator"));
        return stringBuffer.toString();
    }
}

