/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.editor;

import org.eclipse.ajdt.buildconfigurator.editor.BuildContentsSection;
import org.eclipse.ajdt.buildconfigurator.editor.BuildPage;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuild;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuildEntry;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.swt.widgets.Composite;

public class SrcSection
extends BuildContentsSection
implements IModelChangedListener {
    private static String SECTION_TITLE = "AJPropsEditor.SrcSection.title";
    private static String SECTION_DESC = "AJPropsEditor.SrcSection.desc";

    public SrcSection(BuildPage buildPage, Composite composite) {
        super(buildPage, composite);
        this.getSection().setText(AspectJPlugin.getResourceString(SECTION_TITLE));
        this.getSection().setDescription(AspectJPlugin.getResourceString(SECTION_DESC));
    }

    protected void initializeCheckState() {
        super.initializeCheckState();
        IBuild iBuild = this.fBuildModel.getBuild();
        IBuildEntry iBuildEntry = iBuild.getEntry("src.includes");
        IBuildEntry iBuildEntry2 = iBuild.getEntry("src.excludes");
        if (iBuildEntry == null) {
            return;
        }
        super.initializeCheckState(iBuildEntry, iBuildEntry2);
    }

    protected void deleteFolderChildrenFromEntries(IFolder iFolder) {
        IBuild iBuild = this.fBuildModel.getBuild();
        IBuildEntry iBuildEntry = iBuild.getEntry("src.includes");
        IBuildEntry iBuildEntry2 = iBuild.getEntry("src.excludes");
        String string = this.getResourceFolderName(iFolder.getProjectRelativePath().toString());
        this.removeChildren(iBuildEntry, string);
        this.removeChildren(iBuildEntry2, string);
    }

    protected void handleBuildCheckStateChange(boolean bl) {
        IResource iResource = this.fParentResource;
        String string = this.fParentResource.getFullPath().removeFirstSegments(1).toString();
        IBuild iBuild = this.fBuildModel.getBuild();
        IBuildEntry iBuildEntry = iBuild.getEntry("src.includes");
        IBuildEntry iBuildEntry2 = iBuild.getEntry("src.excludes");
        string = this.handleResourceFolder(iResource, string);
        if (this.isChecked) {
            this.handleCheck(iBuildEntry, iBuildEntry2, string, iResource, bl, "src.includes");
        } else {
            this.handleUncheck(iBuildEntry, iBuildEntry2, string, iResource, "src.excludes");
        }
        this.deleteEmptyEntries();
    }
}

