/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.editor.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.ajdt.buildconfigurator.editor.model.BuildEntry;
import org.eclipse.ajdt.buildconfigurator.editor.model.BuildModel;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuild;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuildEntry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.internal.ui.model.IDocumentKey;

public class Build
implements IBuild {
    private BuildModel fModel;
    private HashMap fEntries = new HashMap();

    public Build(BuildModel buildModel) {
        this.fModel = buildModel;
    }

    public void add(IBuildEntry iBuildEntry) throws CoreException {
        this.fEntries.put(iBuildEntry.getName(), iBuildEntry);
        this.fModel.fireModelChanged((IModelChangedEvent)new ModelChangedEvent((IModelChangeProvider)this.fModel, 1, new Object[]{iBuildEntry}, null));
    }

    public void addWithoutNotify(IBuildEntry iBuildEntry) {
        this.fEntries.put(iBuildEntry.getName(), iBuildEntry);
    }

    public IBuildEntry[] getBuildEntries() {
        return this.fEntries.values().toArray(new IBuildEntry[this.fEntries.size()]);
    }

    public IBuildEntry getEntry(String string) {
        return (IBuildEntry)this.fEntries.get(string);
    }

    public void remove(IBuildEntry iBuildEntry) throws CoreException {
        this.fEntries.remove(iBuildEntry.getName());
        this.fModel.fireModelChanged((IModelChangedEvent)new ModelChangedEvent((IModelChangeProvider)this.fModel, 2, new Object[]{iBuildEntry}, null));
    }

    public void removeWithoutNotify(IBuildEntry iBuildEntry) {
        this.fEntries.remove(iBuildEntry.getName());
    }

    public void write(String string, PrintWriter printWriter) {
    }

    public void load(InputStream inputStream) throws IOException {
        this.fEntries.clear();
        Properties properties = new Properties();
        properties.load(inputStream);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            BuildEntry buildEntry = (BuildEntry)this.fModel.getFactory().createEntry(string);
            buildEntry.processEntry(properties.get(string).toString());
            this.fEntries.put(string, buildEntry);
        }
        this.adjustOffsets(this.fModel.getDocument());
    }

    public void adjustOffsets(IDocument iDocument) {
        int n = iDocument.getNumberOfLines();
        try {
            IDocumentKey iDocumentKey = null;
            for (int i = 0; i < n; ++i) {
                String string;
                int n2;
                int n3 = iDocument.getLineOffset(i);
                String string2 = iDocument.get(n3, n2 = iDocument.getLineLength(i));
                if (string2.startsWith("#") | string2.startsWith("!")) {
                    if (iDocumentKey == null) continue;
                    iDocumentKey.setLength(n3 - 1 - iDocumentKey.getOffset());
                    iDocumentKey = null;
                    continue;
                }
                if ((string2 = string2.trim()).length() == 0) continue;
                if (iDocumentKey != null) {
                    if (string2.endsWith("\\")) continue;
                    iDocumentKey.setLength(n3 + iDocument.getLineLength(i) - iDocumentKey.getOffset());
                    iDocumentKey = null;
                    continue;
                }
                int n4 = string2.indexOf(61);
                if (n4 == -1) {
                    n4 = string2.indexOf(58);
                }
                if (n4 == -1) {
                    n4 = string2.indexOf(32);
                }
                if (n4 == -1) {
                    n4 = string2.indexOf(9);
                }
                if ((iDocumentKey = (IDocumentKey)this.getEntry(string = n4 != -1 ? string2.substring(0, n4).trim() : string2)) == null) continue;
                while (Character.isSpaceChar(iDocument.getChar(n3))) {
                    ++n3;
                }
                iDocumentKey.setOffset(n3);
                if (string2.endsWith("\\")) continue;
                iDocumentKey.setLength(iDocument.getLineOffset(i) + iDocument.getLineLength(i) - iDocumentKey.getOffset());
                iDocumentKey = null;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

