/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.editor.model;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.ajdt.buildconfigurator.editor.PropertiesUtil;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuildEntry;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuildModel;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.ui.model.IDocumentKey;

public class BuildEntry
implements IBuildEntry,
IDocumentKey {
    private int fLength = -1;
    private int fOffset = -1;
    private IBuildModel fModel;
    private String fName;
    private ArrayList fTokens = new ArrayList();

    public void addToken(String string) throws CoreException {
        this.fTokens.add(string);
        this.getModel().fireModelObjectChanged(this, this.getName(), null, string);
    }

    public void addTokenWithoutNotify(String string) {
        this.fTokens.add(string);
    }

    public String getName() {
        return this.fName;
    }

    public String[] getTokens() {
        return this.fTokens.toArray(new String[this.fTokens.size()]);
    }

    public boolean contains(String string) {
        return this.fTokens.contains(string);
    }

    public void removeToken(String string) throws CoreException {
        this.fTokens.remove(string);
        this.getModel().fireModelObjectChanged(this, this.getName(), string, null);
    }

    public void removeTokenWithoutNotify(String string) {
        this.fTokens.remove(string);
    }

    public void renameToken(String string, String string2) throws CoreException {
        int n = this.fTokens.indexOf(string);
        if (n != -1) {
            this.fTokens.set(n, string2);
            this.getModel().fireModelObjectChanged(this, this.getName(), string, string2);
        }
    }

    public void setName(String string) {
        String string2 = this.fName;
        this.fName = string;
        if (this.getModel() != null) {
            this.getModel().fireModelObjectChanged(this, this.getName(), string2, string);
        }
    }

    public int getOffset() {
        return this.fOffset;
    }

    public void setOffset(int n) {
        this.fOffset = n;
    }

    public int getLength() {
        return this.fLength;
    }

    public void setLength(int n) {
        this.fLength = n;
    }

    public void write(String string, PrintWriter printWriter) {
    }

    public void setModel(IBuildModel iBuildModel) {
        this.fModel = iBuildModel;
    }

    public IBuildModel getModel() {
        return this.fModel;
    }

    public void processEntry(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.fTokens.add(stringTokenizer.nextToken().trim());
        }
    }

    public String write() {
        return PropertiesUtil.writeKeyValuePair(this.getName(), this.getTokens());
    }
}

