/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.menu;

import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.IBuildConfigurationChangedListener;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.menu.AddBuildConfigurationAction;
import org.eclipse.ajdt.buildconfigurator.menu.BuildConfigurationSelectedAction;
import org.eclipse.ajdt.internal.core.resources.AspectJImages;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;

public class DynamicBuildConfigurationMenu
extends MenuManager
implements IBuildConfigurationChangedListener {
    BuildConfigurator buildconf;
    IContributionItem separator = new Separator();
    private ImageDescriptor id = AspectJImages.BC_TICK.getImageDescriptor();

    public DynamicBuildConfigurationMenu() {
        super(AspectJPlugin.getResourceString("BCLabels.ConfigurationSelectionMenu"));
        this.buildconf = BuildConfigurator.getBuildConfigurator();
        this.buildconf.addBuildConfigurationChangedListener(this);
        AddBuildConfigurationAction addBuildConfigurationAction = new AddBuildConfigurationAction();
        addBuildConfigurationAction.setEnabled(false);
        this.add((IAction)addBuildConfigurationAction);
    }

    public void buildConfigurationChanged(final ProjectBuildConfigurator projectBuildConfigurator) {
        Job job = new Job("BuildConfiguration update build menu"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                DynamicBuildConfigurationMenu.this.rebuildMenu(projectBuildConfigurator);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        if (projectBuildConfigurator != null) {
            job.setRule((ISchedulingRule)projectBuildConfigurator.getJavaProject().getProject());
        }
        job.schedule();
    }

    private void rebuildMenu(ProjectBuildConfigurator projectBuildConfigurator) {
        AddBuildConfigurationAction addBuildConfigurationAction = new AddBuildConfigurationAction();
        if (projectBuildConfigurator == null) {
            Display.getDefault().asyncExec(new Runnable((IAction)addBuildConfigurationAction){
                private final /* synthetic */ IAction val$addAction;
                {
                    this.val$addAction = iAction;
                }

                public void run() {
                    DynamicBuildConfigurationMenu.this.removeAll();
                    DynamicBuildConfigurationMenu.this.setVisible(true);
                    this.val$addAction.setEnabled(false);
                    DynamicBuildConfigurationMenu.this.add(DynamicBuildConfigurationMenu.this.separator);
                    DynamicBuildConfigurationMenu.this.add(this.val$addAction);
                }
            });
            return;
        }
        Util.Comparable[] comparableArray = projectBuildConfigurator.getBuildConfigurations().toArray(new BuildConfiguration[0]);
        Util.sort((Util.Comparable[])comparableArray);
        final BuildConfiguration buildConfiguration = projectBuildConfigurator.getActiveBuildConfiguration();
        final BuildConfiguration[] buildConfigurationArray = new BuildConfiguration[comparableArray.length];
        System.arraycopy(comparableArray, 0, buildConfigurationArray, 0, comparableArray.length);
        Display.getDefault().asyncExec(new Runnable((IAction)addBuildConfigurationAction){
            private final /* synthetic */ IAction val$addAction;
            {
                this.val$addAction = iAction;
            }

            public void run() {
                DynamicBuildConfigurationMenu.this.removeAll();
                for (int i = 0; i < buildConfigurationArray.length; ++i) {
                    BuildConfigurationSelectedAction buildConfigurationSelectedAction = new BuildConfigurationSelectedAction(buildConfigurationArray[i]);
                    if (buildConfigurationArray[i] == buildConfiguration) {
                        buildConfigurationSelectedAction.setImageDescriptor(DynamicBuildConfigurationMenu.this.id);
                    }
                    DynamicBuildConfigurationMenu.this.add((IAction)buildConfigurationSelectedAction);
                }
                DynamicBuildConfigurationMenu.this.add(DynamicBuildConfigurationMenu.this.separator);
                DynamicBuildConfigurationMenu.this.add(this.val$addAction);
                DynamicBuildConfigurationMenu.this.setVisible(true);
            }
        });
    }

    public boolean isDynamic() {
        return true;
    }
}

