/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.popup.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.IBuildConfigurationChangedListener;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class BuildConfigurationChangeAction
implements IObjectActionDelegate,
IBuildConfigurationChangedListener {
    protected IAction myAction;
    protected IStructuredSelection strucSel;
    protected BuildConfigurator buildConfigurator = BuildConfigurator.getBuildConfigurator();
    protected String actionText;
    ArrayList changedBCs;

    public BuildConfigurationChangeAction() {
        this.buildConfigurator.addBuildConfigurationChangedListener(this);
    }

    public void run(IAction iAction) {
        this.changedBCs = new ArrayList();
        ProjectBuildConfigurator projectBuildConfigurator = this.buildConfigurator.getActiveProjectBuildConfigurator();
        if (projectBuildConfigurator != null) {
            Iterator iterator = this.strucSel.iterator();
            ArrayList<IResource> arrayList = new ArrayList<IResource>();
            while (iterator.hasNext()) {
                IResource iResource;
                ProjectBuildConfigurator projectBuildConfigurator2;
                Object object = iterator.next();
                if (object instanceof IJavaElement) {
                    try {
                        object = ((IJavaElement)object).getCorrespondingResource();
                    }
                    catch (JavaModelException javaModelException) {
                        object = null;
                    }
                }
                if (!(object instanceof IResource) || projectBuildConfigurator != (projectBuildConfigurator2 = this.buildConfigurator.getProjectBuildConfigurator((iResource = (IResource)object).getProject()))) continue;
                arrayList.add(iResource);
            }
            this.doMySpecificAction(projectBuildConfigurator.getActiveBuildConfiguration(), arrayList);
        }
    }

    protected abstract Job getJob(BuildConfiguration var1, List var2);

    private void doMySpecificAction(BuildConfiguration buildConfiguration, List list) {
        Job job = this.getJob(buildConfiguration, list);
        job.setPriority(20);
        job.setRule((ISchedulingRule)buildConfiguration.getFile().getProject());
        job.schedule();
    }

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    public void buildConfigurationChanged(final ProjectBuildConfigurator projectBuildConfigurator) {
        if (projectBuildConfigurator != null) {
            this.myAction.setEnabled(true);
            Job job = new Job("BuildConfiguration change action"){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    BuildConfiguration buildConfiguration = projectBuildConfigurator.getActiveBuildConfiguration();
                    BuildConfigurationChangeAction.this.myAction.setText(BuildConfigurationChangeAction.this.actionText.replaceAll("%bcname", buildConfiguration.getName()));
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(20);
            job.setRule((ISchedulingRule)projectBuildConfigurator.getJavaProject().getProject());
            job.schedule();
        } else {
            this.myAction.setEnabled(false);
        }
    }

    abstract boolean isObjectApplicable(Object var1);

    protected boolean isApplicable(Object object) {
        if (object instanceof IPackageFragment) {
            try {
                int n;
                IPackageFragment iPackageFragment = (IPackageFragment)object;
                Object[] objectArray = iPackageFragment.getChildren();
                for (n = 0; n < objectArray.length; ++n) {
                    if (!this.isApplicable(objectArray[n])) continue;
                    return true;
                }
                objectArray = iPackageFragment.getNonJavaResources();
                for (n = 0; n < objectArray.length; ++n) {
                    if (!this.isApplicable(objectArray[n])) continue;
                    return true;
                }
            }
            catch (CoreException coreException) {
                return false;
            }
        } else {
            return this.isObjectApplicable(object);
        }
        return false;
    }

    protected boolean isApplicable(IStructuredSelection iStructuredSelection) {
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.isApplicable(e)) continue;
            return true;
        }
        return false;
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        if (this.myAction == null) {
            this.myAction = iAction;
            ProjectBuildConfigurator projectBuildConfigurator = this.buildConfigurator.getActiveProjectBuildConfigurator();
            if (projectBuildConfigurator != null) {
                this.myAction.setText(this.actionText.replaceAll("%bcname", projectBuildConfigurator.getActiveBuildConfiguration().getName()));
            }
        }
        if (iSelection instanceof IStructuredSelection) {
            this.strucSel = (IStructuredSelection)iSelection;
            iAction.setEnabled(this.isApplicable(this.strucSel));
        } else {
            this.strucSel = null;
            iAction.setEnabled(false);
        }
    }
}

