/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.popup.actions;

import java.util.List;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.popup.actions.BuildConfigurationChangeAction;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;

public class ExcludeAction
extends BuildConfigurationChangeAction {
    public ExcludeAction() {
        this.actionText = AspectJPlugin.getResourceString("BCLabels.ExcludeAction");
    }

    protected Job getJob(final BuildConfiguration buildConfiguration, final List list) {
        return new Job("BuildConfiguration exclude action"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    buildConfiguration.excludeFiles(list);
                }
                catch (CoreException coreException) {
                    AspectJPlugin.getDefault().getErrorHandler().handleError(AspectJPlugin.getResourceString("buildConfig.exceptionExcluding"), coreException);
                }
                return Status.OK_STATUS;
            }
        };
    }

    boolean isObjectApplicable(Object object) {
        try {
            ProjectBuildConfigurator projectBuildConfigurator;
            IFile iFile;
            if (object instanceof ICompilationUnit) {
                object = ((ICompilationUnit)object).getCorrespondingResource();
            }
            if (object instanceof IFile && ProjectProperties.ASPECTJ_SOURCE_FILTER.accept((iFile = (IFile)object).getName()) && (projectBuildConfigurator = this.buildConfigurator.getProjectBuildConfigurator(iFile.getProject())) != null) {
                return projectBuildConfigurator.getActiveBuildConfiguration().isIncluded((IResource)iFile);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }
}

