/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.propertypage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ExclusionInclusionDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.MultipleFolderSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.NewSourceFolderDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.OutputLocationDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.SourceContainerWorkbookPage;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class BCContainerWorkbookPage
extends SourceContainerWorkbookPage {
    private ListDialogField fClassPathList;
    private IJavaProject fCurrJProject;
    private IPath fProjPath;
    private Control fSWTControl;
    private IWorkspaceRoot fWorkspaceRoot;
    private TreeListDialogField fFoldersList;
    private StringDialogField fOutputLocationField;
    private final int IDX_ADD = 0;
    private final int IDX_EDIT = 2;
    private final int IDX_REMOVE = 3;
    static /* synthetic */ Class class$org$eclipse$core$resources$IProject;
    static /* synthetic */ Class class$org$eclipse$core$resources$IFolder;

    public BCContainerWorkbookPage(IWorkspaceRoot iWorkspaceRoot, ListDialogField listDialogField, StringDialogField stringDialogField) {
        super(iWorkspaceRoot, listDialogField, stringDialogField);
        this.fWorkspaceRoot = iWorkspaceRoot;
        this.fClassPathList = listDialogField;
        this.fOutputLocationField = stringDialogField;
        this.fSWTControl = null;
        SourceContainerAdapter sourceContainerAdapter = new SourceContainerAdapter();
        String[] stringArray = new String[]{NewWizardMessages.getString((String)"SourceContainerWorkbookPage.folders.add.button"), null, null, NewWizardMessages.getString((String)"SourceContainerWorkbookPage.folders.remove.button")};
        this.fFoldersList = new TreeListDialogField((ITreeListAdapter)sourceContainerAdapter, stringArray, (ILabelProvider)new CPListLabelProvider());
        this.fFoldersList.setDialogFieldListener((IDialogFieldListener)sourceContainerAdapter);
        this.fFoldersList.setLabelText(NewWizardMessages.getString((String)"SourceContainerWorkbookPage.folders.label"));
        this.fFoldersList.setViewerSorter((ViewerSorter)new CPListElementSorter());
        this.fFoldersList.enableButton(2, false);
    }

    public void init(IJavaProject iJavaProject) {
        this.fCurrJProject = iJavaProject;
        this.fProjPath = this.fCurrJProject.getProject().getFullPath();
        this.updateFoldersList();
    }

    private void updateFoldersList() {
        CPListElement cPListElement;
        int n;
        ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>();
        boolean bl = false;
        List list = this.fClassPathList.getElements();
        for (n = 0; n < list.size(); ++n) {
            boolean bl2;
            cPListElement = (CPListElement)list.get(n);
            if (cPListElement.getEntryKind() != 3) continue;
            arrayList.add(cPListElement);
            boolean bl3 = bl2 = cPListElement.getAttribute("output") != null;
            if (!bl2) continue;
            bl = true;
        }
        this.fFoldersList.setElements(arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            boolean bl4;
            cPListElement = (CPListElement)arrayList.get(n);
            IPath[] iPathArray = (IPath[])cPListElement.getAttribute("exclusion");
            boolean bl5 = bl4 = cPListElement.getAttribute("output") != null;
            if (iPathArray.length <= 0 && !bl4) continue;
            this.fFoldersList.expandElement((Object)cPListElement, 3);
        }
    }

    public Control getControl(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        LayoutUtil.doDefaultLayout((Composite)composite2, (DialogField[])new DialogField[]{this.fFoldersList}, (boolean)true);
        LayoutUtil.setHorizontalGrabbing((Control)this.fFoldersList.getTreeControl(null));
        int n = pixelConverter.convertWidthInCharsToPixels(24);
        this.fFoldersList.setButtonsMinWidth(n);
        this.fSWTControl = composite2;
        List list = this.fFoldersList.getElements();
        for (int i = 0; i < list.size(); ++i) {
            CPListElement cPListElement = (CPListElement)list.get(i);
            IPath[] iPathArray = (IPath[])cPListElement.getAttribute("exclusion");
            IPath[] iPathArray2 = (IPath[])cPListElement.getAttribute("inclusion");
            IPath iPath = (IPath)cPListElement.getAttribute("output");
            if (iPathArray.length <= 0 && iPathArray2.length <= 0 && iPath == null) continue;
            this.fFoldersList.expandElement((Object)cPListElement, 3);
        }
        return composite2;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    protected void sourcePageKeyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
        List list;
        if (treeListDialogField == this.fFoldersList && keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && this.canRemove(list = treeListDialogField.getSelectedElements())) {
            this.removeEntry();
        }
    }

    protected void sourcePageDoubleClicked(TreeListDialogField treeListDialogField) {
        List list;
        if (treeListDialogField == this.fFoldersList && this.canEdit(list = treeListDialogField.getSelectedElements())) {
            this.editEntry();
        }
    }

    private boolean hasFolders(IContainer iContainer) {
        try {
            IResource[] iResourceArray = iContainer.members();
            for (int i = 0; i < iResourceArray.length; ++i) {
                if (!(iResourceArray[i] instanceof IContainer)) continue;
                return true;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    protected void sourcePageCustomButtonPressed(DialogField dialogField, int n) {
        if (dialogField == this.fFoldersList) {
            if (n == 0) {
                Object object;
                ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>(10);
                IProject iProject = this.fCurrJProject.getProject();
                if (iProject.exists()) {
                    if (this.hasFolders((IContainer)iProject)) {
                        object = this.openSourceContainerDialog(null);
                        if (object != null) {
                            for (int i = 0; i < ((CPListElement)object).length; ++i) {
                                arrayList.add(object[i]);
                            }
                        }
                    } else {
                        object = this.openNewSourceContainerDialog(null, true);
                        if (object != null) {
                            arrayList.add((CPListElement)object);
                        }
                    }
                } else {
                    object = this.openNewSourceContainerDialog(null, false);
                    if (object != null) {
                        arrayList.add((CPListElement)object);
                    }
                }
                if (!arrayList.isEmpty()) {
                    if (this.fFoldersList.getSize() == 1 && (object = (CPListElement)this.fFoldersList.getElement(0)).getResource() instanceof IProject) {
                        this.askForChangingBuildPathDialog((CPListElement)object);
                    }
                    object = new HashSet();
                    this.askForAddingExclusionPatternsDialog(arrayList, (Set)object);
                    this.fFoldersList.addElements(arrayList);
                    this.fFoldersList.postSetSelection((ISelection)new StructuredSelection(arrayList));
                    if (!((HashSet)object).isEmpty()) {
                        Iterator iterator = ((HashSet)object).iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            this.fFoldersList.refresh(e);
                            this.fFoldersList.expandElement(e, 3);
                        }
                    }
                }
            } else if (n == 2) {
                this.editEntry();
            } else if (n == 3) {
                this.removeEntry();
            }
        }
    }

    private void editEntry() {
        List list = this.fFoldersList.getSelectedElements();
        if (list.size() != 1) {
            return;
        }
        Object e = list.get(0);
        if (this.fFoldersList.getIndexOfElement(e) != -1) {
            this.editElementEntry((CPListElement)e);
        } else if (e instanceof CPListElementAttribute) {
            this.editAttributeEntry((CPListElementAttribute)e);
        }
    }

    private void editElementEntry(CPListElement cPListElement) {
        CPListElement cPListElement2 = null;
        cPListElement2 = this.openNewSourceContainerDialog(cPListElement, true);
        if (cPListElement2 != null) {
            this.fFoldersList.replaceElement((Object)cPListElement, (Object)cPListElement2);
        }
    }

    private void editAttributeEntry(CPListElementAttribute cPListElementAttribute) {
        String string = cPListElementAttribute.getKey();
        if (string.equals("output")) {
            CPListElement cPListElement = cPListElementAttribute.getParent();
            OutputLocationDialog outputLocationDialog = new OutputLocationDialog(this.getShell(), cPListElement);
            if (outputLocationDialog.open() == 0) {
                cPListElement.setAttribute("output", (Object)outputLocationDialog.getOutputLocation());
                this.fFoldersList.refresh();
                this.fClassPathList.dialogFieldChanged();
            }
        } else if (string.equals("exclusion")) {
            this.showExclusionInclusionDialog(cPListElementAttribute.getParent(), true);
        } else if (string.equals("inclusion")) {
            this.showExclusionInclusionDialog(cPListElementAttribute.getParent(), false);
        }
    }

    private void showExclusionInclusionDialog(CPListElement cPListElement, boolean bl) {
        ExclusionInclusionDialog exclusionInclusionDialog = new ExclusionInclusionDialog(this.getShell(), cPListElement, bl);
        if (exclusionInclusionDialog.open() == 0) {
            cPListElement.setAttribute("inclusion", (Object)exclusionInclusionDialog.getInclusionPattern());
            cPListElement.setAttribute("exclusion", (Object)exclusionInclusionDialog.getExclusionPattern());
            this.fFoldersList.refresh();
            this.fClassPathList.dialogFieldChanged();
        }
    }

    protected void sourcePageSelectionChanged(DialogField dialogField) {
        List list = this.fFoldersList.getSelectedElements();
        this.fFoldersList.enableButton(2, this.canEdit(list));
        this.fFoldersList.enableButton(3, this.canRemove(list));
    }

    private void removeEntry() {
        List list = this.fFoldersList.getSelectedElements();
        for (int i = list.size() - 1; i >= 0; --i) {
            Object e = list.get(i);
            if (!(e instanceof CPListElementAttribute)) continue;
            CPListElementAttribute cPListElementAttribute = (CPListElementAttribute)e;
            String string = cPListElementAttribute.getKey();
            Path[] pathArray = null;
            if (string.equals("exclusion") || string.equals("inclusion")) {
                pathArray = new Path[]{};
            }
            cPListElementAttribute.getParent().setAttribute(string, (Object)pathArray);
            list.remove(i);
        }
        if (list.isEmpty()) {
            this.fFoldersList.refresh();
            this.fClassPathList.dialogFieldChanged();
        } else {
            this.fFoldersList.removeElements(list);
        }
    }

    private boolean canRemove(List list) {
        if (list.size() == 0) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            CPListElementAttribute cPListElementAttribute;
            String string;
            Object e = list.get(i);
            if (!(e instanceof CPListElementAttribute ? ("inclusion".equals(string = (cPListElementAttribute = (CPListElementAttribute)e).getKey()) ? ((IPath[])cPListElementAttribute.getValue()).length == 0 : ("exclusion".equals(string) ? ((IPath[])cPListElementAttribute.getValue()).length == 0 : cPListElementAttribute.getValue() == null)) : e instanceof CPListElement && (cPListElementAttribute = (CPListElement)e).getParentContainer() != null)) continue;
            return false;
        }
        return true;
    }

    private boolean canEdit(List list) {
        if (list.size() != 1) {
            return false;
        }
        Object e = list.get(0);
        if (e instanceof CPListElement) {
            return false;
        }
        return e instanceof CPListElementAttribute;
    }

    private void sourcePageDialogFieldChanged(DialogField dialogField) {
        if (this.fCurrJProject == null) {
            return;
        }
        if (dialogField == this.fFoldersList) {
            this.updateClasspathList();
        }
    }

    private void updateClasspathList() {
        int n;
        int n2;
        List list = this.fFoldersList.getElements();
        List list2 = this.fClassPathList.getElements();
        int n3 = n2 = list2.size();
        int n4 = 0;
        for (n = n2 - 1; n >= 0; --n) {
            CPListElement cPListElement = (CPListElement)list2.get(n);
            int n5 = cPListElement.getEntryKind();
            if (!this.isEntryKind(n5)) continue;
            if (!list.remove(cPListElement)) {
                list2.remove(n);
                n3 = n;
                continue;
            }
            if (n3 != n2) continue;
            n4 = n + 1;
        }
        if (!list.isEmpty()) {
            n = Math.min(n4, n3);
            list2.addAll(n, list);
        }
        if (n3 != n2 || !list.isEmpty()) {
            this.fClassPathList.setElements((Collection)list2);
        }
    }

    private CPListElement openNewSourceContainerDialog(CPListElement cPListElement, boolean bl) {
        if (bl) {
            NewFolderDialog newFolderDialog = new NewFolderDialog(this.getShell(), (IContainer)this.fCurrJProject.getProject());
            newFolderDialog.setTitle(NewWizardMessages.getString((String)"SourceContainerWorkbookPage.NewSourceFolderDialog.new.title"));
            if (newFolderDialog.open() == 0) {
                IResource iResource = (IResource)newFolderDialog.getResult()[0];
                return this.newCPSourceElement(iResource);
            }
            return null;
        }
        String string = cPListElement == null ? NewWizardMessages.getString((String)"SourceContainerWorkbookPage.NewSourceFolderDialog.new.title") : NewWizardMessages.getString((String)"SourceContainerWorkbookPage.NewSourceFolderDialog.edit.title");
        IProject iProject = this.fCurrJProject.getProject();
        NewSourceFolderDialog newSourceFolderDialog = new NewSourceFolderDialog(this.getShell(), string, iProject, this.getExistingContainers(cPListElement), cPListElement);
        newSourceFolderDialog.setMessage(NewWizardMessages.getFormattedString((String)"SourceContainerWorkbookPage.NewSourceFolderDialog.description", (Object)this.fProjPath.toString()));
        if (newSourceFolderDialog.open() == 0) {
            IContainer iContainer = newSourceFolderDialog.getSourceFolder();
            return this.newCPSourceElement((IResource)iContainer);
        }
        return null;
    }

    private void askForChangingBuildPathDialog(CPListElement cPListElement) {
        String string;
        String string2;
        Path path = new Path(this.fOutputLocationField.getText());
        IPath iPath = null;
        if (path.segmentCount() == 1) {
            string2 = PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName");
            iPath = path.append(string2);
            string = NewWizardMessages.getFormattedString((String)"SourceContainerWorkbookPage.ChangeOutputLocationDialog.project_and_output.message", (Object)iPath);
        } else {
            string = NewWizardMessages.getString((String)"SourceContainerWorkbookPage.ChangeOutputLocationDialog.project.message");
        }
        string2 = NewWizardMessages.getString((String)"SourceContainerWorkbookPage.ChangeOutputLocationDialog.title");
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)string2, (String)string)) {
            this.fFoldersList.removeElement((Object)cPListElement);
            if (iPath != null) {
                this.fOutputLocationField.setText(iPath.toString());
            }
        }
    }

    private void askForAddingExclusionPatternsDialog(List list, Set set) {
        this.fixNestingConflicts(list, this.fFoldersList.getElements(), set);
        if (!set.isEmpty()) {
            String string = NewWizardMessages.getString((String)"SourceContainerWorkbookPage.exclusion_added.title");
            String string2 = NewWizardMessages.getString((String)"SourceContainerWorkbookPage.exclusion_added.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)string, (String)string2);
        }
    }

    private CPListElement[] openSourceContainerDialog(CPListElement cPListElement) {
        Class[] classArray = new Class[]{class$org$eclipse$core$resources$IProject == null ? (class$org$eclipse$core$resources$IProject = BCContainerWorkbookPage.class$("org.eclipse.core.resources.IProject")) : class$org$eclipse$core$resources$IProject, class$org$eclipse$core$resources$IFolder == null ? (class$org$eclipse$core$resources$IFolder = BCContainerWorkbookPage.class$("org.eclipse.core.resources.IFolder")) : class$org$eclipse$core$resources$IFolder};
        List list = this.getExistingContainers(null);
        IProject[] iProjectArray = this.fWorkspaceRoot.getProjects();
        ArrayList<IProject> arrayList = new ArrayList<IProject>(iProjectArray.length);
        IProject iProject = this.fCurrJProject.getProject();
        for (int i = 0; i < iProjectArray.length; ++i) {
            if (iProjectArray[i].equals(iProject)) continue;
            arrayList.add(iProjectArray[i]);
        }
        TypedViewerFilter typedViewerFilter = new TypedViewerFilter(classArray, arrayList.toArray());
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        BaseWorkbenchContentProvider baseWorkbenchContentProvider = new BaseWorkbenchContentProvider();
        String string = cPListElement == null ? NewWizardMessages.getString((String)"SourceContainerWorkbookPage.ExistingSourceFolderDialog.new.title") : NewWizardMessages.getString((String)"SourceContainerWorkbookPage.ExistingSourceFolderDialog.edit.title");
        String string2 = cPListElement == null ? NewWizardMessages.getString((String)"SourceContainerWorkbookPage.ExistingSourceFolderDialog.new.description") : NewWizardMessages.getString((String)"SourceContainerWorkbookPage.ExistingSourceFolderDialog.edit.description");
        MultipleFolderSelectionDialog multipleFolderSelectionDialog = new MultipleFolderSelectionDialog(this.getShell(), (ILabelProvider)workbenchLabelProvider, (ITreeContentProvider)baseWorkbenchContentProvider);
        multipleFolderSelectionDialog.setExisting(list.toArray());
        multipleFolderSelectionDialog.setTitle(string);
        multipleFolderSelectionDialog.setMessage(string2);
        multipleFolderSelectionDialog.addFilter((ViewerFilter)typedViewerFilter);
        multipleFolderSelectionDialog.setInput((Object)this.fCurrJProject.getProject().getParent());
        if (cPListElement == null) {
            multipleFolderSelectionDialog.setInitialFocus((Object)this.fCurrJProject.getProject());
        } else {
            multipleFolderSelectionDialog.setInitialFocus((Object)cPListElement.getResource());
        }
        if (multipleFolderSelectionDialog.open() == 0) {
            Object[] objectArray = multipleFolderSelectionDialog.getResult();
            CPListElement[] cPListElementArray = new CPListElement[objectArray.length];
            for (int i = 0; i < cPListElementArray.length; ++i) {
                IResource iResource = (IResource)objectArray[i];
                cPListElementArray[i] = this.newCPSourceElement(iResource);
            }
            return cPListElementArray;
        }
        return null;
    }

    private List getExistingContainers(CPListElement cPListElement) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        List list = this.fFoldersList.getElements();
        for (int i = 0; i < list.size(); ++i) {
            IResource iResource;
            CPListElement cPListElement2 = (CPListElement)list.get(i);
            if (cPListElement2 == cPListElement || !((iResource = cPListElement2.getResource()) instanceof IContainer)) continue;
            arrayList.add(iResource);
        }
        return arrayList;
    }

    private CPListElement newCPSourceElement(IResource iResource) {
        Assert.isNotNull((Object)iResource);
        return new CPListElement(this.fCurrJProject, 3, iResource.getFullPath(), iResource);
    }

    public List getSelection() {
        return this.fFoldersList.getSelectedElements();
    }

    public void setSelection(List list) {
        this.fFoldersList.selectElements((ISelection)new StructuredSelection(list));
    }

    public boolean isEntryKind(int n) {
        return n == 3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SourceContainerAdapter
    implements ITreeListAdapter,
    IDialogFieldListener {
        private final Object[] EMPTY_ARR = new Object[0];

        private SourceContainerAdapter() {
        }

        public void customButtonPressed(TreeListDialogField treeListDialogField, int n) {
            BCContainerWorkbookPage.this.sourcePageCustomButtonPressed((DialogField)treeListDialogField, n);
        }

        public void selectionChanged(TreeListDialogField treeListDialogField) {
            BCContainerWorkbookPage.this.sourcePageSelectionChanged((DialogField)treeListDialogField);
        }

        public void doubleClicked(TreeListDialogField treeListDialogField) {
            BCContainerWorkbookPage.this.sourcePageDoubleClicked(treeListDialogField);
        }

        public void keyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
            BCContainerWorkbookPage.this.sourcePageKeyPressed(treeListDialogField, keyEvent);
        }

        public Object[] getChildren(TreeListDialogField treeListDialogField, Object object) {
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)object).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField treeListDialogField, Object object) {
            return false;
        }

        public void dialogFieldChanged(DialogField dialogField) {
            BCContainerWorkbookPage.this.sourcePageDialogFieldChanged(dialogField);
        }
    }
}

