/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.tests.TestProject;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class BuildConfiguratorTest
extends TestCase {
    IProject javaProject = null;
    IProject ajProject = null;
    static int testNum = 0;
    IFile fileA;
    IFile fileB;
    IFile fileDef;

    protected void setUp() throws Exception {
        super.setUp();
        TestProject testProject = new TestProject("Java Project created by BuildConfiguratorTest " + testNum);
        this.javaProject = testProject.getProject();
        TestProject testProject2 = new TestProject("AJ Project created by BuildConfiguratorTest" + testNum++);
        this.ajProject = testProject2.getProject();
        AspectJPreferences.setAJDTPrefConfigDone(true);
        AJDTUtils.addAspectJNature(this.ajProject);
        this.waitForJobsToComplete(this.ajProject);
        this.setupSandboxSourceFolder();
        this.waitForJobsToComplete(this.ajProject);
    }

    private void setupSandboxSourceFolder() throws Exception {
        ByteArrayInputStream byteArrayInputStream;
        IFolder iFolder;
        Object object;
        IFolder iFolder2 = this.ajProject.getFolder("testSrcPath");
        if (!iFolder2.exists()) {
            iFolder2.create(true, true, null);
        }
        IJavaProject iJavaProject = JavaCore.create((IProject)this.ajProject);
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[iClasspathEntryArray.length + 1];
        boolean bl = false;
        for (int i = 0; i < iClasspathEntryArray.length; ++i) {
            iClasspathEntryArray2[i] = iClasspathEntryArray[i];
            if (!iClasspathEntryArray[i].getPath().equals(iFolder2.getFullPath())) continue;
            bl = true;
        }
        if (!bl) {
            iClasspathEntryArray2[iClasspathEntryArray.length] = JavaCore.newSourceEntry((IPath)iFolder2.getFullPath());
            iJavaProject.setRawClasspath(iClasspathEntryArray2, null);
        }
        this.fileDef = iFolder2.getFile("InDefaultPack.java");
        if (!this.fileDef.exists()) {
            String string = "public class InDefaultPack{}";
            object = new ByteArrayInputStream(string.getBytes());
            this.fileDef.create((InputStream)object, true, null);
        }
        if (!(iFolder = iFolder2.getFolder("package1")).exists()) {
            iFolder.create(true, true, null);
        }
        this.fileA = iFolder.getFile("A.java");
        if (!this.fileA.exists()) {
            object = "package package1;\npublic class A{}";
            byteArrayInputStream = new ByteArrayInputStream(((String)object).getBytes());
            this.fileA.create((InputStream)byteArrayInputStream, true, null);
        }
        this.fileB = iFolder.getFile("B.java");
        if (!this.fileB.exists()) {
            object = "package package1;\npublic class B{}";
            byteArrayInputStream = new ByteArrayInputStream(((String)object).getBytes());
            this.fileB.create((InputStream)byteArrayInputStream, true, null);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetBuildConfigurator() {
        BuildConfigurator buildConfigurator;
        BuildConfigurator buildConfigurator2 = BuildConfigurator.getBuildConfigurator();
        if (buildConfigurator2 != (buildConfigurator = BuildConfigurator.getBuildConfigurator())) {
            BuildConfiguratorTest.fail((String)"Build Configurator not unique.");
        }
    }

    public void testGetProjectBuildConfigurator() throws CoreException {
        BuildConfigurator buildConfigurator = BuildConfigurator.getBuildConfigurator();
        ProjectBuildConfigurator projectBuildConfigurator = buildConfigurator.getProjectBuildConfigurator(this.javaProject);
        if (projectBuildConfigurator != null) {
            BuildConfiguratorTest.fail((String)"Could obtain a ProjectBuildConfigurator for non-aj project. This should not be possible.");
        }
        this.ajProject.close(null);
        projectBuildConfigurator = buildConfigurator.getProjectBuildConfigurator(this.ajProject);
        if (projectBuildConfigurator != null) {
            BuildConfiguratorTest.fail((String)"Could obtain a ProjectBuildConfigurator for closed project. This should not be possible.");
        }
        this.ajProject.open(null);
        projectBuildConfigurator = buildConfigurator.getProjectBuildConfigurator(this.ajProject);
        if (projectBuildConfigurator == null) {
            BuildConfiguratorTest.fail((String)"Could not get a ProjectBuildConfigurator for an aj project.");
        }
    }

    public void testGetBuildConfiguration() {
        BuildConfigurator buildConfigurator = BuildConfigurator.getBuildConfigurator();
        ProjectBuildConfigurator projectBuildConfigurator = buildConfigurator.getProjectBuildConfigurator(this.ajProject);
        BuildConfiguration buildConfiguration = projectBuildConfigurator.getActiveBuildConfiguration();
        if (buildConfiguration == null) {
            BuildConfiguratorTest.fail((String)"Could not get active BuildConfiguration.");
        }
        ArrayList arrayList = new ArrayList(projectBuildConfigurator.getBuildConfigurations());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            BuildConfiguration buildConfiguration2 = (BuildConfiguration)iterator.next();
            projectBuildConfigurator.removeBuildConfiguration(buildConfiguration2);
        }
        buildConfiguration = projectBuildConfigurator.getActiveBuildConfiguration();
        iterator = arrayList.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            BuildConfiguration buildConfiguration3 = (BuildConfiguration)iterator.next();
            projectBuildConfigurator.addBuildConfiguration(buildConfiguration3);
            if (!buildConfiguration3.getFile().equals(buildConfiguration.getFile())) continue;
            bl = true;
        }
        if (!bl) {
            projectBuildConfigurator.removeBuildConfiguration(buildConfiguration);
        }
        if (buildConfiguration == null) {
            BuildConfiguratorTest.fail((String)"No new build configuration was created when removing all old ones.");
        }
    }

    public void testBuildConfigurationIsincluded() {
        BuildConfigurator buildConfigurator = BuildConfigurator.getBuildConfigurator();
        ProjectBuildConfigurator projectBuildConfigurator = buildConfigurator.getProjectBuildConfigurator(this.ajProject);
        BuildConfiguration buildConfiguration = projectBuildConfigurator.getActiveBuildConfiguration();
        this.waitForJobsToComplete(this.ajProject);
        if (!buildConfiguration.isIncluded((IResource)this.fileA)) {
            BuildConfiguratorTest.fail((String)"A.java was not included.");
        }
        if (!buildConfiguration.isIncluded((IResource)this.fileB)) {
            BuildConfiguratorTest.fail((String)"B.java was not included.");
        }
        if (!buildConfiguration.isIncluded((IResource)this.fileDef)) {
            BuildConfiguratorTest.fail((String)"InDefaultPackage.java was not included.");
        }
    }

    public void testBuildConfigurationExclude() throws CoreException {
        BuildConfigurator buildConfigurator = BuildConfigurator.getBuildConfigurator();
        ProjectBuildConfigurator projectBuildConfigurator = buildConfigurator.getProjectBuildConfigurator(this.ajProject);
        BuildConfiguration buildConfiguration = projectBuildConfigurator.getActiveBuildConfiguration();
        this.testBuildConfigurationIsincluded();
        this.waitForJobsToComplete(this.ajProject);
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add(this.fileA);
        buildConfiguration.excludeFiles(arrayList);
        this.waitForJobsToComplete(this.ajProject);
        if (buildConfiguration.isIncluded((IResource)this.fileA)) {
            BuildConfiguratorTest.fail((String)"Exclude failed. A.java still included.");
        }
        if (!buildConfiguration.isIncluded((IResource)this.fileB)) {
            BuildConfiguratorTest.fail((String)"Exclude failed. B.java should be included.");
        }
        if (!buildConfiguration.isIncluded((IResource)this.fileDef)) {
            BuildConfiguratorTest.fail((String)"Exclude failed. InDefaultPackage.java should be included.");
        }
        arrayList.clear();
        arrayList.add(this.fileA.getParent());
        buildConfiguration.excludeFiles(arrayList);
        this.waitForJobsToComplete(this.ajProject);
        if (buildConfiguration.isIncluded((IResource)this.fileA)) {
            BuildConfiguratorTest.fail((String)"Exclude failed. A.java still included.");
        }
        if (buildConfiguration.isIncluded((IResource)this.fileB)) {
            BuildConfiguratorTest.fail((String)"Exclude failed. B.java still included.");
        }
        if (!buildConfiguration.isIncluded((IResource)this.fileDef)) {
            BuildConfiguratorTest.fail((String)"Exclude failed. InDefaultPackage.java should be included.");
        }
        buildConfiguration.includeFiles(arrayList);
        this.waitForJobsToComplete(this.ajProject);
        if (!buildConfiguration.isIncluded((IResource)this.fileA)) {
            BuildConfiguratorTest.fail((String)"Reinclude failed. A.java should be included.");
        }
        if (!buildConfiguration.isIncluded((IResource)this.fileB)) {
            BuildConfiguratorTest.fail((String)"Reinclude failed. B.java should be included.");
        }
        if (!buildConfiguration.isIncluded((IResource)this.fileDef)) {
            BuildConfiguratorTest.fail((String)"Reinclude failed. InDefaultPackage.java should be included.");
        }
        arrayList.clear();
        arrayList.add(this.fileA);
        arrayList.add(this.fileB);
        buildConfiguration.excludeFiles(arrayList);
        this.waitForJobsToComplete(this.ajProject);
        if (buildConfiguration.isIncluded((IResource)this.fileA)) {
            BuildConfiguratorTest.fail((String)"Exclude failed. A.java still included.");
        }
        if (buildConfiguration.isIncluded((IResource)this.fileB)) {
            BuildConfiguratorTest.fail((String)"Exclude failed. B.java still included.");
        }
        if (!buildConfiguration.isIncluded((IResource)this.fileDef)) {
            BuildConfiguratorTest.fail((String)"Exclude failed. InDefaultPackage.java should be included.");
        }
    }

    public void testBuildConfigurationInclude() throws CoreException {
        BuildConfigurator buildConfigurator = BuildConfigurator.getBuildConfigurator();
        ProjectBuildConfigurator projectBuildConfigurator = buildConfigurator.getProjectBuildConfigurator(this.ajProject);
        BuildConfiguration buildConfiguration = projectBuildConfigurator.getActiveBuildConfiguration();
        this.waitForJobsToComplete(this.ajProject);
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add(this.fileA.getParent());
        arrayList.add(this.fileDef);
        buildConfiguration.excludeFiles(arrayList);
        this.waitForJobsToComplete(this.ajProject);
        if (buildConfiguration.isIncluded((IResource)this.fileA)) {
            BuildConfiguratorTest.fail((String)"Exclude failed. A.java should be excluded.");
        }
        if (buildConfiguration.isIncluded((IResource)this.fileB)) {
            BuildConfiguratorTest.fail((String)"Exclude failed. B.java should be excluded.");
        }
        if (buildConfiguration.isIncluded((IResource)this.fileDef)) {
            BuildConfiguratorTest.fail((String)"Exclude failed. InDefaultPackage.java should be excluded.");
        }
        arrayList.clear();
        arrayList.add(this.fileDef);
        buildConfiguration.includeFiles(arrayList);
        this.waitForJobsToComplete(this.ajProject);
        if (buildConfiguration.isIncluded((IResource)this.fileA)) {
            BuildConfiguratorTest.fail((String)"Include failed. A.java should be excluded.");
        }
        if (buildConfiguration.isIncluded((IResource)this.fileB)) {
            BuildConfiguratorTest.fail((String)"Include failed. B.java should be excluded.");
        }
        if (!buildConfiguration.isIncluded((IResource)this.fileDef)) {
            BuildConfiguratorTest.fail((String)"Include failed. InDefaultPackage.java should be included.");
        }
        arrayList.clear();
        arrayList.add(this.fileA.getParent());
        buildConfiguration.includeFiles(arrayList);
        this.waitForJobsToComplete(this.ajProject);
        if (!buildConfiguration.isIncluded((IResource)this.fileA)) {
            BuildConfiguratorTest.fail((String)"Include failed. A.java is not included.");
        }
        if (!buildConfiguration.isIncluded((IResource)this.fileB)) {
            BuildConfiguratorTest.fail((String)"Include failed. B.java is not included.");
        }
        if (!buildConfiguration.isIncluded((IResource)this.fileDef)) {
            BuildConfiguratorTest.fail((String)"Include failed. InDefaultPackage.java is not included.");
        }
    }

    public void testNatureConversion() throws CoreException {
        BuildConfiguration buildConfiguration;
        BuildConfigurator buildConfigurator = BuildConfigurator.getBuildConfigurator();
        AJDTUtils.removeAspectJNature(this.ajProject);
        this.waitForJobsToComplete(this.ajProject);
        ProjectBuildConfigurator projectBuildConfigurator = buildConfigurator.getProjectBuildConfigurator(this.ajProject);
        if (projectBuildConfigurator != null) {
            AJDTUtils.addAspectJNature(this.ajProject);
            BuildConfiguratorTest.fail((String)"could obtain pbc despite of removed aj nature");
        }
        IResource[] iResourceArray = this.ajProject.members();
        for (int i = 0; i < iResourceArray.length; ++i) {
            if (!iResourceArray[i].getName().endsWith("ajproperties")) continue;
            iResourceArray[i].delete(true, null);
        }
        IJavaProject iJavaProject = JavaCore.create((IProject)this.ajProject);
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        for (int i = 0; i < iClasspathEntryArray.length; ++i) {
            if (!iClasspathEntryArray[i].getPath().equals(this.fileDef.getParent().getFullPath())) continue;
            IPath[] iPathArray = new IPath[]{this.fileA.getFullPath().removeFirstSegments(iClasspathEntryArray[i].getPath().matchingFirstSegments(this.fileA.getFullPath()))};
            iClasspathEntryArray[i] = JavaCore.newSourceEntry((IPath)iClasspathEntryArray[i].getPath(), (IPath[])iPathArray);
        }
        iJavaProject.setRawClasspath(iClasspathEntryArray, null);
        AJDTUtils.addAspectJNature(this.ajProject);
        this.waitForJobsToComplete(this.ajProject);
        projectBuildConfigurator = buildConfigurator.getProjectBuildConfigurator(this.ajProject);
        if (projectBuildConfigurator == null) {
            BuildConfiguratorTest.fail((String)"No ProjectBuildConfigurator was created after adding aj nature.");
        }
        if ((buildConfiguration = projectBuildConfigurator.getActiveBuildConfiguration()) == null) {
            BuildConfiguratorTest.fail((String)"No active build configuration was created when added aj nature to project.");
        }
        this.waitForJobsToComplete(this.ajProject);
        if (buildConfiguration.isIncluded((IResource)this.fileA)) {
            BuildConfiguratorTest.fail((String)"jdt exclusion filter not taken into account when converted to aj project.");
        }
        if (!buildConfiguration.isIncluded((IResource)this.fileDef) || !buildConfiguration.isIncluded((IResource)this.fileB)) {
            BuildConfiguratorTest.fail((String)"not all desired files included after conversion to aj project.");
        }
        if (!buildConfiguration.getFile().exists()) {
            BuildConfiguratorTest.fail((String)"New build configuration was created when adding aj nature, but file not written.");
        }
        iJavaProject.getRawClasspath();
        iClasspathEntryArray = iJavaProject.getRawClasspath();
        for (int i = 0; i < iClasspathEntryArray.length; ++i) {
            if (!iClasspathEntryArray[i].getPath().equals(this.fileDef.getParent().getFullPath()) || iClasspathEntryArray[i].getExclusionPatterns().length <= 0) continue;
            BuildConfiguratorTest.fail((String)"Exclusion patterns not reset when converting to aj project.");
        }
    }

    private void waitForJobsToComplete(IProject iProject) {
        Job job = new Job("Dummy Job"){

            public IStatus run(IProgressMonitor iProgressMonitor) {
                return Status.OK_STATUS;
            }
        };
        job.setPriority(50);
        job.setRule((ISchedulingRule)iProject);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

