/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.ITypeNameRequestor;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.launching.JavaRuntime;
import org.osgi.framework.Bundle;

public class TestProject {
    private IProject project;
    private IJavaProject javaProject;
    private IPackageFragmentRoot sourceFolder;
    private boolean disposeDone = false;

    public TestProject() throws CoreException {
        this("TestProject", "bin", true);
    }

    public TestProject(String string) throws CoreException {
        this(string, "bin", true);
    }

    public TestProject(String string, boolean bl) throws CoreException {
        this(string, "bin", bl);
    }

    public TestProject(String string, String string2) throws CoreException {
        this(string, string2, true);
    }

    public TestProject(String string, String string2, boolean bl) throws CoreException {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.project = iWorkspaceRoot.getProject(string);
        this.project.create(null);
        this.project.open(null);
        this.javaProject = JavaCore.create((IProject)this.project);
        this.setJavaNature();
        IFolder iFolder = this.createOutputFolder(string2);
        this.javaProject.setRawClasspath(new IClasspathEntry[0], null);
        this.createOutputFolder(iFolder);
        if (bl) {
            this.addSystemLibraries();
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public void addJar(String string, String string2) throws MalformedURLException, IOException, JavaModelException {
        Path path = this.findFileInPlugin(string, string2);
        IClasspathEntry[] iClasspathEntryArray = this.javaProject.getRawClasspath();
        IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[iClasspathEntryArray.length + 1];
        System.arraycopy(iClasspathEntryArray, 0, iClasspathEntryArray2, 0, iClasspathEntryArray.length);
        iClasspathEntryArray2[iClasspathEntryArray.length] = JavaCore.newLibraryEntry((IPath)path, null, null);
        this.javaProject.setRawClasspath(iClasspathEntryArray2, null);
    }

    public IPackageFragment createPackage(String string) throws CoreException {
        if (this.sourceFolder == null) {
            this.sourceFolder = this.createSourceFolder();
        }
        return this.sourceFolder.createPackageFragment(string, false, null);
    }

    public IType createType(IPackageFragment iPackageFragment, String string, String string2) throws JavaModelException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package " + iPackageFragment.getElementName() + ";\n");
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        ICompilationUnit iCompilationUnit = iPackageFragment.createCompilationUnit(string, stringBuffer.toString(), false, null);
        return iCompilationUnit.getTypes()[0];
    }

    public IPackageFragmentRoot getSourceFolder() throws CoreException {
        if (this.sourceFolder == null) {
            this.sourceFolder = this.createSourceFolder();
        }
        return this.sourceFolder;
    }

    public IFolder createFolder(IPackageFragmentRoot iPackageFragmentRoot, String string) throws JavaModelException, CoreException {
        IFolder iFolder = (IFolder)iPackageFragmentRoot.getCorrespondingResource();
        IFolder iFolder2 = iFolder.getFolder(string);
        iFolder2.create(true, true, null);
        return iFolder2;
    }

    public IFile createFile(IFolder iFolder, String string, String string2) throws CoreException {
        IFile iFile = iFolder.getFile(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        iFile.create((InputStream)byteArrayInputStream, true, null);
        return iFile;
    }

    public synchronized void dispose() throws CoreException {
        this.waitForIndexer();
        this.disposeDone = false;
        this.project.delete(true, true, new IProgressMonitor(){

            public void done() {
                TestProject.this.disposeDone();
            }

            public void beginTask(String string, int n) {
            }

            public void internalWorked(double d) {
            }

            public boolean isCanceled() {
                return false;
            }

            public void setCanceled(boolean bl) {
            }

            public void setTaskName(String string) {
            }

            public void subTask(String string) {
            }

            public void worked(int n) {
            }
        });
        try {
            if (!this.disposeDone) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void disposeDone() {
        this.disposeDone = true;
        this.notify();
    }

    private IFolder createOutputFolder(String string) throws CoreException {
        IFolder iFolder = this.project.getFolder(string);
        try {
            if (!iFolder.exists()) {
                iFolder.create(false, true, null);
            }
        }
        catch (ResourceException resourceException) {
            resourceException.printStackTrace();
        }
        return iFolder;
    }

    private void setJavaNature() throws CoreException {
        IProjectDescription iProjectDescription = this.project.getDescription();
        iProjectDescription.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
        this.project.setDescription(iProjectDescription, null);
    }

    private void createOutputFolder(IFolder iFolder) throws JavaModelException {
        IPath iPath = iFolder.getFullPath();
        this.javaProject.setOutputLocation(iPath, null);
    }

    private IPackageFragmentRoot createSourceFolder() throws CoreException {
        IFolder iFolder = this.project.getFolder("src");
        iFolder.create(false, true, null);
        IPackageFragmentRoot iPackageFragmentRoot = this.javaProject.getPackageFragmentRoot((IResource)iFolder);
        IClasspathEntry[] iClasspathEntryArray = this.javaProject.getRawClasspath();
        IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[iClasspathEntryArray.length + 1];
        System.arraycopy(iClasspathEntryArray, 0, iClasspathEntryArray2, 0, iClasspathEntryArray.length);
        iClasspathEntryArray2[iClasspathEntryArray.length] = JavaCore.newSourceEntry((IPath)iPackageFragmentRoot.getPath());
        this.javaProject.setRawClasspath(iClasspathEntryArray2, null);
        return iPackageFragmentRoot;
    }

    private void addSystemLibraries() throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = this.javaProject.getRawClasspath();
        IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[iClasspathEntryArray.length + 1];
        System.arraycopy(iClasspathEntryArray, 0, iClasspathEntryArray2, 0, iClasspathEntryArray.length);
        iClasspathEntryArray2[iClasspathEntryArray.length] = JavaRuntime.getDefaultJREContainerEntry();
        this.javaProject.setRawClasspath(iClasspathEntryArray2, null);
    }

    private Path findFileInPlugin(String string, String string2) throws MalformedURLException, IOException {
        Bundle bundle = Platform.getBundle((String)string);
        URL uRL = bundle.getEntry("/");
        URL uRL2 = new URL(uRL, string2);
        URL uRL3 = Platform.asLocalURL((URL)uRL2);
        return new Path(uRL3.getPath());
    }

    private void waitForIndexer() throws JavaModelException {
        new SearchEngine().searchAllTypeNames(null, null, 0, 5, SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[0]), new ITypeNameRequestor(){

            public void acceptClass(char[] cArray, char[] cArray2, char[][] cArray3, String string) {
            }

            public void acceptInterface(char[] cArray, char[] cArray2, char[][] cArray3, String string) {
            }
        }, 3, null);
    }
}

