/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.tests;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.ajdt.buildconfigurator.Util;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class UtilTests
extends TestCase {
    String pwd;

    protected void setUp() throws Exception {
        super.setUp();
        String string = File.separator.concat("workspace").concat(File.separator).concat("org").concat(".").concat("eclipse").concat(".").concat("ajdt").concat(".").concat("test");
        String string2 = File.separator.concat("testsrc").concat(File.separator).concat("org").concat(File.separator).concat("eclipse").concat(File.separator).concat("ajdt").concat(File.separator).concat("buildconfigurator");
        this.pwd = System.getProperty("user.dir") + string + string2;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetRelativePathStringWithCommonRoot() {
        Path path = new Path("c:/my/dir");
        Path path2 = new Path("c:/my/src/foo/bar/MyClass.java");
        String string = Util.getRelativePathString((IPath)path2, (IPath)path);
        UtilTests.assertEquals((String)"../src/foo/bar/MyClass.java", (String)string);
    }

    public void testGetRelativePathStringNoCommonRoot() {
        Path path = new Path("c:/my/dir");
        Path path2 = new Path("c:/cat/in/the/hat/MyClass.java");
        String string = Util.getRelativePathString((IPath)path2, (IPath)path);
        UtilTests.assertEquals((String)"../../cat/in/the/hat/MyClass.java", (String)string);
    }

    public void testGetRelativePathStringWithSameHome() {
        Path path = new Path("c:/my/dir");
        Path path2 = new Path("c:/my/dir/MyClass.java");
        String string = Util.getRelativePathString((IPath)path2, (IPath)path);
        UtilTests.assertEquals((String)"MyClass.java", (String)string);
    }

    public void testGetRelativePathStringWithIdenticalPaths() {
        Path path = new Path("c:/warren/oates");
        Path path2 = new Path("c:/warren/oates");
        String string = Util.getRelativePathString((IPath)path2, (IPath)path);
        UtilTests.assertEquals((String)".", (String)string);
    }

    public void testGetRelativePathStringWithNullFile() {
        IPath iPath = null;
        Path path = new Path("c:/my/src/foo/bar/MyClass.java");
        String string = Util.getRelativePathString((IPath)path, iPath);
        UtilTests.assertNull((Object)string);
    }

    public void testGetRelativePathStringWithNullFromDir() {
        Path path = new Path("c:/my/dir");
        IPath iPath = null;
        String string = Util.getRelativePathString(iPath, (IPath)path);
        UtilTests.assertNull((Object)string);
    }

    public void testGetRelativePathStringWithStringCommonRoot() {
        String string = "c:/my/dir";
        String string2 = "c:/my/src/foo/bar/MyClass.java";
        String string3 = Util.getRelativePathString(string2, string);
        UtilTests.assertEquals((String)"../src/foo/bar/MyClass.java", (String)string3);
    }

    public void testGetRelativePathStringNoStringCommonRoot() {
        String string = "c:/my/dir";
        String string2 = "c:/cat/in/the/hat/MyClass.java";
        String string3 = Util.getRelativePathString(string2, string);
        UtilTests.assertEquals((String)"../../cat/in/the/hat/MyClass.java", (String)string3);
    }

    public void testGetRelativePathStringWithStringNullFile() {
        String string = null;
        String string2 = "c:/my/src/foo/bar/MyClass.java";
        String string3 = Util.getRelativePathString(string2, string);
        UtilTests.assertNull((Object)string3);
    }

    public void testGetRelativePathStringWithStringNullFromDir() {
        String string = "c:/my/dir";
        String string2 = null;
        String string3 = Util.getRelativePathString(string2, string);
        UtilTests.assertNull((Object)string3);
    }

    public void testGetRelativePathStringWithIdenticalStrings() {
        String string = "c:/warren/oates";
        String string2 = "c:/warren/oates";
        String string3 = Util.getRelativePathString(string2, string);
        UtilTests.assertEquals((String)".", (String)string3);
    }

    public void testGetRelativePathStringWithEmptyStrings() {
        String string = "";
        String string2 = "";
        String string3 = Util.getRelativePathString(string2, string);
        UtilTests.assertEquals((String)".", (String)string3);
    }

    public void testGetLstFileContentsNullFile() {
        IPath iPath = null;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        try {
            Util.getLstFileContents(iPath, arrayList, arrayList2, arrayList3);
            UtilTests.assertEquals((int)0, (int)arrayList.size());
            UtilTests.assertEquals((int)0, (int)arrayList2.size());
            UtilTests.assertEquals((int)0, (int)arrayList3.size());
        }
        catch (FileNotFoundException fileNotFoundException) {
            UtilTests.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetLstFileContentsNonExistentFile() {
        Path path = new Path("c:/made/up/file/name.lst");
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        try {
            Util.getLstFileContents((IPath)path, arrayList, arrayList2, arrayList3);
            UtilTests.fail((String)"Preceeding call should have thrown FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void testGetLstFileContentsFilesOnly() {
        Path path = new Path(new File(this.pwd, "filesonly.lst").getAbsolutePath());
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        try {
            Util.getLstFileContents((IPath)path, arrayList, arrayList2, arrayList3);
            UtilTests.assertEquals((int)18, (int)arrayList.size());
            UtilTests.assertEquals((int)0, (int)arrayList2.size());
            UtilTests.assertEquals((int)0, (int)arrayList3.size());
        }
        catch (FileNotFoundException fileNotFoundException) {
            UtilTests.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetLstFileContentsFilesAndLinkOnly() {
        Path path = new Path(new File(this.pwd, "filesandlinks.lst").getAbsolutePath());
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        try {
            Util.getLstFileContents((IPath)path, arrayList, arrayList2, arrayList3);
            UtilTests.assertEquals((int)18, (int)arrayList.size());
            UtilTests.assertEquals((int)0, (int)arrayList2.size());
            UtilTests.assertEquals((int)1, (int)arrayList3.size());
        }
        catch (FileNotFoundException fileNotFoundException) {
            UtilTests.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetLstFileOptionsOnly() {
        Path path = new Path(new File(this.pwd, "optionsonly.lst").getAbsolutePath());
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        try {
            Util.getLstFileContents((IPath)path, arrayList, arrayList2, arrayList3);
            UtilTests.assertEquals((int)0, (int)arrayList.size());
            UtilTests.assertEquals((int)3, (int)arrayList2.size());
            UtilTests.assertEquals((int)0, (int)arrayList3.size());
        }
        catch (FileNotFoundException fileNotFoundException) {
            UtilTests.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetLstFileOptionsAndLinkOnly() {
        Path path = new Path(new File(this.pwd, "optionsandlink.lst").getAbsolutePath());
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        try {
            Util.getLstFileContents((IPath)path, arrayList, arrayList2, arrayList3);
            UtilTests.assertEquals((int)0, (int)arrayList.size());
            UtilTests.assertEquals((int)3, (int)arrayList2.size());
            UtilTests.assertEquals((int)1, (int)arrayList3.size());
        }
        catch (FileNotFoundException fileNotFoundException) {
            UtilTests.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetInlinedLstFileWithNoLinksFile() {
        Path path = new Path(new File(this.pwd, "filesonly.lst").getAbsolutePath());
        try {
            IPath iPath = Util.getInlinedLstFile((IPath)path);
            UtilTests.assertSame((String)"Should get input IPath returned", (Object)path, (Object)iPath);
        }
        catch (FileNotFoundException fileNotFoundException) {
            UtilTests.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetInlinedLstFileWithLinksFileAndAbsolutePath() {
        Path path = new Path(new File(this.pwd, "filesandabsolutelink.lst").getAbsolutePath());
        try {
            IPath iPath = Util.getInlinedLstFile((IPath)path);
            UtilTests.assertEquals((String)Util.getInlinedFileName(path.toString()), (String)iPath.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            UtilTests.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetInlinedLstFileWithLinksFileAndRelativePath() {
        Path path = new Path(new File(this.pwd, "filesandrelativelink.lst").getAbsolutePath());
        try {
            IPath iPath = Util.getInlinedLstFile((IPath)path);
            UtilTests.assertEquals((String)Util.getInlinedFileName(path.toString()), (String)iPath.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            UtilTests.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetInlinedLstFileWithNestedLinkFiles() {
        Path path = new Path(new File(this.pwd, "linkone.lst").getAbsolutePath());
        try {
            IPath iPath = Util.getInlinedLstFile((IPath)path);
            UtilTests.assertEquals((String)Util.getInlinedFileName(path.toString()), (String)iPath.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            UtilTests.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetInlinedLstFileWithBadLinkFile() {
        Path path = new Path(new File(this.pwd, "badlink.lst").getAbsolutePath());
        try {
            IPath iPath = Util.getInlinedLstFile((IPath)path);
            UtilTests.assertEquals((String)Util.getInlinedFileName(path.toString()), (String)iPath.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            UtilTests.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetInlinedLstFileWithNullInput() {
        try {
            IPath iPath = Util.getInlinedLstFile(null);
            UtilTests.assertNull((Object)iPath);
        }
        catch (FileNotFoundException fileNotFoundException) {
            UtilTests.fail((String)"Caught unexpected FileNotFoundException!");
        }
    }

    public void testGetInlinedLstFileWithNonExistentFileInput() {
        Path path = new Path(new File(this.pwd, "doesnotexist.lst").getAbsolutePath());
        try {
            IPath iPath = Util.getInlinedLstFile((IPath)path);
            UtilTests.fail((String)"Preceeding call should have thrown FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void testGetInlinedFileName() {
        String string = Util.getInlinedFileName("c:\\made\\up\\name.lst");
        UtilTests.assertEquals((String)"c:\\made\\up\\name.inlined.lst", (String)string);
    }
}

