/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.builder;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.BuildManager;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationshipMap;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.internal.ui.editor.AspectJContentOutlinePage;
import org.eclipse.ajdt.internal.ui.editor.AspectJEditor;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.ajdt.ui.visualiser.AJDTContentProvider;
import org.eclipse.ajdt.ui.visualiser.StructureModelUtil;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class Builder
extends IncrementalProjectBuilder {
    public static final String DEFAULT_CONFIG_FILE = ".generated.lst";
    private static final int CONFIG_FILE_WRITE_ERROR = -10;
    private static final int DEFAULT_TIMEOUT = 120;
    private static final String COMPILE_TIMEOUT = "org.aspectj.ajdt.ui.compile-timeout";
    private static IProject lastBuiltProject = null;
    public static boolean isLocalBuild = false;
    private boolean buildCancelled = false;
    private BuildManager buildManager = null;
    private IProgressMonitor monitor;
    int totalnodes = 0;
    int totalrels = 0;

    public static IProject getLastBuildTarget() {
        return lastBuiltProject;
    }

    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        String string;
        if (AspectJPlugin.DEBUG_COMPILER) {
            System.err.println("Building at " + new Date().toString());
        }
        this.buildCancelled = false;
        IProject iProject = this.getProject();
        AspectJPlugin aspectJPlugin = AspectJPlugin.getDefault();
        aspectJPlugin.setCurrentProject(iProject);
        long l = System.currentTimeMillis();
        ProjectBuildConfigurator projectBuildConfigurator = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(iProject);
        if (projectBuildConfigurator != null && projectBuildConfigurator.fullBuildRequested()) {
            n = 6;
            projectBuildConfigurator.requestFullBuild(false);
        }
        String string2 = "The project cannot be built until its prerequisite " + iProject.getName() + " is built. Cleaning and rebuilding all projects is recommended";
        try {
            Object object;
            string = null;
            if (n == 9) {
                string = "AUTOBUILD";
            }
            if (n == 10) {
                string = "INCREMENTALBUILD";
            }
            if (n == 6) {
                string = "FULLBUILD";
            }
            String string3 = "";
            string3 = AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getIncrementalMode() ? "Incremental AspectJ compilation" : "Full AspectJ compilation";
            AJDTEventTrace.generalEvent("build: Kind=" + string + " Project=" + iProject.getName() + " Mode=" + string3);
            IResourceDelta iResourceDelta = this.getDelta(this.getProject());
            if (n != 6 && !this.sourceFilesChanged(iResourceDelta) && (iResourceDelta.getFlags() | 0x80000) == 0) {
                AJDTEventTrace.generalEvent("build: Examined delta - no source file changes");
                return null;
            }
            this.monitor = iProgressMonitor;
            AJDTEventTrace.build(iProject, AspectJPlugin.getBuildConfigurationFile(iProject), aspectJPlugin.getAjdtProjectProperties().getClasspath());
            ProjectProperties projectProperties = aspectJPlugin.getAjdtProjectProperties();
            List list = projectProperties.getProjectSourceFiles(iProject, ProjectProperties.ASPECTJ_SOURCE_FILTER);
            this.updateBuildConfigIfNecessary(iProject, list);
            IProject[] iProjectArray = this.getRequiredProjects(iProject);
            boolean bl = false;
            for (int i = 0; i < iProjectArray.length; ++i) {
                object = "The project cannot be built until its prerequisite " + iProjectArray[i].getName() + " is rebuilt. Cleaning and rebuilding all projects is recommended";
                if (!this.projectAlreadyMarked(iProject, (String)object)) continue;
                if (n == 6) {
                    projectProperties.clearMarkers(true);
                    CompilerMonitor.clearOtherProjectMarkers(iProject);
                } else {
                    projectProperties.clearMarkers(false);
                }
                this.markProject(iProject, (String)object);
                bl = true;
            }
            if (!bl) {
                if (n == 6) {
                    projectProperties.clearMarkers(true);
                    CompilerMonitor.clearOtherProjectMarkers(iProject);
                } else {
                    projectProperties.clearMarkers(false);
                }
            }
            AJDTUtils.changeProjectToClassDependencies(iProject);
            CompilerMonitor compilerMonitor = aspectJPlugin.getCompilerMonitor();
            if (n == 6) {
                object = JavaCore.create((IProject)iProject);
                if (object != null) {
                    this.cleanOutputFolders((IJavaProject)object);
                } else {
                    AJDTEventTrace.generalEvent("Unable to empty output folder on build all - why cant we find the IJavaProject?");
                }
                compilerMonitor.prepare(iProject, list, iProgressMonitor);
            } else {
                compilerMonitor.prepare(iProject, list, null);
            }
            lastBuiltProject = iProject;
            try {
                this.buildManager = Ajde.getDefault().getBuildManager();
                if (!AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getBuildAsm()) {
                    AJDTEventTrace.generalEvent("build: No structure model to be built for project: " + AspectJPlugin.getDefault().getCurrentProject().getName());
                    this.buildManager.setBuildModelMode(false);
                } else {
                    this.buildManager.setBuildModelMode(true);
                }
                if (n == 6) {
                    this.buildManager.buildFresh(this.getBuildFilePath(iProject));
                } else {
                    this.buildManager.build(this.getBuildFilePath(iProject));
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.waitForBuildCompletion(compilerMonitor);
            if (AspectJPlugin.getDefault().getDisplay().isDisposed()) {
                System.err.println("Not updating vis, display is disposed!");
            } else {
                AspectJPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (ProviderManager.getContentProvider() instanceof AJDTContentProvider) {
                            AJDTContentProvider aJDTContentProvider = (AJDTContentProvider)ProviderManager.getContentProvider();
                            aJDTContentProvider.reset();
                            VisualiserPlugin.refresh();
                        }
                    }
                });
            }
            if (this.buildCancelled) {
                this.markReferencingProjects(iProject, string2);
            } else {
                this.removeMarkerOnReferencingProjects(iProject, string2);
            }
            CompilerMonitor.showOutstandingProblems();
            if (!AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getBuildAsm()) {
                AspectJEditor.forceEditorUpdates(iProject);
            }
            StructureModelUtil.wipeCache();
            AspectJContentOutlinePage.performPendingAdviceMarkerUpdates();
            iProject.refreshLocal(2, null);
            AJDTEventTrace.generalEvent("build: build time = " + (System.currentTimeMillis() - l) + "ms");
        }
        catch (Throwable throwable) {
            Ajde.getDefault().getErrorHandler().handleError("Compile failed.", throwable);
        }
        string = null;
        return string;
    }

    private IProject[] getDependingProjects(IProject iProject) {
        int n;
        IProject[] iProjectArray = iProject.getReferencingProjects();
        IProject[] iProjectArray2 = AJDTUtils.getClassFolderDependingProjects(iProject);
        IProject[] iProjectArray3 = new IProject[iProjectArray.length + iProjectArray2.length];
        for (n = 0; n < iProjectArray.length; ++n) {
            iProjectArray3[n] = iProjectArray[n];
        }
        for (n = 0; n < iProjectArray2.length; ++n) {
            iProjectArray3[n + iProjectArray.length] = iProjectArray2[n];
        }
        return iProjectArray3;
    }

    private IProject[] getRequiredProjects(IProject iProject) {
        int n;
        IProject[] iProjectArray;
        try {
            iProjectArray = iProject.getReferencedProjects();
        }
        catch (CoreException coreException) {
            iProjectArray = new IProject[]{};
            coreException.printStackTrace();
        }
        IProject[] iProjectArray2 = AJDTUtils.getRequiredClassFolderProjects(iProject);
        IProject[] iProjectArray3 = new IProject[iProjectArray.length + iProjectArray2.length];
        for (n = 0; n < iProjectArray.length; ++n) {
            iProjectArray3[n] = iProjectArray[n];
        }
        for (n = 0; n < iProjectArray2.length; ++n) {
            iProjectArray3[n + iProjectArray.length] = iProjectArray2[n];
        }
        return iProjectArray3;
    }

    private void checkAndHandleCancelation() {
        if (this.monitor != null && this.buildManager != null && this.monitor.isCanceled()) {
            this.buildManager.abortBuild();
            this.buildCancelled = true;
        }
    }

    private void markReferencingProjects(IProject iProject, String string) {
        IProject[] iProjectArray = this.getDependingProjects(iProject);
        for (int i = 0; i < iProjectArray.length; ++i) {
            IProject iProject2 = iProjectArray[i];
            if (this.projectAlreadyMarked(iProject2, string)) continue;
            this.markProject(iProject2, string);
        }
    }

    private void markProject(IProject iProject, String string) {
        try {
            IMarker iMarker = iProject.createMarker("org.eclipse.core.resources.problemmarker");
            iMarker.setAttribute("message", (Object)string);
            iMarker.setAttribute("severity", 2);
        }
        catch (CoreException coreException) {
            AJDTEventTrace.generalEvent("build: Problem occured creating the error marker for project " + iProject.getName() + ": " + coreException.getStackTrace());
        }
    }

    private void removeMarkerOnReferencingProjects(IProject iProject, String string) {
        try {
            IProject[] iProjectArray = this.getDependingProjects(iProject);
            for (int i = 0; i < iProjectArray.length; ++i) {
                IProject iProject2 = iProjectArray[i];
                IMarker[] iMarkerArray = iProject2.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
                if (iMarkerArray.length <= 0) continue;
                for (int j = 0; j < iMarkerArray.length; ++j) {
                    IMarker iMarker = iMarkerArray[j];
                    int n = iMarker.getAttribute("severity", -1);
                    String string2 = iMarker.getAttribute("message", "no message");
                    if (n != 2 || !string2.equals(string)) continue;
                    iMarker.delete();
                }
            }
        }
        catch (CoreException coreException) {
            AJDTEventTrace.generalEvent("build: Problem occured either finding the markers for project " + iProject.getName() + ", or deleting the error marker: " + coreException.getStackTrace());
        }
    }

    private boolean projectAlreadyMarked(IProject iProject, String string) {
        try {
            IMarker[] iMarkerArray = iProject.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
            if (iMarkerArray.length > 0) {
                for (int i = 0; i < iMarkerArray.length; ++i) {
                    IMarker iMarker = iMarkerArray[i];
                    int n = iMarker.getAttribute("severity", -1);
                    String string2 = iMarker.getAttribute("message", "no message");
                    if (n != 2 || !string2.equals(string)) continue;
                    return true;
                }
            }
        }
        catch (CoreException coreException) {
            AJDTEventTrace.generalEvent("build: Problem occured finding the markers for project " + iProject.getName() + ": " + coreException.getStackTrace());
        }
        return false;
    }

    private void dumpStructureModel() {
        IHierarchy iHierarchy = AsmManager.getDefault().getHierarchy();
        if (null == iHierarchy) {
            AJDTEventTrace.generalEvent("build: no structure model !!");
            return;
        }
        this.totalnodes = 0;
        this.totalrels = 0;
        this.dumpModelHelper(0, iHierarchy.getRoot(), AsmManager.getDefault().getRelationshipMap());
        try {
            AJDTEventTrace.generalEvent("build: ProgramElements in ASM: " + this.totalnodes + (this.totalnodes == 1 ? "  (Probably just the .lst file)" : ""));
            AJDTEventTrace.generalEvent("build: Relationships in ASM: " + this.totalrels);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void dumpModelHelper(int n, IProgramElement iProgramElement, IRelationshipMap iRelationshipMap) {
        ++this.totalnodes;
        if (iProgramElement instanceof IProgramElement) {
            Object object;
            IProgramElement iProgramElement2 = iProgramElement;
            List list = iRelationshipMap.get(iProgramElement2);
            if (AspectJPlugin.DEBUG_BUILDER) {
                object = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    ((StringBuffer)object).append("-");
                }
                ((StringBuffer)object).append(">");
                ((StringBuffer)object).append(iProgramElement.toString());
                if (iProgramElement2.getSourceLocation() != null) {
                    ((StringBuffer)object).append("    ").append(iProgramElement2.getSourceLocation().getSourceFile());
                }
                AJDTEventTrace.generalEvent(((StringBuffer)object).toString());
            }
            if (list != null) {
                this.totalrels += list.size();
            }
            if (iProgramElement2.getChildren() != null) {
                object = iProgramElement2.getChildren().iterator();
                while (object.hasNext()) {
                    IProgramElement iProgramElement3 = (IProgramElement)object.next();
                    this.dumpModelHelper(n + 2, iProgramElement3, iRelationshipMap);
                }
            }
        } else {
            AJDTEventTrace.generalEvent("What the hell is this?" + iProgramElement);
        }
    }

    private boolean sourceFilesChanged(IResourceDelta iResourceDelta) {
        if (iResourceDelta == null) {
            return true;
        }
        String string = iResourceDelta.getFullPath().toString();
        if (string.endsWith(".java") || string.endsWith(".aj")) {
            return true;
        }
        if (string.endsWith(".lst") && !string.endsWith("/default.lst")) {
            return true;
        }
        boolean bl = false;
        IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
        for (int i = 0; !bl && i < iResourceDeltaArray.length; bl |= this.sourceFilesChanged(iResourceDeltaArray[i]), ++i) {
        }
        return bl;
    }

    private void waitForBuildCompletion(CompilerMonitor compilerMonitor) {
        int n = 0;
        int n2 = 120;
        IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
        if (iPreferenceStore.contains(COMPILE_TIMEOUT)) {
            n2 = iPreferenceStore.getInt(COMPILE_TIMEOUT);
        } else {
            iPreferenceStore.setValue(COMPILE_TIMEOUT, n2);
        }
        while (!compilerMonitor.finished() && n < n2) {
            ++n;
            try {
                this.checkAndHandleCancelation();
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        if (n == n2) {
            this.waitForBuildCompletion(compilerMonitor);
        }
    }

    private boolean continueCompilation(final CompilerMonitor compilerMonitor) {
        final String string = AspectJPlugin.getResourceString("suspiciouslyLongCompileDialog");
        final String string2 = AspectJPlugin.getResourceString("isYourProjectReallyBig");
        AspectJPlugin.getDefault().getDisplay().syncExec(new Runnable(){

            public void run() {
                IPreferenceStore iPreferenceStore;
                boolean bl = false;
                Shell[] shellArray = AspectJPlugin.getDefault().getDisplay().getShells();
                if (shellArray != null && shellArray.length > 0) {
                    iPreferenceStore = shellArray[0];
                    bl = MessageDialog.openQuestion((Shell)iPreferenceStore, (String)string, (String)string2);
                }
                if (bl) {
                    iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
                    int n = iPreferenceStore.getInt(Builder.COMPILE_TIMEOUT);
                    iPreferenceStore.setValue(Builder.COMPILE_TIMEOUT, n *= 2);
                } else {
                    compilerMonitor.finish();
                }
            }
        });
        return !compilerMonitor.finished();
    }

    private String getBuildFilePath(IProject iProject) {
        String string = AspectJPlugin.getBuildConfigurationFile(iProject);
        return string;
    }

    private void updateBuildConfigIfNecessary(IProject iProject, List list) throws CoreException {
        if (this.getBuildFilePath(iProject).endsWith(DEFAULT_CONFIG_FILE)) {
            this.writeBuildConfigFile(list, iProject);
        }
    }

    private void writeBuildConfigFile(List list, IProject iProject) throws CoreException {
        String string = this.getBuildFilePath(iProject);
        try {
            FileWriter fileWriter = new FileWriter(string);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            IResource iResource = list.iterator();
            while (iResource.hasNext()) {
                File file = (File)iResource.next();
                String string2 = file.toString();
                if (!string2.endsWith(".java") && !string2.endsWith(".aj")) continue;
                bufferedWriter.write(string2);
                bufferedWriter.write("\n");
            }
            bufferedWriter.flush();
            fileWriter.flush();
            bufferedWriter.close();
            iResource = iProject.findMember(DEFAULT_CONFIG_FILE);
            if (iResource != null) {
                iResource.refreshLocal(0, null);
            }
        }
        catch (Exception exception) {
            Status status = new Status(4, "org.eclipse.ajdt.ui", -10, AspectJPlugin.getResourceString("configFileCreateError"), (Throwable)exception);
            throw new CoreException((IStatus)status);
        }
    }

    protected void cleanOutputFolders(IJavaProject iJavaProject) throws CoreException {
        boolean bl = "clean".equals(iJavaProject.getOption("org.eclipse.jdt.core.builder.cleanOutputFolder", true));
        if (bl) {
            Object object;
            boolean bl2 = false;
            String string = null;
            IPath iPath = iJavaProject.getOutputLocation();
            if (iPath.segmentCount() == 1) {
                string = iJavaProject.getResource().getLocation().toOSString();
            } else {
                object = ResourcesPlugin.getWorkspace().getRoot().getFolder(iPath);
                bl2 = object.isLinked();
                string = object.getLocation().toOSString();
            }
            object = new File(string);
            int n = this.wipeClasses(((File)object).listFiles());
            AJDTEventTrace.generalEvent("Builder: Tidied output folder, deleted " + n + " .class files from " + string + (bl2 ? " (Linked output folder from " + iPath.toOSString() + ")" : ""));
        }
    }

    private int wipeClasses(File[] fileArray) {
        int n = 0;
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                if (file.getName().endsWith(".class")) {
                    file.delete();
                    ++n;
                }
                if (!file.isDirectory()) continue;
                n += this.wipeClasses(file.listFiles());
            }
        }
        return n;
    }
}

