/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core;

import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.aspectj.ajde.Ajde;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;

public class AJDTEventTrace {
    private static Vector listeners = new Vector();
    private static Vector eventTrace = new Vector();
    private static final int MAXENTRIES = 5000;
    private static final int EVT_STARTUP = 0;
    private static final int EVT_EDITOR_OPEN = 1;
    private static final int EVT_EDITOR_CLOSE = 2;
    private static final int EVT_CONFIG_SELECT = 3;
    private static final int EVT_STRUCTURE_VIEW = 4;
    private static final int EVT_MODEL_UPDATED = 5;
    private static final int EVT_BUILD = 6;
    private static final int EVT_VIEW_ACTION = 7;
    private static final int EVT_NEW_PROJECT = 8;
    private static final int EVT_NEW_CONFIG = 9;
    private static final int EVT_NEW_ASPECT = 10;
    private static final int EVT_NODE_CLICK = 11;
    private static final int EVT_PROJ_PROPS_CHANGED = 12;
    private static final int EVT_PROJ_PROPS_DEFAULTED = 13;
    private static final int EVT_BUILD_CONFIG_READ = 14;
    private static final int EVT_BUILD_CONFIG_WRITE = 15;
    private static final int EVT_GENERAL = 99999;

    public static void startup() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\tAJDT version: ");
        stringBuffer.append(AspectJPlugin.VERSION);
        stringBuffer.append("\n\tAspectJ Compiler version: ");
        stringBuffer.append(Ajde.getDefault().getVersion());
        IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
        String[] stringArray = AspectJPlugin.getDefault().getPluginPreferences().propertyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("\n\t");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" = ");
            stringBuffer.append(iPreferenceStore.getString(stringArray[i]));
        }
        AJDTEventTrace.addEvent(new Event(0, stringBuffer));
    }

    public static void generalEvent(String string) {
        AJDTEventTrace.addEvent(new Event(99999, string));
    }

    public static void editorOpened(IFile iFile) {
        AJDTEventTrace.addEvent(new Event(1, iFile.getName()));
    }

    public static void editorClosed(IFile iFile) {
        AJDTEventTrace.addEvent(new Event(2, iFile.getName()));
    }

    public static void buildConfigSelected(String string, IProject iProject) {
        AJDTEventTrace.addEvent(new Event(3, string, iProject.getName()));
    }

    public static void structureViewRequested(String string) {
        AJDTEventTrace.addEvent(new Event(4, string));
    }

    public static void modelUpdated(IFile iFile) {
        AJDTEventTrace.addEvent(new Event(5, iFile.getName()));
    }

    public static void build(IProject iProject, String string, String string2) {
        AJDTEventTrace.addEvent(new Event(6, new Object[]{iProject.getName(), string, string2}));
    }

    public static void outlineViewAction(String string, IFile iFile) {
        AJDTEventTrace.addEvent(new Event(7, string, iFile.getName()));
    }

    public static void newProjectCreated(IProject iProject) {
        AJDTEventTrace.addEvent(new Event(8, iProject.getName()));
    }

    public static void newConfigFileCreated(IFile iFile) {
        AJDTEventTrace.addEvent(new Event(9, iFile.getName()));
    }

    public static void newAspectCreated(IFile iFile) {
        AJDTEventTrace.addEvent(new Event(10, iFile.getName()));
    }

    public static void nodeClicked(String string, IMarker iMarker) {
        AJDTEventTrace.addEvent(new Event(11, string, iMarker));
    }

    public static void projectPropertiesChanged(IProject iProject) {
        AJDTEventTrace.addEvent(new Event(12, iProject.getName()));
    }

    public static void projectPropertiesDefaulted(IProject iProject) {
        AJDTEventTrace.addEvent(new Event(13, iProject.getName()));
    }

    public static void buildConfigRead(IFile iFile) {
        AJDTEventTrace.addEvent(new Event(14, iFile.getName()));
    }

    public static void buildConfigWrite(IFile iFile) {
        AJDTEventTrace.addEvent(new Event(15, iFile.getName()));
    }

    private static void addEvent(final Event event) {
        if (eventTrace.size() > 5000) {
            eventTrace.remove(0);
        }
        eventTrace.add(event);
        if (!listeners.isEmpty()) {
            AspectJPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Iterator iterator = listeners.iterator();
                    while (iterator.hasNext()) {
                        ((EventListener)iterator.next()).ajdtEvent(event);
                    }
                }
            });
        }
    }

    public static void addListener(EventListener eventListener) {
        listeners.add(eventListener);
        Iterator iterator = eventTrace.iterator();
        while (iterator.hasNext()) {
            eventListener.ajdtEvent((Event)iterator.next());
        }
    }

    public static void removeListener(EventListener eventListener) {
        listeners.remove(eventListener);
    }

    public static class Event {
        Date time;
        int eventCode;
        Object[] eventData;

        public Event(int n) {
            this.init(n, new Object[0]);
        }

        public Event(int n, Object object) {
            this.init(n, new Object[]{object});
        }

        public Event(int n, Object object, Object object2) {
            this.init(n, new Object[]{object, object2});
        }

        public Event(int n, Object[] objectArray) {
            this.init(n, objectArray);
        }

        private void init(int n, Object[] objectArray) {
            this.time = new Date();
            this.eventCode = n;
            this.eventData = objectArray != null ? objectArray : new Object[0];
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(DateFormat.getTimeInstance().format(this.time));
            stringBuffer.append("\t ");
            switch (this.eventCode) {
                case 0: {
                    stringBuffer.append("AJDT Plugin Startup\n");
                    stringBuffer.append(this.eventData[0]);
                    break;
                }
                case 1: {
                    stringBuffer.append("Editor opened on ");
                    stringBuffer.append(this.eventData[0]);
                    break;
                }
                case 2: {
                    stringBuffer.append("Editor closed - ");
                    stringBuffer.append(this.eventData[0]);
                    break;
                }
                case 3: {
                    stringBuffer.append("Configuration file ");
                    stringBuffer.append(this.eventData[0]);
                    stringBuffer.append(" selected for ");
                    stringBuffer.append(this.eventData[1]);
                    break;
                }
                case 4: {
                    stringBuffer.append("Structure view requested for ");
                    stringBuffer.append(this.eventData[0]);
                    break;
                }
                case 5: {
                    stringBuffer.append("Model update notification for ");
                    stringBuffer.append(this.eventData[0]);
                    break;
                }
                case 6: {
                    stringBuffer.append("Building ");
                    stringBuffer.append(this.eventData[0]);
                    stringBuffer.append(" with config ");
                    stringBuffer.append(this.eventData[1]);
                    stringBuffer.append(".\n\t\t CLASSPATH=");
                    stringBuffer.append(this.eventData[2]);
                    break;
                }
                case 7: {
                    stringBuffer.append("Outline view action triggered: ");
                    stringBuffer.append(this.eventData[0]);
                    stringBuffer.append(" for ");
                    stringBuffer.append(this.eventData[1]);
                    break;
                }
                case 8: {
                    stringBuffer.append("New project created: ");
                    stringBuffer.append(this.eventData[0]);
                    break;
                }
                case 9: {
                    stringBuffer.append("New config file created: ");
                    stringBuffer.append(this.eventData[0]);
                    break;
                }
                case 10: {
                    stringBuffer.append("New aspect file created: ");
                    stringBuffer.append(this.eventData[0]);
                    break;
                }
                case 11: {
                    stringBuffer.append("Tree node selected: ");
                    stringBuffer.append(this.eventData[0]);
                    stringBuffer.append(". Navigation target: ");
                    if (this.eventData[1] != null) {
                        IMarker iMarker = (IMarker)this.eventData[1];
                        stringBuffer.append(iMarker.getResource().getName());
                        stringBuffer.append(" line ");
                        try {
                            Integer n = (Integer)iMarker.getAttribute("lineNumber");
                            stringBuffer.append(n);
                        }
                        catch (Exception exception) {
                            stringBuffer.append("ERR");
                        }
                        break;
                    }
                    stringBuffer.append("<None>");
                    break;
                }
                case 12: {
                    stringBuffer.append("Compiler properties changed for project: ");
                    stringBuffer.append(this.eventData[0]);
                    break;
                }
                case 13: {
                    stringBuffer.append("Compiler properties reset to default for project: ");
                    stringBuffer.append(this.eventData[0]);
                    break;
                }
                case 14: {
                    stringBuffer.append("Build configuration file read: ");
                    stringBuffer.append(this.eventData[0]);
                    break;
                }
                case 15: {
                    stringBuffer.append("Build configuration file written: ");
                    stringBuffer.append(this.eventData[0]);
                    break;
                }
                case 99999: {
                    stringBuffer.append(this.eventData[0]);
                }
            }
            return stringBuffer.toString();
        }
    }

    public static interface EventListener {
        public void ajdtEvent(Event var1);
    }
}

