/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.aspectj.ajde.ui.AbstractIcon;
import org.aspectj.ajde.ui.IStructureViewNode;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.weaver.patterns.Pointcut;
import org.eclipse.ajdt.internal.core.AJDTStructureViewNodeAdapter;
import org.eclipse.ajdt.internal.core.resources.AJDTIcon;
import org.eclipse.ajdt.internal.core.resources.AspectJImages;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public class AJDTStructureViewNode
implements IStructureViewNode,
IAdaptable {
    private static final String JDT_IMPORTS_LABEL = "import declarations";
    private static final String FWD_INTRO_REL_NAME = "declares member on";
    private IStructureViewNode.Kind kind = IStructureViewNode.Kind.DECLARATION;
    private String relationshipName = null;
    private List children = new ArrayList();
    private AJDTIcon icon;
    private IProgramElement node;
    private IRelationship relationship = null;
    private AJDTStructureViewNode parent = null;
    private IMarker marker = null;
    private boolean computedCategory = false;
    private int category = 12;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    private AJDTStructureViewNode() {
    }

    public AJDTStructureViewNode(IRelationship iRelationship, AbstractIcon abstractIcon) {
        this.icon = (AJDTIcon)abstractIcon;
        this.kind = IStructureViewNode.Kind.RELATIONSHIP;
        this.relationshipName = iRelationship.getName() + (iRelationship.hasRuntimeTest() ? " (with runtime test)" : "");
        this.relationship = iRelationship;
    }

    public AJDTStructureViewNode(IProgramElement iProgramElement, AbstractIcon abstractIcon) {
        this.icon = (AJDTIcon)abstractIcon;
        this.kind = IStructureViewNode.Kind.LINK;
        this.node = iProgramElement;
    }

    public AJDTStructureViewNode(IProgramElement iProgramElement, AbstractIcon abstractIcon, List list) {
        this.children = list;
        this.icon = (AJDTIcon)abstractIcon;
        boolean bl = iProgramElement.getName().equals(JDT_IMPORTS_LABEL);
        if (bl) {
            this.icon = AspectJImages.JDT_IMPORT_CONTAINER;
        }
        this.kind = IStructureViewNode.Kind.DECLARATION;
        this.node = iProgramElement;
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AJDTStructureViewNode aJDTStructureViewNode = (AJDTStructureViewNode)iterator.next();
                aJDTStructureViewNode.setParent(this);
                if (!bl) continue;
                aJDTStructureViewNode.icon = AspectJImages.JDT_IMPORTED;
            }
        }
    }

    public AbstractIcon getIcon() {
        return this.icon;
    }

    public List getChildren() {
        return this.children;
    }

    public AJDTStructureViewNode getParent() {
        return this.parent;
    }

    public String getLabel() {
        String string = null;
        string = this.kind == IStructureViewNode.Kind.RELATIONSHIP ? this.relationshipName : (this.kind == IStructureViewNode.Kind.LINK ? this.node.toLinkLabelString() : this.node.toLabelString());
        return string;
    }

    private void setParent(AJDTStructureViewNode aJDTStructureViewNode) {
        this.parent = aJDTStructureViewNode;
    }

    public Object getAdapter(Class clazz) {
        if (clazz == (class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = AJDTStructureViewNode.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) {
            return AJDTStructureViewNodeAdapter.getDefault();
        }
        return null;
    }

    public IMarker getMarker(IProject iProject) {
        IResource iResource;
        ISourceLocation iSourceLocation;
        if (this.marker != null) {
            return this.marker;
        }
        IProgramElement iProgramElement = this.node;
        if (iProgramElement != null && (iSourceLocation = iProgramElement.getSourceLocation()) != null && iSourceLocation.getSourceFile().getAbsolutePath() != null && (iResource = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(iSourceLocation.getSourceFile().getAbsolutePath(), iProject)) != null) {
            try {
                this.marker = iResource.createMarker("org.eclipse.core.resources.marker");
                this.marker.setAttribute("lineNumber", iSourceLocation.getLine());
                this.marker.setAttribute("charStart", iSourceLocation.getColumn());
            }
            catch (CoreException coreException) {
                System.err.println((Object)coreException);
                AspectJPlugin.getDefault().getLog().log(coreException.getStatus());
            }
        }
        return this.marker;
    }

    public void add(IStructureViewNode iStructureViewNode) {
        this.children.add(iStructureViewNode);
        ((AJDTStructureViewNode)iStructureViewNode).setParent(this);
    }

    public void remove(IStructureViewNode iStructureViewNode) {
        this.children.remove(iStructureViewNode);
    }

    public int category() {
        if (!this.computedCategory) {
            this.computedCategory = true;
            if (this.node instanceof IProgramElement) {
                IProgramElement iProgramElement = this.node;
                IProgramElement.Kind kind = iProgramElement.getKind();
                if (kind.equals(IProgramElement.Kind.PACKAGE)) {
                    this.category = 0;
                } else if (kind.equals(IProgramElement.Kind.CLASS)) {
                    this.category = 2;
                } else if (kind.equals(IProgramElement.Kind.INTERFACE)) {
                    this.category = 3;
                } else if (kind.equals(IProgramElement.Kind.ASPECT)) {
                    this.category = 4;
                } else if (kind.equals(IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR)) {
                    this.category = 5;
                } else if (kind.equals(IProgramElement.Kind.INTER_TYPE_FIELD)) {
                    this.category = 5;
                } else if (kind.equals(IProgramElement.Kind.INTER_TYPE_METHOD)) {
                    this.category = 5;
                } else if (kind.equals(IProgramElement.Kind.POINTCUT)) {
                    this.category = 7;
                } else if (kind.equals(IProgramElement.Kind.DECLARE_ERROR) || kind.equals(IProgramElement.Kind.DECLARE_WARNING) || kind.equals(IProgramElement.Kind.DECLARE_PARENTS) || kind.equals(IProgramElement.Kind.DECLARE_SOFT)) {
                    this.category = 8;
                } else if (kind.equals(IProgramElement.Kind.ADVICE)) {
                    this.category = 9;
                } else if (kind.equals(IProgramElement.Kind.FIELD)) {
                    this.category = 6;
                } else if (kind.equals(IProgramElement.Kind.CONSTRUCTOR)) {
                    this.category = 10;
                } else if (kind.equals(IProgramElement.Kind.METHOD)) {
                    this.category = 11;
                }
            }
            if (this.getLabel().equals(JDT_IMPORTS_LABEL)) {
                this.category = 1;
            }
        }
        return this.category;
    }

    public boolean isPublic() {
        IProgramElement iProgramElement;
        IProgramElement.Accessibility accessibility;
        boolean bl = true;
        if (this.node instanceof IProgramElement && (accessibility = (iProgramElement = this.node).getAccessibility()) != null && !accessibility.equals(IProgramElement.Accessibility.PUBLIC)) {
            bl = false;
        }
        return bl;
    }

    public void add(IStructureViewNode iStructureViewNode, int n) {
        this.children.add(n, iStructureViewNode);
        ((AJDTStructureViewNode)iStructureViewNode).setParent(this);
    }

    public IStructureViewNode.Kind getKind() {
        return this.kind;
    }

    public String getRelationshipName() {
        return this.relationshipName;
    }

    public IProgramElement getStructureNode() {
        return this.node;
    }

    public Object getRelationshipsSource() {
        return this;
    }

    public Collection getRelationships() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            AJDTStructureViewNode aJDTStructureViewNode = (AJDTStructureViewNode)iterator.next();
            if (aJDTStructureViewNode.kind != IStructureViewNode.Kind.RELATIONSHIP) continue;
            arrayList.add(new AJDTNodeRelationship(aJDTStructureViewNode));
        }
        if (this.node.getKind() == IProgramElement.Kind.POINTCUT) {
            arrayList.add(new AJDTPointcutMatcher(this));
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class AJDTPointcutMatcher {
        private AJDTStructureViewNode anchor = null;

        public AJDTPointcutMatcher(AJDTStructureViewNode aJDTStructureViewNode) {
            this.anchor = aJDTStructureViewNode;
        }

        public String getName() {
            return "matches";
        }

        public Iterator getAssociates() {
            ArrayList<AJDTStructureViewNode> arrayList = new ArrayList<AJDTStructureViewNode>();
            arrayList.add(this.anchor);
            return arrayList.iterator();
        }

        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
            Pointcut pointcut = Pointcut.fromString((String)"execution(* *(..))");
            pointcut.toString();
        }
    }

    static class AJDTNodeRelationship {
        private AJDTStructureViewNode anchor = null;

        public AJDTNodeRelationship(AJDTStructureViewNode aJDTStructureViewNode) {
            this.anchor = aJDTStructureViewNode;
        }

        public String getName() {
            return this.anchor.relationshipName;
        }

        public Iterator getAssociates() {
            return this.anchor.children.iterator();
        }
    }

    public static interface Category {
        public static final int PACKAGE = 0;
        public static final int IMPORTS = 1;
        public static final int CLASS = 2;
        public static final int INTERFACE = 3;
        public static final int ASPECT = 4;
        public static final int INTRODUCTION = 5;
        public static final int FIELD = 6;
        public static final int POINTCUT = 7;
        public static final int DECLARATION = 8;
        public static final int ADVICE = 9;
        public static final int CONSTRUCTOR = 10;
        public static final int METHOD = 11;
        public static final int OTHER = 12;
    }
}

