/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core;

import java.util.List;
import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.IMessage;
import org.eclipse.ajdt.internal.core.AJDTStructureViewNode;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.core.resources.AJDTIcon;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class AJDTStructureViewNodeAdapter
implements IWorkbenchAdapter {
    private static AJDTStructureViewNodeAdapter instance = null;

    public static AJDTStructureViewNodeAdapter getDefault() {
        if (instance == null) {
            instance = new AJDTStructureViewNodeAdapter();
        }
        return instance;
    }

    private AJDTStructureViewNodeAdapter() {
    }

    public Object[] getChildren(Object object) {
        if (object instanceof AJDTStructureViewNode) {
            AJDTStructureViewNode aJDTStructureViewNode = (AJDTStructureViewNode)object;
            return aJDTStructureViewNode.getChildren().toArray();
        }
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        ImageDescriptor imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        if (object instanceof AJDTStructureViewNode) {
            AJDTStructureViewNode aJDTStructureViewNode = (AJDTStructureViewNode)object;
            ImageDescriptor imageDescriptor2 = ((AJDTIcon)aJDTStructureViewNode.getIcon()).getImageDescriptor();
            imageDescriptor = this.decorate(imageDescriptor2, aJDTStructureViewNode);
        }
        return imageDescriptor;
    }

    public String getLabel(Object object) {
        String string = "<>";
        if (object instanceof AJDTStructureViewNode) {
            AJDTStructureViewNode aJDTStructureViewNode = (AJDTStructureViewNode)object;
            string = aJDTStructureViewNode.getLabel();
        }
        return string;
    }

    public Object getParent(Object object) {
        if (object instanceof AJDTStructureViewNode) {
            AJDTStructureViewNode aJDTStructureViewNode = (AJDTStructureViewNode)object;
            return aJDTStructureViewNode.getParent();
        }
        return null;
    }

    private ImageDescriptor decorate(ImageDescriptor imageDescriptor, AJDTStructureViewNode aJDTStructureViewNode) {
        int n = 0;
        IProgramElement iProgramElement = aJDTStructureViewNode.getStructureNode();
        if (iProgramElement != null) {
            IMessage iMessage;
            List list = iProgramElement.getModifiers();
            if (list != null) {
                if (list.contains(IProgramElement.Modifiers.ABSTRACT)) {
                    n |= 1;
                }
                if (list.contains(IProgramElement.Modifiers.FINAL)) {
                    n |= 2;
                }
                if (list.contains(IProgramElement.Modifiers.SYNCHRONIZED)) {
                    n |= 4;
                }
                if (list.contains(IProgramElement.Modifiers.STATIC)) {
                    n |= 8;
                }
            }
            if (iProgramElement.getKind() == IProgramElement.Kind.CONSTRUCTOR || iProgramElement.getKind() == IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR) {
                n |= 0x200;
            }
            if (iProgramElement.isRunnable()) {
                n |= 0x10;
            }
            if (iProgramElement.isOverrider()) {
                n |= 0x80;
            }
            if (iProgramElement.isImplementor()) {
                n |= 0x100;
            }
            if ((iMessage = iProgramElement.getMessage()) != null) {
                if (iMessage.getKind() == IMessage.ERROR) {
                    n |= 0x40;
                } else if (iMessage.getKind() == IMessage.WARNING) {
                    n |= 0x20;
                }
            }
        }
        return AJDTUtils.decorate(imageDescriptor, n);
    }
}

