/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.AJDTConfigSettings;
import org.eclipse.ajdt.internal.ui.dialogs.MessageDialogWithToggle;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.internal.ui.wizards.AJDTPrefConfigWizard;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AJDTUtils {
    private static final Point SMALL_SIZE = new Point(16, 16);
    private static final Point BIG_SIZE = new Point(22, 16);
    private static final int SMALL_ICONS_MASK = 32;
    private static Hashtable imageDescriptorCache = new Hashtable();
    private static boolean myEclipseMessageDisplayed = false;

    public static String getWorkspacePath() {
        return AspectJPlugin.getWorkspace().getRoot().getLocation().toOSString();
    }

    public static String getProjectRootDirectory(IProject iProject) {
        return iProject.getLocation().toOSString();
    }

    public static String getResourcePath(IResource iResource) {
        return iResource.getLocation().toOSString();
    }

    public static ImageDescriptor decorate(ImageDescriptor imageDescriptor, int n) {
        Point point = AJDTUtils.useSmallSize(n) ? SMALL_SIZE : BIG_SIZE;
        String string = new String(imageDescriptor.toString() + ":::" + n + ":::" + point.toString());
        if (imageDescriptorCache.get(string) != null) {
            return (ImageDescriptor)imageDescriptorCache.get(string);
        }
        JavaElementImageDescriptor javaElementImageDescriptor = new JavaElementImageDescriptor(imageDescriptor, n, point);
        imageDescriptorCache.put(string, javaElementImageDescriptor);
        return javaElementImageDescriptor;
    }

    private static boolean useSmallSize(int n) {
        return (n & 0x20) != 0;
    }

    public static void addAjrtToBuildPath(IProject iProject) {
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        try {
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
            IClasspathEntry iClasspathEntry = JavaCore.newVariableEntry((IPath)new Path("ASPECTJRT_LIB"), null, null);
            int n = iClasspathEntryArray.length;
            IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[n + 1];
            System.arraycopy(iClasspathEntryArray, 0, iClasspathEntryArray2, 0, n);
            iClasspathEntryArray2[n] = iClasspathEntry;
            iJavaProject.setRawClasspath(iClasspathEntryArray2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
    }

    public static void addAspectJNature(IProject iProject) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        String[] stringArray = iProjectDescription.getNatureIds();
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        stringArray2[0] = "org.eclipse.ajdt.ui.ajnature";
        iProjectDescription.setNatureIds(stringArray2);
        iProject.setDescription(iProjectDescription, null);
        if (iProject.hasNature("org.eclipse.pde.PluginNature")) {
            AJDTUtils.addAJPluginDependency(iProject);
        } else {
            AJDTUtils.addAjrtToBuildPath(iProject);
        }
        AJDTUtils.changeProjectToClassDependencies(iProject);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                AJDTUtils.verifyWorkbenchConfiguration();
            }
        });
        BuildConfigurator.getBuildConfigurator().setup(iProject);
        AJDTUtils.checkMyEclipseNature(iProject);
    }

    public static void checkMyEclipseNature(IProject iProject) {
        try {
            if ((iProject.hasNature("com.genuitec.eclipse.j2eedt.core.webnature") || iProject.hasNature("com.genuitec.eclipse.j2eedt.core.ejbnature")) && !myEclipseMessageDisplayed) {
                myEclipseMessageDisplayed = true;
                IWorkbenchWindow iWorkbenchWindow = AspectJPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                MessageDialog.openInformation((Shell)iWorkbenchWindow.getShell(), (String)AspectJPlugin.getResourceString("myEclipse.natureDetected.title"), (String)AspectJPlugin.getResourceString("myEclipse.natureDetected.message"));
            }
        }
        catch (CoreException coreException) {
            AspectJPlugin.logException(coreException);
        }
    }

    public static void changeProjectToClassDependencies(IProject iProject) {
        List list = AJDTUtils.getOutputLocationPaths(iProject);
        if (list.size() == 0) {
            return;
        }
        IProject[] iProjectArray = iProject.getReferencingProjects();
        for (int i = 0; i < iProjectArray.length; ++i) {
            IProject iProject2 = iProjectArray[i];
            try {
                if (!iProject2.hasNature("org.eclipse.jdt.core.javanature")) {
                    continue;
                }
            }
            catch (CoreException coreException) {
                AspectJPlugin.logException(coreException);
            }
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject2);
            if (iJavaProject == null) continue;
            try {
                IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
                ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
                for (int j = 0; j < iClasspathEntryArray.length; ++j) {
                    IClasspathEntry iClasspathEntry = iClasspathEntryArray[j];
                    int n = iClasspathEntry.getEntryKind();
                    IPath iPath = iClasspathEntry.getPath();
                    if (n == 2 && iPath.equals(iProject.getFullPath())) {
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            IPath iPath2 = (IPath)iterator.next();
                            IClasspathEntry iClasspathEntry2 = JavaCore.newLibraryEntry((IPath)iPath2, null, null);
                            arrayList.add(iClasspathEntry2);
                        }
                        continue;
                    }
                    arrayList.add(iClasspathEntry);
                }
                IClasspathEntry[] iClasspathEntryArray2 = arrayList.toArray(new IClasspathEntry[arrayList.size()]);
                iJavaProject.setRawClasspath(iClasspathEntryArray2, (IProgressMonitor)new NullProgressMonitor());
                continue;
            }
            catch (JavaModelException javaModelException) {
                javaModelException.printStackTrace();
            }
        }
    }

    private static List getOutputLocationPaths(IProject iProject) {
        ArrayList<IPath> arrayList = new ArrayList<IPath>();
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        if (iJavaProject == null) {
            return arrayList;
        }
        try {
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
            for (int i = 0; i < iClasspathEntryArray.length; ++i) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[i];
                int n = iClasspathEntry.getContentKind();
                if (n != 10 || iClasspathEntry.getOutputLocation() == null) continue;
                arrayList.add(iClasspathEntry.getOutputLocation());
            }
            if (arrayList.size() == 0) {
                arrayList.add(iJavaProject.getOutputLocation());
            }
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
        return arrayList;
    }

    private static void changeClassToProjectDependencies(IProject iProject) {
        List list = AJDTUtils.getOutputLocationPaths(iProject);
        if (list.size() == 0) {
            return;
        }
        IProject[] iProjectArray = AJDTUtils.getClassFolderDependingProjects(iProject);
        for (int i = 0; i < iProjectArray.length; ++i) {
            IProject iProject2 = iProjectArray[i];
            JavaProject javaProject = (JavaProject)JavaCore.create((IProject)iProject2);
            if (javaProject == null) continue;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IPath iPath = (IPath)iterator.next();
                try {
                    IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                    ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
                    for (int j = 0; j < iClasspathEntryArray.length; ++j) {
                        IClasspathEntry iClasspathEntry = iClasspathEntryArray[j];
                        int n = iClasspathEntry.getEntryKind();
                        IPath iPath2 = iClasspathEntry.getPath();
                        if (n == 1 && iPath2.equals(iPath)) {
                            IClasspathEntry iClasspathEntry2 = JavaCore.newProjectEntry((IPath)iProject.getFullPath());
                            arrayList.add(iClasspathEntry2);
                            continue;
                        }
                        arrayList.add(iClasspathEntry);
                    }
                    IClasspathEntry[] iClasspathEntryArray2 = arrayList.toArray(new IClasspathEntry[arrayList.size()]);
                    javaProject.setRawClasspath(iClasspathEntryArray2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (JavaModelException javaModelException) {
                    javaModelException.printStackTrace();
                }
            }
        }
    }

    public static IProject[] getClassFolderDependingProjects(IProject iProject) {
        IProject[] iProjectArray = AspectJPlugin.getWorkspace().getRoot().getProjects();
        List list = AJDTUtils.getOutputLocationPaths(iProject);
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        block4: for (int i = 0; i < iProjectArray.length; ++i) {
            if (!iProjectArray[i].isOpen()) continue;
            try {
                JavaProject javaProject;
                if (!iProjectArray[i].hasNature("org.eclipse.jdt.core.javanature") || (javaProject = (JavaProject)JavaCore.create((IProject)iProjectArray[i])) == null) continue;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    IPath iPath = (IPath)iterator.next();
                    try {
                        IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                        for (int j = 0; j < iClasspathEntryArray.length; ++j) {
                            IClasspathEntry iClasspathEntry = iClasspathEntryArray[j];
                            int n = iClasspathEntry.getEntryKind();
                            IPath iPath2 = iClasspathEntry.getPath();
                            if (n != 1 || !iPath2.equals(iPath)) continue;
                            arrayList.add(iProjectArray[i]);
                            continue block4;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        javaModelException.printStackTrace();
                        continue block4;
                    }
                }
                continue;
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
        IProject[] iProjectArray2 = arrayList.toArray(new IProject[0]);
        return iProjectArray2;
    }

    public static IProject[] getRequiredClassFolderProjects(IProject iProject) {
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        if (iJavaProject == null) {
            return new IProject[0];
        }
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        IProject[] iProjectArray = AspectJPlugin.getWorkspace().getRoot().getProjects();
        block4: for (int i = 0; i < iProjectArray.length; ++i) {
            try {
                if (!iProjectArray[i].isOpen()) continue;
                if (!iProjectArray[i].hasNature("org.eclipse.jdt.core.javanature")) {
                }
            }
            catch (CoreException coreException) {}
            continue;
            IProject iProject2 = iProjectArray[i];
            List list = AJDTUtils.getOutputLocationPaths(iProject2);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IPath iPath = (IPath)iterator.next();
                try {
                    IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
                    for (int j = 0; j < iClasspathEntryArray.length; ++j) {
                        IClasspathEntry iClasspathEntry = iClasspathEntryArray[j];
                        int n = iClasspathEntry.getEntryKind();
                        IPath iPath2 = iClasspathEntry.getPath();
                        if (n != 1 || !iPath2.equals(iPath)) continue;
                        arrayList.add(iProjectArray[i]);
                        continue block4;
                    }
                }
                catch (JavaModelException javaModelException) {
                    javaModelException.printStackTrace();
                    continue block4;
                }
            }
        }
        IProject[] iProjectArray2 = arrayList.toArray(new IProject[0]);
        return iProjectArray2;
    }

    private static void removeMarkerOnReferencingProjects(IProject iProject) {
        try {
            int n;
            String string = "The project cannot be built until its prerequisite " + iProject.getName() + " is rebuilt. Cleaning and rebuilding all projects is recommended";
            IProject[] iProjectArray = iProject.getReferencingProjects();
            IProject[] iProjectArray2 = AJDTUtils.getClassFolderDependingProjects(iProject);
            IProject[] iProjectArray3 = new IProject[iProjectArray.length + iProjectArray2.length];
            for (n = 0; n < iProjectArray.length; ++n) {
                iProjectArray3[n] = iProjectArray[n];
            }
            for (n = 0; n < iProjectArray2.length; ++n) {
                iProjectArray3[n + iProjectArray.length] = iProjectArray2[n];
            }
            for (n = 0; n < iProjectArray3.length; ++n) {
                IProject iProject2 = iProjectArray3[n];
                IMarker[] iMarkerArray = iProject2.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
                if (iMarkerArray.length <= 0) continue;
                for (int i = 0; i < iMarkerArray.length; ++i) {
                    IMarker iMarker = iMarkerArray[i];
                    int n2 = iMarker.getAttribute("severity", -1);
                    String string2 = iMarker.getAttribute("message", "no message");
                    if (n2 != 2 || !string2.equals(string)) continue;
                    iMarker.delete();
                }
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    private static void addAJPluginDependency(IProject iProject) {
        IWorkbenchWindow iWorkbenchWindow = AspectJPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        boolean bl = false;
        if (AspectJPreferences.askPDEAutoImport() && AJDTUtils.confirmPDEAutoImport(iWorkbenchWindow) || AspectJPreferences.doPDEAutoImport()) {
            bl = true;
        }
        if (bl) {
            AJDTUtils.importRuntimePlugin(iProject);
        } else {
            MessageDialog.openWarning((Shell)iWorkbenchWindow.getShell(), (String)AspectJPlugin.getResourceString("NoAutoPluginImportDialog.title"), (String)AspectJPlugin.getResourceString("NoAutoPluginImportDialog.message"));
        }
    }

    private static void importRuntimePlugin(IProject iProject) {
        ManifestEditor manifestEditor = AJDTUtils.getPDEManifestEditor(iProject);
        if (manifestEditor != null) {
            IPluginModel iPluginModel = (IPluginModel)manifestEditor.getAggregateModel();
            try {
                AJDTUtils.addImportToPDEModel(iPluginModel, "org.aspectj.ajde");
                manifestEditor.doSave((IProgressMonitor)new NullProgressMonitor());
                iProject.build(6, "org.eclipse.ajdt.ui.ajbuilder", null, null);
            }
            catch (CoreException coreException) {
                AspectJPlugin.getDefault().getLog().log(coreException.getStatus());
                ErrorDialog.openError((Shell)AspectJPlugin.getDefault().getActiveWorkbenchWindow().getShell(), (String)AspectJPlugin.getResourceString("AutoPluginImportErrorDialog.title"), (String)AspectJPlugin.getResourceString("AutoPluginImportErrorDialog.message"), (IStatus)coreException.getStatus());
            }
        } else {
            AspectJPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ajdt.ui", 0, AspectJPlugin.getResourceString("AutoPluginImportDialog.noEditor.message"), null));
            MessageDialog.openError((Shell)AspectJPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AspectJPlugin.getResourceString("AutoPluginImportDialog.noEditor.title"), (String)AspectJPlugin.getResourceString("AutoPluginImportDialog.noEditor.message"));
        }
    }

    private static void addImportToPDEModel(IPluginModel iPluginModel, String string) throws CoreException {
        IPluginImport iPluginImport = iPluginModel.getPluginFactory().createImport();
        iPluginImport.setId(string);
        iPluginModel.getPluginBase().add(iPluginImport);
        IFile iFile = (IFile)iPluginModel.getUnderlyingResource();
        iFile.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    public static ManifestEditor getPDEManifestEditor(IProject iProject) {
        String string = PDECore.getDefault().getWorkspaceModelManager().getWorkspacePluginModel(iProject).getPluginBase().getId();
        ManifestEditor.openPluginEditor((String)string);
        ManifestEditor manifestEditor = null;
        IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        for (int i = 0; i < iEditorReferenceArray.length; ++i) {
            IEditorReference iEditorReference = iEditorReferenceArray[i];
            if (!iEditorReference.getId().equals("org.eclipse.pde.ui.manifestEditor") || !iEditorReference.getPartName().equals(string)) continue;
            IEditorReference iEditorReference2 = iEditorReference;
            manifestEditor = (ManifestEditor)iEditorReference2.getPart(true);
            break;
        }
        if (manifestEditor != null) {
            manifestEditor.setActivePage("dependencies");
        }
        return manifestEditor;
    }

    public static void verifyWorkbenchConfiguration() {
        boolean bl = true;
        if (AspectJPreferences.isAJDTPrefConfigDone()) {
            bl = false;
        }
        if (AJDTConfigSettings.isAnalyzeAnnotationsDisabled() && AJDTConfigSettings.isAspectJEditorDefault()) {
            bl = false;
        }
        if (bl) {
            AJDTPrefConfigWizard aJDTPrefConfigWizard = new AJDTPrefConfigWizard();
            aJDTPrefConfigWizard.init();
            WizardDialog wizardDialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)aJDTPrefConfigWizard);
            wizardDialog.open();
        }
    }

    public static void removeAspectJNature(IProject iProject) throws CoreException {
        AspectJPlugin aspectJPlugin = AspectJPlugin.getDefault();
        aspectJPlugin.setCurrentProject(iProject);
        aspectJPlugin.getAjdtProjectProperties().clearMarkers(true);
        IProjectDescription iProjectDescription = iProject.getDescription();
        String[] stringArray = iProjectDescription.getNatureIds();
        String[] stringArray2 = new String[stringArray.length - 1];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("org.eclipse.ajdt.ui.ajnature")) continue;
            if (n < stringArray2.length) {
                stringArray2[n++] = stringArray[i];
                continue;
            }
            stringArray2 = stringArray;
            break;
        }
        iProjectDescription.setNatureIds(stringArray2);
        iProject.setDescription(iProjectDescription, null);
        if (iProject.hasNature("org.eclipse.pde.PluginNature")) {
            AJDTUtils.removeAJPluginDependency(iProject);
        } else {
            AJDTUtils.removeAjrtFromBuildPath(iProject);
        }
        AJDTUtils.changeClassToProjectDependencies(iProject);
        AJDTUtils.removeMarkerOnReferencingProjects(iProject);
        BuildConfigurator.getBuildConfigurator().restoreJDTState(iProject);
    }

    private static void removeAJPluginDependency(IProject iProject) {
        ManifestEditor manifestEditor = AJDTUtils.getPDEManifestEditor(iProject);
        if (manifestEditor != null) {
            IPluginModel iPluginModel = (IPluginModel)manifestEditor.getAggregateModel();
            try {
                AJDTUtils.removeImportFromPDEModel(iPluginModel, "org.aspectj.ajde");
                manifestEditor.doSave((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                AspectJPlugin.getDefault().getLog().log(coreException.getStatus());
                ErrorDialog.openError((Shell)AspectJPlugin.getDefault().getActiveWorkbenchWindow().getShell(), (String)AspectJPlugin.getResourceString("AutoPluginRemoveErrorDialog.title"), (String)AspectJPlugin.getResourceString("AutoPluginRemoveErrorDialog.message"), (IStatus)coreException.getStatus());
            }
        } else {
            AspectJPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ajdt.ui", 0, AspectJPlugin.getResourceString("AutoPluginRemoveDialog.noEditor.message"), null));
            MessageDialog.openError((Shell)AspectJPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AspectJPlugin.getResourceString("AutoPluginRemoveDialog.noEditor.title"), (String)AspectJPlugin.getResourceString("AutoPluginRemoveDialog.noEditor.message"));
        }
    }

    private static void removeImportFromPDEModel(IPluginModel iPluginModel, String string) throws CoreException {
        IPluginImport[] iPluginImportArray = iPluginModel.getPluginBase().getImports();
        IPluginImport iPluginImport = null;
        for (int i = 0; i < iPluginImportArray.length; ++i) {
            IPluginImport iPluginImport2 = iPluginImportArray[i];
            if (!iPluginImport2.getId().equals(string)) continue;
            iPluginImport = iPluginImport2;
            break;
        }
        if (iPluginImport != null) {
            iPluginModel.getPluginBase().remove(iPluginImport);
        }
        IFile iFile = (IFile)iPluginModel.getUnderlyingResource();
        iFile.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void removeAjrtFromBuildPath(IProject iProject) {
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        try {
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
            ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
            for (int i = 0; i < iClasspathEntryArray.length; ++i) {
                IPath iPath = iClasspathEntryArray[i].getPath();
                if (iPath.toOSString().endsWith("ASPECTJRT_LIB") || iPath.toOSString().endsWith("aspectjrt.jar")) continue;
                arrayList.add(iClasspathEntryArray[i]);
            }
            if (iClasspathEntryArray.length != arrayList.size()) {
                IClasspathEntry[] iClasspathEntryArray2 = arrayList.toArray(new IClasspathEntry[arrayList.size()]);
                iJavaProject.setRawClasspath(iClasspathEntryArray2, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException javaModelException) {
            AJDTEventTrace.generalEvent(javaModelException.getMessage());
        }
    }

    public static void verifyAjrtVersion(IProject iProject) {
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        String string = AspectJPlugin.getDefault().getAjdtProjectProperties().getAspectjrtClasspath();
        try {
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
            ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
            boolean bl = false;
            for (int i = 0; i < iClasspathEntryArray.length; ++i) {
                IPath iPath = iClasspathEntryArray[i].getPath();
                if (iPath.toOSString().endsWith("aspectjrt.jar")) {
                    IClasspathEntry iClasspathEntry = JavaCore.newLibraryEntry((IPath)new Path(string), null, null);
                    arrayList.add(iClasspathEntry);
                    bl = true;
                    AJDTEventTrace.generalEvent("In project " + iProject.getName() + " - replacing " + iClasspathEntryArray[i].getPath() + " with " + iClasspathEntry.getPath());
                    continue;
                }
                arrayList.add(iClasspathEntryArray[i]);
            }
            if (bl) {
                IClasspathEntry[] iClasspathEntryArray2 = arrayList.toArray(new IClasspathEntry[arrayList.size()]);
                iJavaProject.setRawClasspath(iClasspathEntryArray2, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException javaModelException) {
            AJDTEventTrace.generalEvent(javaModelException.getMessage());
        }
    }

    private static boolean confirmPDEAutoImport(IWorkbenchWindow iWorkbenchWindow) {
        MessageDialogWithToggle messageDialogWithToggle = MessageDialogWithToggle.openQuestion(iWorkbenchWindow.getShell(), AspectJPlugin.getResourceString("PluginImportDialog.importConfirmTitle"), AspectJPlugin.getResourceString("PluginImportDialog.importConfirmMsg"), AspectJPlugin.getResourceString("PluginImportDialog.importConfirmToggleMsg"), false);
        int n = messageDialogWithToggle.getReturnCode();
        if (n >= 0 && messageDialogWithToggle.getToggleState()) {
            if (n == 0) {
                AspectJPreferences.setDoPDEAutoImport(true);
                AspectJPreferences.setAskPDEAutoImport(false);
            } else {
                AspectJPreferences.setDoPDEAutoImport(false);
                AspectJPreferences.setAskPDEAutoImport(false);
            }
        }
        return n == 0;
    }
}

