/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.tests;

import junit.framework.TestCase;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class AJDTUtilsTest
extends TestCase {
    private IProject project;
    private IResource resource;

    public AJDTUtilsTest(String string) {
        super(string);
    }

    public void setUp() {
        IProject[] iProjectArray = AspectJPlugin.getWorkspace().getRoot().getProjects();
        AJDTUtilsTest.assertTrue((String)"Must be at least one project in workspace for this test", (iProjectArray.length > 0 ? 1 : 0) != 0);
        this.project = iProjectArray[0];
        AJDTUtilsTest.assertEquals((String)"Project should be set to 'Examples'", (String)"Examples", (String)this.project.getName());
        this.resource = this.findRequiredResource(this.project, "custom1.lst");
    }

    public void testGetWorkspacePath() {
        String string = AJDTUtils.getWorkspacePath();
        AJDTUtilsTest.assertEquals((String)"D:\\eclipse\\runtime-workspace", (String)string);
    }

    public void testGetProjectRootDirectory() {
        String string = AJDTUtils.getProjectRootDirectory(this.project);
        AJDTUtilsTest.assertEquals((String)"D:\\eclipse\\runtime-workspace\\Examples", (String)string);
    }

    public void testGetResourcePath() {
        String string = AJDTUtils.getResourcePath(this.resource);
        AJDTUtilsTest.assertEquals((String)"D:\\eclipse\\runtime-workspace\\Examples\\custom1.lst", (String)string);
    }

    private IResource findRequiredResource(IProject iProject, String string) {
        IResource iResource = null;
        IResource[] iResourceArray = null;
        try {
            iResourceArray = iProject.members();
        }
        catch (CoreException coreException) {
            AJDTUtilsTest.fail((String)("Exception listing project contents: " + coreException.getMessage()));
        }
        for (int i = 0; i < iResourceArray.length; ++i) {
            IResource iResource2 = iResourceArray[i];
            if (!iResource2.getName().endsWith(string)) continue;
            iResource = iResource2;
            break;
        }
        if (iResource == null) {
            AJDTUtilsTest.fail((String)("Missing required project resource: " + string + "in project " + iProject.getName()));
        }
        return iResource;
    }
}

