/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.tests;

import junit.framework.TestCase;
import org.eclipse.ajdt.internal.ui.wizards.NewAspectCreationWizardPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class NewAspectUtilsTest
extends TestCase {
    private IProject project;
    private IResource resource;

    public NewAspectUtilsTest(String string) {
        super(string);
    }

    public void testGetInnerInsertionPoint() {
        String string = "/*\n* Created on 23-Oct-2003\n*\n * To change the template for this generated file go to\n * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments\n//embedded comment\n//public class TestClass {}\n */\npackage foo.test;\n\n/**\n * @author mchapman\n *\n * To change the template for this generated type comment go to\n * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments\n */\npublic class TestClass {\n\tpublic static void main(String[] args){\n\t\tSystem.out.println(\"Hello\");\n\t}\n}";
        String string2 = "TestClass";
        int n = NewAspectCreationWizardPage.NewAspectUtils.getInnerInsertionPoint(string, string2);
        String string3 = string.substring(0, n);
        String string4 = string.substring(n);
        NewAspectUtilsTest.assertTrue((String)"Pre- and post-insertion point sections should together match the entire input", (boolean)string.equals(string3 + string4));
        NewAspectUtilsTest.assertTrue((String)"Pre-insertion point section should end with {", (boolean)string3.trim().endsWith("{"));
        NewAspectUtilsTest.assertTrue((String)"Post-insertion point section should begin with main declaration", (boolean)string4.trim().startsWith("public static void main"));
    }

    public void testGetInnerImportsInsertionPoint() {
        String[] stringArray = new String[]{"/*\n* Created on 23-Oct-2003\n*\n * To change the template for this generated file go to\n * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments\n//embedded comment\n//public class TestClass {}\n */\npackage foo.test;\n\n/**\n * @author mchapman\n *\n * To change the template for this generated type comment go to\n * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments\n */\npublic class TestClass {", "/*\n* Created on 23-Oct-2003\n*\n * To change the template for this generated file go to\n * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments\n//embedded comment\n//public class TestClass {}\n */\npackage foo.test;\nimport javax.swing.JComponent;\nimport javax.swing.JFrame;\n\n/**\n * @author mchapman\n *\n * To change the template for this generated type comment go to\n * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments\n */\npublic class TestClass {", "/*\n* Created on 23-Oct-2003\n*\n * To change the template for this generated file go to\n * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments\n//embedded comment\n//public class TestClass {}\n */\nimport javax.swing.JComponent;\nimport javax.swing.JFrame;\n\n/**\n * @author mchapman\n *\n * To change the template for this generated type comment go to\n * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments\n */\npublic class TestClass {", "/*\n* Created on 23-Oct-2003\n*\n * To change the template for this generated file go to\n * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments\n//embedded comment\n//public class TestClass {}\n */\n/**\n * @author mchapman\n *\n * To change the template for this generated type comment go to\n * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments\n */\npublic class TestClass {"};
        for (int i = 0; i < stringArray.length; ++i) {
            int n = NewAspectCreationWizardPage.NewAspectUtils.getInnerImportsInsertionPoint(stringArray[i]);
            String string = stringArray[i].substring(0, n);
            String string2 = stringArray[i].substring(n);
            NewAspectUtilsTest.assertTrue((String)"Pre- and post-insertion point sections should together match the entire input", (boolean)stringArray[i].equals(string + string2));
            if (i == 0 || i == 1) {
                NewAspectUtilsTest.assertTrue((String)"Pre-insertion point section should contain package statement", (string.indexOf("package") >= 0 ? 1 : 0) != 0);
            }
            NewAspectUtilsTest.assertTrue((String)"Post-insertion point section should contain class declaration", (string2.indexOf("public class TestClass") >= 0 ? 1 : 0) != 0);
        }
    }
}

