/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui;

import java.io.File;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class AspectJProjectPropertiesPage
extends PropertyPage
implements SelectionListener {
    private Button incremental_modeBtn;
    private Button buildAsmBtn;
    private Button showweavemessagesBtn;
    private StringFieldEditor outputJarEditor;
    private StringFieldEditor nonStandardOptionsEditor;
    private IProject thisProject;
    private static int BROWSE_FOR_CLASSJARS = 0;
    private static int BROWSE_FOR_ASPECTJARS = 1;

    protected Control createContents(Composite composite) {
        this.thisProject = (IProject)this.getElement();
        BuildOptionsAdapter.ensurePropertiesInitialized(this.thisProject);
        Composite composite2 = this.createPageComposite(composite, 3);
        Composite composite3 = this.createRowComposite(composite2, 1);
        Label label = this.createLabel(composite3, AspectJPlugin.getResourceString("compilerPropsPage.description"));
        Composite composite4 = this.createRowComposite(composite2, 2);
        this.outputJarEditor = new StringFieldEditor("", AspectJPlugin.getResourceString("compilerPropsPage.outputJar"), composite4);
        this.nonStandardOptionsEditor = new StringFieldEditor("", AspectJPlugin.getResourceString("compilerPropsPage.nonStandardOptions"), StringFieldEditor.UNLIMITED, composite2);
        Label label2 = this.createLabel(composite2, "");
        this.incremental_modeBtn = this.buildButton(composite2, AspectJPlugin.getResourceString("compilerPropsPage.useIncrementalCompiler"));
        Label label3 = this.createLabel(composite2, AspectJPlugin.getResourceString("compilerPropsPage.incrementalCompilerStatus"));
        this.buildAsmBtn = this.buildButton(composite2, AspectJPlugin.getResourceString("compilerPropsPage.buildasm"));
        Label label4 = this.createLabel(composite2, AspectJPlugin.getResourceString("compilerPropsPage.buildasm.details"));
        this.showweavemessagesBtn = this.buildButton(composite2, AspectJPlugin.getResourceString("compilerPropsPage.showweavemessages"));
        Label label5 = this.createLabel(composite2, AspectJPlugin.getResourceString("compilerPropsPage.showweavemessages.details"));
        this.createLabel(composite2, "");
        this.updatePageContents();
        return composite2;
    }

    private Button buildButton(Composite composite, String string) {
        Button button = new Button(composite, 32);
        button.setText(string);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
        return button;
    }

    private Button buildPushButton(Composite composite, String string) {
        Button button = new Button(composite, 8);
        button.setText(string);
        button.addSelectionListener((SelectionListener)this);
        return button;
    }

    private Button createRadioButton(Composite composite, String string) {
        Button button = new Button(composite, 16400);
        button.setText(string);
        button.addSelectionListener((SelectionListener)this);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        button.setLayoutData((Object)gridData);
        return button;
    }

    private Label createLabel(Composite composite, String string) {
        Label label = new Label(composite, 16384);
        label.setText(string);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 1;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private Composite createPageComposite(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        gridLayout.makeColumnsEqualWidth = true;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        return composite2;
    }

    private Composite createRowComposite(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        gridLayout.makeColumnsEqualWidth = true;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 3;
        composite2.setLayoutData((Object)gridData);
        return composite2;
    }

    private void preserveSetting(QualifiedName qualifiedName, boolean bl) throws CoreException {
        this.preserveSetting(qualifiedName, new Boolean(bl).toString());
    }

    private void preserveSetting(QualifiedName qualifiedName, String string) throws CoreException {
        this.thisProject.setPersistentProperty(qualifiedName, string);
    }

    private String retrieveSettingString(QualifiedName qualifiedName) {
        try {
            String string = this.thisProject.getPersistentProperty(qualifiedName);
            return string;
        }
        catch (CoreException coreException) {
            AspectJPlugin.getDefault().getErrorHandler().handleError(AspectJPlugin.getResourceString("projectProperties.exceptionDuringRetrieve"), coreException);
            return "";
        }
    }

    private boolean retrieveSettingBoolean(QualifiedName qualifiedName) {
        try {
            String string = this.thisProject.getPersistentProperty(qualifiedName);
            if (string == null) {
                return false;
            }
            boolean bl = new Boolean(string);
            return bl;
        }
        catch (CoreException coreException) {
            AspectJPlugin.getDefault().getErrorHandler().handleError(AspectJPlugin.getResourceString("projectProperties.exceptionDuringRetrieve"), coreException);
            return false;
        }
    }

    private String findInvalidJars(String string) {
        if (string.length() == 0) {
            return null;
        }
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = this.thisProject.getLocation().toOSString();
        while (string2.indexOf(File.pathSeparator) != -1) {
            int n = string2.indexOf(File.pathSeparator);
            String string4 = string2.substring(0, n);
            File file = new File(string4);
            if (!file.isAbsolute()) {
                file = new File(string3 + File.separator + string4);
            }
            if (!file.exists()) {
                stringBuffer.append(file + "\n");
            }
            string2 = string2.substring(n + 1);
        }
        if (string2.length() != 0) {
            File file = new File(string2);
            if (!file.isAbsolute()) {
                file = new File(string3 + File.separator + string2);
            }
            if (!file.exists()) {
                stringBuffer.append(file + "\n");
            }
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    private String findInvalidDirs(String string) {
        if (string.length() == 0) {
            return null;
        }
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = AspectJPlugin.getDefault().getCurrentProject().getLocation().toOSString();
        while (string2.indexOf(File.pathSeparator) != -1) {
            int n = string2.indexOf(File.pathSeparator);
            String string4 = string2.substring(0, n);
            File file = new File(string4);
            if (!file.isAbsolute()) {
                file = new File(string3 + File.separator + string4);
            }
            if (!file.isDirectory()) {
                stringBuffer.append(file + "\n");
            }
            string2 = string2.substring(n + 1);
        }
        if (string2.length() != 0) {
            File file = new File(string2);
            if (!file.isAbsolute()) {
                file = new File(string3 + File.separator + string2);
            }
            if (!file.isDirectory()) {
                stringBuffer.append(file + "\n");
            }
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public boolean performOk() {
        String string = this.outputJarEditor.getStringValue();
        if (string != null) {
            try {
                if (!string.startsWith(File.separator)) {
                    IJavaProject iJavaProject = JavaCore.create((IProject)this.thisProject);
                    IPath iPath = iJavaProject.getOutputLocation();
                    IPath iPath2 = AspectJPlugin.getWorkspace().getRoot().getLocation().append(iPath);
                    string = iPath2.toOSString();
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        AJDTEventTrace.projectPropertiesChanged(this.thisProject);
        try {
            this.preserveSetting(BuildOptionsAdapter.INCREMENTAL_COMPILATION, this.incremental_modeBtn.getSelection());
            this.preserveSetting(BuildOptionsAdapter.BUILD_ASM, this.buildAsmBtn.getSelection());
            this.preserveSetting(BuildOptionsAdapter.WEAVEMESSAGES, this.showweavemessagesBtn.getSelection());
            this.preserveSetting(BuildOptionsAdapter.OUTPUTJAR, this.outputJarEditor.getStringValue());
            this.preserveSetting(BuildOptionsAdapter.CHAR_ENC, "");
            this.preserveSetting(BuildOptionsAdapter.NON_STANDARD_OPTS, this.nonStandardOptionsEditor.getStringValue());
        }
        catch (CoreException coreException) {
            AspectJPlugin.getDefault().getErrorHandler().handleError(AspectJPlugin.getResourceString("projectProperties.exceptionDuringStore"), coreException);
            return false;
        }
        return true;
    }

    public void performDefaults() {
        AJDTEventTrace.projectPropertiesDefaulted(this.thisProject);
        try {
            this.thisProject.setPersistentProperty(BuildOptionsAdapter.INCREMENTAL_COMPILATION, null);
            this.thisProject.setPersistentProperty(BuildOptionsAdapter.OUTPUTJAR, null);
            this.thisProject.setPersistentProperty(BuildOptionsAdapter.ASPECTJARS, null);
            this.thisProject.setPersistentProperty(BuildOptionsAdapter.SOURCEROOTS, null);
            this.thisProject.setPersistentProperty(BuildOptionsAdapter.INPUTJARS, null);
            this.thisProject.setPersistentProperty(BuildOptionsAdapter.CHAR_ENC, null);
            BuildOptionsAdapter.ensurePropertiesInitialized(this.thisProject);
            this.updatePageContents();
        }
        catch (CoreException coreException) {
            AspectJPlugin.getDefault().getErrorHandler().handleError(AspectJPlugin.getResourceString("projectProperties.exceptionDefaultingProperties"), coreException);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        Object object = selectionEvent.getSource();
        if (object instanceof Button) {
            Button button = (Button)object;
        }
    }

    public String calculateStrictnessFromButtons() {
        return null;
    }

    public void updatePageContents() {
        this.incremental_modeBtn.setSelection(this.retrieveSettingBoolean(BuildOptionsAdapter.INCREMENTAL_COMPILATION));
        this.buildAsmBtn.setSelection(this.retrieveSettingBoolean(BuildOptionsAdapter.BUILD_ASM));
        this.showweavemessagesBtn.setSelection(this.retrieveSettingBoolean(BuildOptionsAdapter.WEAVEMESSAGES));
        this.outputJarEditor.setStringValue(this.retrieveSettingString(BuildOptionsAdapter.OUTPUTJAR));
        this.nonStandardOptionsEditor.setStringValue(this.retrieveSettingString(BuildOptionsAdapter.NON_STANDARD_OPTS));
    }
}

