/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ajdt.internal.ui.preferences.AJCompilerPreferencePage;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.internal.ui.preferences.PreferencePageSupport;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.TabFolderLayout;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.PropertyPage;

public class CompilerPropertyPage
extends PropertyPage
implements SelectionListener {
    public final String COMPILER_PB_INVALID_ABSOLUTE_TYPE_NAME = "org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName";
    public final String COMPILER_PB_INVALID_WILDCARD_TYPE_NAME = "org.aspectj.ajdt.core.compiler.lint.WildcardTypeName";
    public final String COMPILER_PB_UNRESOLVABLE_MEMBER = "org.aspectj.ajdt.core.compiler.lint.UnresolvableMember";
    public final String COMPILER_PB_TYPE_NOT_EXPOSED_TO_WEAVER = "org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver";
    public final String COMPILER_PB_SHADOW_NOT_IN_STRUCTURE = "org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure";
    public final String COMPILER_PB_UNMATCHED_SUPERTYPE_IN_CALL = "org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall";
    public final String COMPILER_PB_CANNOT_IMPLEMENT_LAZY_TJP = "org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP";
    public final String COMPILER_PB_NEED_SERIAL_VERSION_UID = "org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField";
    public final String COMPILER_PB_INCOMPATIBLE_SERIAL_VERSION = "org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility";
    public final String COMPILER_PB_NO_INTERFACE_CTOR_JOINPOINT = "org.aspectj.ajdt.core.compiler.lint.NoInterfaceCtorJoinpoint";
    public final String COMPILER_NO_WEAVE = "org.aspectj.ajdt.core.compiler.weaver.NoWeave";
    public final String COMPILER_SERIALIZABLE_ASPECTS = "org.aspectj.ajdt.core.compiler.weaver.XSerializableAspects";
    public final String COMPILER_LAZY_TJP = "org.aspectj.ajdt.core.compiler.weaver.XLazyThisJoinPoint";
    public final String COMPILER_NO_ADVICE_INLINE = "org.aspectj.ajdt.core.compiler.weaver.XNoInline";
    public final String COMPILER_REWEAVABLE = "org.aspectj.ajdt.core.compiler.weaver.XReweavable";
    public final String COMPILER_REWEAVABLE_COMPRESS = "org.aspectj.ajdt.core.compiler.weaver.XReweavableCompress";
    private final String PREF_AJ_INVALID_ABSOLUTE_TYPE_NAME = "org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName";
    private final String PREF_AJ_SHADOW_NOT_IN_STRUCTURE = "org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure";
    private final String PREF_AJ_CANNOT_IMPLEMENT_LAZY_TJP = "org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP";
    private final String PREF_AJ_INVALID_WILDCARD_TYPE_NAME = "org.aspectj.ajdt.core.compiler.lint.WildcardTypeName";
    private final String PREF_AJ_TYPE_NOT_EXPOSED_TO_WEAVER = "org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver";
    private final String PREF_AJ_UNRESOLVABLE_MEMBER = "org.aspectj.ajdt.core.compiler.lint.UnresolvableMember";
    private final String PREF_AJ_UNMATCHED_SUPER_TYPE_IN_CALL = "org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall";
    private final String PREF_AJ_INCOMPATIBLE_SERIAL_VERSION = "org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility";
    private final String PREF_AJ_NEED_SERIAL_VERSION_UID_FIELD = "org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField";
    private final String PREF_AJ_NO_INTERFACE_CTOR_JOINPOINT = "org.aspectj.ajdt.core.compiler.lint.NoInterfaceCtorJoinpoint";
    private final String PREF_ENABLE_NO_WEAVE = "org.aspectj.ajdt.core.compiler.weaver.NoWeave";
    private final String PREF_ENABLE_SERIALIZABLE_ASPECTS = "org.aspectj.ajdt.core.compiler.weaver.XSerializableAspects";
    private final String PREF_ENABLE_LAZY_TJP = "org.aspectj.ajdt.core.compiler.weaver.XLazyThisJoinPoint";
    private final String PREF_ENABLE_NO_INLINE = "org.aspectj.ajdt.core.compiler.weaver.XNoInline";
    private final String PREF_ENABLE_REWEAVABLE = "org.aspectj.ajdt.core.compiler.weaver.XReweavable";
    private final String PREF_ENABLE_REWEAVABLE_COMPRESS = "org.aspectj.ajdt.core.compiler.weaver.XReweavableCompress";
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String IGNORE = "ignore";
    private static String ENABLED = "enabled";
    private static String DISABLED = "disabled";
    private Button noweaveButton;
    private Button lazytjpButton;
    private Button noinlineButton;
    private Button reweaveButton;
    private Button reweaveCompressButton;
    private IProject thisProject;
    private boolean initialised = false;
    private int switches = 0;
    protected List fComboBoxes;
    protected List fCheckBoxes = new ArrayList();
    private SelectionButtonDialogField fUseWorkspaceSettings;
    private SelectionButtonDialogField fChangeWorkspaceSettings;
    private SelectionButtonDialogField fUseProjectSettings;
    private TabFolder folder;

    public CompilerPropertyPage() {
        this.fComboBoxes = new ArrayList();
        IDialogFieldListener iDialogFieldListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                CompilerPropertyPage.this.doDialogFieldChanged(dialogField);
            }
        };
        this.fUseWorkspaceSettings = new SelectionButtonDialogField(16);
        this.fUseWorkspaceSettings.setDialogFieldListener(iDialogFieldListener);
        this.fUseWorkspaceSettings.setLabelText(PreferencesMessages.getString((String)"CompilerPropertyPage.useworkspacesettings.label"));
        this.fChangeWorkspaceSettings = new SelectionButtonDialogField(8);
        this.fChangeWorkspaceSettings.setLabelText(PreferencesMessages.getString((String)"CompilerPropertyPage.useworkspacesettings.change"));
        this.fChangeWorkspaceSettings.setDialogFieldListener(iDialogFieldListener);
        this.fUseWorkspaceSettings.attachDialogField((DialogField)this.fChangeWorkspaceSettings);
        this.fUseProjectSettings = new SelectionButtonDialogField(16);
        this.fUseProjectSettings.setDialogFieldListener(iDialogFieldListener);
        this.fUseProjectSettings.setLabelText(PreferencesMessages.getString((String)"CompilerPropertyPage.useprojectsettings.label"));
    }

    public void initDefaults(IPreferenceStore iPreferenceStore) {
        iPreferenceStore.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName", WARNING);
        iPreferenceStore.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure", IGNORE);
        iPreferenceStore.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP", WARNING);
        iPreferenceStore.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.lint.WildcardTypeName", IGNORE);
        iPreferenceStore.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver", WARNING);
        iPreferenceStore.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.lint.UnresolvableMember", WARNING);
        iPreferenceStore.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall", WARNING);
        iPreferenceStore.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility", IGNORE);
        iPreferenceStore.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField", IGNORE);
        iPreferenceStore.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.lint.NoInterfaceCtorJoinpoint", WARNING);
        iPreferenceStore.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.weaver.NoWeave", false);
        iPreferenceStore.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.weaver.XSerializableAspects", false);
        iPreferenceStore.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.weaver.XLazyThisJoinPoint", false);
        iPreferenceStore.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.weaver.XNoInline", false);
        iPreferenceStore.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.weaver.XReweavable", false);
        iPreferenceStore.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.weaver.XReweavableCompress", false);
        iPreferenceStore.setDefault(this.thisProject + "useProjectSettings", false);
        this.initialised = true;
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
    }

    protected Control createContents(Composite composite) {
        this.thisProject = (IProject)this.getElement();
        if (!this.initialised) {
            this.initDefaults(this.getPreferenceStore());
        }
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.fUseWorkspaceSettings.doFillIntoGrid(composite2, 1);
        LayoutUtil.setHorizontalGrabbing((Control)this.fUseWorkspaceSettings.getSelectionButton(null));
        this.fChangeWorkspaceSettings.doFillIntoGrid(composite2, 1);
        this.fUseProjectSettings.doFillIntoGrid(composite2, 2);
        GridData gridData = new GridData(272);
        gridData.horizontalSpan = 2;
        this.folder = new TabFolder(composite, 0);
        this.folder.setLayout((Layout)new TabFolderLayout());
        this.folder.setLayoutData((Object)gridData);
        Composite composite3 = this.createMessagesTabContent((Composite)this.folder);
        TabItem tabItem = new TabItem(this.folder, 0);
        tabItem.setText(AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_messages.tabtitle"));
        tabItem.setControl((Control)composite3);
        composite3 = this.createAdvancedTabContent((Composite)this.folder);
        tabItem = new TabItem(this.folder, 0);
        tabItem.setText(AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_advanced.tabtitle"));
        tabItem.setControl((Control)composite3);
        Dialog.applyDialogFont((Control)composite2);
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        if (iPreferenceStore.getBoolean(this.thisProject + "useProjectSettings")) {
            this.fUseProjectSettings.setSelection(true);
        } else {
            this.fUseWorkspaceSettings.setSelection(true);
        }
        this.updateEnableState();
        return composite2;
    }

    private Composite createMessagesTabContent(Composite composite) {
        String[] stringArray = new String[]{ERROR, WARNING, IGNORE};
        String[] stringArray2 = new String[]{AspectJPlugin.getResourceString("CompilerConfigurationBlock.error"), AspectJPlugin.getResourceString("CompilerConfigurationBlock.warning"), AspectJPlugin.getResourceString("CompilerConfigurationBlock.ignore")};
        int n = 3;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 64);
        label.setText(AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_messages.description"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
        String string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_invalid_absolute_type_name.label");
        this.addComboBox(composite2, string, "org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName", stringArray, stringArray2, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_invalid_wildcard_type_name.label");
        this.addComboBox(composite2, string, "org.aspectj.ajdt.core.compiler.lint.WildcardTypeName", stringArray, stringArray2, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_unresolvable_member.label");
        this.addComboBox(composite2, string, "org.aspectj.ajdt.core.compiler.lint.UnresolvableMember", stringArray, stringArray2, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_type_not_exposed_to_weaver.label");
        this.addComboBox(composite2, string, "org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver", stringArray, stringArray2, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_shadow_not_in_structure.label");
        this.addComboBox(composite2, string, "org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure", stringArray, stringArray2, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_unmatched_super_type_in_call.label");
        this.addComboBox(composite2, string, "org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall", stringArray, stringArray2, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_cannot_implement_lazy_tjp.label");
        this.addComboBox(composite2, string, "org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP", stringArray, stringArray2, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_need_serial_version_uid_field.label");
        this.addComboBox(composite2, string, "org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField", stringArray, stringArray2, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_incompatible_serial_version.label");
        this.addComboBox(composite2, string, "org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility", stringArray, stringArray2, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_no_interface_ctor_joinpoint.label");
        this.addComboBox(composite2, string, "org.aspectj.ajdt.core.compiler.lint.NoInterfaceCtorJoinpoint", stringArray, stringArray2, 0);
        return composite2;
    }

    private Composite createAdvancedTabContent(Composite composite) {
        String[] stringArray = new String[]{ENABLED, DISABLED};
        CheckBoxListener checkBoxListener = new CheckBoxListener();
        int n = 3;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 64);
        label.setText(AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_advanced.description"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
        String string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_no_weave.label");
        this.noweaveButton = this.addCheckBox(composite2, string, "org.aspectj.ajdt.core.compiler.weaver.NoWeave", stringArray, 0);
        this.noweaveButton.addSelectionListener((SelectionListener)checkBoxListener);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_x_serializable_aspects.label");
        this.addCheckBox(composite2, string, "org.aspectj.ajdt.core.compiler.weaver.XSerializableAspects", stringArray, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_x_lazy_tjp.label");
        this.lazytjpButton = this.addCheckBox(composite2, string, "org.aspectj.ajdt.core.compiler.weaver.XLazyThisJoinPoint", stringArray, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_x_no_inline.label");
        this.noinlineButton = this.addCheckBox(composite2, string, "org.aspectj.ajdt.core.compiler.weaver.XNoInline", stringArray, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_x_reweavable.label");
        this.reweaveButton = this.addCheckBox(composite2, string, "org.aspectj.ajdt.core.compiler.weaver.XReweavable", stringArray, 0);
        this.reweaveButton.addSelectionListener((SelectionListener)checkBoxListener);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_x_reweavable_compress.label");
        this.reweaveCompressButton = this.addCheckBox(composite2, string, "org.aspectj.ajdt.core.compiler.weaver.XReweavableCompress", stringArray, 0);
        this.reweaveCompressButton.addSelectionListener((SelectionListener)checkBoxListener);
        this.checkNoWeaveSelection();
        return composite2;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return AspectJPlugin.getDefault().getPreferenceStore();
    }

    public boolean performOk() {
        int n;
        Object object;
        ControlData controlData;
        int n2;
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        boolean bl = false;
        for (n2 = this.fComboBoxes.size() - 1; n2 >= 0; --n2) {
            Combo combo = (Combo)this.fComboBoxes.get(n2);
            controlData = (ControlData)combo.getData();
            object = controlData.getValue(combo.getSelectionIndex());
            if (object.equals(iPreferenceStore.getString(this.thisProject.toString() + controlData.getKey()))) continue;
            bl = true;
            iPreferenceStore.setValue(this.thisProject + controlData.getKey(), (String)object);
        }
        n2 = 0;
        for (n = this.fCheckBoxes.size() - 1; n >= 0; --n) {
            controlData = (Button)this.fCheckBoxes.get(n);
            object = (ControlData)controlData.getData();
            boolean bl2 = controlData.getSelection();
            if (bl2 == iPreferenceStore.getBoolean(this.thisProject.toString() + object.getKey())) continue;
            n2 = 1;
            iPreferenceStore.setValue(this.thisProject.toString() + object.getKey(), bl2);
        }
        n = 0;
        if (iPreferenceStore.getBoolean(this.thisProject + "useProjectSettings") != this.useProjectSettings()) {
            n = 1;
            iPreferenceStore.setValue(this.thisProject + "useProjectSettings", this.useProjectSettings());
        }
        AspectJPlugin.getDefault().savePluginPreferences();
        if (bl || n2 != 0 || n != 0 || this.switches > 1 && this.useProjectSettings()) {
            boolean bl3 = false;
            object = this.getProjectBuildDialogStrings();
            if (object != null) {
                MessageDialog messageDialog = new MessageDialog(this.getShell(), object[0], null, object[1], 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
                int n3 = messageDialog.open();
                if (n3 == 0) {
                    bl3 = true;
                } else if (n3 != 1) {
                    return false;
                }
            }
            if (bl3) {
                this.doProjectBuild();
            }
        }
        return true;
    }

    protected String[] getProjectBuildDialogStrings() {
        String string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.needsbuild.title");
        String string2 = AspectJPlugin.getResourceString("CompilerConfigurationBlock.needsprojectbuild.message");
        return new String[]{string, string2};
    }

    protected void doProjectBuild() {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
        try {
            progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                    iProgressMonitor.beginTask("", 2);
                    try {
                        iProgressMonitor.setTaskName(AspectJPlugin.getResourceString("OptionsConfigurationBlock.buildproject.taskname"));
                        CompilerPropertyPage.this.thisProject.build(6, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                    finally {
                        iProgressMonitor.done();
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = AspectJPlugin.getResourceString("OptionsConfigurationBlock.builderror.message");
            AspectJPlugin.getDefault().getErrorHandler().handleError(string, invocationTargetException);
        }
    }

    protected void performDefaults() {
        String string;
        ControlData controlData;
        Combo combo;
        int n;
        super.performDefaults();
        this.fUseWorkspaceSettings.setSelection(true);
        this.fUseProjectSettings.setSelection(false);
        for (n = this.fComboBoxes.size() - 1; n >= 0; --n) {
            combo = (Combo)this.fComboBoxes.get(n);
            controlData = (ControlData)combo.getData();
            string = this.getPreferenceStore().getDefaultString(controlData.getKey());
            combo.select(controlData.getSelection(string));
        }
        for (n = this.fCheckBoxes.size() - 1; n >= 0; --n) {
            combo = (Button)this.fCheckBoxes.get(n);
            if (this.useProjectSettings()) {
                combo.setEnabled(true);
            }
            combo.setSelection((controlData = (ControlData)combo.getData()).getSelection(string = this.getPreferenceStore().getDefaultString(controlData.getKey())) == 1);
        }
    }

    private Label createLabel(Composite composite, String string) {
        Label label = new Label(composite, 16384);
        label.setText(string);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected Button addCheckBox(Composite composite, String string, String string2, String[] stringArray, int n) {
        ControlData controlData = new ControlData(string2, stringArray);
        int n2 = string.indexOf("-");
        String string3 = string.substring(0, n2);
        String string4 = string.substring(n2 + 1);
        string4 = string4.trim();
        GridData gridData = new GridData(1040);
        gridData.horizontalSpan = 3;
        gridData.horizontalIndent = n;
        Button button = new Button(composite, 32);
        button.setText(string3);
        button.setData((Object)controlData);
        button.setLayoutData((Object)gridData);
        Label label = new Label(composite, 64);
        label.setText(string4);
        GridData gridData2 = new GridData(768);
        gridData2.horizontalIndent = 20;
        label.setLayoutData((Object)gridData2);
        this.createLabel(composite, "");
        boolean bl = this.getPreferenceStore().getBoolean(this.thisProject.toString() + string2);
        button.setSelection(bl);
        this.fCheckBoxes.add(button);
        return button;
    }

    protected void addComboBox(Composite composite, String string, String string2, String[] stringArray, String[] stringArray2, int n) {
        ControlData controlData = new ControlData(string2, stringArray);
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n;
        Label label = new Label(composite, 16448);
        label.setText(string);
        label.setLayoutData((Object)gridData);
        Combo combo = new Combo(composite, 8);
        combo.setItems(stringArray2);
        combo.setData((Object)controlData);
        combo.setLayoutData((Object)new GridData(256));
        Label label2 = new Label(composite, 0);
        label2.setLayoutData((Object)new GridData(768));
        String string3 = this.getPreferenceStore().getString(this.thisProject.toString() + string2);
        if (string3 != null && string3.length() > 0) {
            combo.select(controlData.getSelection(string3));
        }
        this.fComboBoxes.add(combo);
    }

    private void checkNoWeaveSelection() {
        boolean bl = this.noweaveButton.getSelection();
        if (bl) {
            this.lazytjpButton.setEnabled(!bl);
            this.noinlineButton.setEnabled(!bl);
            this.reweaveButton.setEnabled(!bl);
            this.reweaveCompressButton.setEnabled(!bl);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    private void doDialogFieldChanged(DialogField dialogField) {
        if (dialogField == this.fChangeWorkspaceSettings) {
            String string = "org.eclipse.ajdt.ui.preferences.AJCompilerPreferencePage";
            AJCompilerPreferencePage aJCompilerPreferencePage = new AJCompilerPreferencePage();
            PreferencePageSupport.showPreferencePage((Shell)this.getShell(), (String)string, (IPreferencePage)aJCompilerPreferencePage);
        } else {
            ++this.switches;
            this.updateEnableState();
        }
    }

    private void updateEnableState() {
        if (this.useProjectSettings()) {
            Combo combo;
            int n;
            for (n = 0; n < this.fComboBoxes.size(); ++n) {
                combo = (Combo)this.fComboBoxes.get(n);
                combo.setEnabled(true);
            }
            for (n = 0; n < this.fCheckBoxes.size(); ++n) {
                combo = (Button)this.fCheckBoxes.get(n);
                combo.setEnabled(true);
            }
            n = this.noweaveButton.getSelection() ? 1 : 0;
            if (n != 0) {
                this.lazytjpButton.setSelection(false);
                this.noinlineButton.setSelection(false);
                this.reweaveButton.setSelection(false);
                this.reweaveCompressButton.setSelection(false);
            }
            this.lazytjpButton.setEnabled(n == 0);
            this.noinlineButton.setEnabled(n == 0);
            this.reweaveButton.setEnabled(n == 0);
            this.reweaveCompressButton.setEnabled(n == 0);
        } else {
            Combo combo;
            int n;
            for (n = 0; n < this.fComboBoxes.size(); ++n) {
                combo = (Combo)this.fComboBoxes.get(n);
                combo.setEnabled(false);
            }
            for (n = 0; n < this.fCheckBoxes.size(); ++n) {
                combo = (Button)this.fCheckBoxes.get(n);
                combo.setEnabled(false);
            }
        }
    }

    private boolean useProjectSettings() {
        return this.fUseProjectSettings.isSelected();
    }

    private class CheckBoxListener
    implements SelectionListener {
        private CheckBoxListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            boolean bl;
            if (selectionEvent.getSource().equals(CompilerPropertyPage.this.noweaveButton)) {
                boolean bl2 = CompilerPropertyPage.this.noweaveButton.getSelection();
                if (bl2) {
                    CompilerPropertyPage.this.lazytjpButton.setSelection(false);
                    CompilerPropertyPage.this.noinlineButton.setSelection(false);
                    CompilerPropertyPage.this.reweaveButton.setSelection(false);
                    CompilerPropertyPage.this.reweaveCompressButton.setSelection(false);
                }
                CompilerPropertyPage.this.lazytjpButton.setEnabled(!bl2);
                CompilerPropertyPage.this.noinlineButton.setEnabled(!bl2);
                CompilerPropertyPage.this.reweaveButton.setEnabled(!bl2);
                CompilerPropertyPage.this.reweaveCompressButton.setEnabled(!bl2);
            } else if (selectionEvent.getSource().equals(CompilerPropertyPage.this.reweaveButton)) {
                boolean bl3 = CompilerPropertyPage.this.reweaveButton.getSelection();
                if (bl3) {
                    CompilerPropertyPage.this.reweaveCompressButton.setSelection(false);
                }
            } else if (selectionEvent.getSource().equals(CompilerPropertyPage.this.reweaveCompressButton) && (bl = CompilerPropertyPage.this.reweaveCompressButton.getSelection())) {
                CompilerPropertyPage.this.reweaveButton.setSelection(false);
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    }

    protected static class ControlData {
        private String fKey;
        private String[] fValues;

        public ControlData(String string, String[] stringArray) {
            this.fKey = string;
            this.fValues = stringArray;
        }

        public String getKey() {
            return this.fKey;
        }

        public String getValue(boolean bl) {
            int n = bl ? 0 : 1;
            return this.fValues[n];
        }

        public String getValue(int n) {
            return this.fValues[n];
        }

        public int getSelection(String string) {
            for (int i = 0; i < this.fValues.length; ++i) {
                if (!string.equals(this.fValues[i])) continue;
                return i;
            }
            return 0;
        }
    }
}

