/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.IBuildConfigurationChangedListener;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.builder.Builder;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;

public class PulldownBuildselectorMenu
implements IWorkbenchWindowPulldownDelegate,
SelectionListener,
IBuildConfigurationChangedListener {
    private IAction buildAction;
    private ProjectBuildConfigurator currentPbc;

    public PulldownBuildselectorMenu() {
        BuildConfigurator.getBuildConfigurator().addBuildConfigurationChangedListener(this);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
    }

    public String getWorkspaceDirectory() {
        IProject iProject = AspectJPlugin.getDefault().getCurrentProject();
        if (iProject == null) {
            return null;
        }
        IPath iPath = iProject.getLocation();
        iPath = iPath.removeLastSegments(1);
        return new String(iPath.toOSString() + File.separator);
    }

    public Menu getMenu(Control control) {
        Menu menu = new Menu(control);
        ProjectBuildConfigurator projectBuildConfigurator = BuildConfigurator.getBuildConfigurator().getActiveProjectBuildConfigurator();
        if (projectBuildConfigurator == null) {
            MenuItem menuItem = new MenuItem(menu, 32);
            menuItem.setText("No open AspectJ project selected");
            menuItem.setData(null);
            return menu;
        }
        Util.Comparable[] comparableArray = projectBuildConfigurator.getBuildConfigurations().toArray(new BuildConfiguration[0]);
        Util.sort((Util.Comparable[])comparableArray);
        MenuItem menuItem = null;
        BuildConfiguration buildConfiguration = projectBuildConfigurator.getActiveBuildConfiguration();
        for (int i = 0; i < comparableArray.length; ++i) {
            Util.Comparable comparable = comparableArray[i];
            menuItem = new MenuItem(menu, 32);
            menuItem.setText(comparable.getName());
            menuItem.addSelectionListener((SelectionListener)this);
            menuItem.setData((Object)comparable);
            if (comparable != buildConfiguration) continue;
            menuItem.setSelection(true);
        }
        return menu;
    }

    public void run(IAction iAction) {
        ProjectBuildConfigurator projectBuildConfigurator = BuildConfigurator.getBuildConfigurator().getActiveProjectBuildConfigurator();
        if (projectBuildConfigurator != null) {
            this.build(projectBuildConfigurator.getJavaProject().getProject());
        }
    }

    public void buildConfigurationChanged(ProjectBuildConfigurator projectBuildConfigurator) {
        this.currentPbc = projectBuildConfigurator;
        if (projectBuildConfigurator == null) {
            this.buildAction.setEnabled(false);
        } else {
            this.buildAction.setEnabled(true);
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        if (this.buildAction == null) {
            this.buildAction = iAction;
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.chooseBuild(selectionEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.chooseBuild(selectionEvent);
    }

    public void chooseBuild(SelectionEvent selectionEvent) {
        Object object = selectionEvent.getSource();
        if (object instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)object;
            BuildConfiguration buildConfiguration = (BuildConfiguration)menuItem.getData();
            ProjectBuildConfigurator projectBuildConfigurator = BuildConfigurator.getBuildConfigurator().getActiveProjectBuildConfigurator();
            if (projectBuildConfigurator != null) {
                projectBuildConfigurator.setActiveBuildConfiguration(buildConfiguration);
            }
        }
    }

    private void build(final IProject iProject) {
        Shell shell = AspectJPlugin.getDefault().getActiveWorkbenchWindow().getShell();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            void doLocalBuild(int n, IProgressMonitor iProgressMonitor) throws CoreException {
                Builder.isLocalBuild = true;
                iProject.build(6, iProgressMonitor);
                Builder.isLocalBuild = false;
            }

            public void run(IProgressMonitor iProgressMonitor) {
                try {
                    this.doLocalBuild(6, iProgressMonitor);
                }
                catch (CoreException coreException) {
                    AspectJPlugin.getDefault().getErrorHandler().handleError("Build pulldown error", coreException);
                }
                catch (NullPointerException nullPointerException) {
                    AJDTEventTrace.generalEvent("Unexpected NullPointerException during build processing (eclipse bug?): Your task view will be temporarily out of step with compilation:" + nullPointerException);
                }
                catch (OperationCanceledException operationCanceledException) {
                    AJDTEventTrace.generalEvent("Build was cancelled.");
                }
            }
        };
        try {
            new ProgressMonitorDialog(shell).run(true, true, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            AspectJPlugin.getDefault().getErrorHandler().handleError("Auto build on select failed", invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            AspectJPlugin.getDefault().getErrorHandler().handleError("Auto build on select failed", interruptedException);
        }
    }
}

