/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.actions;

import org.eclipse.ajdt.internal.builder.Builder;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class BuildSelectorAction
implements IWorkbenchWindowActionDelegate {
    private IFile currentlySelectedBuildFile = null;

    public void run(IAction iAction) {
        IProject iProject = this.currentlySelectedBuildFile.getProject();
        try {
            if (!iProject.hasNature("org.eclipse.ajdt.ui.ajnature")) {
                return;
            }
        }
        catch (CoreException coreException) {
            AspectJPlugin.getDefault().getErrorHandler().handleError("Unable to verify project nature", coreException);
        }
        AspectJPlugin.setBuildConfigurationFile(iProject, this.currentlySelectedBuildFile);
        AspectJPlugin.getDefault().setCurrentProject(iProject);
        BuildSelectorAction.doFullBuild(iProject);
    }

    public static void doFullBuild(final IProject iProject) {
        IWorkbenchWindow iWorkbenchWindow = AspectJPlugin.getDefault().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return;
        }
        Shell shell = iWorkbenchWindow.getShell();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            void doLocalBuild(int n, IProgressMonitor iProgressMonitor) throws CoreException {
                Builder.isLocalBuild = true;
                iProject.build(6, iProgressMonitor);
                Builder.isLocalBuild = false;
            }

            public void run(IProgressMonitor iProgressMonitor) {
                try {
                    this.doLocalBuild(6, iProgressMonitor);
                }
                catch (CoreException coreException) {
                    AspectJPlugin.getDefault().getErrorHandler().handleError("Build on select error", coreException);
                }
                catch (Exception exception) {
                    System.out.println(exception);
                    exception.printStackTrace();
                }
            }
        };
        try {
            new ProgressMonitorDialog(shell).run(true, true, iRunnableWithProgress);
        }
        catch (Exception exception) {
            AspectJPlugin.getDefault().getErrorHandler().handleError("Auto build on select failed", exception);
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        IStructuredSelection iStructuredSelection;
        Object object;
        if (iSelection instanceof IStructuredSelection && (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) instanceof IFile) {
            this.currentlySelectedBuildFile = (IFile)object;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
    }
}

