/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajde;

import java.io.File;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JavaProject;

public class BuildOptionsAdapter
implements org.aspectj.ajde.BuildOptionsAdapter {
    public static final QualifiedName INCREMENTAL_COMPILATION = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.incrementalMode");
    public static final QualifiedName BUILD_ASM = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.buildAsm");
    public static final QualifiedName WEAVEMESSAGES = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.showweavemessages");
    public static final QualifiedName INPUTJARS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.inputJars");
    public static final QualifiedName INPUTJARSBROWSEDIR = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.inputJarsBrowseDir");
    public static final QualifiedName ASPECTJARSBROWSEDIR = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.aspectJarsBrowseDir");
    public static final QualifiedName INPATH = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.inpath");
    public static final QualifiedName INPATH_CON_KINDS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.inpathConKinds");
    public static final QualifiedName INPATH_ENT_KINDS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.inpathEntKinds");
    public static final QualifiedName ASPECTPATH = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.aspectpath");
    public static final QualifiedName ASPECTPATH_CON_KINDS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.aspectpathConKinds");
    public static final QualifiedName ASPECTPATH_ENT_KINDS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.aspectpathEntKinds");
    public static final QualifiedName OUTPUTJAR = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.outputJar");
    public static final QualifiedName SOURCEROOTS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.sourceRoots");
    public static final QualifiedName ASPECTJARS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.aspectJars");
    public static final QualifiedName CHAR_ENC = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.characterEncoding");
    public static final QualifiedName NON_STANDARD_OPTS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.nonStandardOptions");
    public static final QualifiedName COMPILATION_STRICTNESS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.compilationStrictness");
    public static final boolean INCREMENTAL_COMPILATION_DEFAULT = false;
    public static final boolean WEAVE_MESSAGES_DEFAULT = false;
    public static final boolean BUILD_ASM_DEFAULT = true;
    public static final String NON_STANDARD_OPTS_DEFAULT = "-Xlint";
    public static final String CHAR_ENC_DEFAULT = System.getProperty("file.encoding");
    public static final boolean JAVA_OR_AJ_EXT_DEFAULT = false;

    public Map getJavaOptionsMap() {
        Map map = null;
        try {
            JavaProject javaProject = (JavaProject)AspectJPlugin.getDefault().getCurrentProject().getNature("org.eclipse.jdt.core.javanature");
            Class<?> clazz = javaProject.getClass();
            Method method = clazz.getDeclaredMethod("getOptions", Boolean.TYPE);
            map = (Map)method.invoke((Object)javaProject, Boolean.TRUE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (map == null) {
            return JavaCore.getOptions();
        }
        return map;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Current Compiler options set:");
        stringBuffer.append("[Incremental compilation=" + this.getIncrementalMode() + "]");
        stringBuffer.append("[NonStandard options='" + this.getNonStandardOptions() + "']");
        return stringBuffer.toString();
    }

    private boolean retrieveSettingBoolean(QualifiedName qualifiedName) {
        IProject iProject = AspectJPlugin.getDefault().getCurrentProject();
        try {
            String string = iProject.getPersistentProperty(qualifiedName);
            boolean bl = new Boolean(string);
            return bl;
        }
        catch (CoreException coreException) {
            AspectJPlugin.getDefault().getErrorHandler().handleError(AspectJPlugin.getResourceString("buildOptionsAdapter.exceptionDuringRetrieve"), coreException);
            return false;
        }
    }

    private String retrieveSettingString(QualifiedName qualifiedName) {
        IProject iProject = AspectJPlugin.getDefault().getCurrentProject();
        try {
            String string = iProject.getPersistentProperty(qualifiedName);
            if (string == null) {
                return "";
            }
            return string;
        }
        catch (CoreException coreException) {
            AspectJPlugin.getDefault().getErrorHandler().handleError(AspectJPlugin.getResourceString("buildOptionsAdapter.exceptionDuringRetrieve"), coreException);
            return "";
        }
    }

    public boolean getLenientSpecMode() {
        return false;
    }

    public String getNonStandardOptions() {
        this.ensurePropertiesInitialized();
        IProject iProject = AspectJPlugin.getDefault().getCurrentProject();
        String string = this.retrieveSettingString(NON_STANDARD_OPTS);
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getNonStandardOptions called, returning :" + string);
        }
        string = string + AspectJPreferences.getLintOptions(iProject);
        string = string + AspectJPreferences.getAdvancedOptions(iProject);
        if (AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getShowWeaveMessages()) {
            string = string + " -showWeaveInfo";
        }
        return string;
    }

    public boolean getPortingMode() {
        return false;
    }

    public boolean getPreprocessMode() {
        return false;
    }

    public boolean getSourceOnePointFourMode() {
        return false;
    }

    public boolean getStrictSpecMode() {
        return false;
    }

    public boolean getIncrementalMode() {
        this.ensurePropertiesInitialized();
        boolean bl = this.retrieveSettingBoolean(INCREMENTAL_COMPILATION);
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getIncrementalMode called, returning :" + new Boolean(bl));
        }
        return bl;
    }

    public boolean getBuildAsm() {
        this.ensurePropertiesInitialized();
        boolean bl = this.retrieveSettingBoolean(BUILD_ASM);
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getBuildAsm called, returning :" + new Boolean(bl));
        }
        return bl;
    }

    public boolean getShowWeaveMessages() {
        this.ensurePropertiesInitialized();
        boolean bl = this.retrieveSettingBoolean(WEAVEMESSAGES);
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getShowWeaveMessages called, returning :" + new Boolean(bl));
        }
        return bl;
    }

    public String getWorkingOutputPath() {
        return "";
    }

    public String getComplianceLevel() {
        return null;
    }

    public Set getDebugLevel() {
        return null;
    }

    public boolean getNoImportError() {
        return false;
    }

    public boolean getPreserveAllLocals() {
        return false;
    }

    public String getSourceCompatibilityLevel() {
        return null;
    }

    public Set getWarnings() {
        return null;
    }

    public boolean getUseJavacMode() {
        return false;
    }

    public String getCharacterEncoding() {
        return null;
    }

    private static void preserveSetting(IProject iProject, QualifiedName qualifiedName, boolean bl) throws CoreException {
        BuildOptionsAdapter.preserveSetting(iProject, qualifiedName, new Boolean(bl).toString());
    }

    private static void preserveSetting(IProject iProject, QualifiedName qualifiedName, String string) throws CoreException {
        iProject.setPersistentProperty(qualifiedName, string);
    }

    private void ensurePropertiesInitialized() {
        BuildOptionsAdapter.ensurePropertiesInitialized(AspectJPlugin.getDefault().getCurrentProject());
    }

    public static void ensurePropertiesInitialized(IProject iProject) {
        try {
            if (iProject.getPersistentProperty(INCREMENTAL_COMPILATION) == null) {
                BuildOptionsAdapter.preserveSetting(iProject, INCREMENTAL_COMPILATION, false);
            }
            if (iProject.getPersistentProperty(BUILD_ASM) == null) {
                BuildOptionsAdapter.preserveSetting(iProject, BUILD_ASM, true);
            }
            if (iProject.getPersistentProperty(WEAVEMESSAGES) == null) {
                BuildOptionsAdapter.preserveSetting(iProject, WEAVEMESSAGES, false);
            }
            if (iProject.getPersistentProperty(INPUTJARSBROWSEDIR) == null) {
                BuildOptionsAdapter.preserveSetting(iProject, INPUTJARSBROWSEDIR, iProject.getLocation().toOSString());
            }
            if (iProject.getPersistentProperty(ASPECTJARSBROWSEDIR) == null) {
                BuildOptionsAdapter.preserveSetting(iProject, ASPECTJARSBROWSEDIR, iProject.getLocation().toOSString());
            }
            if (iProject.getPersistentProperty(INPATH) == null) {
                BuildOptionsAdapter.preserveSetting(iProject, INPATH, "");
            }
            if (iProject.getPersistentProperty(INPATH_CON_KINDS) == null) {
                BuildOptionsAdapter.preserveSetting(iProject, INPATH_CON_KINDS, "");
            }
            if (iProject.getPersistentProperty(INPATH_ENT_KINDS) == null) {
                BuildOptionsAdapter.preserveSetting(iProject, INPATH_ENT_KINDS, "");
            }
            if (iProject.getPersistentProperty(ASPECTPATH) == null) {
                BuildOptionsAdapter.preserveSetting(iProject, ASPECTPATH, "");
            }
            if (iProject.getPersistentProperty(ASPECTPATH_CON_KINDS) == null) {
                BuildOptionsAdapter.preserveSetting(iProject, ASPECTPATH_CON_KINDS, "");
            }
            if (iProject.getPersistentProperty(ASPECTPATH_ENT_KINDS) == null) {
                BuildOptionsAdapter.preserveSetting(iProject, ASPECTPATH_ENT_KINDS, "");
            }
            if (iProject.getPersistentProperty(INPUTJARS) == null) {
                BuildOptionsAdapter.preserveSetting(iProject, INPUTJARS, "");
            }
            if (iProject.getPersistentProperty(OUTPUTJAR) == null) {
                BuildOptionsAdapter.preserveSetting(iProject, OUTPUTJAR, "");
            }
            if (iProject.getPersistentProperty(ASPECTJARS) == null) {
                BuildOptionsAdapter.preserveSetting(iProject, ASPECTJARS, "");
            }
            if (iProject.getPersistentProperty(SOURCEROOTS) == null) {
                BuildOptionsAdapter.preserveSetting(iProject, SOURCEROOTS, "");
            }
            if (iProject.getPersistentProperty(CHAR_ENC) == null) {
                BuildOptionsAdapter.preserveSetting(iProject, CHAR_ENC, CHAR_ENC_DEFAULT);
            }
        }
        catch (CoreException coreException) {
            AspectJPlugin.getDefault().getErrorHandler().handleError(AspectJPlugin.getResourceString("buildOptionsAdapter.exceptionInitializingProperties"), coreException);
        }
    }

    public String getOutJar() {
        this.ensurePropertiesInitialized();
        String string = this.retrieveSettingString(OUTPUTJAR);
        if (string.trim().length() > 0 && !string.startsWith("\\") && !string.startsWith("/")) {
            String string2 = string.trim();
            boolean bl = true;
            if (string2.length() > 1 && string2.charAt(1) == ':') {
                bl = false;
            }
            if (bl) {
                IProject iProject = AspectJPlugin.getDefault().getCurrentProject();
                String string3 = iProject.getLocation().toOSString();
                string = new String(string3 + File.separator + string.trim());
            }
        }
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getOutJar called, returning :" + string);
        }
        return string;
    }

    public Set getInJars() {
        this.ensurePropertiesInitialized();
        String string = this.retrieveSettingString(INPUTJARS);
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getInJars called, returning :" + string);
        }
        if (string.length() == 0) {
            return null;
        }
        return this.mapStringToSet(string, false);
    }

    public Set getInPath() {
        this.ensurePropertiesInitialized();
        String string = this.retrieveSettingString(INPATH);
        string = this.fullyQualifyPathEntries(string);
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getInPath called, returning :" + string);
        }
        if (string.length() == 0) {
            return null;
        }
        return this.mapStringToSet(string, false);
    }

    private String fullyQualifyPathEntries(String string) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.startsWith("/")) {
                String string3 = null;
                int n = string2.indexOf("/", 1);
                string3 = n != -1 ? string2.substring(1, n) : string2.substring(1);
                IProject iProject = AspectJPlugin.getWorkspace().getRoot().getProject(string3);
                if (iProject != null && iProject.getLocation() != null) {
                    String string4 = iProject.getLocation().toString();
                    if (n != -1) {
                        stringBuffer.append(string4 + "/" + string2.substring(n + 1));
                    } else {
                        stringBuffer.append(string4);
                    }
                } else {
                    AJDTEventTrace.generalEvent("AspectJ path entry " + string2 + " does not exist. Ignoring.");
                    if (AspectJPlugin.DEBUG_BUILDER) {
                        System.out.println("BuildOptionsAdapter.fullyQualifyPathEntries detected path entry " + string2 + " does not exist");
                    }
                }
            } else {
                stringBuffer.append(string2);
            }
            stringBuffer.append(File.pathSeparator);
        }
        string2 = stringBuffer.toString();
        if (string2.endsWith(File.pathSeparator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public Set getAspectPath() {
        this.ensurePropertiesInitialized();
        String string = this.retrieveSettingString(ASPECTPATH);
        string = this.fullyQualifyPathEntries(string);
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getAspectPath called, returning :" + string);
        }
        if (string.length() == 0) {
            return null;
        }
        return this.mapStringToSet(string, false);
    }

    private Set mapStringToSet(String string, boolean bl) {
        if (string.length() == 0) {
            return null;
        }
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = AspectJPlugin.getDefault().getCurrentProject().getLocation().toOSString();
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("Converting ]" + string + "[");
        }
        HashSet<File> hashSet = new HashSet<File>();
        while (string2.indexOf(File.pathSeparator) != -1) {
            int n = string2.indexOf(File.pathSeparator);
            String string4 = string2.substring(0, n);
            File file = new File(string4);
            if (!file.isAbsolute()) {
                file = new File(string3 + File.separator + string4);
            }
            if (bl && !file.exists()) {
                stringBuffer.append(file + "\n");
                if (AspectJPlugin.DEBUG_BUILDER) {
                    System.out.println("Skipping file ]" + file.toString() + "[");
                }
            } else {
                hashSet.add(file);
                if (AspectJPlugin.DEBUG_BUILDER) {
                    System.out.println("Adding file ]" + file.toString() + "[");
                }
            }
            string2 = string2.substring(n + 1);
        }
        if (string2.length() != 0) {
            File file = new File(string2);
            if (!file.isAbsolute()) {
                file = new File(string3 + File.separator + string2);
            }
            if (bl && !file.exists()) {
                stringBuffer.append(file + "\n");
                if (AspectJPlugin.DEBUG_BUILDER) {
                    System.out.println("Skipping file ]" + file.toString() + "[");
                }
            } else {
                hashSet.add(file);
                if (AspectJPlugin.DEBUG_BUILDER) {
                    System.out.println("Adding file ]" + file.toString() + "[");
                }
            }
        }
        if (bl && stringBuffer.length() != 0) {
            AspectJPlugin.getDefault().getErrorHandler().handleWarning("The following jar files do not exist and are being ignored:\n" + stringBuffer.toString());
        }
        return hashSet;
    }

    public Set getSourceRoots() {
        this.ensurePropertiesInitialized();
        String string = this.retrieveSettingString(SOURCEROOTS);
        if (AspectJPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getSourceRoots called, returning :" + string);
        }
        return this.mapStringToSet(string, false);
    }
}

